/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine;

import com.jxdinfo.hussar.migration.exceptions.MigrationException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowDumpAppDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowImportMsgDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowLoadAppDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowAppDumpAllMsgDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowDumpVo;
import com.jxdinfo.hussar.workflow.manage.engine.service.WorkflowAppMigrationApiService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowAppMigrationService {
    private static final WorkflowAppMigrationApiService workflowMgrationPluginApiService = BpmSpringContextHolder.getBean(WorkflowAppMigrationApiService.class);
    private static final Logger logger = LoggerFactory.getLogger(WorkflowAppMigrationService.class);

    public static void dumpApp(WorkflowDumpAppDto workflowDumpAppDto) {
        logger.info("\u5f00\u59cb\u5bfc\u51fa\u6d41\u7a0b\u6570\u636e");
        try {
            if ("22".equals(workflowDumpAppDto.getAppType()) && StringUtil.endWith((CharSequence)workflowDumpAppDto.getAppCode(), (CharSequence)"_extension")) {
                workflowDumpAppDto.setAppCode(workflowDumpAppDto.getAppCode().substring(0, workflowDumpAppDto.getAppCode().length() - 10));
            }
            String workflowFilePath = workflowDumpAppDto.getFilePath() + File.separator + "workflow";
            WorkflowAppDumpAllMsgDto workflowAppDumpAllMsgDto = workflowMgrationPluginApiService.dumpApp(workflowDumpAppDto);
            List<WorkflowDumpVo> workflowDumpVoList = workflowAppDumpAllMsgDto.getWorkflowDumpVoList();
            String flowProperty = workflowAppDumpAllMsgDto.getFlowProperty();
            String preloadMsg = workflowAppDumpAllMsgDto.getPreloadMsg();
            if (HussarUtils.isNotEmpty((Object)flowProperty)) {
                File file = new File(workflowFilePath);
                if (!file.exists()) {
                    file.mkdirs();
                }
            } else {
                logger.info("\u672a\u83b7\u53d6\u5230\u6570\u636e\uff0c\u8df3\u8fc7\u6d41\u7a0b\u5bfc\u51fa");
                return;
            }
            if (HussarUtils.isNotEmpty((Object)flowProperty)) {
                FileUtils.write((File)new File(workflowFilePath, "flowProperty.json"), (CharSequence)flowProperty, (Charset)StandardCharsets.UTF_8);
            }
            if (HussarUtils.isNotEmpty((Object)preloadMsg)) {
                FileUtils.write((File)new File(workflowFilePath, "preloadMsg.json"), (CharSequence)preloadMsg, (Charset)StandardCharsets.UTF_8);
            }
            if (HussarUtils.isNotEmpty(workflowDumpVoList)) {
                for (WorkflowDumpVo workflowDumpVo : workflowDumpVoList) {
                    String processDirName = workflowFilePath + File.separator + workflowDumpVo.getProcessKey() + File.separator + workflowDumpVo.getVersion();
                    File file = new File(processDirName, workflowDumpVo.getFileSuffix());
                    if (file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    FileUtils.write((File)file, (CharSequence)workflowDumpVo.getContent(), (Charset)StandardCharsets.UTF_8);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6d41\u7a0b\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new MigrationException((Throwable)e);
        }
        logger.info("\u6d41\u7a0b\u6570\u636e\u5bfc\u51fa\u5b8c\u6210");
    }

    public static void loadApp(WorkflowLoadAppDto workflowLoadAppDto) {
        try {
            String workflowPath = workflowLoadAppDto.getFilePath() + File.separator + "workflow";
            File workflowDir = new File(workflowPath);
            if (workflowDir.exists()) {
                logger.info("\u5f00\u59cb\u5bfc\u5165\u6d41\u7a0b\u6570\u636e");
                if ("22".equals(workflowLoadAppDto.getAppType()) && StringUtil.endWith((CharSequence)workflowLoadAppDto.getAppCode(), (CharSequence)"_extension")) {
                    workflowLoadAppDto.setAppCode(workflowLoadAppDto.getAppCode().substring(0, workflowLoadAppDto.getAppCode().length() - 10));
                }
                switch (workflowLoadAppDto.getAppType()) {
                    case "2": {
                        workflowLoadAppDto.setAppType("1");
                        break;
                    }
                    case "21": {
                        workflowLoadAppDto.setAppType("3");
                        break;
                    }
                    default: {
                        workflowLoadAppDto.setAppType("2");
                    }
                }
                workflowLoadAppDto.setPreloadMsg(FileUtils.readFileToString((File)new File(workflowPath + File.separator + "preloadMsg.json"), (Charset)StandardCharsets.UTF_8));
                workflowLoadAppDto.setFlowProperty(FileUtils.readFileToString((File)new File(workflowPath + File.separator + "flowProperty.json"), (Charset)StandardCharsets.UTF_8));
                ArrayList<WorkflowImportMsgDto> importMsgList = new ArrayList<WorkflowImportMsgDto>();
                if (HussarUtils.isNotEmpty((Object[])workflowDir.listFiles())) {
                    for (File flowDir : workflowDir.listFiles()) {
                        if (!flowDir.isDirectory() || !HussarUtils.isNotEmpty((Object[])flowDir.listFiles())) continue;
                        for (File flowFile : flowDir.listFiles()) {
                            try {
                                String processKey = flowDir.getName();
                                String version = flowFile.getName();
                                if (!flowFile.isDirectory() || !HussarUtils.isNotEmpty((Object[])flowFile.listFiles())) continue;
                                for (File file : flowFile.listFiles()) {
                                    WorkflowImportMsgDto workflowImportMsgDto = new WorkflowImportMsgDto();
                                    workflowImportMsgDto.setFileContent(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
                                    workflowImportMsgDto.setProcessKey(processKey);
                                    workflowImportMsgDto.setVersion(version);
                                    workflowImportMsgDto.setFileName(file.getName());
                                    importMsgList.add(workflowImportMsgDto);
                                }
                            }
                            catch (IOException e) {
                                throw new MigrationException((Throwable)e);
                            }
                        }
                    }
                    workflowLoadAppDto.setWorkflowImportMsgDtoList(importMsgList);
                    ApiResponse<?> response = workflowMgrationPluginApiService.loadApp(workflowLoadAppDto);
                    logger.info("\u6d41\u7a0b\u6570\u636e\u5bfc\u5165\u5b8c\u6210");
                    return;
                }
            }
            logger.info("\u672a\u83b7\u53d6\u5230\u6570\u636e,\u8df3\u8fc7\u6d41\u7a0b\u5bfc\u5165");
        }
        catch (Exception e) {
            logger.error("\u6d41\u7a0b\u6570\u636e\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            throw new MigrationException((Throwable)e);
        }
    }
}

