/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.constant;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;

public class TaskSourceFlag {
    public static final String MAIN_PROCESS_START = "main_process_start";
    public static final String RECEIVE_SIGNAL = "receive_signal";
    public static final String PROCESS_RESTART = "process_restart";
    public static final String SIMPLE_COMPLETE = "complete";
    public static final String COMPLETE_LEAP = "complete_leap";
    public static final String SIMPLE_REJECT = "reject";
    public static final String SIMPLE_REVOKE = "revoke";
    public static final String REJECT_REVOKE = "reject_revoke";
    public static final String SIMPLE_FREEJUMP = "freejump";
    public static final String TRANSFER = "transfer";
    public static final String MULTI_TRANSFER = "multiTransfer";
    public static final String ENTRUST = "entrust";
    public static final String SKIP = "skip";
    public static final String END_PROCESS = "endProcess";
    public static final String REVOKE_PROCESS = "revokeProcess";
    public static final String ASSIST = "assist";
    public static final String ASSIST_ADD = "assist_add";
    public static final String ASSIST_COMPLETE = "assist_complete";
    public static final String CC_TASK = "ccTask";
    public static final String MAIN_COMPLETE = "main_complete";
    public static final String MAIN_REJECT = "main_reject";
    public static final String MAIN_JUMP = "main_jump";
    public static final String SUB_END_FOR_MAIN_JUMP = "sub_end_jump";
    public static final String SUB_END_FOR_MAIN_REJECT = "sub_end_reject";
    public static final String SUB_END_FOR_MAIN_REVOKE = "sub_end_revoke";
    public static final String MAIN_END = "main_end";
    public static final String ADD_ASSIGNEE = "addAssignee";
    public static final String DEL_ASSIGNEE = "delAssignee";
    public static final String OVERTIME_AUTO_COMPLETE = "overtime_auto_complete";
    public static final String OVERTIME_AUTO_REJECT = "overtime_auto_reject";
    public static final Set<String> COMPLETE = ImmutableSet.of((Object)"complete", (Object)"main_process_start", (Object)"receive_signal", (Object)"process_restart", (Object)"main_complete", (Object)"main_reject", (Object[])new String[]{"main_jump", "overtime_auto_complete"});
    public static final Set<String> NORMAL_COMPLETE = ImmutableSet.builder().addAll(COMPLETE).add((Object)"freejump").add((Object)"complete_leap").build();
    public static final Set<String> SUB_PROCESS_START = ImmutableSet.of((Object)"main_reject", (Object)"main_complete", (Object)"main_jump");
    public static final Set<String> PROCESS_START = ImmutableSet.builder().addAll(SUB_PROCESS_START).add((Object)"main_process_start").build();
    public static final Set<String> END = ImmutableSet.builder().add((Object)"endProcess").add((Object)"main_end").build();
    public static final Map<String, String> SIMPLE_MAPPING = ImmutableMap.builder().put((Object)"complete", (Object)"complete").put((Object)"main_process_start", (Object)"complete").put((Object)"receive_signal", (Object)"complete").put((Object)"process_restart", (Object)"complete").put((Object)"main_complete", (Object)"complete").put((Object)"main_reject", (Object)"complete").put((Object)"main_jump", (Object)"complete").put((Object)"overtime_auto_complete", (Object)"overtime_auto_complete").put((Object)"reject", (Object)"reject").put((Object)"sub_end_reject", (Object)"reject").put((Object)"overtime_auto_reject", (Object)"overtime_auto_reject").put((Object)"revoke", (Object)"revoke").put((Object)"sub_end_revoke", (Object)"revoke").put((Object)"freejump", (Object)"freejump").put((Object)"sub_end_jump", (Object)"freejump").put((Object)"endProcess", (Object)"endProcess").put((Object)"main_end", (Object)"endProcess").put((Object)"revokeProcess", (Object)"revokeProcess").put((Object)"skip", (Object)"skip").put((Object)"complete_leap", (Object)"complete").put((Object)"reject_revoke", (Object)"revoke").put((Object)"transfer", (Object)"transfer").put((Object)"multiTransfer", (Object)"multiTransfer").put((Object)"assist", (Object)"assist").put((Object)"assist_add", (Object)"assist_add").put((Object)"assist_complete", (Object)"assist_complete").put((Object)"ccTask", (Object)"ccTask").put((Object)"addAssignee", (Object)"addAssignee").put((Object)"delAssignee", (Object)"delAssignee").build();

    public static boolean isComplete(String taskSourceFlag) {
        return COMPLETE.contains(taskSourceFlag);
    }

    public static boolean isRejectOrRevoke(String taskSourceFlag) {
        return TaskSourceFlag.isReject(taskSourceFlag) || TaskSourceFlag.isRevoke(taskSourceFlag);
    }

    public static boolean isReject(String taskSourceFlag) {
        return SIMPLE_REJECT.equals(taskSourceFlag) || SUB_END_FOR_MAIN_REJECT.equals(taskSourceFlag) || OVERTIME_AUTO_REJECT.equals(taskSourceFlag);
    }

    public static boolean isRejectRevoke(String taskSourceFlag) {
        return REJECT_REVOKE.equals(taskSourceFlag);
    }

    public static boolean isRevoke(String taskSourceFlag) {
        return SIMPLE_REVOKE.equals(taskSourceFlag) || REJECT_REVOKE.equals(taskSourceFlag) || SUB_END_FOR_MAIN_REVOKE.equals(taskSourceFlag);
    }

    public static boolean isFreeJump(String taskSourceFlag) {
        return SIMPLE_FREEJUMP.equals(taskSourceFlag) || SUB_END_FOR_MAIN_JUMP.equals(taskSourceFlag);
    }

    public static boolean isEndProcess(String taskSourceFlag) {
        return END_PROCESS.equals(taskSourceFlag) || REVOKE_PROCESS.equals(taskSourceFlag);
    }

    public static String mappingToSimple(String taskSourceFlag) {
        String simple = SIMPLE_MAPPING.get(taskSourceFlag);
        return simple == null ? taskSourceFlag : simple;
    }
}

