/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bsp.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.OrganInfoVo;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysStruAuditFront"})
public class SysStruAuditFrontController
extends BaseController {
    @Autowired
    private ISysStruAuditService sysStruAuditService;
    @Resource
    private SysOrgManageService orgMaintenanceService;

    @RequestMapping(value={"/list"})
    @ResponseBody
    @RequiresPermissions(value={"sysStruAudit:list"})
    @BussinessLog(key="/sysStruAudit/list", type="04", value="\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u5ba1\u6838\u5217\u8868")
    public ApiResponse<JSONObject> list(@RequestBody Map<String, Object> map) {
        String organName = map.get("organ") == null ? null : map.get("organ").toString();
        String type = map.get("status") == null ? null : map.get("status").toString();
        int page = map.get("current") == null ? 1 : Integer.parseInt(map.get("current").toString());
        int limit = map.get("size") == null ? 10 : Integer.parseInt(map.get("size").toString());
        Page pages = new Page((long)page, (long)limit);
        JSONObject jsonObject = new JSONObject();
        List list = this.sysStruAuditService.queryOrganAudit(pages, organName, type);
        jsonObject.put("count", (Object)pages.getTotal());
        jsonObject.put("data", (Object)list);
        jsonObject.put("code", (Object)0);
        jsonObject.put("msg", (Object)"success");
        return ApiResponse.data((Object)jsonObject);
    }

    @RequestMapping(value={"/verify"})
    @ResponseBody
    @BussinessLog(key="/sysStruAudit/verify", type="03", value="\u7ec4\u7ec7\u673a\u6784/\u4eba\u5458\u64cd\u4f5c\u5ba1\u6838")
    @RequiresPermissions(value={"sysStruAudit:verify"})
    public ApiResponse<Object> verify(@RequestBody Map<String, Object> map) {
        String realStruId;
        String struId = map.get("struId") == null ? null : map.get("struId").toString();
        String type = map.get("type") == null ? null : map.get("type").toString();
        String inUse = map.get("inUse") == null ? null : map.get("inUse").toString();
        String string = realStruId = map.get("realStruId") == null ? "" : map.get("realStruId").toString();
        if (this.sysStruAuditService.verify(struId, type, inUse, realStruId)) {
            if ("1".equals(type)) {
                return ApiResponse.success((String)"\u901a\u8fc7\u6210\u529f\uff01");
            }
            return ApiResponse.success((String)"\u9a73\u56de\u6210\u529f\uff01");
        }
        if ("1".equals(type)) {
            return ApiResponse.fail((String)"\u901a\u8fc7\u5931\u8d25\uff01");
        }
        return ApiResponse.fail((String)"\u9a73\u56de\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/detail"})
    @ResponseBody
    @BussinessLog(key="/sysStruAudit/detail", type="04", value="\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u5ba1\u6838\u8be6\u60c5")
    @RequiresPermissions(value={"sysStruAudit:detail"})
    public ApiResponse<JSONObject> view(@RequestBody Map<String, Object> map) {
        String struId = map.get("struId") == null ? null : map.get("struId").toString();
        String type = map.get("type") == null ? null : map.get("type").toString();
        JSONObject jsonObject = new JSONObject();
        if ("1".equals(type)) {
            OrganInfoVo orgInfo = this.sysStruAuditService.getOrgInfoById(struId);
            jsonObject.put("orgData", (Object)orgInfo);
            return ApiResponse.data((Object)jsonObject);
        }
        if ("2".equals(type)) {
            String realStruId = map.get("realStruId") == null ? null : map.get("realStruId").toString();
            OrganInfoVo orgInfo = this.sysStruAuditService.getEditOrgInfoById(struId);
            OrganInfoVo oldOrgInfo = this.orgMaintenanceService.getOldOrgInfoById(realStruId);
            jsonObject.put("orgData", (Object)orgInfo);
            jsonObject.put("oldOrgData", (Object)oldOrgInfo);
            return ApiResponse.data((Object)jsonObject);
        }
        if ("3".equals(type)) {
            String realStruId = map.get("realStruId") == null ? null : map.get("realStruId").toString();
            OrganInfoVo orgInfo = this.orgMaintenanceService.getOldOrgInfoById(realStruId);
            jsonObject.put("orgData", (Object)orgInfo);
            return ApiResponse.data((Object)jsonObject);
        }
        String realStruId = map.get("realStruId") == null ? null : map.get("realStruId").toString();
        OrganInfoVo oldOrgInfo = this.orgMaintenanceService.getOldOrgInfoById(realStruId);
        String newParentName = this.sysStruAuditService.getNewParentName(struId);
        OrganInfoVo orgInfo = this.orgMaintenanceService.getOldOrgInfoById(realStruId);
        orgInfo.setParentName(newParentName);
        jsonObject.put("orgData", (Object)orgInfo);
        jsonObject.put("oldOrgData", (Object)oldOrgInfo);
        return ApiResponse.data((Object)jsonObject);
    }
}

