/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.menu;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bsp.menu.model.SysMenu;
import com.jxdinfo.hussar.bsp.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.front.common.response.ResultCode;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/frontMenu"})
public class SysMenuFrontController
extends BaseController {
    @Resource
    ISysMenuManageService sysMenuManageService;
    @Resource
    private ISysDicRefService iSysDicRefService;
    @Resource
    private ISysMenuManageService iSysMenuManageService;

    @RequestMapping(value={"getMenu"})
    public ApiResponse<?> getMenu() {
        ShiroUser shiroUser = ShiroKit.getUser();
        if (shiroUser != null) {
            List menus = shiroUser.getRolesList() != null && shiroUser.getRolesList().size() > 0 ? this.iSysMenuManageService.getMenuByRoles(shiroUser.getId(), shiroUser.getRolesList()) : new ArrayList();
            return ApiResponse.data(menus);
        }
        return ApiResponse.fail((int)ResultCode.UN_AUTHORIZED.getCode(), (String)ResultCode.UN_AUTHORIZED.getMessage());
    }

    @RequiresPermissions(value={"menu:menuTree"})
    @RequestMapping(value={"/menuTree"})
    public ApiResponse<List<JSTreeModel>> menuTree() {
        List result = this.sysMenuManageService.getMenuTree();
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setText("\u83dc\u5355\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setType("isRoot");
        result.add(root);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @BussinessLog(key="/menu/menuInfoSave", type="01", value="\u65b0\u589e\u83dc\u5355", pk="menuId")
    @RequiresPermissions(value={"menu:menuInfoSave"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @RequestMapping(value={"/menuInfoSave"})
    public ApiResponse<Tip> menuInfoSave(@RequestBody SysMenu sysMenu) {
        this.sysMenuManageService.menuInfoSave(sysMenu);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @BussinessLog(key="/menu/menuInfoEditSave", type="03", value="\u4fee\u6539\u83dc\u5355", pk="menuId")
    @RequiresPermissions(value={"menu:menuInfoEditSave"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @RequestMapping(value={"/menuInfoEditSave"})
    public ApiResponse<Tip> menuInfoEditSave(@RequestBody SysMenu sysMenu) {
        SysMenu result = this.sysMenuManageService.getMenuInfo(sysMenu.getMenuId());
        LogObjectHolder.me().set((Object)result);
        this.sysMenuManageService.menuInfoSave(sysMenu);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"menu:menuInfo"})
    @RequestMapping(value={"/menuInfo"})
    public ApiResponse<Map> menuInfo(@RequestBody Map<String, String> body) {
        String menuId = body.get("menuId");
        String length = body.get("length");
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysMenu result = this.sysMenuManageService.getMenuInfo(menuId);
        map.put("menuInfo", result);
        map.put("length", length);
        map.put("openType", this.iSysDicRefService.getDictLabel("menu_type", result.getOpenType()));
        return ApiResponse.data(map);
    }

    @BussinessLog(key="/menu/delMenuById", type="02", value="\u5220\u9664\u83dc\u5355", pk="menuId")
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @RequestMapping(value={"/delMenuById"})
    @RequiresPermissions(value={"menu:delMenuById"})
    public ApiResponse<Tip> delMenuById(@RequestBody Map<String, String> map) {
        String ids = map.get("menuIds") == null ? "" : map.get("menuIds");
        List<String> menuIds = Arrays.asList(ids.split(","));
        if (this.sysMenuManageService.removeByIds(menuIds)) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequiresPermissions(value={"menu:menuTreeById"})
    @RequestMapping(value={"/menuTreeById"})
    public ApiResponse<List<JSTreeModel>> menuTreeById(@RequestBody Map<String, Object> map) {
        String menuId = map.get("menuId") == null ? null : map.get("menuId").toString();
        String isHead = map.get("isRoot") == null ? null : map.get("isRoot").toString();
        Boolean isRoot = Boolean.valueOf(isHead);
        List result = this.sysMenuManageService.menuTreeById(menuId);
        if (isRoot.booleanValue()) {
            JSTreeModel root = new JSTreeModel();
            root.setId("1");
            root.setText("\u83dc\u5355\u5217\u8868");
            root.setParent("#");
            root.setIsLeaf("0");
            root.setType("isRoot");
            result.add(root);
        }
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/menuTreeOrder"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @RequiresPermissions(value={"menu:menuTreeOrder"})
    @BussinessLog(key="/menu/menuTreeOrder", type="03", value="\u83dc\u5355\u6811\u4e0b\u7ea7\u6392\u5e8f")
    public ApiResponse<Tip> menuTreeOrder(@RequestBody Map<String, Object> map) {
        String treeInfo = map.get("treeInfo") == null ? "" : map.get("treeInfo").toString();
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        JSONObject json = new JSONObject();
        ArrayList<SysMenu> list = new ArrayList<SysMenu>();
        for (int i = 0; i < treeArr.size(); ++i) {
            json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = i + 1 + "";
            SysMenu sm = new SysMenu();
            sm.setMenuId(id);
            sm.setSeq(new BigDecimal(order));
            list.add(sm);
        }
        if (ToolUtil.isNotEmpty(list)) {
            this.sysMenuManageService.updateBatchById(list, list.size());
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/menuTreeChange"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @RequiresPermissions(value={"menu:menuTreeChange"})
    @BussinessLog(key="/menu/menuTreeChange", type="03", value="\u83dc\u5355\u6811\u8f6c\u79fb")
    public ApiResponse<Tip> menuTreeChange(@RequestBody Map<String, String> map) {
        String menuId = map.get("menuId");
        String parentId = map.get("parentId");
        this.sysMenuManageService.menuTreeChange(menuId, parentId);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/singleMove"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @RequiresPermissions(value={"menu:singleMove"})
    @BussinessLog(key="/menu/singleMove", type="03", value="\u83dc\u5355\u6811\u4e0a\u79fb/\u4e0b\u79fb")
    public ApiResponse<Object> updateMoveNode(@RequestBody Map<String, Object> map) {
        String menuId = map.get("menuId") == null ? null : map.get("menuId").toString();
        boolean isUp = map.get("isUp") == null ? null : Boolean.valueOf(map.get("isUp").toString().equals("true"));
        if (ToolUtil.isEmpty((Object)menuId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.sysMenuManageService.updateMoveNode(menuId, isUp);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/exportMenu"})
    @RequiresPermissions(value={"menu:exportMenu"})
    @BussinessLog(key="/menu/exportMenu", type="03", value="\u83dc\u5355\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String menuIds = super.getPara("menuIds") == null ? "" : super.getPara("menuIds");
        List<String> menuIdList = Arrays.asList(menuIds.split(","));
        this.sysMenuManageService.exportMenu(menuIdList, response);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/importData"})
    @RequiresPermissions(value={"menu:importData"})
    @BussinessLog(key="/menu/importData", type="03", value="\u83dc\u5355\u5bfc\u5165")
    public ApiResponse<Tip> importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        Tip result = this.sysMenuManageService.importMenu(content);
        return ApiResponse.success((int)result.getCode(), (String)result.getMessage());
    }
}

