/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.view.controller;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.view.dto.HussarViewOrderDTO;
import com.jxdinfo.hussar.view.dto.ViewSchemaDTO;
import com.jxdinfo.hussar.view.model.HussarView;
import com.jxdinfo.hussar.view.model.HussarViewOrder;
import com.jxdinfo.hussar.view.service.IHussarViewManagementService;
import com.jxdinfo.hussar.view.service.IHussarViewOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u89c6\u56fe\u7ba1\u7406\u63a5\u53e3")
@RestController
@RequestMapping(value={"/hussarBase/view"})
public class HussarViewManagementController {
    private static final Logger logger = LoggerFactory.getLogger(HussarViewManagementController.class);
    @Resource
    private IHussarViewManagementService iHussarViewManagementService;
    @Resource
    private IHussarViewOrderService iHussarViewOrderService;

    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u89c6\u56fe", notes="\u4fdd\u5b58\u6570\u636e\u89c6\u56fe")
    @PostMapping(value={"/saveViewSysAndPub"})
    public ApiResponse<Boolean> saveViewSysAndPub(@RequestBody ViewSchemaDTO viewSchemaDTO) throws Exception {
        return this.iHussarViewManagementService.saveViewSysAndPub(viewSchemaDTO);
    }

    @GetMapping(value={"/getViewSysAndPub"})
    public ApiResponse<List<HussarView>> getViewSysAndPub(@RequestParam String pageId, @RequestParam String componentId, @RequestParam(required=false) String appId) throws Exception {
        return this.iHussarViewManagementService.getViewSysAndPub(pageId, componentId, appId);
    }

    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u89c6\u56fe", notes="\u4fdd\u5b58\u6570\u636e\u89c6\u56fe")
    @PostMapping(value={"/saveViewReturnId"})
    public ApiResponse<Long> saveViewReturnId(@RequestBody HussarView view) {
        try {
            return this.iHussarViewManagementService.saveViewReturnId(view);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8868\u5355\u89c6\u56fe\u5931\u8d25", (Throwable)e);
            return ApiResponse.fail((String)"\u83b7\u53d6\u8868\u5355\u89c6\u56fe\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u6839\u636e\u8868\u5355id\u83b7\u53d6\u6570\u636e\u89c6\u56fe", notes="\u6839\u636e\u8868\u5355id\u83b7\u53d6\u6570\u636e\u89c6\u56fe")
    @GetMapping(value={"/get"})
    public ApiResponse<List<HussarView>> get(@RequestParam String pageId, @RequestParam String componentId, @RequestParam(required=false) String appId) {
        return this.iHussarViewManagementService.get(pageId, componentId, appId);
    }

    @ApiOperation(value="\u6839\u636e\u89c6\u56feid\u83b7\u53d6\u6570\u636e\u89c6\u56fe", notes="\u6839\u636e\u89c6\u56feid\u83b7\u53d6\u6570\u636e\u89c6\u56fe")
    @GetMapping(value={"/getById"})
    public ApiResponse<HussarView> getById(@RequestParam Long viewId) {
        return this.iHussarViewManagementService.getById(viewId);
    }

    @PostMapping(value={"/updateView"})
    public ApiResponse<Boolean> update(@RequestBody HussarView view) {
        return this.iHussarViewManagementService.update(view);
    }

    @PostMapping(value={"/copy_view"})
    public ApiResponse<Long> copyView(@RequestBody HussarView view) {
        return this.iHussarViewManagementService.copyView(view);
    }

    @GetMapping(value={"/deleteById"})
    public ApiResponse<Boolean> deleteById(@RequestParam String viewId) {
        return this.iHussarViewManagementService.deleteById(viewId);
    }

    @GetMapping(value={"/getOrderBypageId"})
    public ApiResponse<HussarViewOrder> getOrderByUser(@RequestParam(required=false) String appId, @RequestParam String pageId, @RequestParam String componentId, @RequestParam(required=false) Long userId) {
        return this.iHussarViewOrderService.getOrderByUser(appId, pageId, componentId, userId);
    }

    @PostMapping(value={"/insert"})
    public ApiResponse<Boolean> insert(@RequestBody HussarViewOrder viewOrder) {
        return this.iHussarViewOrderService.insert(viewOrder);
    }

    @PostMapping(value={"/updateViewOrder"})
    public ApiResponse<Boolean> update(@RequestBody HussarViewOrderDTO hussarViewOrderDTO) {
        return this.iHussarViewOrderService.updateBatch(hussarViewOrderDTO);
    }

    @PostMapping(value={"/getDefaultOrder"})
    public ApiResponse<HussarViewOrder> getDefaultOrder(@RequestParam(required=false) String appId, @RequestParam String pageId, @RequestParam String componentId) {
        return this.iHussarViewOrderService.getDefaultOrder(appId, pageId, componentId);
    }
}

