/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.view.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.view.dao.HussarViewOrderMapper;
import com.jxdinfo.hussar.view.dto.HussarViewOrderDTO;
import com.jxdinfo.hussar.view.dto.ViewHideDTO;
import com.jxdinfo.hussar.view.model.HussarViewOrder;
import com.jxdinfo.hussar.view.service.IHussarViewOrderService;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class HussarViewOrderServiceImpl
extends HussarServiceImpl<HussarViewOrderMapper, HussarViewOrder>
implements IHussarViewOrderService {
    @Resource
    private HussarViewOrderMapper hussarViewOrderMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarViewOrderServiceImpl.class);

    public ApiResponse<HussarViewOrder> getOrderByUser(Long formId, Long userId) {
        HussarViewOrder viewOrder = this.hussarViewOrderMapper.getOrderByUser(formId, userId);
        return ApiResponse.success((Object)viewOrder);
    }

    public ApiResponse<HussarViewOrder> getOrderByUser(String pageId, Long userId, String componentId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            SecurityUser user = BaseSecurityUtil.getUser();
            if (HussarUtils.isEmpty((Object)user)) {
                return ApiResponse.fail((String)"\u65e0\u7528\u6237\u4fe1\u606f");
            }
            userId = user.getId();
        }
        HussarViewOrder viewOrder = this.hussarViewOrderMapper.getOrderByPageId(pageId, userId, componentId);
        return ApiResponse.success((Object)viewOrder);
    }

    public ApiResponse<Boolean> insert(HussarViewOrder customViewOrder) {
        try {
            this.hussarViewOrderMapper.insert(customViewOrder);
            return ApiResponse.success((Object)true);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u81ea\u5b9a\u4e49\u89c6\u56fe\u6392\u5e8f\u65b0\u589e\u5931\u8d25");
        }
    }

    public ApiResponse<Boolean> update(HussarViewOrder customViewOrder) {
        try {
            this.hussarViewOrderMapper.updateById(customViewOrder);
            return ApiResponse.success((Object)true);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u81ea\u5b9a\u4e49\u89c6\u56fe\u6392\u5e8f\u66f4\u65b0\u5931\u8d25");
        }
    }

    public ApiResponse<Boolean> updateBatch(HussarViewOrderDTO hussarViewOrderDTO) {
        try {
            Long userId = BaseSecurityUtil.getUser().getId();
            List order = hussarViewOrderDTO.getViewHideDTOS().stream().map(ViewHideDTO::getViewId).collect(Collectors.toList());
            HashMap<String, String> viewHide = new HashMap<String, String>();
            for (ViewHideDTO viewHideDTO : hussarViewOrderDTO.getViewHideDTOS()) {
                viewHide.put(viewHideDTO.getViewId(), String.valueOf(viewHideDTO.getHide()));
            }
            HussarViewOrder viewOrder = this.hussarViewOrderMapper.getOrderByPageId(hussarViewOrderDTO.getPageId(), userId, hussarViewOrderDTO.getComponentId());
            if (HussarUtils.isEmpty((Object)viewOrder)) {
                HussarViewOrder newViewOrder = new HussarViewOrder();
                newViewOrder.setComponentId(hussarViewOrderDTO.getComponentId());
                newViewOrder.setPageId(hussarViewOrderDTO.getPageId());
                newViewOrder.setUserId(userId);
                newViewOrder.setViewOrder(JSONObject.toJSONString(order));
                newViewOrder.setViewHide(JSONObject.toJSONString(viewHide));
                this.hussarViewOrderMapper.insert(newViewOrder);
                return ApiResponse.success((Object)true);
            }
            viewOrder.setViewOrder(JSONObject.toJSONString(order));
            viewOrder.setViewHide(JSONObject.toJSONString(viewHide));
            this.hussarViewOrderMapper.updateById(viewOrder);
            return ApiResponse.success((Object)true);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u81ea\u5b9a\u4e49\u89c6\u56fe\u6392\u5e8f\u66f4\u65b0\u5931\u8d25");
        }
    }
}

