/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.view.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.FilterField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.NavLeftTreeOption;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.ShowField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.ShowFieldMulti;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.TableButton;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.view.dao.HussarViewManagementMapper;
import com.jxdinfo.hussar.view.dto.HussarViewDTO;
import com.jxdinfo.hussar.view.model.HussarView;
import com.jxdinfo.hussar.view.model.HussarViewOrder;
import com.jxdinfo.hussar.view.service.IHussarViewManagementService;
import com.jxdinfo.hussar.view.service.IHussarViewOrderService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class HussarViewManagementServiceImpl
extends HussarServiceImpl<HussarViewManagementMapper, HussarView>
implements IHussarViewManagementService {
    @Resource
    private HussarViewManagementMapper hussarViewManagementMapper;
    @Resource
    private IHussarViewOrderService iHussarViewOrderService;
    private static final Logger logger = LoggerFactory.getLogger(HussarViewManagementServiceImpl.class);

    public ApiResponse<Long> saveViewReturnId(DataView dataView) {
        Long userId = BaseSecurityUtil.getUser().getId();
        ArrayList<String> authority = new ArrayList<String>();
        authority.add(String.valueOf(userId));
        dataView.setViewPermission(authority);
        HussarView customView = this.convertToCustomView(dataView);
        try {
            this.hussarViewManagementMapper.insert(customView);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u4fdd\u5b58\u89c6\u56fe\u5931\u8d25");
        }
        HussarViewOrder oldOrder = (HussarViewOrder)this.iHussarViewOrderService.getOrderByUser(customView.getPageId(), userId, customView.getComponentId()).getData();
        HussarViewOrder newOrder = new HussarViewOrder();
        if (HussarUtils.isEmpty((Object)oldOrder)) {
            List<HussarView> views = this.hussarViewManagementMapper.getByPageId(customView.getPageId(), String.valueOf(userId), customView.getComponentId(), null);
            ArrayList<String> viewOrders = new ArrayList<String>();
            HashMap<String, String> viewHide = new HashMap<String, String>();
            for (HussarView view : views) {
                viewOrders.add(String.valueOf(view.getViewId()));
                viewHide.put(String.valueOf(view.getViewId()), "true");
            }
            viewOrders.add(0, customView.getViewId().toString());
            viewHide.put(customView.getViewId().toString(), "true");
            newOrder.setPageId(customView.getPageId());
            newOrder.setComponentId(customView.getComponentId());
            newOrder.setUserId(userId);
            newOrder.setViewOrder(JSONObject.toJSONString(viewOrders));
            newOrder.setViewHide(JSONObject.toJSONString(viewHide));
            this.iHussarViewOrderService.insert(newOrder).getData();
        } else {
            HussarUtils.copy((Object)oldOrder, (Object)newOrder);
            List order = JSONObject.parseArray((String)newOrder.getViewOrder(), String.class);
            HashMap hide = (HashMap)JSONObject.parseObject((String)newOrder.getViewHide(), HashMap.class);
            order.add(0, String.valueOf(customView.getViewId()));
            hide.put(String.valueOf(customView.getViewId()), "true");
            newOrder.setViewOrder(JSONObject.toJSONString((Object)order));
            newOrder.setViewHide(JSONObject.toJSONString((Object)hide));
            this.iHussarViewOrderService.update(newOrder).getData();
        }
        return ApiResponse.success((Object)customView.getViewId());
    }

    public ApiResponse<List<DataView>> get(String formId, String userId, boolean isDevelop) {
        List<HussarView> customViews = this.hussarViewManagementMapper.getByUser(Long.valueOf(formId), userId, isDevelop);
        if (HussarUtils.isEmpty(customViews)) {
            return ApiResponse.success((String)"\u65e0\u81ea\u5b9a\u4e49\u89c6\u56fe");
        }
        ArrayList<DataView> dataViews = new ArrayList<DataView>();
        for (HussarView customView : customViews) {
            DataView view = this.convertToDataView(customView);
            dataViews.add(view);
        }
        return ApiResponse.success(dataViews);
    }

    public ApiResponse<List<DataView>> get(String pageId, String userId, String componentId, String appId) {
        List<HussarView> customViews;
        if (HussarUtils.isEmpty((Object)userId)) {
            SecurityUser user = BaseSecurityUtil.getUser();
            if (HussarUtils.isEmpty((Object)user)) {
                logger.error("\u81ea\u5b9a\u4e49\u89c6\u56fe\u67e5\u8be2\u5931\u8d25\uff0c\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
                return ApiResponse.fail((String)"\u65e0\u7528\u6237\u4fe1\u606f");
            }
            customViews = this.hussarViewManagementMapper.getByPageId(pageId, String.valueOf(user.getId()), componentId, appId);
        } else {
            customViews = this.hussarViewManagementMapper.getByPageId(pageId, userId, componentId, appId);
        }
        List<DataView> dataViews = new ArrayList<DataView>();
        for (HussarView customView : customViews) {
            DataView view = this.convertToDataView(customView);
            dataViews.add(view);
        }
        dataViews = this.handleViewOrder(pageId, componentId, dataViews, null);
        return ApiResponse.success(dataViews);
    }

    private List<DataView> handleViewOrder(String pageId, String componentId, List<DataView> allViews, List<String> originalOrder) {
        ArrayList<DataView> orderView = new ArrayList<DataView>();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long userId = shiroUser.getId();
        HussarViewOrder order = (HussarViewOrder)this.iHussarViewOrderService.getOrderByUser(pageId, userId, componentId).getData();
        if (HussarUtils.isNotEmpty((Object)order)) {
            List viewOrders = JSONObject.parseArray((String)order.getViewOrder(), String.class);
            List viewOrder = viewOrders.stream().distinct().collect(Collectors.toList());
            ArrayList<Object> newViewOrder = new ArrayList<Object>();
            newViewOrder.addAll(viewOrder);
            Map viewHide = (Map)JSONObject.parseObject((String)order.getViewHide(), HashMap.class);
            HashMap<String, String> newViewHide = new HashMap<String, String>();
            HussarUtils.copy((Object)viewHide, newViewHide);
            for (DataView allView : allViews) {
                Optional<String> first = viewOrder.stream().filter(v -> HussarUtils.equals((Object)v, (Object)allView.getId())).findFirst();
                if (first.isPresent() || !HussarUtils.equals((Object)allView.getCategory(), (Object)"public")) continue;
                newViewOrder.add(allView.getId());
                newViewHide.put(allView.getId(), "true");
            }
            List newDistinctViewOrder = newViewOrder.stream().distinct().collect(Collectors.toList());
            order.setViewOrder(JSONObject.toJSONString(newDistinctViewOrder));
            order.setViewHide(JSONObject.toJSONString(newViewHide));
            this.iHussarViewOrderService.update(order);
            for (String viewId : newDistinctViewOrder) {
                Optional<DataView> first = allViews.stream().filter(view -> HussarUtils.equals((Object)view.getId(), (Object)viewId)).findFirst();
                if (!first.isPresent()) continue;
                DataView view2 = first.get();
                String hide = (String)newViewHide.get(viewId);
                if (HussarUtils.isNotEmpty((Object)hide)) {
                    view2.setVisible(Boolean.parseBoolean(hide));
                }
                orderView.add(view2);
            }
            return orderView;
        }
        if (HussarUtils.isEmpty(originalOrder)) {
            for (DataView view3 : allViews) {
                view3.setVisible(true);
                orderView.add(view3);
            }
        } else {
            for (String name : originalOrder) {
                Optional<DataView> any = allViews.stream().filter(x -> HussarUtils.equals((Object)x.getName(), (Object)name)).findAny();
                if (!any.isPresent()) continue;
                DataView view4 = any.get();
                view4.setVisible(true);
                orderView.add(view4);
            }
        }
        return orderView;
    }

    public ApiResponse<List<DataView>> getAll(String formId) {
        List<HussarView> customViews = this.hussarViewManagementMapper.getByFormId(Long.valueOf(formId));
        if (HussarUtils.isEmpty(customViews)) {
            return ApiResponse.success((String)"\u65e0\u81ea\u5b9a\u4e49\u89c6\u56fe");
        }
        ArrayList<DataView> dataViews = new ArrayList<DataView>();
        for (HussarView customView : customViews) {
            DataView view = this.convertToDataView(customView);
            dataViews.add(view);
        }
        return ApiResponse.success(dataViews);
    }

    public ApiResponse<List<DataView>> getView(String formId, int type) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            logger.error("\u81ea\u5b9a\u4e49\u89c6\u56fe\u67e5\u8be2\u5931\u8d25\uff0c\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
            return ApiResponse.fail((String)"\u65e0\u7528\u6237\u4fe1\u606f");
        }
        Long userId = user.getId();
        List<HussarView> customViews = this.hussarViewManagementMapper.getView(Long.valueOf(formId), userId + "", type);
        if (HussarUtils.isEmpty(customViews)) {
            return ApiResponse.success((String)"\u65e0\u81ea\u5b9a\u4e49\u89c6\u56fe");
        }
        ArrayList<DataView> dataViews = new ArrayList<DataView>();
        for (HussarView customView : customViews) {
            DataView view = this.convertToDataView(customView);
            dataViews.add(view);
        }
        return ApiResponse.success(dataViews);
    }

    public ApiResponse<DataView> getById(Long viewId) {
        HussarView customView = (HussarView)this.hussarViewManagementMapper.selectById(viewId);
        try {
            return ApiResponse.success((Object)this.convertToDataView(customView));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u81ea\u5b9a\u4e49\u89c6\u56fe\u5f02\u5e38\uff1a{}\uff0cviewId\uff1a{}", (Object)e.getMessage(), (Object)viewId);
            return ApiResponse.fail((String)"\u83b7\u53d6\u89c6\u56fe ==> \u83b7\u53d6\u5931\u8d25");
        }
    }

    public ApiResponse<Boolean> deleteById(String viewId) {
        try {
            this.hussarViewManagementMapper.deleteById(Long.valueOf(viewId));
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u81ea\u5b9a\u4e49\u89c6\u56fe\u5f02\u5e38\uff1a{}\uff0cviewId\uff1a{}", (Object)e.getMessage(), (Object)viewId);
            return ApiResponse.fail((String)"\u5220\u9664\u89c6\u56fe ==> \u5220\u9664\u5931\u8d25");
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Boolean> update(DataView dataView) {
        HussarView customView = this.convertToCustomView(dataView);
        try {
            this.hussarViewManagementMapper.updateById(customView);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u66f4\u65b0\u81ea\u5b9a\u4e49\u89c6\u56fe ==> \u66f4\u65b0\u5931\u8d25");
        }
        return ApiResponse.success((Object)true);
    }

    public Long copyView(DataView dataView) {
        ArrayList<String> authority = new ArrayList<String>();
        Long userId = BaseSecurityUtil.getUser().getId();
        authority.add(String.valueOf(userId));
        dataView.setViewPermission(authority);
        HussarView customView = this.convertToCustomView(dataView);
        this.hussarViewManagementMapper.insert(customView);
        Long viewId = customView.getViewId();
        HussarViewOrder viewOrder = (HussarViewOrder)this.iHussarViewOrderService.getOrderByUser(dataView.getPageId(), userId, dataView.getComponentId()).getData();
        if (HussarUtils.isNotEmpty((Object)viewOrder)) {
            List orderList = JSONObject.parseArray((String)viewOrder.getViewOrder(), String.class);
            orderList.add(String.valueOf(viewId));
            Map viewHide = (Map)JSONObject.parseObject((String)viewOrder.getViewHide(), HashMap.class);
            viewHide.put(String.valueOf(viewId), "true");
            viewOrder.setViewOrder(JSONObject.toJSONString((Object)orderList));
            viewOrder.setViewHide(JSONObject.toJSONString((Object)viewHide));
            this.iHussarViewOrderService.update(viewOrder);
        }
        return viewId;
    }

    public ApiResponse<Boolean> updateBatch(HussarViewDTO hussarViewDTO) {
        ArrayList<HussarView> customViews = new ArrayList<HussarView>();
        for (DataView dataView : hussarViewDTO.getViews()) {
            HussarView view = this.convertToCustomView(dataView);
            customViews.add(view);
        }
        try {
            this.saveOrUpdateBatch(customViews);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u6279\u91cf\u5220\u9664\u89c6\u56fe\u5931\u8d25");
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Boolean> deleteBatch(String pageId) {
        try {
            this.hussarViewManagementMapper.delete((Wrapper)new QueryWrapper().lambda().eq(HussarView::getPageId, (Object)pageId));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u6279\u91cf\u5220\u9664\u89c6\u56fe\u5931\u8d25");
        }
        return ApiResponse.success((Object)true);
    }

    public HussarView convertToCustomView(DataView dataView) {
        HussarView customView = new HussarView();
        if (HussarUtils.isNotEmpty((Object)dataView.getId())) {
            customView.setViewId(Long.valueOf(dataView.getId()));
        }
        customView.setName(dataView.getName());
        customView.setAlias(dataView.getAlias());
        customView.setCategory(dataView.getCategory());
        customView.setViewType(dataView.getViewType());
        customView.setTabType(dataView.getTabType());
        customView.setStyles(JSON.toJSONString((Object)dataView.getStyles()));
        customView.setButtons(JSON.toJSONString((Object)dataView.getButtons()));
        customView.setTools(JSON.toJSONString((Object)dataView.getTools()));
        customView.setOperations(JSON.toJSONString((Object)dataView.getOperations()));
        customView.setFilters(JSON.toJSONString((Object)dataView.getFilters()));
        customView.setOrderBy(JSON.toJSONString((Object)dataView.getOrderBy()));
        customView.setShowFields(JSON.toJSONString((Object)dataView.getShowFields()));
        customView.setShowFieldMulti(JSON.toJSONString((Object)dataView.getShowFieldMulti()));
        customView.setViewPermission(JSON.toJSONString((Object)dataView.getViewPermission()));
        customView.setVisible(String.valueOf(dataView.isVisible()));
        customView.setFormId(dataView.getFormId());
        customView.setI18nKeys(dataView.getI18nKeys());
        customView.setNavLeftTreeOption(JSON.toJSONString((Object)dataView.getNavLeftTreeOption()));
        customView.setFilterFields(JSON.toJSONString((Object)dataView.getFilterFields()));
        customView.setTopFilterFields(JSON.toJSONString((Object)dataView.getTopFilterFields()));
        customView.setCssConfigs(JSON.toJSONString((Object)dataView.getConfigs()));
        customView.setShowCount(dataView.getShowCount());
        customView.setComponentId(dataView.getComponentId());
        customView.setPageId(dataView.getPageId());
        return customView;
    }

    public DataView convertToDataView(HussarView customView) {
        DataView view = new DataView();
        view.setId(String.valueOf(customView.getViewId()));
        view.setName(customView.getName());
        view.setAlias(customView.getAlias());
        view.setCategory(customView.getCategory());
        view.setViewType(customView.getViewType());
        view.setTabType(customView.getTabType());
        view.setVisible(HussarUtils.equals((Object)customView.getVisible(), (Object)"true"));
        view.setStyles((Map)JSON.parseObject((String)customView.getStyles(), HashMap.class));
        view.setViewPermission(JSON.parseObject((String)customView.getViewPermission(), Object.class));
        view.setButtons(JSONArray.parseArray((String)customView.getButtons(), TableButton.class));
        view.setTools(JSONArray.parseArray((String)customView.getTools(), TableButton.class));
        view.setOperations(JSONArray.parseArray((String)customView.getOperations(), TableButton.class));
        view.setFilters(JSONArray.parseArray((String)customView.getFilters(), Filter.class));
        view.setOrderBy(JSONArray.parseArray((String)customView.getOrderBy(), OrderItem.class));
        view.setShowFields(JSONArray.parseArray((String)customView.getShowFields(), ShowField.class));
        view.setShowFieldMulti(JSONArray.parseArray((String)customView.getShowFieldMulti(), ShowFieldMulti.class));
        view.setFormId(customView.getFormId());
        view.setI18nKeys(customView.getI18nKeys());
        view.setNavLeftTreeOption((NavLeftTreeOption)JSON.parseObject((String)customView.getNavLeftTreeOption(), NavLeftTreeOption.class));
        view.setFilterFields(JSONArray.parseArray((String)customView.getFilterFields(), FilterField.class));
        view.setTopFilterFields(JSONArray.parseArray((String)customView.getTopFilterFields(), FilterField.class));
        view.setConfigs((Map)JSONObject.parseObject((String)customView.getCssConfigs()));
        view.setShowCount(customView.getShowCount());
        view.setPageId(customView.getPageId());
        view.setComponentId(customView.getComponentId());
        return view;
    }
}

