/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.view.controller;

import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.view.dto.HussarViewOrderDTO;
import com.jxdinfo.hussar.view.model.HussarViewOrder;
import com.jxdinfo.hussar.view.service.IHussarViewManagementService;
import com.jxdinfo.hussar.view.service.IHussarViewOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u89c6\u56fe\u7ba1\u7406\u63a5\u53e3")
@RestController
@RequestMapping(value={"/hussarBase/view"})
public class HussarViewManagementController {
    private static final Logger logger = LoggerFactory.getLogger(HussarViewManagementController.class);
    @Resource
    private IHussarViewManagementService iHussarViewManagementService;
    @Resource
    private IHussarViewOrderService iHussarViewOrderService;

    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u89c6\u56fe", notes="\u4fdd\u5b58\u6570\u636e\u89c6\u56fe")
    @PostMapping(value={"/saveViewReturnId"})
    public ApiResponse<Long> saveViewReturnId(@RequestBody DataView dataView) {
        try {
            return this.iHussarViewManagementService.saveViewReturnId(dataView);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8868\u5355\u89c6\u56fe\u5931\u8d25", (Throwable)e);
            return ApiResponse.fail((String)"\u83b7\u53d6\u8868\u5355\u89c6\u56fe\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u6839\u636e\u8868\u5355id\u83b7\u53d6\u6570\u636e\u89c6\u56fe", notes="\u6839\u636e\u8868\u5355id\u83b7\u53d6\u6570\u636e\u89c6\u56fe")
    @GetMapping(value={"/getByFormId"})
    public ApiResponse<List<DataView>> get(@RequestParam String formId, @RequestParam(required=false) String userId, @RequestParam(required=false) boolean isDevelop) {
        return this.iHussarViewManagementService.get(formId, userId, isDevelop);
    }

    @ApiOperation(value="\u6839\u636e\u8868\u5355id\u83b7\u53d6\u6570\u636e\u89c6\u56fe", notes="\u6839\u636e\u8868\u5355id\u83b7\u53d6\u6570\u636e\u89c6\u56fe")
    @GetMapping(value={"/get"})
    public ApiResponse<List<DataView>> get(@RequestParam String pageId, @RequestParam(required=false) String userId, @RequestParam String componentId, @RequestParam(required=false) String appId) {
        return this.iHussarViewManagementService.get(pageId, userId, componentId, appId);
    }

    @ApiOperation(value="\u6839\u636e\u8868\u5355ID\u83b7\u53d6\u5168\u90e8\u81ea\u5b9a\u4e49\u89c6\u56fe\u6216\u516c\u5171\u89c6\u56fe", notes="\u6839\u636e\u8868\u5355ID\u83b7\u53d6\u5168\u90e8\u81ea\u5b9a\u4e49\u89c6\u56fe\u6216\u516c\u5171\u89c6\u56fe")
    @GetMapping(value={"/getAll"})
    public ApiResponse<List<DataView>> getAll(@RequestParam String formId) {
        return this.iHussarViewManagementService.getAll(formId);
    }

    @ApiOperation(value="\u6839\u636e\u8868\u5355id\u548c\u7c7b\u578b\u83b7\u53d6\u81ea\u5b9a\u4e49\u89c6\u56fe", notes="\u6839\u636e\u8868\u5355id\u548c\u7c7b\u578b\u83b7\u53d6\u81ea\u5b9a\u4e49\u89c6\u56fe")
    @GetMapping(value={"/getView"})
    public ApiResponse<List<DataView>> getView(@RequestParam String formId, @RequestParam int type) {
        return this.iHussarViewManagementService.getView(formId, type);
    }

    @ApiOperation(value="\u6839\u636e\u89c6\u56feid\u83b7\u53d6\u6570\u636e\u89c6\u56fe", notes="\u6839\u636e\u89c6\u56feid\u83b7\u53d6\u6570\u636e\u89c6\u56fe")
    @GetMapping(value={"/getById"})
    public ApiResponse<DataView> getById(@RequestParam Long viewId) {
        return this.iHussarViewManagementService.getById(viewId);
    }

    @PostMapping(value={"/updateView"})
    public ApiResponse<Boolean> update(@RequestBody DataView dataView) {
        return this.iHussarViewManagementService.update(dataView);
    }

    @PostMapping(value={"/copy_view"})
    public ApiResponse<Long> copyView(@RequestBody DataView dataView) {
        Long ViewId = this.iHussarViewManagementService.copyView(dataView);
        return ApiResponse.success((Object)ViewId);
    }

    @GetMapping(value={"/deleteById"})
    public ApiResponse<Boolean> deleteById(@RequestParam String viewId) {
        return this.iHussarViewManagementService.deleteById(viewId);
    }

    @GetMapping(value={"/getOrderByUser"})
    public ApiResponse<HussarViewOrder> getOrderByUser(@RequestParam Long formId, @RequestParam Long userId) {
        return this.iHussarViewOrderService.getOrderByUser(formId, userId);
    }

    @GetMapping(value={"/getOrderBypageId"})
    public ApiResponse<HussarViewOrder> getOrderByUser(@RequestParam String pageId, @RequestParam(required=false) Long userId, @RequestParam String componentId) {
        return this.iHussarViewOrderService.getOrderByUser(pageId, userId, componentId);
    }

    @PostMapping(value={"/insert"})
    public ApiResponse<Boolean> insert(@RequestBody HussarViewOrder customViewOrder) {
        return this.iHussarViewOrderService.insert(customViewOrder);
    }

    @PostMapping(value={"/updateViewOrder"})
    public ApiResponse<Boolean> update(@RequestBody HussarViewOrderDTO hussarViewOrderDTO) {
        return this.iHussarViewOrderService.updateBatch(hussarViewOrderDTO);
    }
}

