/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.unifiedtodo.common.BpmCommonConstantProperties;
import com.jxdinfo.hussar.unifiedtodo.dao.UnifiedToDoMapper;
import com.jxdinfo.hussar.unifiedtodo.dto.CountQueryDto;
import com.jxdinfo.hussar.unifiedtodo.dto.QueryToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveCategoryDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveProcessDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveProcessInfoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TransferTaskDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateCategoryDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateTaskUserToDoDto;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedCategoryInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedCategoryType;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedStartTask;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedSystemInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedCategoryInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedCategoryTypeService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedStartTaskService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedSystemInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskUserService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedToDoService;
import com.jxdinfo.hussar.unifiedtodo.vo.CategoryQueryVo;
import com.jxdinfo.hussar.unifiedtodo.vo.CountQueryVo;
import com.jxdinfo.hussar.unifiedtodo.vo.ToDoVo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class UnifiedToDoServiceImpl
implements IUnifiedToDoService {
    @Resource
    private UnifiedToDoMapper unifiedToDoMapper;
    @Autowired
    private IUnifiedSystemInfoService unifiedSystemInfoServiceImpl;
    @Autowired
    private IUnifiedTaskInfoService unifiedTaskInfoServiceImpl;
    @Autowired
    private IUnifiedTaskUserService unifiedTaskUserServiceImpl;
    @Autowired
    private IUnifiedTaskUserService unifiedTaskUserService;
    @Autowired
    private IUnifiedStartTaskService unifiedStartTaskServiceImpl;
    @Resource
    private IUnifiedCategoryTypeService unifiedCategoryTypeService;
    @Resource
    private IUnifiedCategoryInfoService unifiedCategoryInfoService;
    private static final Logger logger = LoggerFactory.getLogger(UnifiedToDoServiceImpl.class);
    @Autowired
    private BpmCommonConstantProperties bpmCommonConstantProperties;

    public ApiResponse<Long> getCountTotal(String systemId, String userId, String executeStatus) {
        LambdaQueryWrapper wrapperInfo = new LambdaQueryWrapper();
        LambdaQueryWrapper wrapperUser = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)systemId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
            wrapperUser.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
        }
        if (ToolUtil.isNotEmpty((Object)executeStatus)) {
            wrapperUser.eq(UnifiedTaskUser::getExecuteStatus, (Object)executeStatus);
            wrapperInfo.eq(UnifiedTaskInfo::getTaskStatus, (Object)executeStatus);
        }
        if (ToolUtil.isNotEmpty((Object)userId)) {
            wrapperUser.eq(UnifiedTaskUser::getUserId, (Object)userId);
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperUser.isNull(UnifiedTaskUser::getUrgeStatus)).isNull(UnifiedTaskUser::getCcMoment)).eq(UnifiedTaskUser::getUserType, (Object)"1");
            return ApiResponse.success((Object)this.unifiedTaskUserServiceImpl.count((Wrapper)wrapperUser));
        }
        return ApiResponse.success((Object)this.unifiedTaskInfoServiceImpl.count((Wrapper)wrapperInfo));
    }

    public ApiResponse<JSONObject> countAllTotal(String systemId, String userId) {
        return this.countAllTotal(new CountQueryDto(systemId, userId));
    }

    public ApiResponse<JSONObject> countAllTotal(CountQueryDto countQueryDto) {
        boolean isEmptyResult;
        JSONObject jsonObject = new JSONObject();
        boolean bl = isEmptyResult = countQueryDto.getProcessDefinitionKey() != null && countQueryDto.getProcessDefinitionKey().isEmpty();
        if (!isEmptyResult && HussarUtils.isNotEmpty((Object)countQueryDto.getCategoryId())) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(UnifiedCategoryInfo::getCategoryTypeId, (Object)countQueryDto.getCategoryId());
            List list = this.unifiedCategoryInfoService.list((Wrapper)lambdaQueryWrapper);
            List processKeyList = list.stream().map(UnifiedCategoryInfo::getCategoryAttribute).collect(Collectors.toList());
            if (countQueryDto.getProcessDefinitionKey() != null) {
                countQueryDto.getProcessDefinitionKey().retainAll(processKeyList);
            } else {
                countQueryDto.setProcessDefinitionKey(processKeyList);
            }
            boolean bl2 = isEmptyResult = countQueryDto.getProcessDefinitionKey() != null && countQueryDto.getProcessDefinitionKey().isEmpty();
        }
        if (isEmptyResult) {
            jsonObject.put("todo", (Object)0);
            jsonObject.put("done", (Object)0);
            jsonObject.put("cc", (Object)0);
            jsonObject.put("urge", (Object)0);
            jsonObject.put("start", (Object)0);
            if (countQueryDto.isCountGroupBySystemId()) {
                jsonObject.put("systemCountInfo", new ArrayList());
            }
            return ApiResponse.success((Object)jsonObject);
        }
        if (countQueryDto.isCountGroupBySystemId()) {
            List<CountQueryVo> list = this.unifiedToDoMapper.countAllTotalWithGroup(countQueryDto);
            List<CountQueryVo> startCountList = this.unifiedToDoMapper.countStartTaskWithGroup(countQueryDto);
            HashMap<String, CountQueryVo> map = new HashMap<String, CountQueryVo>();
            for (CountQueryVo countQueryVo : startCountList) {
                map.put(countQueryVo.getSystemId(), countQueryVo);
            }
            CountQueryVo countAll = new CountQueryVo();
            for (CountQueryVo countQueryVo : list) {
                CountQueryVo startCount = (CountQueryVo)map.remove(countQueryVo.getSystemId());
                countAll.setTodo(countAll.getTodo() + countQueryVo.getTodo());
                countAll.setDone(countAll.getDone() + countQueryVo.getDone());
                countAll.setCc(countAll.getCc() + countQueryVo.getCc());
                countAll.setUrge(countAll.getUrge() + countQueryVo.getUrge());
                if (startCount == null) continue;
                countQueryVo.setStarted(startCount.getStarted());
                countAll.setStarted(countAll.getStarted() + countQueryVo.getStarted());
            }
            if (!map.isEmpty()) {
                for (CountQueryVo countQueryVo : map.values()) {
                    countAll.setStarted(countAll.getStarted() + countQueryVo.getStarted());
                    list.add(countQueryVo);
                }
            }
            list.sort(Comparator.comparing(CountQueryVo::getSystemId));
            jsonObject.put("todo", (Object)countAll.getTodo());
            jsonObject.put("done", (Object)countAll.getDone());
            jsonObject.put("cc", (Object)countAll.getCc());
            jsonObject.put("urge", (Object)countAll.getUrge());
            jsonObject.put("start", (Object)countAll.getStarted());
            jsonObject.put("systemCountInfo", list);
        } else {
            CountQueryVo countQueryVo = this.unifiedToDoMapper.countAllTotal(countQueryDto);
            CountQueryVo startQueryVo = this.unifiedToDoMapper.countStartTask(countQueryDto);
            jsonObject.put("todo", (Object)countQueryVo.getTodo());
            jsonObject.put("done", (Object)countQueryVo.getDone());
            jsonObject.put("cc", (Object)countQueryVo.getCc());
            jsonObject.put("urge", (Object)countQueryVo.getUrge());
            jsonObject.put("start", (Object)startQueryVo.getStarted());
        }
        return ApiResponse.success((Object)jsonObject);
    }

    public ApiResponse<String> saveTask(SaveToDoDto saveToDoDto) {
        logger.info("*********************\u7edf\u4e00\u5f85\u529e\u4fdd\u5b58\u4efb\u52a1saveTask\u5f00\u59cb*************");
        logger.info("\u5165\u53c2saveTodoDto:{}", (Object)JSON.toJSONString((Object)saveToDoDto));
        List executors = saveToDoDto.getExecutors();
        List followers = saveToDoDto.getFollowers();
        String taskStatus = ToolUtil.isNotEmpty((Object)saveToDoDto.getTaskStatus()) ? saveToDoDto.getTaskStatus() : "0";
        saveToDoDto.setTaskStatus(taskStatus);
        this.unifiedTaskInfoServiceImpl.save(saveToDoDto);
        logger.info("\u5f85\u529e\u4efb\u52a1\u4fdd\u5b58\u6210\u529f,\u4fdd\u5b58\u6570\u636e\u4e3a:{}", (Object)JSON.toJSONString((Object)saveToDoDto));
        if (HussarUtils.isNotEmpty((Object)executors)) {
            for (UnifiedTaskUser unifiedTaskUser : executors) {
                unifiedTaskUser.setSystemId(saveToDoDto.getSystemId());
                unifiedTaskUser.setTaskId(saveToDoDto.getTaskId());
                unifiedTaskUser.setTodoId(saveToDoDto.getTodoId());
                unifiedTaskUser.setExecuteStatus(taskStatus);
                unifiedTaskUser.setUserType("1");
                unifiedTaskUser.setReceiveTime(ToolUtil.isNotEmpty((Object)saveToDoDto.getLastTime()) ? saveToDoDto.getLastTime() : new Date());
            }
        }
        if (ToolUtil.isNotEmpty((Object)followers)) {
            for (UnifiedTaskUser unifiedTaskUser : followers) {
                unifiedTaskUser.setSystemId(saveToDoDto.getSystemId());
                unifiedTaskUser.setTaskId(saveToDoDto.getTaskId());
                unifiedTaskUser.setTodoId(saveToDoDto.getTodoId());
                unifiedTaskUser.setExecuteStatus(taskStatus);
                unifiedTaskUser.setUserType("0");
                unifiedTaskUser.setReceiveTime(ToolUtil.isNotEmpty((Object)saveToDoDto.getLastTime()) ? saveToDoDto.getLastTime() : new Date());
            }
            if (HussarUtils.isNotEmpty((Object)executors)) {
                executors.addAll(followers);
            }
        }
        logger.info("\u4eba\u5458\u4fe1\u606f\u4e3a:{}", (Object)JSON.toJSONString((Object)executors));
        this.unifiedTaskUserServiceImpl.saveBatch(executors);
        logger.info("*********************\u7edf\u4e00\u5f85\u529e\u4fdd\u5b58\u4efb\u52a1saveTask\u5b8c\u6210*************");
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateTask(SaveToDoDto saveToDoDto) {
        logger.info("*********************\u7edf\u4e00\u5f85\u529e\u66f4\u65b0\u5f85\u529e\u4efb\u52a1updateTask\u5f00\u59cb*************");
        logger.info("\u5165\u53c2saveTodoDto:{}", (Object)JSON.toJSONString((Object)saveToDoDto));
        saveToDoDto.setLastTime(ToolUtil.isNotEmpty((Object)saveToDoDto.getLastTime()) ? saveToDoDto.getLastTime() : new Date());
        LambdaQueryWrapper wrapperInfo = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getSystemId())) {
            wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)saveToDoDto.getSystemId());
        }
        wrapperInfo.eq(UnifiedTaskInfo::getTaskId, (Object)saveToDoDto.getTaskId());
        UnifiedTaskInfo s = (UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.getOne((Wrapper)wrapperInfo);
        if (ToolUtil.isEmpty((Object)s)) {
            this.unifiedTaskInfoServiceImpl.save(saveToDoDto);
            logger.info("\u4fdd\u5b58\u5f85\u529e\u4efb\u52a1\u6210\u529f\uff0c\u4fdd\u5b58\u6570\u636e\u4e3a:{}", (Object)JSON.toJSONString((Object)saveToDoDto));
        } else {
            this.unifiedTaskInfoServiceImpl.updateById(saveToDoDto);
            logger.info("\u4fee\u6539\u5f85\u529e\u4efb\u52a1\u6210\u529f\uff0c\u4fee\u6539\u6570\u636e\u4e3a:{}", (Object)JSON.toJSONString((Object)saveToDoDto));
        }
        List executors = saveToDoDto.getExecutors();
        List followers = saveToDoDto.getFollowers();
        ArrayList allTaskUsers = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)executors)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskUser::getSystemId, (Object)saveToDoDto.getSystemId())).eq(UnifiedTaskUser::getTaskId, (Object)saveToDoDto.getTaskId());
            this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapper);
            logger.info("\u6210\u529f\u5220\u9664\u4eba\u5458\u4fe1\u606f\uff0c\u5220\u9664\u6570\u636e\u7684systemId:{},taskId:{}", (Object)saveToDoDto.getSystemId(), (Object)saveToDoDto.getTaskId());
            for (UnifiedTaskUser unifiedTaskUser : executors) {
                unifiedTaskUser.setSystemId(saveToDoDto.getSystemId());
                unifiedTaskUser.setTaskId(saveToDoDto.getTaskId());
                unifiedTaskUser.setTodoId(saveToDoDto.getTodoId());
                unifiedTaskUser.setExecuteStatus("0");
                unifiedTaskUser.setUserType("1");
                unifiedTaskUser.setReceiveTime(ToolUtil.isNotEmpty((Object)saveToDoDto.getLastTime()) ? saveToDoDto.getLastTime() : new Date());
            }
            allTaskUsers.addAll(executors);
            if (ToolUtil.isNotEmpty((Object)followers)) {
                for (UnifiedTaskUser unifiedTaskUser : followers) {
                    unifiedTaskUser.setSystemId(saveToDoDto.getSystemId());
                    unifiedTaskUser.setTaskId(saveToDoDto.getTaskId());
                    unifiedTaskUser.setTodoId(saveToDoDto.getTodoId());
                    unifiedTaskUser.setExecuteStatus("0");
                    unifiedTaskUser.setUserType("0");
                    unifiedTaskUser.setReceiveTime(ToolUtil.isNotEmpty((Object)saveToDoDto.getLastTime()) ? saveToDoDto.getLastTime() : new Date());
                }
                allTaskUsers.addAll(followers);
            }
        }
        this.unifiedTaskUserServiceImpl.saveBatch(allTaskUsers);
        logger.info("\u4fdd\u5b58\u4eba\u5458\u4fe1\u606f\u6210\u529f\uff0c\u4fdd\u5b58\u6570\u636e\u4e3a:{}", (Object)JSON.toJSONString(allTaskUsers));
        logger.info("*********************\u7edf\u4e00\u5f85\u529e\u66f4\u65b0\u5f85\u529e\u4efb\u52a1updateTask\u5b8c\u6210*************");
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<Page<SaveToDoDto>> getListTask(Page<SaveToDoDto> page, QueryToDoDto queryToDoDto) {
        Page<SaveToDoDto> saveToDoDtoPage;
        boolean isEmptyResult;
        this.handleDate(queryToDoDto);
        boolean bl = isEmptyResult = queryToDoDto.getProcessDefinitionKey() != null && queryToDoDto.getProcessDefinitionKey().isEmpty();
        if (!isEmptyResult && HussarUtils.isNotEmpty((Object)queryToDoDto.getCategoryId())) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(UnifiedCategoryInfo::getCategoryTypeId, (Object)queryToDoDto.getCategoryId());
            List list = this.unifiedCategoryInfoService.list((Wrapper)lambdaQueryWrapper);
            List processKeyList = list.stream().map(UnifiedCategoryInfo::getCategoryAttribute).collect(Collectors.toList());
            if (queryToDoDto.getProcessDefinitionKey() != null) {
                queryToDoDto.getProcessDefinitionKey().retainAll(processKeyList);
            } else {
                queryToDoDto.setProcessDefinitionKey(processKeyList);
            }
            boolean bl2 = isEmptyResult = queryToDoDto.getProcessDefinitionKey() != null && queryToDoDto.getProcessDefinitionKey().isEmpty();
        }
        if (isEmptyResult) {
            Page pageProcess = new Page();
            pageProcess.setCurrent(page.getCurrent());
            pageProcess.setSize(page.getSize());
            pageProcess.setTotal(0L);
            pageProcess.setRecords(new ArrayList());
            return ApiResponse.success((Object)pageProcess);
        }
        if (HussarUtils.isNotEmpty((Object)queryToDoDto.getSubject())) {
            queryToDoDto.setSubject(queryToDoDto.getSubject().replace("%", "\\%").replace("_", "\\_"));
        }
        if (HussarUtils.isNotEmpty((Object)queryToDoDto.getProcessTitle())) {
            queryToDoDto.setProcessTitle(queryToDoDto.getProcessTitle().replace("%", "\\%").replace("_", "\\_"));
        }
        List saveToDoDtoList = new ArrayList();
        if ("3".equals(queryToDoDto.getUserType())) {
            Page pageProcess = new Page();
            pageProcess.setCurrent(page.getCurrent());
            pageProcess.setSize(page.getSize());
            if (HussarUtils.isEmpty((Object)queryToDoDto.getCreateUserId()) && HussarUtils.isNotEmpty((Object)queryToDoDto.getUserId())) {
                queryToDoDto.setCreateUserId(queryToDoDto.getUserId());
            }
            saveToDoDtoPage = this.unifiedToDoMapper.queryProcessList((Page<SaveProcessDto>)pageProcess, queryToDoDto);
            saveToDoDtoList = saveToDoDtoPage.getRecords();
        } else {
            saveToDoDtoPage = this.unifiedToDoMapper.queryTaskList(page, queryToDoDto);
            saveToDoDtoList = saveToDoDtoPage.getRecords();
            for (Object saveToDoDto : saveToDoDtoList) {
                if (!"0".equals(saveToDoDto.getSystemSource())) continue;
                if (saveToDoDto.getMandator() != null && saveToDoDto.getWebLinkurl() != null) {
                    saveToDoDto.setWebLinkurl(saveToDoDto.getWebLinkurl().replaceFirst("&taskId=" + saveToDoDto.getTaskId(), "&taskId=" + saveToDoDto.getTaskId() + ":" + saveToDoDto.getMandator()));
                }
                if (saveToDoDto.getCcMoment() == null) continue;
                saveToDoDto.setTaskId(saveToDoDto.getTaskId() + ":" + saveToDoDto.getCcMoment());
            }
        }
        if ("3".equals(queryToDoDto.getUserType()) || "1".equals(queryToDoDto.getExecuteStatus()) && "1".equals(queryToDoDto.getUserType())) {
            ArrayList<String> processInstIdList = new ArrayList<String>();
            for (SaveToDoDto saveToDoDto : saveToDoDtoList) {
                if ("1".equals(saveToDoDto.getProcessState())) {
                    saveToDoDto.setCurrentNodeName(this.bpmCommonConstantProperties.getUnifiedTodoEnd());
                    continue;
                }
                processInstIdList.add(saveToDoDto.getProcessInstanceid());
            }
            if (HussarUtils.isNotEmpty(processInstIdList)) {
                List<SaveToDoDto> nodeNameList = this.unifiedToDoMapper.getNodeNames(processInstIdList);
                HashMap<String, Set> nodeMap = new HashMap<String, Set>();
                for (SaveToDoDto saveToDoDtoTemp : nodeNameList) {
                    String procInstId = saveToDoDtoTemp.getProcessInstanceid();
                    Set set = (Set)nodeMap.get(procInstId);
                    set = set == null ? new HashSet() : set;
                    set.add(saveToDoDtoTemp.getTaskName());
                    nodeMap.put(procInstId, set);
                }
                for (SaveToDoDto saveToDoDto : saveToDoDtoList) {
                    Set nodeNames = (Set)nodeMap.get(saveToDoDto.getProcessInstanceid());
                    if (!HussarUtils.isNotEmpty((Object)nodeNames)) continue;
                    saveToDoDto.setCurrentNodeName(String.join((CharSequence)",", nodeNames));
                }
            }
            saveToDoDtoPage.setRecords(saveToDoDtoList);
        }
        return ApiResponse.success(saveToDoDtoPage);
    }

    public ApiResponse<ToDoVo> getToDoByTaskId(String todoId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UnifiedTaskInfo::getTodoId, (Object)Long.parseLong(todoId));
        UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.getOne((Wrapper)wrapper);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UnifiedTaskUser::getTodoId, (Object)Long.valueOf(todoId));
        List users = this.unifiedTaskUserServiceImpl.list((Wrapper)queryWrapper);
        ArrayList<UnifiedTaskUser> executors = new ArrayList<UnifiedTaskUser>();
        ArrayList<UnifiedTaskUser> followers = new ArrayList<UnifiedTaskUser>();
        for (UnifiedTaskUser unifiedTaskUser : users) {
            if ("1".equals(unifiedTaskUser.getUserType())) {
                executors.add(unifiedTaskUser);
                continue;
            }
            followers.add(unifiedTaskUser);
        }
        ToDoVo toDoVo = (ToDoVo)JSON.parseObject((String)JSON.toJSONString((Object)unifiedTaskInfo), ToDoVo.class);
        toDoVo.setExecutors(executors);
        toDoVo.setFollowers(followers);
        LambdaQueryWrapper wrapperSystem = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)unifiedTaskInfo.getSystemId())) {
            wrapperSystem.eq(UnifiedSystemInfo::getSystemId, (Object)unifiedTaskInfo.getSystemId());
            toDoVo.setSystemAddress(((UnifiedSystemInfo)this.unifiedSystemInfoServiceImpl.getOne((Wrapper)wrapperSystem)).getSystemAddress());
        }
        return ApiResponse.success((Object)toDoVo);
    }

    public ApiResponse<String> deleteTask(String taskIds, String systemId, String processInstId) {
        logger.info("*********************\u7edf\u4e00\u5f85\u529e\u5220\u9664\u4efb\u52a1\u5f00\u59cb*************");
        if (HussarUtils.isEmpty((Object)taskIds) && HussarUtils.isEmpty((Object)processInstId)) {
            logger.error("\u4efb\u52a1ID\u548c\u6d41\u7a0b\u5b9e\u4f8bID\u5747\u4e3a\u7a7a\u3002");
            return ApiResponse.fail((String)"\u4efb\u52a1ID\u548c\u6d41\u7a0b\u5b9e\u4f8bID\u5747\u4e3a\u7a7a\u3002");
        }
        ArrayList<String> taskId = null;
        if (ToolUtil.isNotEmpty((Object)taskIds)) {
            taskId = new ArrayList<String>(Arrays.asList(taskIds.split(",")));
        }
        LambdaQueryWrapper wrapperInfo = new LambdaQueryWrapper();
        LambdaQueryWrapper wrapperUser = new LambdaQueryWrapper();
        if (ToolUtil.isNotEmpty(taskId)) {
            logger.info("taskId:{}", (Object)JSON.toJSONString(taskId));
            wrapperInfo.in(UnifiedTaskInfo::getTaskId, taskId);
            wrapperUser.in(UnifiedTaskUser::getTaskId, taskId);
        }
        if (ToolUtil.isNotEmpty((Object)systemId)) {
            logger.info("systemId:{}", (Object)systemId);
            wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
            wrapperUser.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
        }
        if (ToolUtil.isNotEmpty((Object)processInstId)) {
            ArrayList<String> processInstIdList = new ArrayList<String>(Arrays.asList(processInstId.split(",")));
            logger.info("processInstIdList:{}", processInstIdList);
            wrapperInfo.in(UnifiedTaskInfo::getProcessInstanceid, processInstIdList);
            LambdaQueryWrapper wrapperInfoByProcessInstId = new LambdaQueryWrapper();
            wrapperInfoByProcessInstId.in(UnifiedTaskInfo::getProcessInstanceid, processInstIdList);
            List list = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapperInfoByProcessInstId).stream().map(UnifiedTaskInfo::getTodoId).collect(Collectors.toList());
            if (HussarUtils.isEmpty((Object)taskIds) && HussarUtils.isEmpty(list)) {
                logger.error(this.bpmCommonConstantProperties.getTaskIdAndTodoIdIsNull());
                return ApiResponse.fail((String)this.bpmCommonConstantProperties.getTaskIdAndTodoIdIsNull());
            }
            wrapperUser.in(HussarUtils.isNotEmpty(list), UnifiedTaskUser::getTodoId, list);
        }
        logger.info("taskIds:{}", (Object)taskIds);
        logger.info("processInstId:{}", (Object)processInstId);
        this.unifiedTaskInfoServiceImpl.remove((Wrapper)wrapperInfo);
        this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapperUser);
        logger.info("*********************\u7edf\u4e00\u5f85\u529e\u5220\u9664\u4efb\u52a1\u5b8c\u6210*************");
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateTaskStatus(String taskId, String systemId, String processInstId, String taskStatus, String webLinkurl, String mobileLinkurl, String lastTime) {
        logger.info("*********************\u7edf\u4e00\u5f85\u529e\u66f4\u65b0\u5f85\u529e\u4efb\u52a1\u72b6\u6001updateTaskStatus\u5f00\u59cb*************");
        logger.info("\u5165\u53c2\u4fe1\u606f\u4e3a\uff1ataskId:{},systemId:{},processInstanceId:{},taskStatus:{},webLinkUrl:{},mobileLinkUrl:{},lastTime:{}", new Object[]{taskId, systemId, processInstId, taskStatus, webLinkurl, mobileLinkurl, lastTime});
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date date = null;
        try {
            date = ToolUtil.isNotEmpty((Object)lastTime) ? formatter.parse(lastTime) : new Date();
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        taskStatus = ToolUtil.isNotEmpty((Object)taskStatus) ? taskStatus : "1";
        LambdaUpdateWrapper wrapperInfo = new LambdaUpdateWrapper();
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getTaskId, (Object)taskId);
        }
        if (ToolUtil.isNotEmpty((Object)systemId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
        }
        List userByProcessInstId = null;
        if (ToolUtil.isNotEmpty((Object)processInstId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)processInstId);
            LambdaUpdateWrapper wrapperByProcessInstId = new LambdaUpdateWrapper();
            wrapperByProcessInstId.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)processInstId);
            userByProcessInstId = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapperByProcessInstId).stream().map(UnifiedTaskInfo::getTodoId).collect(Collectors.toList());
        }
        logger.info("\u67e5\u8be2\u5230\u7684TODO_ID\uff1a{}", (Object)JSON.toJSONString(userByProcessInstId));
        if (HussarUtils.isEmpty((Object)taskId) && HussarUtils.isEmpty(userByProcessInstId)) {
            logger.error(this.bpmCommonConstantProperties.getTaskIdAndTodoIdIsNull());
            return ApiResponse.fail((String)this.bpmCommonConstantProperties.getTaskIdAndTodoIdIsNull());
        }
        if (ToolUtil.isNotEmpty((Object)mobileLinkurl)) {
            wrapperInfo.set(UnifiedTaskInfo::getMobileLinkurl, (Object)mobileLinkurl);
        }
        if (ToolUtil.isNotEmpty((Object)webLinkurl)) {
            wrapperInfo.set(UnifiedTaskInfo::getWebLinkurl, (Object)webLinkurl);
        }
        wrapperInfo.set(UnifiedTaskInfo::getTaskStatus, (Object)taskStatus);
        wrapperInfo.set(UnifiedTaskInfo::getLastTime, (Object)date);
        this.unifiedTaskInfoServiceImpl.update((Wrapper)wrapperInfo);
        logger.info("\u4fee\u6539\u5f85\u529e\u4efb\u52a1\u8868\u6210\u529f\uff01");
        LambdaUpdateWrapper wrapperUser = new LambdaUpdateWrapper();
        if (ToolUtil.isNotEmpty((Object)systemId)) {
            wrapperUser.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
        }
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            wrapperUser.eq(UnifiedTaskUser::getTaskId, (Object)taskId);
        }
        if (ToolUtil.isNotEmpty(userByProcessInstId)) {
            wrapperUser.in(UnifiedTaskUser::getTodoId, userByProcessInstId);
        }
        wrapperUser.set(UnifiedTaskUser::getExecuteStatus, (Object)taskStatus);
        if ("1".equals(taskStatus)) {
            wrapperUser.set(UnifiedTaskUser::getCompleteTime, (Object)date);
        } else {
            wrapperUser.set(UnifiedTaskUser::getCompleteTime, null);
        }
        this.unifiedTaskUserServiceImpl.update((Wrapper)wrapperUser);
        logger.info("\u4fee\u6539\u5f85\u529e\u4efb\u52a1\u4eba\u5458\u8868\u4fe1\u606f\u6210\u529f\uff01");
        logger.info("*********************\u7edf\u4e00\u5f85\u529e\u66f4\u65b0\u5f85\u529e\u4efb\u52a1\u72b6\u6001updateTaskStatus\u5b8c\u6210*************");
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateTaskStatusWithOutFollowers(String taskId, String systemId, String processInstId, String taskStatus, String webLinkurl, String mobileLinkurl, String lastTime, String formId) {
        logger.info("*********************\u7edf\u4e00\u5f85\u529e\u66f4\u65b0\u5f85\u529e\u4efb\u52a1\u72b6\u6001updateTaskStatusWithOutFollowers\u5f00\u59cb*************");
        logger.info("\u5165\u53c2\u4fe1\u606f\u4e3a\uff1ataskId:{},systemId:{},processInstanceId:{},taskStatus:{},webLinkUrl:{},mobileLinkUrl:{},lastTime:{},formId:{}", new Object[]{taskId, systemId, processInstId, taskStatus, webLinkurl, mobileLinkurl, lastTime, formId});
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date date = null;
        try {
            date = ToolUtil.isNotEmpty((Object)lastTime) ? formatter.parse(lastTime) : new Date();
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        taskStatus = ToolUtil.isNotEmpty((Object)taskStatus) ? taskStatus : "1";
        LambdaUpdateWrapper wrapperInfo = new LambdaUpdateWrapper();
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getTaskId, (Object)taskId);
        }
        if (ToolUtil.isNotEmpty((Object)systemId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
        }
        List userByProcessInstId = null;
        if (ToolUtil.isNotEmpty((Object)processInstId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)processInstId);
            LambdaUpdateWrapper wrapperByProcessInstId = new LambdaUpdateWrapper();
            wrapperByProcessInstId.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)processInstId);
            if ("1".equals(taskStatus)) {
                wrapperInfo.eq(UnifiedTaskInfo::getTaskStatus, (Object)"0");
                wrapperByProcessInstId.eq(UnifiedTaskInfo::getTaskStatus, (Object)"0");
            }
            userByProcessInstId = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapperByProcessInstId).stream().map(UnifiedTaskInfo::getTodoId).collect(Collectors.toList());
        }
        logger.info("\u67e5\u8be2\u5230\u7684TODO_ID\uff1a{}", (Object)JSON.toJSONString(userByProcessInstId));
        if (HussarUtils.isEmpty((Object)taskId) && HussarUtils.isEmpty(userByProcessInstId)) {
            logger.error(this.bpmCommonConstantProperties.getTaskIdAndTodoIdIsNull());
            return ApiResponse.fail((String)this.bpmCommonConstantProperties.getTaskIdAndTodoIdIsNull());
        }
        if (ToolUtil.isNotEmpty((Object)mobileLinkurl)) {
            wrapperInfo.set(UnifiedTaskInfo::getMobileLinkurl, (Object)mobileLinkurl);
        }
        if (ToolUtil.isNotEmpty((Object)webLinkurl)) {
            wrapperInfo.set(UnifiedTaskInfo::getWebLinkurl, (Object)webLinkurl);
        }
        if (HussarUtils.isNotEmpty((Object)formId)) {
            wrapperInfo.set(UnifiedTaskInfo::getFormId, (Object)formId);
        }
        wrapperInfo.set(UnifiedTaskInfo::getTaskStatus, (Object)taskStatus);
        wrapperInfo.set(UnifiedTaskInfo::getLastTime, (Object)date);
        this.unifiedTaskInfoServiceImpl.update((Wrapper)wrapperInfo);
        logger.info("\u4fee\u6539\u5f85\u529e\u4efb\u52a1\u8868\u6210\u529f\uff01");
        LambdaUpdateWrapper wrapperUser = new LambdaUpdateWrapper();
        wrapperUser.eq(UnifiedTaskUser::getUserType, (Object)"1");
        if (ToolUtil.isNotEmpty((Object)systemId)) {
            wrapperUser.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
        }
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            wrapperUser.eq(UnifiedTaskUser::getTaskId, (Object)taskId);
        }
        if (ToolUtil.isNotEmpty(userByProcessInstId)) {
            wrapperUser.in(UnifiedTaskUser::getTodoId, userByProcessInstId);
        }
        wrapperUser.set(UnifiedTaskUser::getExecuteStatus, (Object)taskStatus);
        if ("1".equals(taskStatus)) {
            wrapperUser.set(UnifiedTaskUser::getCompleteTime, (Object)date);
        } else {
            wrapperUser.set(UnifiedTaskUser::getCompleteTime, null);
        }
        this.unifiedTaskUserServiceImpl.update((Wrapper)wrapperUser);
        logger.info("\u4fee\u6539\u5f85\u529e\u4efb\u52a1\u4eba\u5458\u8868\u4fe1\u606f\u6210\u529f\uff01");
        logger.info("*********************\u7edf\u4e00\u5f85\u529e\u66f4\u65b0\u5f85\u529e\u4efb\u52a1\u72b6\u6001updateTaskStatus\u5b8c\u6210*************");
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateUserStatus(UnifiedTaskUser unifiedTaskUser) {
        logger.info("*********************\u7edf\u4e00\u5f85\u529e\u66f4\u65b0\u6267\u884c\u4eba/\u6284\u9001\u4eba\u5f85\u529e\u72b6\u6001updateUserStatus\u5f00\u59cb*************");
        logger.info("\u5165\u53c2\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)unifiedTaskUser));
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        if (HussarUtils.isNotEmpty((Object)unifiedTaskUser.getSystemId())) {
            wrapper.eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskUser.getSystemId());
        }
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskUser.getTaskId())).eq(UnifiedTaskUser::getUserId, (Object)unifiedTaskUser.getUserId())).eq(UnifiedTaskUser::getUserType, (Object)unifiedTaskUser.getUserType())).eq(HussarUtils.isNotEmpty((Object)unifiedTaskUser.getCcMoment()), UnifiedTaskUser::getCcMoment, (Object)unifiedTaskUser.getCcMoment());
        ((LambdaUpdateWrapper)wrapper.set(UnifiedTaskUser::getExecuteStatus, (Object)unifiedTaskUser.getExecuteStatus())).set(UnifiedTaskUser::getCompleteTime, (Object)(ToolUtil.isNotEmpty((Object)unifiedTaskUser.getCompleteTime()) ? unifiedTaskUser.getCompleteTime() : new Date()));
        this.unifiedTaskUserServiceImpl.update((Wrapper)wrapper);
        logger.info("\u4fee\u6539\u5f85\u529e\u4efb\u52a1\u4eba\u5458\u8868\u4fe1\u606f\u6210\u529f\uff01");
        logger.info("*********************\u7edf\u4e00\u5f85\u529e\u66f4\u65b0\u6267\u884c\u4eba/\u6284\u9001\u4eba\u5f85\u529e\u72b6\u6001updateUserStatus\u5b8c\u6210*************");
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateTaskUser(String taskId, String systemId, String executeStatus, List<UnifiedTaskUser> executors, List<UnifiedTaskUser> followers) {
        logger.info("********************\u5f00\u59cb\u66f4\u65b0\u4efb\u52a1\u5904\u7406\u4eba**************");
        logger.info("\u5165\u53c2\u4fe1\u606f\u4e3a\uff1ataskId:{}, systemId:{}, executeStatus:{}, executors:{}, followers:{}", new Object[]{taskId, systemId, executeStatus, JSON.toJSONString(executors), JSON.toJSONString(followers)});
        LambdaQueryWrapper wrapperInfo = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)systemId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
        }
        wrapperInfo.eq(UnifiedTaskInfo::getTaskId, (Object)taskId);
        UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.getOne((Wrapper)wrapperInfo);
        logger.info("\u6839\u636e\u4efb\u52a1ID{}\u67e5\u8be2\u5230\u7684unifiedTaskInfo:{}", (Object)taskId, (Object)JSON.toJSONString((Object)unifiedTaskInfo));
        if (HussarUtils.isEmpty((Object)unifiedTaskInfo)) {
            return ApiResponse.fail((String)"\u7edf\u4e00\u5f85\u529e\u4e2d\u4efb\u52a1\u4e0d\u5b58\u5728\u3002");
        }
        Long todoId = unifiedTaskInfo.getTodoId();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)systemId)) {
            wrapper.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
        }
        ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getUserType, (Object)"1");
        this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapper);
        logger.info("\u6839\u636etaskId:{}\u5220\u9664\u6267\u884c\u4eba\u4fe1\u606f", (Object)taskId);
        for (UnifiedTaskUser unifiedTaskUser : executors) {
            unifiedTaskUser.setUnifiedId(null);
            unifiedTaskUser.setSystemId(Long.valueOf(Long.parseLong(systemId)));
            unifiedTaskUser.setTaskId(taskId);
            unifiedTaskUser.setTodoId(todoId);
            unifiedTaskUser.setExecuteStatus(ToolUtil.isNotEmpty((Object)executeStatus) ? executeStatus : "0");
            unifiedTaskUser.setUserType("1");
        }
        if (HussarUtils.isNotEmpty(followers)) {
            LambdaQueryWrapper wrapperFollower = new LambdaQueryWrapper();
            if (HussarUtils.isNotEmpty((Object)systemId)) {
                wrapperFollower.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
            }
            ((LambdaQueryWrapper)wrapperFollower.eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getUserType, (Object)"0");
            this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapperFollower);
            logger.info("\u6839\u636etaskId:{}\u5220\u9664\u4f20\u9605\u4eba\u4fe1\u606f", (Object)taskId);
            for (UnifiedTaskUser unifiedTaskUser : followers) {
                unifiedTaskUser.setUnifiedId(null);
                unifiedTaskUser.setSystemId(Long.valueOf(Long.parseLong(systemId)));
                unifiedTaskUser.setTaskId(taskId);
                unifiedTaskUser.setTodoId(todoId);
                unifiedTaskUser.setExecuteStatus(ToolUtil.isNotEmpty((Object)executeStatus) ? executeStatus : "0");
                unifiedTaskUser.setUserType("0");
            }
            executors.addAll(followers);
        }
        this.unifiedTaskUserServiceImpl.saveBatch(executors);
        logger.info("\u4fdd\u5b58\u6240\u6709\u4eba\u5458\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(executors));
        logger.info("********************\u5b8c\u6210\u66f4\u65b0\u4efb\u52a1\u5904\u7406\u4eba**************");
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> addTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        logger.info("********************\u6dfb\u52a0\u6267\u884c\u4eba/\u6284\u9001\u4eba\u5f00\u59cb**************");
        logger.info("\u5165\u53c2\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(unifiedTaskUsers));
        for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
            LambdaQueryWrapper wrapperInfo = new LambdaQueryWrapper();
            if (HussarUtils.isNotEmpty((Object)unifiedTaskUser.getSystemId())) {
                wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)unifiedTaskUser.getSystemId());
            }
            wrapperInfo.eq(UnifiedTaskInfo::getTaskId, (Object)unifiedTaskUser.getTaskId());
            UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.getOne((Wrapper)wrapperInfo);
            if (unifiedTaskInfo == null) continue;
            unifiedTaskUser.setTodoId(unifiedTaskInfo.getTodoId());
            unifiedTaskUser.setExecuteStatus(ToolUtil.isNotEmpty((Object)unifiedTaskUser.getExecuteStatus()) ? unifiedTaskUser.getExecuteStatus() : "0");
        }
        this.unifiedTaskUserServiceImpl.saveBatch(unifiedTaskUsers);
        logger.info("\u6210\u529f\u4fdd\u5b58\u6240\u6709\u4eba\u5458\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(unifiedTaskUsers));
        logger.info("********************\u6dfb\u52a0\u6267\u884c\u4eba/\u6284\u9001\u4eba\u5b8c\u6210**************");
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> deleteTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        logger.info("********************\u5220\u9664\u6267\u884c\u4eba/\u6284\u9001\u4eba\u5f00\u59cb**************");
        logger.info("\u5165\u53c2\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(unifiedTaskUsers));
        for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            if (HussarUtils.isNotEmpty((Object)unifiedTaskUser.getSystemId())) {
                wrapper.eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskUser.getSystemId());
            }
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskUser.getTaskId())).eq(UnifiedTaskUser::getUserType, (Object)unifiedTaskUser.getUserType())).eq(HussarUtils.isNotEmpty((Object)unifiedTaskUser.getCcMoment()), UnifiedTaskUser::getCcMoment, (Object)unifiedTaskUser.getCcMoment());
            if (ToolUtil.isNotEmpty((Object)unifiedTaskUser.getUserId())) {
                wrapper.eq(UnifiedTaskUser::getUserId, (Object)unifiedTaskUser.getUserId());
            }
            if (HussarUtils.isNotEmpty((Object)unifiedTaskUser.getMandator())) {
                wrapper.eq(UnifiedTaskUser::getMandator, (Object)unifiedTaskUser.getMandator());
            } else if ("".equals(unifiedTaskUser.getMandator())) {
                wrapper.isNull(UnifiedTaskUser::getMandator);
            }
            this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapper);
            logger.info("\u6210\u529f\u5220\u9664\u4eba\u5458\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)unifiedTaskUser));
        }
        logger.info("********************\u5220\u9664\u6267\u884c\u4eba/\u6284\u9001\u4eba\u5b8c\u6210**************");
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateTaskUser(String taskId, String systemId, String executeStatus, UpdateTaskUserToDoDto updateTaskUserToDoDto) {
        return this.updateTaskUser(taskId, systemId, executeStatus, updateTaskUserToDoDto.getExecutors(), updateTaskUserToDoDto.getFollowers());
    }

    public ApiResponse<String> transferTaskDeleteTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        logger.info("********************\u8f6c\u529e\u4efb\u52a1\u5220\u9664\u6267\u884c\u4eba\u5f00\u59cb**************");
        logger.info("\u5165\u53c2\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(unifiedTaskUsers));
        for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            if (HussarUtils.isNotEmpty((Object)unifiedTaskUser.getSystemId())) {
                wrapper.eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskUser.getSystemId());
            }
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskUser.getTaskId())).eq(UnifiedTaskUser::getUserType, (Object)unifiedTaskUser.getUserType())).eq(UnifiedTaskUser::getTaskState, (Object)unifiedTaskUser.getTaskState());
            if (ToolUtil.isNotEmpty((Object)unifiedTaskUser.getUserId())) {
                wrapper.eq(UnifiedTaskUser::getUserId, (Object)unifiedTaskUser.getUserId());
            }
            this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapper);
            logger.info("\u6210\u529f\u5220\u9664\u4eba\u5458\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)unifiedTaskUser));
        }
        logger.info("********************\u8f6c\u529e\u4efb\u52a1\u5220\u9664\u6267\u884c\u4eba\u5b8c\u6210**************");
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> transferUserTask(TransferTaskDto transferTaskDto) {
        logger.info("********************\u8f6c\u529e\u4efb\u52a1\u5f00\u59cb**************");
        logger.info("\u5165\u53c2\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)transferTaskDto));
        if (HussarUtils.isEmpty((Object)transferTaskDto.getMap())) {
            return ApiResponse.fail((String)"\u672a\u4f20\u9012\u7528\u6237\u4fe1\u606f");
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        if (HussarUtils.isNotEmpty((Object)transferTaskDto.getSystemId())) {
            wrapper.eq(UnifiedTaskUser::getSystemId, (Object)transferTaskDto.getSystemId());
        }
        ((LambdaUpdateWrapper)wrapper.eq(UnifiedTaskUser::getTaskId, (Object)transferTaskDto.getTaskId())).eq(UnifiedTaskUser::getUserType, (Object)"1");
        List unifiedTaskUsers = this.unifiedTaskUserService.list((Wrapper)wrapper);
        logger.info("\u67e5\u8be2\u5230\u7684\u4eba\u5458\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)unifiedTaskUsers));
        if (HussarUtils.isNotEmpty((Object)unifiedTaskUsers)) {
            for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
                if ((!HussarUtils.isEmpty((Object)unifiedTaskUser.getMandator()) || !HussarUtils.isNotEmpty((Object)unifiedTaskUser.getUserId()) || !unifiedTaskUser.getUserId().equals(transferTaskDto.getConsignor())) && (!HussarUtils.isNotEmpty((Object)unifiedTaskUser.getMandator()) || !unifiedTaskUser.getMandator().equals(transferTaskDto.getConsignor()))) continue;
                unifiedTaskUser.setUserId(transferTaskDto.getUserId());
                unifiedTaskUser.setMandator(transferTaskDto.getConsignor());
                unifiedTaskUser.setTaskState("2");
                unifiedTaskUser.setUserName((String)transferTaskDto.getMap().get(transferTaskDto.getUserId()));
                unifiedTaskUser.setMandatorName((String)transferTaskDto.getMap().get(transferTaskDto.getConsignor()));
                this.unifiedTaskUserService.updateById(unifiedTaskUser);
                logger.info("\u6210\u529f\u66f4\u65b0\u4eba\u5458\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)unifiedTaskUser));
            }
        }
        logger.info("********************\u8f6c\u529e\u4efb\u52a1\u5b8c\u6210**************");
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> addUrgeTask(SaveToDoDto saveToDoDto) {
        logger.info("********************\u65b0\u589e\u50ac\u529e\u4efb\u52a1\u5f00\u59cb**************");
        logger.info("\u5165\u53c2\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)saveToDoDto));
        LambdaUpdateWrapper wrapperInfo = new LambdaUpdateWrapper();
        if (HussarUtils.isAllEmpty((Object[])new Object[]{saveToDoDto.getTaskId(), saveToDoDto.getBusinessid(), saveToDoDto.getProcessInstanceid()})) {
            return ApiResponse.fail((String)"\u53c2\u6570\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getBusinessid())) {
            wrapperInfo.eq(UnifiedTaskInfo::getBusinessid, (Object)saveToDoDto.getBusinessid());
        }
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getProcessInstanceid())) {
            wrapperInfo.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)saveToDoDto.getProcessInstanceid());
        }
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getSystemId())) {
            wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)saveToDoDto.getSystemId());
        }
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getTaskId())) {
            wrapperInfo.eq(UnifiedTaskInfo::getTaskId, (Object)saveToDoDto.getTaskId());
        }
        wrapperInfo.eq(UnifiedTaskInfo::getTaskStatus, (Object)"0");
        List taskInfoList = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapperInfo);
        logger.info("\u67e5\u8be2\u5230\u7684\u5f85\u529e\u4efb\u52a1\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)taskInfoList));
        wrapperInfo.set(UnifiedTaskInfo::getUrgeUserId, (Object)saveToDoDto.getUrgeUserId());
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getUrgeUserName())) {
            wrapperInfo.set(UnifiedTaskInfo::getUrgeUserName, (Object)saveToDoDto.getUrgeUserName());
        }
        this.unifiedTaskInfoServiceImpl.update((Wrapper)wrapperInfo);
        logger.info("\u6210\u529f\u66f4\u65b0\u5f85\u529e\u4efb\u52a1\u4fe1\u606f\uff0c\u66f4\u65b0\u540e\uff1a{}", (Object)JSON.toJSONString((Object)taskInfoList));
        ArrayList<UnifiedTaskUser> unifiedTaskUserList = new ArrayList<UnifiedTaskUser>();
        for (UnifiedTaskInfo unifiedTaskInfo : taskInfoList) {
            String taskId = unifiedTaskInfo.getTaskId();
            LambdaUpdateWrapper taskUserWrapperInfo = new LambdaUpdateWrapper();
            taskUserWrapperInfo.eq(UnifiedTaskUser::getTaskId, (Object)taskId);
            taskUserWrapperInfo.isNull(UnifiedTaskUser::getUrgeStatus);
            taskUserWrapperInfo.eq(UnifiedTaskUser::getUserType, (Object)"1");
            List list = this.unifiedTaskUserServiceImpl.list((Wrapper)taskUserWrapperInfo);
            logger.info("\u67e5\u8be2\u5230\u7684\u5f85\u529e\u4efb\u52a1\u53c2\u4e0e\u8005\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)list));
            for (UnifiedTaskUser taskUser : list) {
                UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
                unifiedTaskUser.setTodoId(unifiedTaskInfo.getTodoId());
                unifiedTaskUser.setSystemId(unifiedTaskInfo.getSystemId());
                unifiedTaskUser.setTaskId(unifiedTaskInfo.getTaskId());
                unifiedTaskUser.setUserId(taskUser.getUserId());
                unifiedTaskUser.setExecuteStatus("0");
                unifiedTaskUser.setUserType("1");
                unifiedTaskUser.setUrgeStatus("1");
                unifiedTaskUser.setUrgeTime(saveToDoDto.getUrgeTime());
                unifiedTaskUserList.add(unifiedTaskUser);
            }
        }
        this.unifiedTaskUserServiceImpl.saveBatch(unifiedTaskUserList);
        logger.info("\u6210\u529f\u50ac\u529e\u4efb\u52a1\u53c2\u4e0e\u8005\u4fe1\u606f\uff0c\u4fdd\u5b58\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(unifiedTaskUserList));
        logger.info("********************\u65b0\u589e\u50ac\u529e\u4efb\u52a1\u5b8c\u6210**************");
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> addStartProcess(SaveProcessDto saveProcessDto) {
        logger.info("********************\u65b0\u589e\u53d1\u8d77\u6d41\u7a0b\u5f00\u59cb**************");
        logger.info("\u5165\u53c2\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)saveProcessDto));
        this.unifiedStartTaskServiceImpl.save(saveProcessDto);
        logger.info("********************\u65b0\u589e\u53d1\u8d77\u6d41\u7a0b\u5b8c\u6210**************");
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateStartProcess(SaveProcessDto saveProcessDto) {
        logger.info("********************\u4fee\u6539\u53d1\u8d77\u6d41\u7a0b\u5f00\u59cb**************");
        logger.info("\u5165\u53c2\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)saveProcessDto));
        try {
            String businessId = saveProcessDto.getBusinessId();
            String processInstanceId = saveProcessDto.getProcInstId();
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            if (HussarUtils.isNotEmpty((Object)businessId)) {
                wrapper.eq(UnifiedStartTask::getBusinessId, (Object)businessId);
            }
            if (HussarUtils.isNotEmpty((Object)processInstanceId)) {
                wrapper.eq(UnifiedStartTask::getProcInstId, (Object)processInstanceId);
            }
            wrapper.set(UnifiedStartTask::getEndTime, (Object)saveProcessDto.getEndTime());
            wrapper.set(UnifiedStartTask::getProcessState, (Object)saveProcessDto.getProcessState());
            if (HussarUtils.isNotEmpty((Object)saveProcessDto.getProcessTitle())) {
                wrapper.set(UnifiedStartTask::getProcessTitle, (Object)saveProcessDto.getProcessTitle());
            }
            if (HussarUtils.isNotEmpty((Object)saveProcessDto.getDataDetail())) {
                wrapper.set(UnifiedStartTask::getDataDetail, (Object)saveProcessDto.getDataDetail());
            }
            this.unifiedStartTaskServiceImpl.update((Wrapper)wrapper);
            logger.info("********************\u4fee\u6539\u53d1\u8d77\u6d41\u7a0b\u5b8c\u6210**************");
            return ApiResponse.success((Object)"", null);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u4fee\u6539\u6d41\u7a0b\u72b6\u6001\u5931\u8d25\uff01");
        }
    }

    public ApiResponse<String> deleteStartProcess(SaveProcessDto saveProcessDto) {
        logger.info("********************\u5220\u9664\u53d1\u8d77\u6d41\u7a0b\u5f00\u59cb**************");
        logger.info("\u5165\u53c2\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)saveProcessDto));
        try {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            if (HussarUtils.isNotEmpty((Object)saveProcessDto.getBusinessId())) {
                String businessIds = saveProcessDto.getBusinessId();
                List<String> businessList = Arrays.asList(businessIds.split(","));
                wrapper.in(UnifiedStartTask::getBusinessId, businessList);
            }
            if (HussarUtils.isNotEmpty((Object)saveProcessDto.getProcInstId())) {
                String processInstanceIds = saveProcessDto.getProcInstId();
                List<String> processInstanceIdList = Arrays.asList(processInstanceIds.split(","));
                wrapper.in(UnifiedStartTask::getProcInstId, processInstanceIdList);
            }
            this.unifiedStartTaskServiceImpl.remove((Wrapper)wrapper);
            logger.info("********************\u5220\u9664\u53d1\u8d77\u6d41\u7a0b\u5b8c\u6210**************");
            return ApiResponse.success((Object)"", null);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u5220\u9664\u6d41\u7a0b\u5931\u8d25\uff01");
        }
    }

    public ApiResponse<String> updateBusinessInfo(SaveToDoDto saveToDoDto) {
        logger.info("********************\u4fee\u6539\u4efb\u52a1\u8868\u4e2d\u5b57\u6bb5updateBusinessInfo\u5f00\u59cb**************");
        logger.info("\u5165\u53c2\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)saveToDoDto));
        try {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            if (HussarUtils.isNotEmpty((Object)saveToDoDto.getProcessInstanceid())) {
                wrapper.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)saveToDoDto.getProcessInstanceid());
            }
            if (HussarUtils.isNotEmpty((Object)saveToDoDto.getBusinessid())) {
                wrapper.eq(UnifiedTaskInfo::getBusinessid, (Object)saveToDoDto.getBusinessid());
            }
            if (HussarUtils.isNotEmpty((Object)saveToDoDto.getProcessTitle())) {
                wrapper.set(UnifiedTaskInfo::getProcessTitle, (Object)saveToDoDto.getProcessTitle());
            }
            if (HussarUtils.isNotEmpty((Object)saveToDoDto.getDataDetail())) {
                wrapper.set(UnifiedTaskInfo::getDataDetail, (Object)saveToDoDto.getDataDetail());
            }
            this.unifiedTaskInfoServiceImpl.update((Wrapper)wrapper);
            logger.info("********************\u4fee\u6539\u4efb\u52a1\u8868\u4e2d\u5b57\u6bb5updateBusinessInfo\u5b8c\u6210**************");
            return ApiResponse.success((Object)"", null);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u66f4\u65b0\u5931\u8d25\uff01");
        }
    }

    public ApiResponse<List<Map<String, Object>>> querySystemNameList() {
        return this.unifiedSystemInfoServiceImpl.querySystemNameList();
    }

    public ApiResponse<List<CategoryQueryVo>> queryAllCategory(String userId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.isNull(HussarUtils.isEmpty((Object)userId), UnifiedCategoryType::getUserId);
        lambdaQueryWrapper.eq(HussarUtils.isNotEmpty((Object)userId), UnifiedCategoryType::getUserId, (Object)userId);
        List list = this.unifiedCategoryTypeService.list((Wrapper)lambdaQueryWrapper);
        list.sort((o1, o2) -> {
            if (o1.getCategorySeq().equals(o2.getCategorySeq())) {
                return o2.getLastTime().compareTo(o1.getLastTime());
            }
            return o1.getCategorySeq().compareTo(o2.getCategorySeq());
        });
        ArrayList<CategoryQueryVo> result = new ArrayList<CategoryQueryVo>();
        for (UnifiedCategoryType unifiedCategoryType : list) {
            result.add(new CategoryQueryVo(unifiedCategoryType));
        }
        return ApiResponse.success(result);
    }

    public ApiResponse<?> saveCategory(SaveCategoryDto saveCategoryDto) {
        UnifiedCategoryType categoryType = new UnifiedCategoryType(saveCategoryDto);
        this.unifiedCategoryTypeService.save(categoryType);
        if (HussarUtils.isNotEmpty((Object)saveCategoryDto.getAttributes())) {
            ArrayList<UnifiedCategoryInfo> infos = new ArrayList<UnifiedCategoryInfo>();
            for (String attribute : saveCategoryDto.getAttributes()) {
                UnifiedCategoryInfo unifiedCategoryInfo = new UnifiedCategoryInfo();
                unifiedCategoryInfo.setCategoryTypeId(categoryType.getId());
                unifiedCategoryInfo.setCategoryAttribute(attribute);
                infos.add(unifiedCategoryInfo);
            }
            this.unifiedCategoryInfoService.saveBatch(infos);
        }
        return ApiResponse.success();
    }

    public ApiResponse<?> updateCategory(UpdateCategoryDto updateCategoryDto) {
        UnifiedCategoryType categoryType = new UnifiedCategoryType(updateCategoryDto);
        this.unifiedCategoryTypeService.updateById(categoryType);
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(UnifiedCategoryInfo::getCategoryTypeId, (Object)categoryType.getId());
        this.unifiedCategoryInfoService.remove((Wrapper)lambdaQueryWrapper);
        if (HussarUtils.isNotEmpty((Object)updateCategoryDto.getAttributes())) {
            ArrayList<UnifiedCategoryInfo> infos = new ArrayList<UnifiedCategoryInfo>();
            for (String attribute : updateCategoryDto.getAttributes()) {
                UnifiedCategoryInfo unifiedCategoryInfo = new UnifiedCategoryInfo();
                unifiedCategoryInfo.setCategoryTypeId(categoryType.getId());
                unifiedCategoryInfo.setCategoryAttribute(attribute);
                infos.add(unifiedCategoryInfo);
            }
            this.unifiedCategoryInfoService.saveBatch(infos);
        }
        return ApiResponse.success();
    }

    public ApiResponse<?> deleteCategory(Long id) {
        this.unifiedCategoryTypeService.removeById(id);
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(UnifiedCategoryInfo::getCategoryTypeId, (Object)id);
        this.unifiedCategoryInfoService.remove((Wrapper)lambdaQueryWrapper);
        return ApiResponse.success();
    }

    public ApiResponse<?> saveProcessInfo(SaveProcessInfoDto saveProcessInfoDto) {
        List ccRemoveUser;
        List deleteToDoDtos;
        logger.info("********************\u4fdd\u5b58\u6d41\u7a0b\u4fe1\u606fsaveProcessInfo\u5f00\u59cb**************");
        logger.info("\u5165\u53c2\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)saveProcessInfoDto));
        SaveProcessDto saveProcessDto = saveProcessInfoDto.getSaveProcessDto();
        Long systemId = saveProcessInfoDto.getSaveProcessDto().getSystemId();
        if (saveProcessInfoDto.isAddProcess()) {
            this.unifiedStartTaskServiceImpl.save(saveProcessDto);
            logger.info("\u65b0\u589e\u6d41\u7a0b\u4fe1\u606f\u6210\u529f");
        } else {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(UnifiedStartTask::getProcInstId, (Object)saveProcessDto.getProcInstId());
            lambdaQueryWrapper.eq(UnifiedStartTask::getSystemId, (Object)saveProcessDto.getSystemId());
            lambdaQueryWrapper.eq(UnifiedStartTask::getBusinessId, (Object)saveProcessDto.getBusinessId());
            this.unifiedStartTaskServiceImpl.update(saveProcessDto, (Wrapper)lambdaQueryWrapper);
            logger.info("\u4fee\u6539\u6d41\u7a0b\u4fe1\u606f\u6210\u529f");
        }
        List saveToDoDtos = saveProcessInfoDto.getSaveToDoDtoList();
        ArrayList<SaveToDoDto> saveToDoDtoList = new ArrayList<SaveToDoDto>();
        ArrayList<SaveToDoDto> updateToDoDtoList = new ArrayList<SaveToDoDto>();
        ArrayList<String> deleteToDoDtoList = new ArrayList<String>();
        ArrayList userList = new ArrayList();
        for (SaveToDoDto saveToDoDto : saveToDoDtos) {
            List list;
            String taskStatus = ToolUtil.isNotEmpty((Object)saveToDoDto.getTaskStatus()) ? saveToDoDto.getTaskStatus() : "0";
            saveToDoDto.setTaskStatus(taskStatus);
            saveToDoDtoList.add(saveToDoDto);
            List executors = saveToDoDto.getExecutors();
            if (HussarUtils.isNotEmpty((Object)executors)) {
                for (Object unifiedTaskUser : executors) {
                    unifiedTaskUser.setSystemId(saveToDoDto.getSystemId());
                    unifiedTaskUser.setTaskId(saveToDoDto.getTaskId());
                    unifiedTaskUser.setTodoId(saveToDoDto.getTodoId());
                    unifiedTaskUser.setExecuteStatus(taskStatus);
                    unifiedTaskUser.setUserType("1");
                    unifiedTaskUser.setReceiveTime(saveToDoDto.getCreateTime());
                }
                userList.addAll(executors);
            }
            if (!HussarUtils.isNotEmpty((Object)(list = saveToDoDto.getFollowers()))) continue;
            if (ToolUtil.isNotEmpty((Object)list)) {
                Object unifiedTaskUser;
                unifiedTaskUser = list.iterator();
                while (unifiedTaskUser.hasNext()) {
                    UnifiedTaskUser unifiedTaskUser2 = (UnifiedTaskUser)unifiedTaskUser.next();
                    unifiedTaskUser2.setSystemId(saveToDoDto.getSystemId());
                    unifiedTaskUser2.setTaskId(saveToDoDto.getTaskId());
                    unifiedTaskUser2.setTodoId(saveToDoDto.getTodoId());
                    unifiedTaskUser2.setExecuteStatus(taskStatus);
                    unifiedTaskUser2.setUserType("0");
                }
            }
            userList.addAll(list);
        }
        List updateToDoDtos = saveProcessInfoDto.getUpdateSaveToDoDtoList();
        if (HussarUtils.isNotEmpty((Object)updateToDoDtos)) {
            ArrayList<String> updateTaskIds = new ArrayList<String>();
            updateToDoDtos.forEach(o -> updateTaskIds.add(o.getTaskId()));
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(UnifiedTaskInfo::getSystemId, (Object)systemId);
            queryWrapper.in(UnifiedTaskInfo::getTaskId, updateTaskIds);
            List unifiedTaskInfos = this.unifiedTaskInfoServiceImpl.list((Wrapper)queryWrapper);
            for (SaveToDoDto updateTodoDto : updateToDoDtos) {
                String taskStatus = ToolUtil.isNotEmpty((Object)updateTodoDto.getTaskStatus()) ? updateTodoDto.getTaskStatus() : "1";
                unifiedTaskInfos.forEach(o -> {
                    if (o.getTaskId().equals(updateTodoDto.getTaskId())) {
                        updateTodoDto.setTodoId(o.getTodoId());
                    }
                });
                updateTaskIds.add(updateTodoDto.getTaskId());
                updateToDoDtoList.add(updateTodoDto);
                List followers = updateTodoDto.getFollowers();
                if (!HussarUtils.isNotEmpty((Object)followers)) continue;
                if (ToolUtil.isNotEmpty((Object)followers)) {
                    for (UnifiedTaskUser unifiedTaskUser : followers) {
                        unifiedTaskUser.setSystemId(updateTodoDto.getSystemId());
                        unifiedTaskUser.setTaskId(updateTodoDto.getTaskId());
                        unifiedTaskUser.setTodoId(updateTodoDto.getTodoId());
                        if ("1".equals(unifiedTaskUser.getExecuteStatus())) {
                            unifiedTaskUser.setCompleteTime(updateTodoDto.getLastTime());
                        }
                        unifiedTaskUser.setUserType("0");
                    }
                }
                userList.addAll(followers);
            }
            this.unifiedTaskInfoServiceImpl.updateBatchById(updateToDoDtos);
            logger.info("\u66f4\u65b0\u5f85\u529e\u4efb\u52a1\u8868\u4fe1\u606f\u6210\u529f, \u66f4\u65b0\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)updateToDoDtos));
        }
        if (HussarUtils.isNotEmpty((Object)(deleteToDoDtos = saveProcessInfoDto.getDeleteSaveToDoDtoList()))) {
            for (SaveToDoDto deleteToDoDto : deleteToDoDtos) {
                deleteToDoDtoList.add(deleteToDoDto.getTaskId());
            }
        }
        if (HussarUtils.isNotEmpty((Object)saveProcessInfoDto.getUpdateUserInfoList())) {
            List updateUserInfoList = saveProcessInfoDto.getUpdateUserInfoList();
            Iterator taskIds = new HashSet();
            updateUserInfoList.forEach(o -> taskIds.add(o.getTaskId()));
            ArrayList arrayList = new ArrayList(taskIds);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(UnifiedTaskUser::getTaskId, arrayList);
            lambdaQueryWrapper.eq(UnifiedTaskUser::getUserType, (Object)"0");
            List unifiedTaskUsers = this.unifiedTaskUserServiceImpl.list((Wrapper)lambdaQueryWrapper);
            ArrayList<UnifiedTaskUser> updateTaskUsers = new ArrayList<UnifiedTaskUser>();
            if (HussarUtils.isNotEmpty((Object)unifiedTaskUsers)) {
                for (UnifiedTaskUser updateUserInfo : updateUserInfoList) {
                    for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
                        if (!unifiedTaskUser.getTaskId().equals(updateUserInfo.getTaskId()) || !unifiedTaskUser.getUserId().equals(updateUserInfo.getUserId())) continue;
                        unifiedTaskUser.setCompleteTime(updateUserInfo.getCompleteTime());
                        unifiedTaskUser.setExecuteStatus("1");
                        updateTaskUsers.add(unifiedTaskUser);
                    }
                }
            }
            if (HussarUtils.isNotEmpty(updateTaskUsers)) {
                this.unifiedTaskUserServiceImpl.updateBatchById(updateTaskUsers);
                logger.info("\u66f4\u65b0\u4eba\u5458\u8868\u4fe1\u606f\u6210\u529f, \u66f4\u65b0\u4e3a\uff1a{}", (Object)JSON.toJSONString(updateTaskUsers));
            }
        }
        if (HussarUtils.isNotEmpty(deleteToDoDtoList)) {
            LambdaQueryWrapper deleteWrapper = new LambdaQueryWrapper();
            deleteWrapper.in(UnifiedTaskInfo::getTaskId, deleteToDoDtoList);
            deleteWrapper.eq(UnifiedTaskInfo::getSystemId, (Object)systemId);
            this.unifiedTaskInfoServiceImpl.remove((Wrapper)deleteWrapper);
            logger.info("\u5220\u9664\u5f85\u529e\u4efb\u52a1\u8868\u4fe1\u606f\u6210\u529f, \u5220\u9664\u6570\u636e\u7684taskId\u4e3a\uff1a{}", (Object)JSON.toJSONString(deleteToDoDtoList));
        }
        if (HussarUtils.isNotEmpty(saveToDoDtoList)) {
            this.unifiedTaskInfoServiceImpl.saveBatch(saveToDoDtoList);
            logger.info("\u4fdd\u5b58\u5f85\u529e\u4efb\u52a1\u8868\u4fe1\u606f\u6210\u529f, \u4fdd\u5b58\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString(saveToDoDtoList));
        }
        HashMap<String, Long> todoInfo = new HashMap<String, Long>();
        if (HussarUtils.isNotEmpty(saveToDoDtoList)) {
            for (UnifiedTaskInfo unifiedTaskInfo : saveToDoDtoList) {
                todoInfo.put(unifiedTaskInfo.getTaskId(), unifiedTaskInfo.getTodoId());
            }
            for (UnifiedTaskUser unifiedTaskUser : userList) {
                unifiedTaskUser.setTodoId((Long)todoInfo.get(unifiedTaskUser.getTaskId()));
            }
        }
        ArrayList<String> deleteTaskIds = new ArrayList<String>();
        ArrayList arrayList = new ArrayList();
        if (HussarUtils.isNotEmpty(deleteToDoDtoList)) {
            deleteTaskIds.addAll(deleteToDoDtoList);
        }
        if (HussarUtils.isNotEmpty(updateToDoDtoList)) {
            updateToDoDtoList.forEach(o -> {
                deleteTaskIds.add(o.getTaskId());
                saveTaskUsers.addAll(o.getExecutors());
            });
            if (HussarUtils.isNotEmpty((Object)deleteToDoDtos)) {
                for (SaveToDoDto deleteToDoDto : deleteToDoDtos) {
                    deleteTaskIds.add(deleteToDoDto.getTaskId());
                }
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(UnifiedTaskUser::getTaskId, deleteTaskIds);
            queryWrapper.eq(UnifiedTaskUser::getSystemId, (Object)systemId);
            List originUsers = this.unifiedTaskUserServiceImpl.list((Wrapper)queryWrapper);
            HashMap originTodoIdMap = new HashMap();
            if (HussarUtils.isNotEmpty((Object)originUsers)) {
                originUsers.forEach(o -> originTodoIdMap.put(o.getTaskId(), o.getTodoId()));
            }
            if (HussarUtils.isNotEmpty(arrayList)) {
                arrayList.forEach(o -> o.setTodoId((Long)originTodoIdMap.get(o.getTaskId())));
            }
            queryWrapper.eq(UnifiedTaskUser::getUserType, (Object)"1");
            this.unifiedTaskUserServiceImpl.remove((Wrapper)queryWrapper);
            logger.info("\u5220\u9664\u6267\u884c\u4eba\u4fe1\u606f\u6210\u529f, \u5220\u9664\u6570\u636e\u7684taskId\u4e3a\uff1a{}", (Object)JSON.toJSONString(deleteTaskIds));
        }
        if (HussarUtils.isNotEmpty((Object)(ccRemoveUser = saveProcessInfoDto.getDeleteUserInfoList()))) {
            LambdaQueryWrapper ccWrapper = new LambdaQueryWrapper();
            ccWrapper.in(UnifiedTaskUser::getTaskId, (Collection)ccRemoveUser);
            ccWrapper.eq(UnifiedTaskUser::getUserType, (Object)"0");
            this.unifiedTaskUserServiceImpl.remove((Wrapper)ccWrapper);
            logger.info("\u5220\u9664\u4f20\u9605\u4fe1\u606f\u6210\u529f, \u5220\u9664\u6570\u636e\u7684taskId\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)ccRemoveUser));
        }
        if (HussarUtils.isNotEmpty(arrayList)) {
            userList.addAll(arrayList);
        }
        if (HussarUtils.isNotEmpty(userList)) {
            this.unifiedTaskUserServiceImpl.saveBatch(userList);
            logger.info("\u4fdd\u5b58\u4eba\u5458\u4fe1\u606f\u6210\u529f, \u4fdd\u5b58\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString(userList));
        }
        logger.info("********************\u4fdd\u5b58\u6d41\u7a0b\u4fe1\u606fsaveProcessInfo\u5f00\u59cb**************");
        return ApiResponse.success();
    }

    private QueryToDoDto handleDate(QueryToDoDto queryToDoDto) {
        Date createEndTime = queryToDoDto.getCreateEndTime();
        Date completeEndTime = queryToDoDto.getCompleteEndTime();
        Date ccEndTime = queryToDoDto.getCcEndTime();
        Date urgeEndTime = queryToDoDto.getUrgeEndTime();
        if (HussarUtils.isNotEmpty((Object)createEndTime)) {
            long createEnd = createEndTime.getTime() + 999L;
            queryToDoDto.setCreateEndTime(new Date(createEnd));
        }
        if (HussarUtils.isNotEmpty((Object)completeEndTime)) {
            long completeEnd = completeEndTime.getTime() + 999L;
            queryToDoDto.setCompleteEndTime(new Date(completeEnd));
        }
        if (HussarUtils.isNotEmpty((Object)ccEndTime)) {
            long ccEnd = ccEndTime.getTime() + 999L;
            queryToDoDto.setCcEndTime(new Date(ccEnd));
        }
        if (HussarUtils.isNotEmpty((Object)urgeEndTime)) {
            long urgeEnd = urgeEndTime.getTime() + 999L;
            queryToDoDto.setUrgeEndTime(new Date(urgeEnd));
        }
        return queryToDoDto;
    }

    public ApiResponse<?> getUnifiedProcess(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            userId = BaseSecurityUtil.getUser().getUserId().toString();
        }
        List<SaveToDoDto> processList = this.unifiedToDoMapper.getUnifiedProcess(userId);
        JSONArray jsonArray = new JSONArray();
        for (SaveToDoDto process : processList) {
            if (HussarUtils.isEmpty((Object)process.getProcessDefinitionkey())) continue;
            HashMap<String, String> processMap = new HashMap<String, String>();
            processMap.put("id", process.getProcessDefinitionkey());
            processMap.put("name", process.getProcessName());
            jsonArray.add(processMap);
        }
        return ApiResponse.success((Object)jsonArray);
    }
}

