/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.AbstractLambdaWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.ObjectUtil;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.unifiedtodo.config.UnifiedTodoGLDProperties;
import com.jxdinfo.hussar.unifiedtodo.config.UnifiedTodoProperties;
import com.jxdinfo.hussar.unifiedtodo.constant.ProcessState;
import com.jxdinfo.hussar.unifiedtodo.constant.UnifiedToDoConfigure;
import com.jxdinfo.hussar.unifiedtodo.dto.GlodonMainDataDto;
import com.jxdinfo.hussar.unifiedtodo.dto.GlodonNodeDataDto;
import com.jxdinfo.hussar.unifiedtodo.dto.GlodonResponse;
import com.jxdinfo.hussar.unifiedtodo.dto.ProcessDeleteDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskAddBatchDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskChangeDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskChangedDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskDeleteDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskUpdateDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserAddBatchDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserChangeDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserDeleteDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserUpdateDto;
import com.jxdinfo.hussar.unifiedtodo.model.TaskInfoWithUser;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedDeleteProcessInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedDoneTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedPendingTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedProcessInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedProcessRectificationInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedReadedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTodoTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedUnReadTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedDeleteProcessInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedPendingTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedProcessInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedProcessRectificationService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskUserService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTodoTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedUnReadTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.utils.HttpClientUtil;
import com.jxdinfo.hussar.unifiedtodo.utils.UnifiedRabbitMQUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UnifiedTaskServiceImpl
implements IUnifiedTaskService {
    @Autowired
    private IUnifiedTaskInfoService unifiedTaskInfoService;
    @Autowired
    private IUnifiedTaskUserService unifiedTaskUserService;
    @Autowired
    private IUnifiedProcessInfoService unifiedProcessInfoService;
    private static final String MODULE_NAME = "OA-\u6570\u636e\u63a8\u9001";
    @Resource
    private UnifiedTodoProperties unifiedTodoProperties;
    @Resource
    private UnifiedTodoGLDProperties unifiedTodoGLDProperties;
    @Resource
    private ISysUsersService usersService;
    @Resource
    private ISysStruService sysStruService;
    private static final Logger logger = LoggerFactory.getLogger(UnifiedTaskServiceImpl.class);
    @Autowired
    private IUnifiedPendingTaskInfoService iUnifiedPendingTaskInfoService;
    @Autowired
    private IUnifiedTodoTaskInfoService iUnifiedTodoTaskInfoService;
    @Autowired
    private IUnifiedUnReadTaskInfoService iUnifiedUnReadTaskInfoService;
    @Autowired
    private IUnifiedProcessRectificationService iUnifiedProcessRectificationService;
    @Resource
    private IUnifiedDeleteProcessInfoService iUnifiedDeleteProcessInfoService;
    @Resource
    private UnifiedToDoConfigure unifiedToDoConfigure;
    @Resource
    private ISysUsersService sysUsersService;
    @Value(value="${hussar.bpm.system-id}")
    String systemId;
    @Value(value="${hussar.vue-app-ias-url}")
    String vueAppIasUrl;
    @Value(value="${hussar.approval-center-pc}")
    String approvalCenterPc;
    @Value(value="${hussar.approval-center-mobile}")
    String approvalCenterMobile;
    @Value(value="${hussar.vue-app-ias-new-tab}")
    String vueAppIasNewsTab;
    private static final Map<String, String> PROCESS_STATE = new HashMap<String, String>();

    public ApiResponse<String> taskChange(TaskChangeDto taskChangeDto, TaskChangedDto taskChangedDto) {
        LambdaQueryWrapper wrapper;
        ApiResponse isBuildSuccess = taskChangeDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (taskChangedDto == null) {
            wrapper = new LambdaQueryWrapper();
            taskChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
            this.unifiedTaskInfoService.remove((Wrapper)wrapper);
        } else {
            SysUsers sysUsers;
            wrapper = new LambdaUpdateWrapper();
            taskChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
            List unifiedDoneTaskInfos = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(UnifiedTaskInfo::getTaskId, (Collection)taskChangeDto.getTaskIds())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"3"));
            List unifiedTodoTaskInfos = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(UnifiedTaskInfo::getTaskId, (Collection)taskChangeDto.getTaskIds())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1"));
            List unifiedUnReadTaskInfos = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(UnifiedTaskInfo::getTaskId, (Collection)taskChangeDto.getTaskIds())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"4"));
            ArrayList<UnifiedTaskInfo> unifiedTodoTaskInfoNews = new ArrayList<UnifiedTaskInfo>();
            if (CollectionUtil.isNotEmpty((Collection)unifiedDoneTaskInfos)) {
                for (UnifiedTaskInfo unifiedDoneTaskInfo : unifiedDoneTaskInfos) {
                    unifiedDoneTaskInfo.setCreateTime(taskChangedDto.getCreateTime());
                    unifiedDoneTaskInfo.setLastTime(taskChangedDto.getLastTime());
                    unifiedDoneTaskInfo.setDeadLine(taskChangedDto.getDeadLine());
                    unifiedDoneTaskInfo.setWebLinkurl(taskChangedDto.getWebLinkurl());
                    unifiedDoneTaskInfo.setMobileLinkurl(taskChangedDto.getMobileLinkurl());
                    unifiedDoneTaskInfo.setTaskDefinitionkey(taskChangedDto.getTaskDefinitionkey());
                    unifiedDoneTaskInfo.setTaskName(taskChangedDto.getTaskName());
                    unifiedDoneTaskInfo.setWebUrlProps(taskChangedDto.getWebUrlProps());
                    unifiedDoneTaskInfo.setMobileUrlProps(taskChangedDto.getMobileUrlProps());
                    unifiedDoneTaskInfo.setComment(taskChangedDto.getComment());
                    if (!this.unifiedTodoGLDProperties.isOpen()) continue;
                    GlodonNodeDataDto nodeDataDto = new GlodonNodeDataDto();
                    nodeDataDto.setId(unifiedDoneTaskInfo.getTaskId());
                    nodeDataDto.setFlowId(unifiedDoneTaskInfo.getProcessInstanceid());
                    nodeDataDto.setDeleted(Boolean.valueOf(false));
                    sysUsers = this.usersService.getUserByOutOriginId(unifiedDoneTaskInfo.getUserId());
                    nodeDataDto.setPromoterId(HussarUtils.isNull((Object)sysUsers) ? "" : sysUsers.getOutOriginId());
                    nodeDataDto.setPromoterNo(unifiedDoneTaskInfo.getAssigneeUserNumber());
                    nodeDataDto.setPromoterName(unifiedDoneTaskInfo.getAssigneeUserName());
                    nodeDataDto.setDeptName(unifiedDoneTaskInfo.getDeptName());
                    nodeDataDto.setPostName(unifiedDoneTaskInfo.getPostName());
                    nodeDataDto.setComment(unifiedDoneTaskInfo.getComment());
                    nodeDataDto.setJumpUrl(this.unifiedTodoGLDProperties.getToDoList() + "%2526processInstId=" + unifiedDoneTaskInfo.getProcessInstanceid());
                    if (null != unifiedDoneTaskInfo.getCompleteTime()) {
                        nodeDataDto.setApproveTime(DateUtil.format((Date)unifiedDoneTaskInfo.getCompleteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    if (null != unifiedDoneTaskInfo.getDeadLine()) {
                        nodeDataDto.setDeadlineTime(DateUtil.format((Date)unifiedDoneTaskInfo.getDeadLine(), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    nodeDataDto.setApprovalStatus(Integer.valueOf(2));
                    this.pushGldNode(nodeDataDto);
                }
                taskChangedDto.buildWrapper((LambdaUpdateWrapper)wrapper);
                this.unifiedTaskInfoService.update((Wrapper)wrapper);
            } else if (CollectionUtil.isNotEmpty((Collection)unifiedTodoTaskInfos)) {
                for (UnifiedTaskInfo unifiedTodoTaskInfo : unifiedTodoTaskInfos) {
                    unifiedTodoTaskInfo.setCreateTime(taskChangedDto.getCreateTime());
                    unifiedTodoTaskInfo.setLastTime(taskChangedDto.getLastTime());
                    unifiedTodoTaskInfo.setDeadLine(taskChangedDto.getDeadLine());
                    unifiedTodoTaskInfo.setWebLinkurl(taskChangedDto.getWebLinkurl());
                    unifiedTodoTaskInfo.setMobileLinkurl(taskChangedDto.getMobileLinkurl());
                    unifiedTodoTaskInfo.setTaskDefinitionkey(taskChangedDto.getTaskDefinitionkey());
                    unifiedTodoTaskInfo.setTaskName(taskChangedDto.getTaskName());
                    unifiedTodoTaskInfo.setWebUrlProps(taskChangedDto.getWebUrlProps());
                    unifiedTodoTaskInfo.setMobileUrlProps(taskChangedDto.getMobileUrlProps());
                    unifiedTodoTaskInfo.setComment(taskChangedDto.getComment());
                    if (this.unifiedTodoGLDProperties.isOpen()) {
                        GlodonNodeDataDto requestBody = new GlodonNodeDataDto();
                        requestBody.setFlowId(unifiedTodoTaskInfo.getProcessInstanceid());
                        requestBody.setId(unifiedTodoTaskInfo.getTaskId());
                        sysUsers = this.usersService.getUserByOutOriginId(unifiedTodoTaskInfo.getUserId());
                        requestBody.setPromoterId(HussarUtils.isNull((Object)sysUsers) ? "" : sysUsers.getOutOriginId());
                        requestBody.setPromoterNo(unifiedTodoTaskInfo.getAssigneeUserNumber());
                        requestBody.setPromoterName(unifiedTodoTaskInfo.getAssigneeUserName());
                        requestBody.setDeptName(unifiedTodoTaskInfo.getDeptName());
                        requestBody.setPostName(unifiedTodoTaskInfo.getPostName());
                        requestBody.setComment(unifiedTodoTaskInfo.getComment());
                        requestBody.setDeleted(Boolean.valueOf(false));
                        if (null != unifiedTodoTaskInfo.getDeadLine()) {
                            requestBody.setDeadlineTime(DateUtil.format((Date)unifiedTodoTaskInfo.getDeadLine(), (String)"yyyy-MM-dd HH:mm:ss"));
                        }
                        if ("1".equals(unifiedTodoTaskInfo.getTaskStatus())) {
                            requestBody.setApprovalStatus(Integer.valueOf(1));
                            requestBody.setJumpUrl(this.unifiedTodoGLDProperties.getToBe() + "%2526taskId=" + unifiedTodoTaskInfo.getTaskId());
                        } else if ("3".equals(unifiedTodoTaskInfo.getTaskStatus())) {
                            requestBody.setApprovalStatus(Integer.valueOf(2));
                            requestBody.setJumpUrl(this.unifiedTodoGLDProperties.getToDoList() + "%2526processInstId=" + unifiedTodoTaskInfo.getProcessInstanceid());
                        }
                        this.pushGldNode(requestBody);
                    }
                    unifiedTodoTaskInfoNews.add(unifiedTodoTaskInfo);
                }
                if ("3".equals(taskChangedDto.getTaskType())) {
                    List<UnifiedTaskInfo> unifiedDoneTaskInfoList = unifiedTodoTaskInfoNews.stream().map(todo -> {
                        UnifiedTaskInfo doneTaskInfo = new UnifiedTaskInfo();
                        BeanUtils.copyProperties((Object)todo, (Object)doneTaskInfo);
                        doneTaskInfo.setTaskStatus("3");
                        return doneTaskInfo;
                    }).collect(Collectors.toList());
                    this.unifiedTaskInfoService.remove((Wrapper)wrapper);
                    if (this.unifiedTodoGLDProperties.isOpen()) {
                        unifiedDoneTaskInfoList.forEach(doneTaskInfo -> {
                            GlodonNodeDataDto nodeDataDto = new GlodonNodeDataDto();
                            nodeDataDto.setFlowId(doneTaskInfo.getProcessInstanceid());
                            nodeDataDto.setId(doneTaskInfo.getTaskId());
                            nodeDataDto.setDeleted(Boolean.valueOf(false));
                            SysUsers sysUsers = this.usersService.getUserByOutOriginId(doneTaskInfo.getUserId());
                            nodeDataDto.setPromoterId(HussarUtils.isNull((Object)sysUsers) ? "" : sysUsers.getOutOriginId());
                            nodeDataDto.setPromoterNo(doneTaskInfo.getAssigneeUserNumber());
                            nodeDataDto.setPromoterName(doneTaskInfo.getAssigneeUserName());
                            nodeDataDto.setDeptName(doneTaskInfo.getDeptName());
                            nodeDataDto.setPostName(doneTaskInfo.getPostName());
                            nodeDataDto.setComment(doneTaskInfo.getComment());
                            nodeDataDto.setJumpUrl(this.unifiedTodoGLDProperties.getToDoList() + "%2526processInstId=" + doneTaskInfo.getProcessInstanceid());
                            if (null != doneTaskInfo.getCompleteTime()) {
                                nodeDataDto.setApproveTime(DateUtil.format((Date)doneTaskInfo.getCompleteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                            }
                            if (null != doneTaskInfo.getDeadLine()) {
                                nodeDataDto.setDeadlineTime(DateUtil.format((Date)doneTaskInfo.getDeadLine(), (String)"yyyy-MM-dd HH:mm:ss"));
                            }
                            nodeDataDto.setApprovalStatus(Integer.valueOf(2));
                            this.pushGldNode(nodeDataDto);
                        });
                    }
                    this.unifiedTaskInfoService.saveOrUpdateBatch(unifiedDoneTaskInfoList);
                }
            } else if (HussarUtils.isNotEmpty((Object)unifiedUnReadTaskInfos)) {
                ArrayList<UnifiedTaskInfo> unifiedReadedTaskInfoNews = new ArrayList<UnifiedTaskInfo>();
                for (UnifiedTaskInfo unifiedUnReadTaskInfo : unifiedUnReadTaskInfos) {
                    UnifiedTaskInfo unifiedReadedTaskInfo = new UnifiedTaskInfo();
                    BeanUtils.copyProperties((Object)unifiedUnReadTaskInfo, (Object)unifiedReadedTaskInfo);
                    unifiedReadedTaskInfo.setTaskStatus("5");
                    unifiedReadedTaskInfoNews.add(unifiedReadedTaskInfo);
                }
                this.unifiedTaskInfoService.remove((Wrapper)wrapper);
                this.unifiedTaskInfoService.saveOrUpdateBatch(unifiedReadedTaskInfoNews);
            } else {
                taskChangedDto.buildWrapper((LambdaUpdateWrapper)wrapper);
                this.unifiedTaskInfoService.update((Wrapper)wrapper);
            }
        }
        if (this.unifiedTodoProperties.getOpen()) {
            logger.info("taskIds" + taskChangeDto.getTaskIds());
            List taskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, (Collection)taskChangeDto.getTaskIds())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"3"));
            if (CollectionUtil.isEmpty((Collection)taskInfoList)) {
                taskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, (Collection)taskChangeDto.getTaskIds())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"5"));
                logger.info("readSize" + taskInfoList.size());
            }
            logger.info("taskSize:" + taskInfoList.size());
            if (CollectionUtil.isNotEmpty((Collection)taskInfoList)) {
                for (UnifiedTaskInfo unifiedTaskInfo : taskInfoList) {
                    logger.info("taskInfo:" + JSON.toJSONString((Object)unifiedTaskInfo));
                    List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                    this.pushTaskToOa(unifiedTaskInfo, taskUsers, null);
                }
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> taskChangeClassify(TaskChangeDto taskChangeDto, TaskChangedDto taskChangedDto) {
        block5: {
            List doneTaskInfoList;
            block6: {
                LambdaQueryWrapper wrapper;
                ApiResponse isBuildSuccess = taskChangeDto.buildAllInfo();
                if (!isBuildSuccess.isSuccess()) {
                    return isBuildSuccess;
                }
                if (taskChangedDto == null) {
                    wrapper = new LambdaQueryWrapper();
                    taskChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
                    this.unifiedTaskInfoService.remove((Wrapper)wrapper);
                } else {
                    wrapper = new LambdaUpdateWrapper();
                    taskChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
                    taskChangedDto.buildWrapper((LambdaUpdateWrapper)wrapper);
                    this.unifiedTaskInfoService.update((Wrapper)wrapper);
                }
                if (!this.unifiedTodoProperties.getOpen()) break block5;
                logger.info("taskIds" + taskChangeDto.getTaskIds());
                doneTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, (Collection)taskChangeDto.getTaskIds())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"3")).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')));
                if (!CollectionUtil.isEmpty((Collection)doneTaskInfoList)) break block6;
                List readTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, (Collection)taskChangeDto.getTaskIds())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"5")).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')));
                logger.info("readTaskInfoSize:" + readTaskInfoList.size());
                if (!CollectionUtil.isNotEmpty((Collection)readTaskInfoList)) break block5;
                for (UnifiedTaskInfo readTaskInfo : readTaskInfoList) {
                    logger.info("readTaskInfo:" + JSON.toJSONString((Object)readTaskInfo));
                    List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)readTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)readTaskInfo.getSystemId()));
                    this.pushTaskToOa(null, null, null, null, readTaskInfo, taskUsers, null);
                }
                break block5;
            }
            logger.info("doneTaskInfoSize:" + doneTaskInfoList.size());
            for (UnifiedTaskInfo doneTaskInfo : doneTaskInfoList) {
                logger.info("doneTaskInfo:" + JSON.toJSONString((Object)doneTaskInfo));
                List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)doneTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)doneTaskInfo.getSystemId()));
                this.pushTaskToOa(null, null, doneTaskInfo, null, null, taskUsers, null);
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> taskChange(TaskDeleteDto taskDeleteDto, TaskAddBatchDto taskAddBatchDto) {
        ApiResponse<String> isDeleteSuccess;
        if (taskDeleteDto != null && !(isDeleteSuccess = this.taskDelete(taskDeleteDto)).isSuccess()) {
            return isDeleteSuccess;
        }
        if (taskAddBatchDto != null) {
            return this.taskAddBatch(taskAddBatchDto);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> taskChangeClassify(TaskDeleteDto taskDeleteDto, TaskAddBatchDto taskAddBatchDto) {
        ApiResponse<String> isDeleteSuccess;
        if (taskDeleteDto != null && !(isDeleteSuccess = this.taskDeleteClassify(taskDeleteDto)).isSuccess()) {
            return isDeleteSuccess;
        }
        if (taskAddBatchDto != null) {
            return this.taskAddBatchClassify(taskAddBatchDto);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> userChange(UserChangeDto userChangeDto, UnifiedTaskUser unifiedTaskUser) {
        ApiResponse isBuildSuccess = userChangeDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (unifiedTaskUser == null) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            userChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
            this.unifiedTaskUserService.remove((Wrapper)wrapper);
        } else {
            SysUsers sysUsers;
            GlodonNodeDataDto requestBody;
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            userChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
            this.unifiedTaskUserService.update((Object)unifiedTaskUser, (Wrapper)wrapper);
            List unifiedDoneTaskInfos = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(UnifiedTaskInfo::getTaskId, (Collection)userChangeDto.getTaskIds())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"3"));
            List unifiedTodoTaskInfos = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(UnifiedTaskInfo::getTaskId, (Collection)userChangeDto.getTaskIds())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1"));
            if (CollectionUtil.isNotEmpty((Collection)unifiedDoneTaskInfos)) {
                for (UnifiedTaskInfo unifiedDoneTaskInfo : unifiedDoneTaskInfos) {
                    unifiedDoneTaskInfo.setDeptId(unifiedTaskUser.getDeptId());
                    unifiedDoneTaskInfo.setDeptName(unifiedTaskUser.getDeptName());
                    unifiedDoneTaskInfo.setUnitId(unifiedTaskUser.getUnitId());
                    unifiedDoneTaskInfo.setUnitName(unifiedTaskUser.getUnitName());
                    unifiedDoneTaskInfo.setPostId(unifiedTaskUser.getPostId());
                    unifiedDoneTaskInfo.setPostName(unifiedTaskUser.getPostName());
                    unifiedDoneTaskInfo.setUserId(unifiedTaskUser.getUserId());
                    unifiedDoneTaskInfo.setAssigneeUserName(unifiedTaskUser.getUserName());
                    unifiedDoneTaskInfo.setAssigneeUserNumber(unifiedTaskUser.getUserNumber());
                    unifiedDoneTaskInfo.setAssigneeDeptId(unifiedTaskUser.getDeptId());
                    unifiedDoneTaskInfo.setAssigneeDeptName(unifiedTaskUser.getDeptName());
                    unifiedDoneTaskInfo.setAssigneeUnitId(unifiedTaskUser.getUnitId());
                    unifiedDoneTaskInfo.setAssigneeUnitName(unifiedTaskUser.getUnitName());
                    unifiedDoneTaskInfo.setAssigneeMainDeptId(unifiedTaskUser.getMainDeptId());
                    unifiedDoneTaskInfo.setAssigneeMainDeptName(unifiedTaskUser.getMainDeptName());
                    unifiedDoneTaskInfo.setAssigneeMainUnitId(unifiedTaskUser.getMainUnitId());
                    unifiedDoneTaskInfo.setAssigneeMainUnitName(unifiedTaskUser.getMainUnitName());
                    unifiedDoneTaskInfo.setCompleteTime(unifiedTaskUser.getCompleteTime());
                    if (!this.unifiedTodoGLDProperties.isOpen()) continue;
                    requestBody = new GlodonNodeDataDto();
                    requestBody.setFlowId(unifiedDoneTaskInfo.getProcessInstanceid());
                    requestBody.setId(unifiedDoneTaskInfo.getTaskId());
                    sysUsers = this.usersService.getUserByOutOriginId(unifiedDoneTaskInfo.getUserId());
                    requestBody.setPromoterId(HussarUtils.isNull((Object)sysUsers) ? "" : sysUsers.getOutOriginId());
                    requestBody.setPromoterNo(unifiedDoneTaskInfo.getAssigneeUserNumber());
                    requestBody.setPromoterName(unifiedDoneTaskInfo.getAssigneeUserName());
                    requestBody.setDeptName(unifiedDoneTaskInfo.getDeptName());
                    requestBody.setPostName(unifiedDoneTaskInfo.getPostName());
                    requestBody.setComment(unifiedDoneTaskInfo.getComment());
                    requestBody.setDeleted(Boolean.valueOf(false));
                    if (null != unifiedDoneTaskInfo.getCompleteTime()) {
                        requestBody.setApproveTime(DateUtil.format((Date)unifiedDoneTaskInfo.getCompleteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    if (null != unifiedDoneTaskInfo.getDeadLine()) {
                        requestBody.setDeadlineTime(DateUtil.format((Date)unifiedDoneTaskInfo.getDeadLine(), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    if ("1".equals(unifiedDoneTaskInfo.getTaskStatus())) {
                        requestBody.setApprovalStatus(Integer.valueOf(1));
                        requestBody.setJumpUrl(this.unifiedTodoGLDProperties.getToBe() + "%2526taskId=" + unifiedDoneTaskInfo.getTaskId());
                    } else if ("3".equals(unifiedDoneTaskInfo.getTaskStatus())) {
                        requestBody.setApprovalStatus(Integer.valueOf(2));
                        requestBody.setJumpUrl(this.unifiedTodoGLDProperties.getToDoList() + "%2526processInstId=" + unifiedDoneTaskInfo.getProcessInstanceid());
                    }
                    this.pushGldNode(requestBody);
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)unifiedTodoTaskInfos)) {
                for (UnifiedTaskInfo unifiedTodoTaskInfo : unifiedTodoTaskInfos) {
                    unifiedTodoTaskInfo.setDeptId(unifiedTaskUser.getDeptId());
                    unifiedTodoTaskInfo.setDeptName(unifiedTaskUser.getDeptName());
                    unifiedTodoTaskInfo.setUnitId(unifiedTaskUser.getUnitId());
                    unifiedTodoTaskInfo.setUnitName(unifiedTaskUser.getUnitName());
                    unifiedTodoTaskInfo.setPostId(unifiedTaskUser.getPostId());
                    unifiedTodoTaskInfo.setPostName(unifiedTaskUser.getPostName());
                    unifiedTodoTaskInfo.setUserId(unifiedTaskUser.getUserId());
                    unifiedTodoTaskInfo.setAssigneeUserName(unifiedTaskUser.getUserName());
                    unifiedTodoTaskInfo.setAssigneeUserNumber(unifiedTaskUser.getUserNumber());
                    unifiedTodoTaskInfo.setAssigneeDeptId(unifiedTaskUser.getDeptId());
                    unifiedTodoTaskInfo.setAssigneeDeptName(unifiedTaskUser.getDeptName());
                    unifiedTodoTaskInfo.setAssigneeUnitId(unifiedTaskUser.getUnitId());
                    unifiedTodoTaskInfo.setAssigneeUnitName(unifiedTaskUser.getUnitName());
                    unifiedTodoTaskInfo.setAssigneeMainDeptId(unifiedTaskUser.getMainDeptId());
                    unifiedTodoTaskInfo.setAssigneeMainDeptName(unifiedTaskUser.getMainDeptName());
                    unifiedTodoTaskInfo.setAssigneeMainUnitId(unifiedTaskUser.getMainUnitId());
                    unifiedTodoTaskInfo.setAssigneeMainUnitName(unifiedTaskUser.getMainUnitName());
                    unifiedTodoTaskInfo.setCompleteTime(unifiedTaskUser.getCompleteTime());
                    if (!this.unifiedTodoGLDProperties.isOpen()) continue;
                    requestBody = new GlodonNodeDataDto();
                    requestBody.setFlowId(unifiedTodoTaskInfo.getProcessInstanceid());
                    requestBody.setId(unifiedTodoTaskInfo.getTaskId());
                    sysUsers = this.usersService.getUserByOutOriginId(unifiedTodoTaskInfo.getUserId());
                    requestBody.setPromoterId(HussarUtils.isNull((Object)sysUsers) ? "" : sysUsers.getOutOriginId());
                    requestBody.setPromoterNo(unifiedTodoTaskInfo.getAssigneeUserNumber());
                    requestBody.setPromoterName(unifiedTodoTaskInfo.getAssigneeUserName());
                    requestBody.setDeptName(unifiedTodoTaskInfo.getDeptName());
                    requestBody.setPostName(unifiedTodoTaskInfo.getPostName());
                    requestBody.setComment(unifiedTodoTaskInfo.getComment());
                    requestBody.setDeleted(Boolean.valueOf(false));
                    if (null != unifiedTodoTaskInfo.getCompleteTime()) {
                        requestBody.setApproveTime(DateUtil.format((Date)unifiedTodoTaskInfo.getCompleteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    if (null != unifiedTodoTaskInfo.getDeadLine()) {
                        requestBody.setDeadlineTime(DateUtil.format((Date)unifiedTodoTaskInfo.getDeadLine(), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    if ("1".equals(unifiedTodoTaskInfo.getTaskStatus())) {
                        requestBody.setApprovalStatus(Integer.valueOf(1));
                        requestBody.setJumpUrl(this.unifiedTodoGLDProperties.getToBe() + "%2526taskId=" + unifiedTodoTaskInfo.getTaskId());
                    } else if ("3".equals(unifiedTodoTaskInfo.getTaskStatus())) {
                        requestBody.setApprovalStatus(Integer.valueOf(2));
                        requestBody.setJumpUrl(this.unifiedTodoGLDProperties.getToDoList() + "%2526processInstId=" + unifiedTodoTaskInfo.getProcessInstanceid());
                    }
                    this.pushGldNode(requestBody);
                }
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> userChangeClassify(UserChangeDto userChangeDto, UnifiedTaskUser unifiedTaskUser) {
        ApiResponse isBuildSuccess = userChangeDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (unifiedTaskUser == null) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            userChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
            this.unifiedTaskUserService.remove((Wrapper)wrapper);
        } else {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            userChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
            this.unifiedTaskUserService.update((Object)unifiedTaskUser, (Wrapper)wrapper);
            LambdaUpdateWrapper<UnifiedTaskInfo> taskAssigneeUpateWrapper = this.getTaskAssigneeUpdateWrapper(userChangeDto, unifiedTaskUser);
            this.unifiedTaskInfoService.update(taskAssigneeUpateWrapper);
        }
        return ApiResponse.success();
    }

    private LambdaUpdateWrapper<UnifiedTaskInfo> getTaskAssigneeUpdateWrapper(UserChangeDto userChangeDto, UnifiedTaskUser unifiedTaskUser) {
        LambdaUpdateWrapper unifiedTaskUpdateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(UnifiedTaskInfo::getAssigneeUserNumber, (Object)unifiedTaskUser.getUserNumber())).set(UnifiedTaskInfo::getUserId, (Object)unifiedTaskUser.getUserId())).set(UnifiedTaskInfo::getAssigneeUserName, (Object)unifiedTaskUser.getUserName())).set(UnifiedTaskInfo::getDeptId, (Object)unifiedTaskUser.getDeptId())).set(UnifiedTaskInfo::getDeptName, (Object)unifiedTaskUser.getDeptName())).set(UnifiedTaskInfo::getAssigneeDeptId, (Object)unifiedTaskUser.getDeptId())).set(UnifiedTaskInfo::getAssigneeDeptName, (Object)unifiedTaskUser.getDeptName())).set(UnifiedTaskInfo::getUnitId, (Object)unifiedTaskUser.getUnitId())).set(UnifiedTaskInfo::getUnitName, (Object)unifiedTaskUser.getUnitName())).set(UnifiedTaskInfo::getAssigneeUnitId, (Object)unifiedTaskUser.getUnitId())).set(UnifiedTaskInfo::getAssigneeUnitName, (Object)unifiedTaskUser.getUnitName())).set(UnifiedTaskInfo::getPostId, (Object)unifiedTaskUser.getPostId())).set(UnifiedTaskInfo::getPostName, (Object)unifiedTaskUser.getPostName())).set(UnifiedTaskInfo::getAssigneeMainDeptId, (Object)unifiedTaskUser.getMainDeptId())).set(UnifiedTaskInfo::getAssigneeMainDeptName, (Object)unifiedTaskUser.getMainDeptName())).set(UnifiedTaskInfo::getAssigneeMainUnitId, (Object)unifiedTaskUser.getMainUnitId())).set(UnifiedTaskInfo::getAssigneeMainUnitName, (Object)unifiedTaskUser.getMainUnitName())).in(UnifiedTaskInfo::getTaskId, (Collection)userChangeDto.getTaskIds())).eq(UnifiedTaskInfo::getSystemId, (Object)userChangeDto.getSystemId());
        return unifiedTaskUpdateWrapper;
    }

    public ApiResponse<String> userChange(UserDeleteDto userDeleteDto, UserAddBatchDto userAddBatchDto) {
        ApiResponse<String> isDeleteSuccess;
        if (userDeleteDto != null && !(isDeleteSuccess = this.userDelete(userDeleteDto)).isSuccess()) {
            return isDeleteSuccess;
        }
        if (userAddBatchDto != null) {
            return this.userAddBatch(userAddBatchDto);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> userChangeClassify(UserDeleteDto userDeleteDto, UserAddBatchDto userAddBatchDto) {
        ApiResponse<String> isDeleteSuccess;
        if (userDeleteDto != null && !(isDeleteSuccess = this.userDeleteClassify(userDeleteDto)).isSuccess()) {
            return isDeleteSuccess;
        }
        if (userAddBatchDto != null) {
            return this.userAddBatchClassify(userAddBatchDto);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> taskAddBatch(TaskAddBatchDto taskAddBatchDto) {
        ApiResponse isBuildSuccess = taskAddBatchDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        ArrayList taskInfos = new ArrayList();
        ArrayList taskUsers = new ArrayList();
        taskAddBatchDto.getTaskInfos().forEach(taskInfoWithUser -> {
            taskInfos.add(taskInfoWithUser.getTaskInfo());
            if (taskInfoWithUser.getTaskUsers() != null) {
                taskUsers.addAll(taskInfoWithUser.getTaskUsers());
            }
        });
        this.unifiedTaskInfoService.saveBatch(taskInfos);
        if (HussarUtils.isNotEmpty(taskUsers)) {
            this.unifiedTaskUserService.saveBatch(taskUsers);
        }
        if (this.unifiedTodoProperties.getOpen() && CollectionUtil.isNotEmpty(taskInfos)) {
            logger.info("\u6284\u9001\u63a8\u9001\u5f00\u59cb");
            for (UnifiedTaskInfo taskInfo : taskInfos) {
                List<Object> resultList;
                List<UnifiedTaskUser> partList = taskUsers.stream().filter(u -> u.getTaskId().equals(taskInfo.getTaskId())).collect(Collectors.toList());
                if ("4".equals(taskInfo.getTaskStatus())) {
                    List allIdList;
                    List allUserList;
                    List allList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)taskInfo.getProcessInstanceid())).ne(UnifiedTaskInfo::getTaskId, (Object)taskInfo.getTaskId()));
                    if (!CollectionUtil.isNotEmpty((Collection)allList) || !CollectionUtil.isNotEmpty((Collection)(allUserList = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, allIdList = allList.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toList()))).eq(UnifiedTaskUser::getSystemId, (Object)taskInfo.getSystemId()))))) continue;
                    List allUserIds = allUserList.stream().map(UnifiedTaskUser::getUserId).collect(Collectors.toList());
                    resultList = partList.stream().filter(u -> !allUserIds.contains(u.getUserId())).collect(Collectors.toList());
                } else {
                    resultList = partList;
                }
                this.pushTaskToOa(taskInfo, resultList, null);
            }
            if ("2".equals(((UnifiedTaskInfo)taskInfos.get(0)).getTaskStatus())) {
                logger.info("\u5f85\u5ba1\u63a8\u9001\u5f00\u59cb");
                List taskInfoList = this.unifiedTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)((UnifiedTaskInfo)taskInfos.get(0)).getProcessInstanceid()));
                List ccList = taskInfoList.stream().filter(t -> "4".equals(t.getTaskStatus())).collect(Collectors.toList());
                List unCcList = taskInfoList.stream().filter(t -> !"4".equals(t.getTaskStatus())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(ccList)) {
                    return ApiResponse.success((Object)"", null);
                }
                List taskIdList = taskInfoList.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toList());
                List taskUserList = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, taskIdList)).eq(UnifiedTaskUser::getSystemId, (Object)((UnifiedTaskInfo)taskInfos.get(0)).getSystemId()));
                if (CollectionUtil.isEmpty((Collection)taskUserList)) {
                    return ApiResponse.success((Object)"", null);
                }
                List ccTaskIdList = ccList.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toList());
                List unCcTaskIdList = unCcList.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toList());
                List ccUserList = taskUserList.stream().filter(t -> ccTaskIdList.contains(t.getTaskId())).collect(Collectors.toList());
                List unCcUserIdList = taskUserList.stream().filter(t -> unCcTaskIdList.contains(t.getTaskId())).map(UnifiedTaskUser::getUserId).collect(Collectors.toList());
                for (UnifiedTaskInfo unifiedTaskInfo : ccList) {
                    logger.info("\u6d41\u7a0b\u914d\u7f6e\u7684\u6284\u9001\u6570\u636e:" + JSON.toJSONString((Object)unifiedTaskInfo));
                    List partUserList = ccUserList.stream().filter(c -> c.getTaskId().equals(unifiedTaskInfo.getTaskId())).collect(Collectors.toList());
                    if (CollectionUtil.isEmpty(partUserList)) continue;
                    List<UnifiedTaskUser> unifiedTaskUsers = partUserList.stream().filter(p -> !unCcUserIdList.contains(p.getUserId())).collect(Collectors.toList());
                    this.pushTaskToOa(unifiedTaskInfo, unifiedTaskUsers, null);
                }
            }
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> taskAddBatchClassify(TaskAddBatchDto taskAddBatchDto) {
        ApiResponse isBuildSuccess = taskAddBatchDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        ArrayList taskInfos = new ArrayList();
        ArrayList taskUsers = new ArrayList();
        ArrayList doneTaskInfos = new ArrayList();
        ArrayList pendingTaskInfos = new ArrayList();
        ArrayList readedTaskInfos = new ArrayList();
        ArrayList todoTaskInfos = new ArrayList();
        ArrayList unReadTaskInfos = new ArrayList();
        UnifiedProcessInfo processInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)((TaskInfoWithUser)taskAddBatchDto.getTaskInfos().get(0)).getTaskInfo().getProcessInstanceid()));
        taskAddBatchDto.getTaskInfos().forEach(taskInfoWithUser -> {
            if (taskInfoWithUser.getTaskUsers() != null) {
                taskUsers.addAll(taskInfoWithUser.getTaskUsers());
                taskInfos.add(new UnifiedTaskInfo().buildTaskInfo(taskInfoWithUser.getTaskInfo(), (UnifiedTaskUser)taskInfoWithUser.getTaskUsers().get(0)));
            }
        });
        taskInfos.forEach(taskInfo -> {
            if (HussarUtils.isNotEmpty((Object)taskInfo)) {
                switch (taskInfo.getTaskStatus()) {
                    case "1": {
                        todoTaskInfos.add(taskInfo);
                        break;
                    }
                    case "2": {
                        pendingTaskInfos.add(taskInfo);
                        break;
                    }
                    case "4": {
                        unReadTaskInfos.add(taskInfo);
                        break;
                    }
                    case "5": {
                        readedTaskInfos.add(taskInfo);
                        break;
                    }
                    default: {
                        doneTaskInfos.add(taskInfo);
                    }
                }
            }
        });
        if (HussarUtils.isNotEmpty(taskInfos)) {
            if (HussarUtils.isNotEmpty((Object)processInfo)) {
                new UnifiedTaskInfo().buildTaskInfo(taskInfos, processInfo);
            }
            this.unifiedTaskInfoService.saveBatch(taskInfos);
        }
        if (HussarUtils.isNotEmpty(taskUsers)) {
            this.unifiedTaskUserService.saveBatch(taskUsers);
        }
        if (this.unifiedTodoProperties.getOpen()) {
            List<UnifiedTaskUser> partList;
            if (CollectionUtil.isNotEmpty(unReadTaskInfos)) {
                logger.info("\u6284\u9001\u63a8\u9001\u5f00\u59cb");
                for (UnifiedTaskInfo unReadTaskInfo : unReadTaskInfos) {
                    List allUserList;
                    List readTaskInfoList;
                    List doneTaskInfoList;
                    List pendingTaskInfoList;
                    logger.info("unReadTaskInfo\u672a\u8bfb\uff1a" + JSON.toJSONString((Object)unReadTaskInfo));
                    partList = taskUsers.stream().filter(u -> u.getTaskId().equals(unReadTaskInfo.getTaskId())).collect(Collectors.toList());
                    List<Object> resultList = new ArrayList<UnifiedTaskUser>();
                    ArrayList allIdList = new ArrayList();
                    List todoTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)unReadTaskInfo.getProcessInstanceid())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1")).eq(UnifiedTaskInfo::getProcessState, (Object)Character.valueOf('0'))).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')));
                    if (CollectionUtil.isNotEmpty((Collection)todoTaskInfoList)) {
                        todoTaskInfoList.forEach(t -> allIdList.add(t.getTaskId()));
                    }
                    if (CollectionUtil.isNotEmpty((Collection)(pendingTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)unReadTaskInfo.getProcessInstanceid())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"2")).eq(UnifiedTaskInfo::getProcessState, (Object)Character.valueOf('0'))).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')))))) {
                        pendingTaskInfoList.forEach(t -> allIdList.add(t.getTaskId()));
                    }
                    if (CollectionUtil.isNotEmpty((Collection)(doneTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)unReadTaskInfo.getProcessInstanceid())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"3")).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')))))) {
                        doneTaskInfoList.forEach(t -> allIdList.add(t.getTaskId()));
                    }
                    if (CollectionUtil.isNotEmpty((Collection)(readTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)unReadTaskInfo.getProcessInstanceid())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"5")).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')))))) {
                        readTaskInfoList.forEach(t -> allIdList.add(t.getTaskId()));
                    }
                    if (CollectionUtil.isNotEmpty(allIdList) && CollectionUtil.isNotEmpty((Collection)(allUserList = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, allIdList)).eq(UnifiedTaskUser::getSystemId, (Object)unReadTaskInfo.getSystemId()))))) {
                        List allUserIds = allUserList.stream().map(UnifiedTaskUser::getUserId).collect(Collectors.toList());
                        resultList = partList.stream().filter(u -> !allUserIds.contains(u.getUserId())).collect(Collectors.toList());
                    }
                    this.pushTaskToOa(null, null, null, unReadTaskInfo, null, resultList, null);
                }
            }
            if (CollectionUtil.isNotEmpty(pendingTaskInfos)) {
                List unReadTaskInfoList;
                List readTaskInfoList;
                List doneTaskInfoList;
                List pendingTaskInfoList;
                logger.info("\u5f85\u5ba1\u63a8\u9001\u5f00\u59cb");
                ArrayList ccIdList = new ArrayList();
                ArrayList unCcIdList = new ArrayList();
                List todoTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)((UnifiedTaskInfo)pendingTaskInfos.get(0)).getProcessInstanceid())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1")).eq(UnifiedTaskInfo::getProcessState, (Object)Character.valueOf('0'))).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')));
                if (CollectionUtil.isNotEmpty((Collection)todoTaskInfoList)) {
                    todoTaskInfoList.forEach(t -> unCcIdList.add(t.getTaskId()));
                }
                if (CollectionUtil.isNotEmpty((Collection)(pendingTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)((UnifiedTaskInfo)pendingTaskInfos.get(0)).getProcessInstanceid())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"2")).eq(UnifiedTaskInfo::getProcessState, (Object)Character.valueOf('0'))).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')))))) {
                    pendingTaskInfoList.forEach(t -> unCcIdList.add(t.getTaskId()));
                }
                if (CollectionUtil.isNotEmpty((Collection)(doneTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)((UnifiedTaskInfo)pendingTaskInfos.get(0)).getProcessInstanceid())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"3")).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')))))) {
                    doneTaskInfoList.forEach(t -> unCcIdList.add(t.getTaskId()));
                }
                if (CollectionUtil.isNotEmpty((Collection)(readTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)((UnifiedTaskInfo)pendingTaskInfos.get(0)).getProcessInstanceid())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"5")).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')))))) {
                    readTaskInfoList.forEach(t -> unCcIdList.add(t.getTaskId()));
                }
                if (CollectionUtil.isEmpty((Collection)(unReadTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)((UnifiedTaskInfo)pendingTaskInfos.get(0)).getProcessInstanceid())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"4")).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')))))) {
                    return ApiResponse.success((Object)"", null);
                }
                unReadTaskInfoList.forEach(t -> ccIdList.add(t.getTaskId()));
                List ccTaskUserList = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, ccIdList)).eq(UnifiedTaskUser::getSystemId, (Object)((UnifiedTaskInfo)taskInfos.get(0)).getSystemId()));
                List unCcTaskUserList = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, unCcIdList)).eq(UnifiedTaskUser::getSystemId, (Object)((UnifiedTaskInfo)taskInfos.get(0)).getSystemId()));
                if (CollectionUtil.isEmpty((Collection)ccTaskUserList)) {
                    return ApiResponse.success((Object)"", null);
                }
                ArrayList unCcUserIdList = CollectionUtil.isEmpty((Collection)unCcTaskUserList) ? new ArrayList() : unCcTaskUserList.stream().map(UnifiedTaskUser::getUserId).collect(Collectors.toList());
                for (UnifiedTaskInfo unReadTaskInfo : unReadTaskInfoList) {
                    logger.info("\u6d41\u7a0b\u914d\u7f6e\u7684\u6284\u9001\u6570\u636e:" + JSON.toJSONString((Object)unReadTaskInfo));
                    List partUserList = ccTaskUserList.stream().filter(c -> c.getTaskId().equals(unReadTaskInfo.getTaskId())).collect(Collectors.toList());
                    if (CollectionUtil.isEmpty(partUserList)) continue;
                    List<UnifiedTaskUser> unifiedTaskUsers = partUserList.stream().filter(p -> !unCcUserIdList.contains(p.getUserId())).collect(Collectors.toList());
                    this.pushTaskToOa(null, null, null, unReadTaskInfo, null, unifiedTaskUsers, null);
                }
            }
            if (HussarUtils.isNotEmpty(todoTaskInfos)) {
                for (UnifiedTaskInfo todoTaskInfo : todoTaskInfos) {
                    logger.info("todoTaskInfo\u9700\u5ba1\uff1a" + JSON.toJSONString((Object)todoTaskInfo));
                    partList = taskUsers.stream().filter(u -> u.getTaskId().equals(todoTaskInfo.getTaskId())).collect(Collectors.toList());
                    this.pushTaskToOa(todoTaskInfo, null, null, null, null, partList, null);
                }
            }
            if (HussarUtils.isNotEmpty(doneTaskInfos)) {
                for (UnifiedTaskInfo doneTaskInfo : doneTaskInfos) {
                    logger.info("doneTaskInfo\u5df2\u5ba1\uff1a" + JSON.toJSONString((Object)doneTaskInfo));
                    partList = taskUsers.stream().filter(u -> u.getTaskId().equals(doneTaskInfo.getTaskId())).collect(Collectors.toList());
                    this.pushTaskToOa(null, null, doneTaskInfo, null, null, partList, null);
                }
            }
            if (HussarUtils.isNotEmpty(readedTaskInfos)) {
                for (UnifiedTaskInfo readTaskInfo : readedTaskInfos) {
                    logger.info("readTaskInfo\u6284\u9001\u5df2\u8bfb\uff1a" + JSON.toJSONString((Object)readTaskInfo));
                    partList = taskUsers.stream().filter(u -> u.getTaskId().equals(readTaskInfo.getTaskId())).collect(Collectors.toList());
                    this.pushTaskToOa(null, null, null, null, readTaskInfo, partList, null);
                }
            }
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> taskAdd(TaskInfoWithUser taskInfoWithUser) {
        UnifiedTaskInfo taskInfo;
        ApiResponse isBuildSuccess = taskInfoWithUser.buildAllInfoForTaskAdd();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (HussarUtils.isNotEmpty((Object)taskInfoWithUser.getTaskInfo())) {
            if ("3".equals(taskInfoWithUser.getTaskInfo()) && this.unifiedTodoGLDProperties.isOpen()) {
                taskInfo = taskInfoWithUser.getTaskInfo();
                GlodonNodeDataDto requestBody = new GlodonNodeDataDto();
                requestBody.setFlowId(taskInfo.getProcessInstanceid());
                requestBody.setId(taskInfo.getTaskId());
                requestBody.setDeleted(Boolean.valueOf(false));
                SysUsers sysUsers = this.usersService.getUserByOutOriginId(taskInfo.getUserId());
                requestBody.setPromoterId(HussarUtils.isNull((Object)sysUsers) ? "" : sysUsers.getOutOriginId());
                requestBody.setPromoterNo(taskInfo.getAssigneeUserNumber());
                requestBody.setPromoterName(taskInfo.getAssigneeUserName());
                requestBody.setDeptName(taskInfo.getDeptName());
                requestBody.setPostName(taskInfo.getPostName());
                if (null != taskInfo.getCompleteTime()) {
                    requestBody.setApproveTime(DateUtil.format((Date)taskInfo.getCompleteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (null != taskInfo.getDeadLine()) {
                    requestBody.setDeadlineTime(DateUtil.format((Date)taskInfo.getDeadLine(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if ("1".equals(taskInfo.getTaskStatus())) {
                    requestBody.setApprovalStatus(Integer.valueOf(1));
                    requestBody.setJumpUrl(this.unifiedTodoGLDProperties.getToBe() + "%2526taskId=" + taskInfo.getTaskId());
                } else if ("3".equals(taskInfo.getTaskStatus())) {
                    requestBody.setApprovalStatus(Integer.valueOf(2));
                    requestBody.setJumpUrl(this.unifiedTodoGLDProperties.getToDoList() + "%2526processInstId=" + taskInfo.getProcessInstanceid());
                }
                this.pushGldNode(requestBody);
            }
            this.unifiedTaskInfoService.save((Object)taskInfoWithUser.getTaskInfo());
        }
        if (HussarUtils.isNotEmpty((Object)taskInfoWithUser.getTaskUsers())) {
            this.unifiedTaskUserService.saveBatch((Collection)taskInfoWithUser.getTaskUsers());
        }
        if (this.unifiedTodoProperties.getOpen()) {
            taskInfo = taskInfoWithUser.getTaskInfo();
            List taskUsers = taskInfoWithUser.getTaskUsers();
            this.pushTaskToOa(taskInfo, taskUsers, null);
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> taskAddClassify(TaskInfoWithUser taskInfoWithUser) {
        ApiResponse isBuildSuccess = taskInfoWithUser.buildAllInfoForTaskAdd();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        ArrayList<UnifiedTaskInfo> doneTaskInfos = new ArrayList<UnifiedTaskInfo>();
        ArrayList<UnifiedTaskInfo> pendingTaskInfos = new ArrayList<UnifiedTaskInfo>();
        ArrayList<UnifiedTaskInfo> readedTaskInfos = new ArrayList<UnifiedTaskInfo>();
        ArrayList<UnifiedTaskInfo> todoTaskInfos = new ArrayList<UnifiedTaskInfo>();
        ArrayList<UnifiedTaskInfo> unReadTaskInfos = new ArrayList<UnifiedTaskInfo>();
        if (HussarUtils.isNotEmpty((Object)taskInfoWithUser.getTaskUsers())) {
            String processInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)taskInfoWithUser.getTaskInfo().getProcessInstanceid()));
            this.unifiedTaskUserService.saveBatch((Collection)taskInfoWithUser.getTaskUsers());
            new UnifiedTaskInfo().buildTaskInfo(taskInfoWithUser.getTaskInfo(), (UnifiedTaskUser)taskInfoWithUser.getTaskUsers().get(0));
            if (HussarUtils.isNotEmpty((Object)processInfo)) {
                ArrayList<UnifiedTaskInfo> unifiedTaskInfos = new ArrayList<UnifiedTaskInfo>();
                unifiedTaskInfos.add(taskInfoWithUser.getTaskInfo());
                new UnifiedTaskInfo().buildTaskInfo(unifiedTaskInfos, (UnifiedProcessInfo)processInfo);
                this.unifiedTaskInfoService.saveBatch(unifiedTaskInfos);
            } else {
                this.unifiedTaskInfoService.save((Object)taskInfoWithUser.getTaskInfo());
            }
        }
        if (HussarUtils.isNotEmpty((Object)taskInfoWithUser.getTaskInfo())) {
            switch (taskInfoWithUser.getTaskInfo().getTaskStatus()) {
                case "1": {
                    todoTaskInfos.addAll(this.wrapData(taskInfoWithUser.getTaskInfo(), taskInfoWithUser.getTaskUsers()));
                    break;
                }
                case "2": {
                    pendingTaskInfos.addAll(this.wrapData(taskInfoWithUser.getTaskInfo(), taskInfoWithUser.getTaskUsers()));
                    break;
                }
                case "4": {
                    unReadTaskInfos.addAll(this.wrapData(taskInfoWithUser.getTaskInfo(), taskInfoWithUser.getTaskUsers()));
                    break;
                }
                case "5": {
                    readedTaskInfos.addAll(this.wrapData(taskInfoWithUser.getTaskInfo(), taskInfoWithUser.getTaskUsers()));
                    break;
                }
                default: {
                    doneTaskInfos.addAll(this.wrapData(taskInfoWithUser.getTaskInfo(), taskInfoWithUser.getTaskUsers()));
                }
            }
        }
        if (this.unifiedTodoProperties.getOpen()) {
            List taskUsers = taskInfoWithUser.getTaskUsers();
            switch (taskInfoWithUser.getTaskInfo().getTaskStatus()) {
                case "1": {
                    this.pushTaskToOa(CollectionUtil.isEmpty(todoTaskInfos) ? null : (UnifiedTaskInfo)todoTaskInfos.get(0), null, null, null, null, taskUsers, null);
                    break;
                }
                case "2": {
                    this.pushTaskToOa(null, CollectionUtil.isEmpty(pendingTaskInfos) ? null : (UnifiedTaskInfo)pendingTaskInfos.get(0), null, null, null, taskUsers, null);
                    break;
                }
                case "4": {
                    this.pushTaskToOa(null, null, null, CollectionUtil.isEmpty(unReadTaskInfos) ? null : (UnifiedTaskInfo)unReadTaskInfos.get(0), null, taskUsers, null);
                    break;
                }
                case "5": {
                    this.pushTaskToOa(null, null, null, null, CollectionUtil.isEmpty(readedTaskInfos) ? null : (UnifiedTaskInfo)readedTaskInfos.get(0), taskUsers, null);
                    break;
                }
                default: {
                    this.pushTaskToOa(null, null, CollectionUtil.isEmpty(doneTaskInfos) ? null : (UnifiedTaskInfo)doneTaskInfos.get(0), null, null, taskUsers, null);
                }
            }
        }
        return ApiResponse.success((Object)"", null);
    }

    private void pushTaskToOa(UnifiedTaskInfo todoTaskInfo, UnifiedTaskInfo pendingTaskInfo, UnifiedTaskInfo doneTaskInfo, UnifiedTaskInfo unReadTaskInfo, UnifiedTaskInfo readTaskInfo, List<UnifiedTaskUser> taskUsers, UnifiedProcessInfo unifiedProcessInfo) {
        if (CollectionUtil.isEmpty(taskUsers)) {
            return;
        }
        if (ObjectUtil.isNotNull((Object)todoTaskInfo)) {
            logger.info("\u9700\u5ba1todoTaskInfo:" + JSON.toJSONString((Object)todoTaskInfo));
            this.pushOfContent(todoTaskInfo.getProcessInstanceid(), todoTaskInfo.getTaskId(), todoTaskInfo.getStartUserId(), todoTaskInfo.getTaskName(), todoTaskInfo.getMobileLinkurl(), todoTaskInfo.getTaskStatus(), todoTaskInfo.getCreateTime(), taskUsers, unifiedProcessInfo);
            return;
        }
        if (ObjectUtil.isNotNull((Object)pendingTaskInfo)) {
            logger.info("\u5f85\u5ba1pendingTaskInfo:" + JSON.toJSONString((Object)pendingTaskInfo));
            this.pushOfContent(pendingTaskInfo.getProcessInstanceid(), pendingTaskInfo.getTaskId(), pendingTaskInfo.getStartUserId(), pendingTaskInfo.getTaskName(), pendingTaskInfo.getMobileLinkurl(), pendingTaskInfo.getTaskStatus(), pendingTaskInfo.getCreateTime(), taskUsers, unifiedProcessInfo);
            return;
        }
        if (ObjectUtil.isNotNull((Object)doneTaskInfo)) {
            logger.info("\u5df2\u5ba1doneTaskInfo:" + JSON.toJSONString((Object)doneTaskInfo));
            this.pushOfContent(doneTaskInfo.getProcessInstanceid(), doneTaskInfo.getTaskId(), doneTaskInfo.getStartUserId(), doneTaskInfo.getTaskName(), doneTaskInfo.getMobileLinkurl(), doneTaskInfo.getTaskStatus(), doneTaskInfo.getCreateTime(), taskUsers, unifiedProcessInfo);
            return;
        }
        if (ObjectUtil.isNotNull((Object)unReadTaskInfo)) {
            logger.info("\u672a\u8bfbunReadTaskInfo:" + JSON.toJSONString((Object)unReadTaskInfo));
            this.pushOfContent(unReadTaskInfo.getProcessInstanceid(), unReadTaskInfo.getTaskId(), unReadTaskInfo.getStartUserId(), unReadTaskInfo.getTaskName(), unReadTaskInfo.getMobileLinkurl(), unReadTaskInfo.getTaskStatus(), unReadTaskInfo.getCreateTime(), taskUsers, unifiedProcessInfo);
            return;
        }
        if (ObjectUtil.isNotNull((Object)readTaskInfo)) {
            logger.info("\u5df2\u8bfbreadTaskInfo:" + JSON.toJSONString((Object)readTaskInfo));
            this.pushOfContent(readTaskInfo.getProcessInstanceid(), readTaskInfo.getTaskId(), readTaskInfo.getStartUserId(), readTaskInfo.getTaskName(), readTaskInfo.getMobileLinkurl(), readTaskInfo.getTaskStatus(), readTaskInfo.getCreateTime(), taskUsers, unifiedProcessInfo);
        }
    }

    private void pushOfContent(String processInstanceId, String taskId, String createUserId, String taskName, String mobileLinkUrl, String taskStatus, Date createTime, List<UnifiedTaskUser> taskUsers, UnifiedProcessInfo unifiedProcessInfo) {
        for (UnifiedTaskUser taskUser : taskUsers) {
            logger.info("taskUser:" + JSON.toJSONString((Object)taskUser));
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            UnifiedProcessInfo processInfo = !HussarUtils.isNull((Object)unifiedProcessInfo) ? unifiedProcessInfo : (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)processInstanceId));
            if (HussarUtils.isNull((Object)processInfo)) {
                return;
            }
            String sendUserString = processInfo.getStartUserId();
            Object sendUser = null;
            Object receiver = null;
            if (HussarUtils.isNull(sendUser) || HussarUtils.isNull(receiver)) {
                this.HandlerLog(sendUserString, createUserId);
                return;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("syscode", this.unifiedTodoProperties.getOaThirdCode());
            data.put("flowid", processInstanceId);
            data.put("requestname", processInfo.getProcessName());
            data.put("workflowname", processInfo.getProcessName());
            data.put("nodename", taskName);
            data.put("appurl", mobileLinkUrl);
            String flowState = this.getFlowState(processInfo, data, processInstanceId, taskId, taskStatus);
            if (HussarUtils.isNull((Object)flowState)) {
                return;
            }
            data.put("isremark", flowState);
            data.put("viewtype", this.getReadState(taskStatus));
            data.put("creator", sendUser.getUserAccount());
            data.put("createdatetime", HussarUtils.isNull((Object)processInfo.getStartTime()) ? sf.format(DateUtil.now()) : sf.format(processInfo.getStartTime()));
            data.put("receiver", receiver.getUserAccount());
            data.put("receivedatetime", HussarUtils.isNull((Object)createTime) ? sf.format(DateUtil.now()) : sf.format(createTime));
            data.put("receivets", String.valueOf(System.currentTimeMillis()));
            try {
                String resultData = JSON.toJSONString(data);
                logger.info("requestParam:" + resultData);
                String resp = HttpClientUtil.httpPost(this.unifiedTodoProperties.getReceiveDataUrl(), resultData, null);
                logger.info("responseParam:" + resp);
                JSONObject jsonObject = JSON.parseObject((String)resp);
                if (!jsonObject.get((Object)"operResult").equals("0")) continue;
                this.HandlerLog(sendUserString, createUserId);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.HandlerLog(sendUserString, createUserId);
            }
        }
    }

    private void pushTaskToOa(UnifiedTaskInfo taskInfo, List<UnifiedTaskUser> taskUsers, UnifiedProcessInfo unifiedProcessInfo) {
        if (CollectionUtil.isEmpty(taskUsers)) {
            return;
        }
        logger.info("taskInfo:" + JSON.toJSONString((Object)taskInfo));
        for (UnifiedTaskUser taskUser : taskUsers) {
            logger.info("taskUser:" + JSON.toJSONString((Object)taskUser));
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            UnifiedProcessInfo processInfo = !HussarUtils.isNull((Object)unifiedProcessInfo) ? unifiedProcessInfo : (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)taskInfo.getProcessInstanceid()));
            if (HussarUtils.isNull((Object)processInfo)) {
                return;
            }
            String sendUserString = processInfo.getStartUserId();
            SysUsers sendUser = this.usersService.getUserByOutOriginId(sendUserString);
            SysUsers receiver = this.usersService.getUserByOutOriginId(taskUser.getUserId());
            if (HussarUtils.isNull((Object)sendUser) || HussarUtils.isNull((Object)receiver)) {
                this.HandlerLog(sendUserString, taskInfo.getStartUserName());
                return;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("syscode", this.unifiedTodoProperties.getOaThirdCode());
            data.put("flowid", taskInfo.getProcessInstanceid());
            data.put("requestname", processInfo.getProcessName());
            data.put("workflowname", processInfo.getProcessName());
            data.put("nodename", taskInfo.getTaskName());
            data.put("appurl", taskInfo.getMobileLinkurl());
            data.put("comment", taskInfo.getComment());
            String flowState = this.getFlowState(processInfo, data, taskInfo);
            if (HussarUtils.isNull((Object)flowState)) {
                return;
            }
            data.put("isremark", flowState);
            data.put("viewtype", this.getReadState(taskInfo.getTaskStatus()));
            data.put("creator", sendUser.getUserAccount());
            data.put("createdatetime", HussarUtils.isNull((Object)processInfo.getStartTime()) ? sf.format(DateUtil.now()) : sf.format(processInfo.getStartTime()));
            data.put("receiver", receiver.getUserAccount());
            data.put("receivedatetime", HussarUtils.isNull((Object)taskInfo.getCreateTime()) ? sf.format(DateUtil.now()) : sf.format(taskInfo.getCreateTime()));
            data.put("receivets", String.valueOf(System.currentTimeMillis()));
            try {
                String resultData = JSON.toJSONString(data);
                logger.info("requestParam:" + resultData);
                String resp = HttpClientUtil.httpPost(this.unifiedTodoProperties.getReceiveDataUrl(), resultData, null);
                logger.info("responseParam:" + resp);
                JSONObject jsonObject = JSON.parseObject((String)resp);
                if (!jsonObject.get((Object)"operResult").equals("0")) continue;
                this.HandlerLog(sendUserString, taskInfo.getStartUserName());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.HandlerLog(sendUserString, taskInfo.getStartUserName());
            }
        }
    }

    private void HandlerLog(String userId, String userName) {
        UserDetails userDetails = new UserDetails();
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName(MODULE_NAME);
        auditLogModel.setEventGrade(AuditEventGrade.SERVICE_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.EXCEPTION);
        auditLogModel.setEventDesc("\u7528\u6237\u8bbf\u95eeOA-\u6570\u636e\u63a8\u9001");
        userDetails.setUserIdStr(userId);
        userDetails.setUserName(userName);
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
    }

    private String getFlowState(UnifiedProcessInfo processInfo, Map<String, Object> data, String processInstanceId, String taskId, String taskStatus) {
        if ("1".equals(taskStatus)) {
            data.put("pcurl", this.unifiedTodoProperties.getToBe() + "%2526taskId=" + taskId);
            logger.info("pcurl:" + data.get("pcurl"));
            return "0";
        }
        if ("3".equals(taskStatus) && ProcessState.RUNNING.getValue().equals(processInfo.getProcessState()) || "5".equals(taskStatus)) {
            data.put("pcurl", this.unifiedTodoProperties.getToDoList() + "%2526processInstId=" + processInstanceId);
            logger.info("pcurl:" + data.get("pcurl"));
            return "2";
        }
        if ("3".equals(taskStatus)) {
            data.put("pcurl", this.unifiedTodoProperties.getToDoList() + "%2526processInstId=" + processInstanceId);
            logger.info("pcurl:" + data.get("pcurl"));
            return "4";
        }
        if ("4".equals(taskStatus)) {
            data.put("pcurl", this.unifiedTodoProperties.getToUnRead() + "%2526taskId=" + taskId);
            logger.info("pcurl:" + data.get("pcurl"));
            return "8";
        }
        return null;
    }

    private String getFlowState(UnifiedProcessInfo processInfo, Map<String, Object> data, UnifiedTaskInfo taskInfo) {
        if ("1".equals(taskInfo.getTaskStatus())) {
            data.put("pcurl", this.unifiedTodoProperties.getToBe() + "%2526taskId=" + taskInfo.getTaskId());
            logger.info("pcurl:" + data.get("pcurl"));
            return "0";
        }
        if ("3".equals(taskInfo.getTaskStatus()) && ProcessState.RUNNING.getValue().equals(processInfo.getProcessState()) || "5".equals(taskInfo.getTaskStatus())) {
            data.put("pcurl", this.unifiedTodoProperties.getToDoList() + "%2526processInstId=" + taskInfo.getProcessInstanceid());
            logger.info("pcurl:" + data.get("pcurl"));
            return "2";
        }
        if ("3".equals(taskInfo.getTaskStatus())) {
            data.put("pcurl", this.unifiedTodoProperties.getToDoList() + "%2526processInstId=" + taskInfo.getProcessInstanceid());
            logger.info("pcurl:" + data.get("pcurl"));
            return "4";
        }
        if ("4".equals(taskInfo.getTaskStatus())) {
            data.put("pcurl", this.unifiedTodoProperties.getToUnRead() + "%2526taskId=" + taskInfo.getTaskId());
            logger.info("pcurl:" + data.get("pcurl"));
            return "8";
        }
        return null;
    }

    private String getReadState(String readState) {
        if ("4".equals(readState)) {
            return "0";
        }
        if ("5".equals(readState)) {
            return "1";
        }
        return "0";
    }

    public ApiResponse<String> taskDelete(TaskDeleteDto taskDeleteDto) {
        List taskInfos;
        ApiResponse isBuildSuccess = taskDeleteDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        LambdaQueryWrapper unifiedTaskInfoQuery = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)taskDeleteDto.getProcInstId()), UnifiedTaskInfo::getProcessInstanceid, (Object)taskDeleteDto.getProcInstId())).in(HussarUtils.isNotEmpty((Object)taskDeleteDto.getTaskIds()), UnifiedTaskInfo::getTaskId, (Collection)taskDeleteDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)taskDeleteDto.getTaskTypes()), UnifiedTaskInfo::getTaskStatus, (Collection)taskDeleteDto.getTaskTypes())).eq(UnifiedTaskInfo::getSystemId, (Object)taskDeleteDto.getSystemId());
        if (taskDeleteDto.isCascade() && !(taskInfos = this.unifiedTaskInfoService.list((Wrapper)unifiedTaskInfoQuery)).isEmpty()) {
            if (this.unifiedTodoGLDProperties.isOpen()) {
                List<UnifiedTaskInfo> unifiedDoneTaskInfos = taskInfos.stream().filter(taskInfo -> "3".equals(taskInfo.getTaskStatus())).collect(Collectors.toList());
                List<UnifiedTaskInfo> unifiedTodoTaskInfos = taskInfos.stream().filter(taskInfo -> "1".equals(taskInfo.getTaskStatus())).collect(Collectors.toList());
                unifiedDoneTaskInfos.forEach(unifiedTaskInfo -> {
                    GlodonNodeDataDto nodeData = new GlodonNodeDataDto();
                    nodeData.setFlowId(unifiedTaskInfo.getProcessInstanceid());
                    nodeData.setId(unifiedTaskInfo.getTaskId());
                    nodeData.setDeleted(Boolean.valueOf(true));
                    SysUsers sysUsers = this.usersService.getUserByOutOriginId(unifiedTaskInfo.getUserId());
                    nodeData.setPromoterId(HussarUtils.isNull((Object)sysUsers) ? "" : sysUsers.getOutOriginId());
                    nodeData.setPromoterNo(unifiedTaskInfo.getAssigneeUserNumber());
                    nodeData.setPromoterName(unifiedTaskInfo.getAssigneeUserName());
                    nodeData.setDeptName(unifiedTaskInfo.getDeptName());
                    nodeData.setPostName(unifiedTaskInfo.getPostName());
                    nodeData.setComment(unifiedTaskInfo.getComment());
                    this.pushGldNode(nodeData);
                });
                unifiedTodoTaskInfos.forEach(unifiedTaskInfo -> {
                    GlodonNodeDataDto nodeData = new GlodonNodeDataDto();
                    nodeData.setFlowId(unifiedTaskInfo.getProcessInstanceid());
                    nodeData.setId(unifiedTaskInfo.getTaskId());
                    nodeData.setDeleted(Boolean.valueOf(true));
                    SysUsers sysUsers = this.usersService.getUserByOutOriginId(unifiedTaskInfo.getUserId());
                    nodeData.setPromoterId(HussarUtils.isNull((Object)sysUsers) ? "" : sysUsers.getOutOriginId());
                    nodeData.setPromoterNo(unifiedTaskInfo.getAssigneeUserNumber());
                    nodeData.setPromoterName(unifiedTaskInfo.getAssigneeUserName());
                    nodeData.setDeptName(unifiedTaskInfo.getDeptName());
                    nodeData.setPostName(unifiedTaskInfo.getPostName());
                    nodeData.setComment(unifiedTaskInfo.getComment());
                    this.pushGldNode(nodeData);
                });
            }
            this.unifiedTaskUserService.remove((Wrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, (Collection)taskInfos.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toSet())));
        }
        this.unifiedTaskInfoService.remove((Wrapper)unifiedTaskInfoQuery);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> taskDeleteClassify(TaskDeleteDto taskDeleteDto) {
        LambdaQueryWrapper unifiedTodoTaskInfoQuery;
        List taskInfos;
        List taskInfos2;
        ApiResponse isBuildSuccess = taskDeleteDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        LambdaQueryWrapper unifiedTaskInfoQuery = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)taskDeleteDto.getProcInstId()), UnifiedTaskInfo::getProcessInstanceid, (Object)taskDeleteDto.getProcInstId())).in(HussarUtils.isNotEmpty((Object)taskDeleteDto.getTaskIds()), UnifiedTaskInfo::getTaskId, (Collection)taskDeleteDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)taskDeleteDto.getTaskTypes()), UnifiedTaskInfo::getTaskStatus, (Collection)taskDeleteDto.getTaskTypes())).eq(UnifiedTaskInfo::getSystemId, (Object)taskDeleteDto.getSystemId());
        if (taskDeleteDto.isCascade() && !(taskInfos2 = this.unifiedTaskInfoService.list((Wrapper)unifiedTaskInfoQuery)).isEmpty()) {
            this.unifiedTaskUserService.remove((Wrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, (Collection)taskInfos2.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toSet())));
        }
        if (this.unifiedTodoProperties.getOpen() && HussarUtils.isNotEmpty((Object)(taskInfos = this.unifiedTaskInfoService.list((Wrapper)(unifiedTodoTaskInfoQuery = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)taskDeleteDto.getProcInstId()), UnifiedTaskInfo::getProcessInstanceid, (Object)taskDeleteDto.getProcInstId())).in(HussarUtils.isNotEmpty((Object)taskDeleteDto.getTaskIds()), UnifiedTaskInfo::getTaskId, (Collection)taskDeleteDto.getTaskIds())).eq(UnifiedTaskInfo::getSystemId, (Object)taskDeleteDto.getSystemId())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1")).eq(UnifiedTaskInfo::getProcessState, (Object)Character.valueOf('0'))).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0'))))))) {
            logger.info("\u8fd4\u56de\u6574\u6539/\u505c\u6b62\u6d41\u7a0b \u5c06\u6d41\u7a0b\u6240\u6709\u9700\u5ba1\u53d8\u6210\u5df2\u529e");
            for (UnifiedTaskInfo taskInfo : taskInfos) {
                logger.info("taskInfo\uff1a" + JSON.toJSONString((Object)taskInfo));
                List todoTaskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)taskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)taskInfo.getSystemId()));
                taskInfo.setTaskStatus("3");
                this.pushTaskToOa(taskInfo, null, null, null, null, todoTaskUsers, null);
            }
        }
        this.unifiedTaskInfoService.remove((Wrapper)unifiedTaskInfoQuery);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> taskUpdate(TaskUpdateDto taskUpdateDto) {
        ApiResponse isBuildSuccess = taskUpdateDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        String taskId = taskUpdateDto.getTaskId();
        if (taskUpdateDto.getUpdateCompleteTime() != null) {
            this.unifiedTaskUserService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getSystemId, (Object)taskUpdateDto.getSystemId())).set(UnifiedTaskUser::getCompleteTime, (Object)taskUpdateDto.getUpdateCompleteTime()));
        }
        if (!HussarUtils.isAllEmpty((Object[])new Object[]{taskUpdateDto.getUpdateTaskType(), taskUpdateDto.getUpdateDeadLine()})) {
            if ("3".equals(taskUpdateDto.getUpdateTaskType())) {
                List unifiedDoneTaskInfos = this.unifiedTaskInfoService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)taskId)).eq(UnifiedTaskInfo::getSystemId, (Object)taskUpdateDto.getSystemId()));
                unifiedDoneTaskInfos.forEach(unifiedTaskInfo -> {
                    if (this.unifiedTodoGLDProperties.isOpen()) {
                        GlodonNodeDataDto nodeDataDto = new GlodonNodeDataDto();
                        nodeDataDto.setFlowId(unifiedTaskInfo.getProcessInstanceid());
                        nodeDataDto.setId(unifiedTaskInfo.getTaskId());
                        nodeDataDto.setDeleted(Boolean.valueOf(false));
                        SysUsers sysUsers = this.usersService.getUserByOutOriginId(unifiedTaskInfo.getUserId());
                        nodeDataDto.setPromoterId(HussarUtils.isNull((Object)sysUsers) ? "" : sysUsers.getOutOriginId());
                        nodeDataDto.setPromoterNo(unifiedTaskInfo.getAssigneeUserNumber());
                        nodeDataDto.setPromoterName(unifiedTaskInfo.getAssigneeUserName());
                        nodeDataDto.setDeptName(unifiedTaskInfo.getDeptName());
                        nodeDataDto.setPostName(unifiedTaskInfo.getPostName());
                        nodeDataDto.setComment(unifiedTaskInfo.getComment());
                        nodeDataDto.setJumpUrl(this.unifiedTodoGLDProperties.getToDoList() + "%2526processInstId=" + unifiedTaskInfo.getProcessInstanceid());
                        if (null != unifiedTaskInfo.getCompleteTime()) {
                            nodeDataDto.setApproveTime(DateUtil.format((Date)unifiedTaskInfo.getCompleteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                        }
                        if (null != unifiedTaskInfo.getDeadLine()) {
                            nodeDataDto.setDeadlineTime(DateUtil.format((Date)unifiedTaskInfo.getDeadLine(), (String)"yyyy-MM-dd HH:mm:ss"));
                        }
                        nodeDataDto.setApprovalStatus(Integer.valueOf(2));
                        this.pushGldNode(nodeDataDto);
                    }
                });
            }
            this.unifiedTaskInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)taskId)).eq(UnifiedTaskInfo::getSystemId, (Object)taskUpdateDto.getSystemId())).set(HussarUtils.isNotEmpty((Object)taskUpdateDto.getUpdateTaskType()), UnifiedTaskInfo::getTaskStatus, (Object)taskUpdateDto.getUpdateTaskType())).set(HussarUtils.isNotEmpty((Object)taskUpdateDto.getUpdateDeadLine()), UnifiedTaskInfo::getDeadLine, (Object)taskUpdateDto.getUpdateDeadLine())).set(HussarUtils.isNotEmpty((Object)taskUpdateDto.getComment()), UnifiedTaskInfo::getComment, (Object)taskUpdateDto.getComment()));
        }
        if (this.unifiedTodoProperties.getOpen()) {
            List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getSystemId, (Object)taskUpdateDto.getSystemId()));
            UnifiedTaskInfo taskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)taskId));
            this.pushTaskToOa(taskInfo, taskUsers, null);
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> taskUpdateClassify(TaskUpdateDto taskUpdateDto) {
        ApiResponse isBuildSuccess = taskUpdateDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        String taskId = taskUpdateDto.getTaskId();
        if (taskUpdateDto.getUpdateCompleteTime() != null) {
            this.unifiedTaskUserService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getSystemId, (Object)taskUpdateDto.getSystemId())).set(UnifiedTaskUser::getCompleteTime, (Object)taskUpdateDto.getUpdateCompleteTime()));
        }
        if (!HussarUtils.isAllEmpty((Object[])new Object[]{taskUpdateDto.getUpdateTaskType(), taskUpdateDto.getUpdateDeadLine()})) {
            this.unifiedTaskInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)taskId)).eq(UnifiedTaskInfo::getSystemId, (Object)taskUpdateDto.getSystemId())).set(HussarUtils.isNotEmpty((Object)taskUpdateDto.getUpdateTaskType()), UnifiedTaskInfo::getTaskStatus, (Object)taskUpdateDto.getUpdateTaskType())).set(HussarUtils.isNotEmpty((Object)taskUpdateDto.getUpdateDeadLine()), UnifiedTaskInfo::getDeadLine, (Object)taskUpdateDto.getUpdateDeadLine())).set(HussarUtils.isNotEmpty((Object)taskUpdateDto.getComment()), UnifiedTaskInfo::getComment, (Object)taskUpdateDto.getComment())).set(HussarUtils.isNotEmpty((Object)taskUpdateDto.getUpdateCompleteTime()), UnifiedTaskInfo::getCompleteTime, (Object)taskUpdateDto.getUpdateCompleteTime()));
        }
        if (this.unifiedTodoProperties.getOpen()) {
            List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getSystemId, (Object)taskUpdateDto.getSystemId()));
            UnifiedTaskInfo readTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)taskId)).eq(UnifiedTaskInfo::getSystemId, (Object)taskUpdateDto.getSystemId())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"5")).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')));
            if (!ObjectUtil.isNull((Object)readTaskInfo)) {
                this.pushTaskToOa(null, null, null, null, readTaskInfo, taskUsers, null);
            } else {
                UnifiedTaskInfo doneTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)taskId)).eq(UnifiedTaskInfo::getSystemId, (Object)taskUpdateDto.getSystemId())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"3")).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')));
                this.pushTaskToOa(null, null, doneTaskInfo, null, null, taskUsers, null);
            }
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> userAddBatch(UserAddBatchDto userAddBatchDto) {
        List taskUsers;
        List taskIdList;
        List taskInfoList;
        ApiResponse isBuildSuccess = userAddBatchDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskUserService.saveBatch((Collection)userAddBatchDto.getTaskUsers());
        List taskInfos = this.unifiedTaskInfoService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)userAddBatchDto.getTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)userAddBatchDto.getSystemId()));
        ArrayList<UnifiedTaskInfo> taskInfoListAdd = new ArrayList<UnifiedTaskInfo>();
        if (HussarUtils.isNotEmpty((Object)userAddBatchDto.getTaskUsers())) {
            for (UnifiedTaskUser unifiedTaskUser : userAddBatchDto.getTaskUsers()) {
                if (!HussarUtils.isNotEmpty((Object)taskInfos)) continue;
                UnifiedTaskInfo unifiedTaskInfo = new UnifiedTaskInfo();
                BeanUtils.copyProperties(taskInfos.get(0), (Object)unifiedTaskInfo);
                if ("1".equals(unifiedTaskInfo.getTaskStatus())) {
                    unifiedTaskInfo.setDeptId(unifiedTaskUser.getDeptId());
                    unifiedTaskInfo.setDeptName(unifiedTaskUser.getDeptName());
                    unifiedTaskInfo.setUnitId(unifiedTaskUser.getUnitId());
                    unifiedTaskInfo.setUnitName(unifiedTaskUser.getUnitName());
                    unifiedTaskInfo.setPostId(unifiedTaskUser.getPostId());
                    unifiedTaskInfo.setPostName(unifiedTaskUser.getPostName());
                    unifiedTaskInfo.setUserId(unifiedTaskUser.getUserId());
                    unifiedTaskInfo.setAssigneeUserName(unifiedTaskUser.getUserName());
                    unifiedTaskInfo.setAssigneeUserNumber(unifiedTaskUser.getUserNumber());
                    unifiedTaskInfo.setAssigneeDeptId(unifiedTaskUser.getDeptId());
                    unifiedTaskInfo.setAssigneeDeptName(unifiedTaskUser.getDeptName());
                    unifiedTaskInfo.setAssigneeUnitId(unifiedTaskUser.getUnitId());
                    unifiedTaskInfo.setAssigneeUnitName(unifiedTaskUser.getUnitName());
                    unifiedTaskInfo.setAssigneeMainDeptId(unifiedTaskUser.getMainDeptId());
                    unifiedTaskInfo.setAssigneeMainDeptName(unifiedTaskUser.getMainDeptName());
                    unifiedTaskInfo.setAssigneeMainUnitId(unifiedTaskUser.getMainUnitId());
                    unifiedTaskInfo.setAssigneeMainUnitName(unifiedTaskUser.getMainUnitName());
                    unifiedTaskInfo.setCompleteTime(unifiedTaskUser.getCompleteTime());
                    if (this.unifiedTodoGLDProperties.isOpen()) {
                        GlodonNodeDataDto requestBody = new GlodonNodeDataDto();
                        requestBody.setFlowId(unifiedTaskInfo.getProcessInstanceid());
                        requestBody.setId(unifiedTaskInfo.getTaskId());
                        SysUsers sysUsers = this.usersService.getUserByOutOriginId(unifiedTaskInfo.getUserId());
                        requestBody.setPromoterId(HussarUtils.isNull((Object)sysUsers) ? "" : sysUsers.getOutOriginId());
                        requestBody.setPromoterNo(unifiedTaskInfo.getAssigneeUserNumber());
                        requestBody.setPromoterName(unifiedTaskInfo.getAssigneeUserName());
                        requestBody.setDeptName(unifiedTaskInfo.getDeptName());
                        requestBody.setPostName(unifiedTaskInfo.getPostName());
                        requestBody.setDeleted(Boolean.valueOf(false));
                        requestBody.setComment(unifiedTaskInfo.getComment());
                        requestBody.setJumpUrl(this.unifiedTodoGLDProperties.getToBe() + "%2526taskId=" + unifiedTaskInfo.getTaskId());
                        if (null != unifiedTaskInfo.getDeadLine()) {
                            requestBody.setDeadlineTime(DateUtil.format((Date)unifiedTaskInfo.getDeadLine(), (String)"yyyy-MM-dd HH:mm:ss"));
                        }
                        if (null != unifiedTaskInfo.getCompleteTime()) {
                            requestBody.setApproveTime(DateUtil.format((Date)unifiedTaskInfo.getCompleteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                        }
                        if ("1".equals(unifiedTaskInfo.getTaskStatus())) {
                            requestBody.setApprovalStatus(Integer.valueOf(1));
                            requestBody.setJumpUrl(this.unifiedTodoGLDProperties.getToBe() + "%2526taskId=" + unifiedTaskInfo.getTaskId());
                        } else if ("3".equals(unifiedTaskInfo.getTaskStatus())) {
                            requestBody.setApprovalStatus(Integer.valueOf(2));
                            requestBody.setJumpUrl(this.unifiedTodoGLDProperties.getToDoList() + "%2526processInstId=" + unifiedTaskInfo.getProcessInstanceid());
                        }
                        this.pushGldNode(requestBody);
                    }
                } else {
                    unifiedTaskInfo.setDeptId(unifiedTaskUser.getDeptId());
                    unifiedTaskInfo.setDeptName(unifiedTaskUser.getDeptName());
                    unifiedTaskInfo.setUnitId(unifiedTaskUser.getUnitId());
                    unifiedTaskInfo.setUnitName(unifiedTaskUser.getUnitName());
                    unifiedTaskInfo.setPostId(unifiedTaskUser.getPostId());
                    unifiedTaskInfo.setPostName(unifiedTaskUser.getPostName());
                    unifiedTaskInfo.setUserId(unifiedTaskUser.getUserId());
                    unifiedTaskInfo.setCompleteTime(unifiedTaskUser.getCompleteTime());
                }
                taskInfoListAdd.add(unifiedTaskInfo);
                this.unifiedTaskInfoService.saveOrUpdateBatch(taskInfoListAdd);
            }
        }
        if (this.unifiedTodoProperties.getOpen() && CollectionUtil.isNotEmpty((Collection)(taskInfoList = this.unifiedTaskInfoService.list((Wrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, taskIdList = (taskUsers = userAddBatchDto.getTaskUsers()).stream().map(UnifiedTaskUser::getTaskId).collect(Collectors.toList())))))) {
            for (UnifiedTaskInfo unifiedTaskInfo : taskInfoList) {
                List<UnifiedTaskUser> partList = taskUsers.stream().filter(t -> t.getTaskId().equals(unifiedTaskInfo.getTaskId())).collect(Collectors.toList());
                unifiedTaskInfo.setTaskStatus("1");
                this.pushTaskToOa(unifiedTaskInfo, partList, null);
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> userAddBatchClassify(UserAddBatchDto userAddBatchDto) {
        List idList;
        List taskInfoList;
        ApiResponse isBuildSuccess = userAddBatchDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        List taskUserList = userAddBatchDto.getTaskUsers();
        if (HussarUtils.isNotEmpty((Object)taskUserList) && HussarUtils.isNotEmpty((Object)(taskInfoList = this.unifiedTaskInfoService.list((Wrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, idList = taskUserList.stream().map(UnifiedTaskUser::getTaskId).collect(Collectors.toList())))))) {
            for (Object unifiedTaskInfo : taskInfoList) {
                for (UnifiedTaskUser taskUser : taskUserList) {
                    if (!unifiedTaskInfo.getTaskId().equals(taskUser.getTaskId())) continue;
                    unifiedTaskInfo = unifiedTaskInfo.buildTaskInfo((UnifiedTaskInfo)unifiedTaskInfo, taskUser);
                }
            }
            this.unifiedTaskInfoService.updateBatchById((Collection)taskInfoList);
        }
        this.unifiedTaskUserService.saveBatch((Collection)taskUserList);
        if (this.unifiedTodoProperties.getOpen()) {
            List readTaskInfoList;
            List unReadTaskInfoList;
            List doneTaskInfoList;
            List pendingTaskInfoList;
            List taskUsers = userAddBatchDto.getTaskUsers();
            List taskIdList = taskUsers.stream().map(UnifiedTaskUser::getTaskId).collect(Collectors.toList());
            List todoTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, taskIdList)).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1")).eq(UnifiedTaskInfo::getProcessState, (Object)Character.valueOf('0'))).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')));
            if (CollectionUtil.isNotEmpty((Collection)todoTaskInfoList)) {
                for (Object todoTaskInfo : todoTaskInfoList) {
                    List<UnifiedTaskUser> partList = taskUsers.stream().filter(arg_0 -> UnifiedTaskServiceImpl.lambda$userAddBatchClassify$35((UnifiedTaskInfo)todoTaskInfo, arg_0)).collect(Collectors.toList());
                    todoTaskInfo.setTaskStatus("1");
                    logger.info("userAddBatchClassify \u9700\u5ba1\uff1a" + JSON.toJSONString((Object)todoTaskInfo));
                    this.pushTaskToOa((UnifiedTaskInfo)todoTaskInfo, null, null, null, null, partList, null);
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)(pendingTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, taskIdList)).eq(UnifiedTaskInfo::getTaskStatus, (Object)"2")).eq(UnifiedTaskInfo::getProcessState, (Object)Character.valueOf('0'))).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')))))) {
                for (Object pendingTaskInfo : pendingTaskInfoList) {
                    List<UnifiedTaskUser> partList = taskUsers.stream().filter(arg_0 -> UnifiedTaskServiceImpl.lambda$userAddBatchClassify$36((UnifiedTaskInfo)pendingTaskInfo, arg_0)).collect(Collectors.toList());
                    pendingTaskInfo.setTaskStatus("1");
                    logger.info("userAddBatchClassify \u5f85\u5ba1\uff1a" + JSON.toJSONString((Object)pendingTaskInfo));
                    this.pushTaskToOa(null, (UnifiedTaskInfo)pendingTaskInfo, null, null, null, partList, null);
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)(doneTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, taskIdList)).eq(UnifiedTaskInfo::getTaskStatus, (Object)"3")).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')))))) {
                for (Object doneTaskInfo : doneTaskInfoList) {
                    List<UnifiedTaskUser> partList = taskUsers.stream().filter(arg_0 -> UnifiedTaskServiceImpl.lambda$userAddBatchClassify$37((UnifiedTaskInfo)doneTaskInfo, arg_0)).collect(Collectors.toList());
                    doneTaskInfo.setTaskStatus("1");
                    logger.info("userAddBatchClassify \u5df2\u5ba1\uff1a" + JSON.toJSONString((Object)doneTaskInfo));
                    this.pushTaskToOa(null, null, (UnifiedTaskInfo)doneTaskInfo, null, null, partList, null);
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)(unReadTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, taskIdList)).eq(UnifiedTaskInfo::getTaskStatus, (Object)"4")).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')))))) {
                for (UnifiedTaskInfo unReadTaskInfo : unReadTaskInfoList) {
                    List<UnifiedTaskUser> partList = taskUsers.stream().filter(t -> t.getTaskId().equals(unReadTaskInfo.getTaskId())).collect(Collectors.toList());
                    unReadTaskInfo.setTaskStatus("1");
                    logger.info("userAddBatchClassify \u672a\u8bfb\uff1a" + JSON.toJSONString((Object)unReadTaskInfo));
                    this.pushTaskToOa(null, null, null, unReadTaskInfo, null, partList, null);
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)(readTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, taskIdList)).eq(UnifiedTaskInfo::getTaskStatus, (Object)"5")).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')))))) {
                for (UnifiedTaskInfo readTaskInfo : readTaskInfoList) {
                    List<UnifiedTaskUser> partList = taskUsers.stream().filter(t -> t.getTaskId().equals(readTaskInfo.getTaskId())).collect(Collectors.toList());
                    readTaskInfo.setTaskStatus("1");
                    logger.info("userAddBatchClassify \u5df2\u8bfb\uff1a" + JSON.toJSONString((Object)readTaskInfo));
                    this.pushTaskToOa(null, null, null, null, readTaskInfo, partList, null);
                }
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> userAdd(UnifiedTaskUser unifiedTaskUser) {
        ApiResponse isBuildSuccess = unifiedTaskUser.buildAllInfoForUserAdd();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskUserService.save((Object)unifiedTaskUser);
        return ApiResponse.success();
    }

    public ApiResponse<String> userAddClassify(UnifiedTaskUser unifiedTaskUser) {
        ApiResponse isBuildSuccess = unifiedTaskUser.buildAllInfoForUserAdd();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskUserService.save((Object)unifiedTaskUser);
        return ApiResponse.success();
    }

    public ApiResponse<String> userDelete(UserDeleteDto userDeleteDto) {
        ApiResponse isBuildSuccess = userDeleteDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (this.unifiedTodoProperties.getOpen()) {
            logger.info("\u6d41\u7a0b\u5e73\u53f0\u5207\u6362\u8282\u70b9\u5ba1\u6279\u4eba\u6570\u636e\u63a8\u9001\u5f00\u59cb");
            if (CollectionUtil.isNotEmpty((Collection)userDeleteDto.getTaskIds())) {
                List unifiedTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, (Collection)userDeleteDto.getTaskIds()));
                logger.info("taskInfoSize:" + unifiedTaskInfoList.size());
                if (CollectionUtil.isNotEmpty((Collection)unifiedTaskInfoList)) {
                    UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId()));
                    if (!Objects.isNull(unifiedTaskInfo)) {
                        unifiedTaskInfoList.add(unifiedTaskInfo);
                    }
                    for (UnifiedTaskInfo taskInfo : unifiedTaskInfoList) {
                        List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)taskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)taskInfo.getSystemId()));
                        taskInfo.setTaskStatus("3");
                        this.pushTaskToOa(taskInfo, taskUsers, null);
                    }
                } else {
                    UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId()));
                    if (!Objects.isNull(unifiedTaskInfo)) {
                        List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                        unifiedTaskInfo.setTaskStatus("3");
                        this.pushTaskToOa(unifiedTaskInfo, taskUsers, null);
                    }
                }
            } else {
                UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId()));
                if (!Objects.isNull(unifiedTaskInfo)) {
                    List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                    unifiedTaskInfo.setTaskStatus("3");
                    this.pushTaskToOa(unifiedTaskInfo, taskUsers, null);
                }
            }
        }
        this.unifiedTaskUserService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskId()), UnifiedTaskUser::getTaskId, (Object)userDeleteDto.getTaskId())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskIds()), UnifiedTaskUser::getTaskId, (Collection)userDeleteDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getDeleteUserIds()), UnifiedTaskUser::getUserId, (Collection)userDeleteDto.getDeleteUserIds())).notIn(HussarUtils.isNotEmpty((Object)userDeleteDto.getReserveUserIds()), UnifiedTaskUser::getUserId, (Collection)userDeleteDto.getReserveUserIds())).eq(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskTypes()), UnifiedTaskUser::getTaskStatus, (Object)userDeleteDto.getTaskTypes()));
        return ApiResponse.success();
    }

    public ApiResponse<String> userDeleteClassify(UserDeleteDto userDeleteDto) {
        ApiResponse isBuildSuccess = userDeleteDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (this.unifiedTodoProperties.getOpen()) {
            logger.info("\u6d41\u7a0b\u5e73\u53f0\u5207\u6362\u8282\u70b9\u5ba1\u6279\u4eba\u6570\u636e\u63a8\u9001\u5f00\u59cb");
            if (CollectionUtil.isNotEmpty((Collection)userDeleteDto.getTaskIds())) {
                List unifiedTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, (Collection)userDeleteDto.getTaskIds())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1")).eq(UnifiedTaskInfo::getProcessState, (Object)Character.valueOf('0'))).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')));
                logger.info("taskInfoSize:" + unifiedTaskInfoList.size());
                if (CollectionUtil.isNotEmpty((Collection)unifiedTaskInfoList)) {
                    UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1")).eq(UnifiedTaskInfo::getProcessState, (Object)Character.valueOf('0'))).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')));
                    if (!Objects.isNull(unifiedTaskInfo)) {
                        unifiedTaskInfoList.add(unifiedTaskInfo);
                    }
                    for (UnifiedTaskInfo taskInfo : unifiedTaskInfoList) {
                        List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)taskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)taskInfo.getSystemId()));
                        taskInfo.setTaskStatus("3");
                        this.pushTaskToOa(taskInfo, null, null, null, null, taskUsers, null);
                    }
                } else {
                    UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1")).eq(UnifiedTaskInfo::getProcessState, (Object)Character.valueOf('0'))).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')));
                    if (!Objects.isNull(unifiedTaskInfo)) {
                        List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                        unifiedTaskInfo.setTaskStatus("3");
                        this.pushTaskToOa(unifiedTaskInfo, null, null, null, null, taskUsers, null);
                    }
                }
            } else {
                UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId()));
                if (!Objects.isNull(unifiedTaskInfo)) {
                    List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                    unifiedTaskInfo.setTaskStatus("3");
                    this.pushTaskToOa(unifiedTaskInfo, null, null, null, null, taskUsers, null);
                    List unifiedTodoTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(UnifiedTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId())).eq(UnifiedTaskInfo::getProcessInstanceid, (Object)unifiedTaskInfo.getProcessInstanceid())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1")).eq(UnifiedTaskInfo::getProcessState, (Object)Character.valueOf('0'))).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')));
                    if (HussarUtils.isNotEmpty((Object)unifiedTodoTaskInfoList)) {
                        logger.info("\u83b7\u53d6\u5269\u4f59\u9700\u5ba1\u6570\u636e\uff0c\u63a8\u9001\u5230oa\uff0c\u9632\u6b62\u591a\u4e2a\u8282\u70b9\u662f\u540c\u4e00\u4e2a\u4eba\u5ba1\u6279\uff0c\u4e00\u4e2a\u8282\u70b9\u5207\u6362\u5ba1\u6279\u4eba\u540e\uff0coa\u7cfb\u7edf\u91cc\u6ca1\u6709\u5f85\u529e\u6570\u636e");
                        for (UnifiedTaskInfo todoTaskInfo : unifiedTodoTaskInfoList) {
                            logger.info("todoTaskInfo\uff1a" + JSON.toJSONString((Object)todoTaskInfo));
                            List todoTaskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)todoTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)todoTaskInfo.getSystemId()));
                            this.pushTaskToOa(todoTaskInfo, null, null, null, null, todoTaskUsers, null);
                        }
                    }
                }
            }
        }
        this.unifiedTaskUserService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskId()), UnifiedTaskUser::getTaskId, (Object)userDeleteDto.getTaskId())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskIds()), UnifiedTaskUser::getTaskId, (Collection)userDeleteDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getDeleteUserIds()), UnifiedTaskUser::getUserId, (Collection)userDeleteDto.getDeleteUserIds())).notIn(HussarUtils.isNotEmpty((Object)userDeleteDto.getReserveUserIds()), UnifiedTaskUser::getUserId, (Collection)userDeleteDto.getReserveUserIds())).eq(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskTypes()), UnifiedTaskUser::getTaskStatus, (Object)userDeleteDto.getTaskTypes()));
        return ApiResponse.success();
    }

    public ApiResponse<String> userUpdate(UserUpdateDto userUpdateDto) {
        ApiResponse isBuildSuccess = userUpdateDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskUserService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getSystemId, (Object)userUpdateDto.getSystemId())).eq(UnifiedTaskUser::getTaskId, (Object)userUpdateDto.getTaskId())).eq(HussarUtils.isNotEmpty((Object)userUpdateDto.getTaskType()), UnifiedTaskUser::getTaskStatus, (Object)userUpdateDto.getTaskType())).eq(HussarUtils.isNotEmpty((Object)userUpdateDto.getUserId()), UnifiedTaskUser::getUserId, (Object)userUpdateDto.getUserId())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateUser()), UnifiedTaskUser::getUserId, (Object)userUpdateDto.getUpdateUser())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateTaskType()), UnifiedTaskUser::getTaskStatus, (Object)userUpdateDto.getUpdateTaskType())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateCompleteTime()), UnifiedTaskUser::getCompleteTime, (Object)userUpdateDto.getUpdateCompleteTime()));
        if (HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateTaskType())) {
            switch (userUpdateDto.getUpdateTaskType()) {
                case "5": {
                    List unReadList = this.unifiedTaskInfoService.list((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)userUpdateDto.getUserId())).eq(UnifiedTaskInfo::getSystemId, (Object)userUpdateDto.getSystemId())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"4"));
                    this.unifiedTaskInfoService.remove((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)userUpdateDto.getUserId())).eq(UnifiedTaskInfo::getSystemId, (Object)userUpdateDto.getSystemId())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"4"));
                    ArrayList<UnifiedTaskInfo> readedList = new ArrayList<UnifiedTaskInfo>();
                    for (UnifiedTaskInfo unifiedUnReadTaskInfo : unReadList) {
                        unifiedUnReadTaskInfo.setTaskStatus("5");
                        unifiedUnReadTaskInfo.setCompleteTime(userUpdateDto.getUpdateCompleteTime());
                        readedList.add(unifiedUnReadTaskInfo);
                    }
                    this.unifiedTaskInfoService.saveBatch(readedList);
                    break;
                }
                case "3": {
                    List todoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)userUpdateDto.getUserId())).eq(UnifiedTaskInfo::getSystemId, (Object)userUpdateDto.getSystemId())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1"));
                    this.unifiedTaskInfoService.remove((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)userUpdateDto.getUserId())).eq(UnifiedTaskInfo::getSystemId, (Object)userUpdateDto.getSystemId())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1"));
                    ArrayList<UnifiedTaskInfo> doneList = new ArrayList<UnifiedTaskInfo>();
                    Iterator iterator = todoList.iterator();
                    while (iterator.hasNext()) {
                        UnifiedTaskInfo unifiedTodoTaskInfo;
                        UnifiedTaskInfo unifiedDoneTaskInfo = unifiedTodoTaskInfo = (UnifiedTaskInfo)iterator.next();
                        unifiedDoneTaskInfo.setTaskStatus("5");
                        unifiedDoneTaskInfo.setCompleteTime(userUpdateDto.getUpdateCompleteTime());
                        if (this.unifiedTodoGLDProperties.isOpen()) {
                            GlodonNodeDataDto nodeDataDto = new GlodonNodeDataDto();
                            nodeDataDto.setFlowId(unifiedDoneTaskInfo.getProcessInstanceid());
                            nodeDataDto.setId(unifiedDoneTaskInfo.getTaskId());
                            nodeDataDto.setDeleted(Boolean.valueOf(false));
                            SysUsers sysUsers = this.usersService.getUserByOutOriginId(unifiedDoneTaskInfo.getUserId());
                            nodeDataDto.setPromoterId(HussarUtils.isNull((Object)sysUsers) ? "" : sysUsers.getOutOriginId());
                            nodeDataDto.setPromoterNo(unifiedDoneTaskInfo.getAssigneeUserNumber());
                            nodeDataDto.setPromoterName(unifiedDoneTaskInfo.getAssigneeUserName());
                            nodeDataDto.setDeptName(unifiedDoneTaskInfo.getDeptName());
                            nodeDataDto.setPostName(unifiedDoneTaskInfo.getPostName());
                            nodeDataDto.setComment(unifiedDoneTaskInfo.getComment());
                            nodeDataDto.setJumpUrl(this.unifiedTodoGLDProperties.getToDoList() + "%2526processInstId=" + unifiedDoneTaskInfo.getProcessInstanceid());
                            if (null != unifiedDoneTaskInfo.getCompleteTime()) {
                                nodeDataDto.setApproveTime(DateUtil.format((Date)unifiedDoneTaskInfo.getCompleteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                            }
                            if (null != unifiedDoneTaskInfo.getDeadLine()) {
                                nodeDataDto.setDeadlineTime(DateUtil.format((Date)unifiedDoneTaskInfo.getDeadLine(), (String)"yyyy-MM-dd HH:mm:ss"));
                            }
                            nodeDataDto.setApprovalStatus(Integer.valueOf(2));
                            this.pushGldNode(nodeDataDto);
                        }
                        doneList.add(unifiedDoneTaskInfo);
                    }
                    this.unifiedTaskInfoService.saveBatch(doneList);
                    break;
                }
            }
        } else {
            this.unifiedTaskInfoService.remove((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskInfo::getSystemId, (Object)userUpdateDto.getSystemId())).eq(UnifiedTaskInfo::getTaskId, (Object)userUpdateDto.getTaskId())).eq(HussarUtils.isNotEmpty((Object)userUpdateDto.getUserId()), UnifiedTaskInfo::getUserId, (Object)userUpdateDto.getUserId())).eq(UnifiedTaskInfo::getTaskStatus, (Object)userUpdateDto.getTaskType())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateUser()), UnifiedTaskInfo::getUserId, (Object)userUpdateDto.getUpdateUser())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateCompleteTime()), UnifiedTaskInfo::getCompleteTime, (Object)userUpdateDto.getUpdateCompleteTime()));
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> userUpdateClassify(UserUpdateDto userUpdateDto) {
        ApiResponse isBuildSuccess = userUpdateDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskUserService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getSystemId, (Object)userUpdateDto.getSystemId())).eq(UnifiedTaskUser::getTaskId, (Object)userUpdateDto.getTaskId())).eq(HussarUtils.isNotEmpty((Object)userUpdateDto.getTaskType()), UnifiedTaskUser::getTaskStatus, (Object)userUpdateDto.getTaskType())).eq(HussarUtils.isNotEmpty((Object)userUpdateDto.getUserId()), UnifiedTaskUser::getUserId, (Object)userUpdateDto.getUserId())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateUser()), UnifiedTaskUser::getUserId, (Object)userUpdateDto.getUpdateUser())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateTaskType()), UnifiedTaskUser::getTaskStatus, (Object)userUpdateDto.getUpdateTaskType())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateCompleteTime()), UnifiedTaskUser::getCompleteTime, (Object)userUpdateDto.getUpdateCompleteTime()));
        return ApiResponse.success();
    }

    public ApiResponse<String> processAdd(UnifiedProcessInfo processInfo) {
        List list;
        ApiResponse isBuildSuccess = processInfo.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedProcessInfoService.save((Object)processInfo);
        this.updateTaskProcessDetail(processInfo);
        if (this.unifiedTodoProperties.getOpen() && HussarUtils.isNotEmpty((Object)(list = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)processInfo.getProcInstId())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1"))))) {
            for (UnifiedTaskInfo unifiedTaskInfo : list) {
                List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                this.pushTaskToOa(unifiedTaskInfo, taskUsers, processInfo);
            }
        }
        if (this.unifiedTodoGLDProperties.isOpen()) {
            GlodonMainDataDto requestBody = new GlodonMainDataDto();
            SysUsers sysUsers = this.usersService.getUserByOutOriginId(processInfo.getStartUserId());
            if (!HussarUtils.isNull((Object)sysUsers)) {
                String outOriginId = this.sysStruService.getByStruId(String.valueOf(sysUsers.getDepartmentId()));
                requestBody.setPromoterId(sysUsers.getOutOriginId());
                requestBody.setProjectId(HussarUtils.isNull((Object)outOriginId) ? "" : this.getOaProjectId(outOriginId));
            } else {
                requestBody.setPromoterId("");
                requestBody.setProjectId("");
            }
            requestBody.setProjectName(processInfo.getDeptName());
            requestBody.setId(String.valueOf(processInfo.getProcInstId()));
            requestBody.setFlowName(processInfo.getProcessName());
            requestBody.setPromoterNo(processInfo.getStartUserNumber());
            requestBody.setPromoterName(processInfo.getStartUserName());
            requestBody.setDeleted(Boolean.valueOf(false));
            if (null != processInfo.getStartTime()) {
                requestBody.setPromotionTime(DateUtil.format((Date)processInfo.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            requestBody.setApprovalStatus(Integer.valueOf(processInfo.getProcessState()));
            this.pushGldMain(requestBody);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> processAddClassify(UnifiedProcessInfo processInfo) {
        List list;
        ApiResponse isBuildSuccess = processInfo.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedProcessInfoService.save((Object)processInfo);
        this.updateTaskProcessDetail(processInfo);
        if (this.unifiedTodoProperties.getOpen() && HussarUtils.isNotEmpty((Object)(list = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)processInfo.getProcInstId())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1")).eq(UnifiedTaskInfo::getProcessState, (Object)Character.valueOf('0'))).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')))))) {
            for (UnifiedTaskInfo unifiedTaskInfo : list) {
                logger.info("processAddClassify \u9700\u5ba1\uff1a" + JSON.toJSONString((Object)unifiedTaskInfo));
                List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                this.pushTaskToOa(unifiedTaskInfo, null, null, null, null, taskUsers, processInfo);
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> processUpdate(UnifiedProcessInfo processInfo) {
        ApiResponse isBuildSuccess = processInfo.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        UnifiedProcessInfo record = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)processInfo.getProcInstId()));
        this.unifiedProcessInfoService.update((Object)processInfo, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).eq(UnifiedProcessInfo::getProcInstId, (Object)processInfo.getProcInstId()));
        if (HussarUtils.isNotEmpty((Object)processInfo.getProcessState())) {
            this.pushMessageCenter(processInfo);
            if (this.unifiedTodoGLDProperties.isOpen() && null != record && this.isPushGld(processInfo, record)) {
                GlodonMainDataDto requestBody = new GlodonMainDataDto();
                SysUsers sysUsers = this.usersService.getUserByOutOriginId(processInfo.getStartUserId());
                if (!HussarUtils.isNull((Object)sysUsers)) {
                    requestBody.setPromoterId(sysUsers.getOutOriginId());
                } else {
                    requestBody.setPromoterId("");
                }
                requestBody.setId(String.valueOf(processInfo.getProcInstId()));
                requestBody.setApprovalStatus(Integer.valueOf(processInfo.getProcessState()));
                requestBody.setPromoterNo(processInfo.getStartUserNumber());
                requestBody.setPromoterName(processInfo.getStartUserName());
                requestBody.setDeleted(Boolean.valueOf(false));
                this.pushGldMain(requestBody);
            }
            switch (processInfo.getProcessState()) {
                case "3": {
                    List processInfos = this.unifiedProcessInfoService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).eq(UnifiedProcessInfo::getProcInstId, (Object)processInfo.getProcInstId()));
                    ArrayList<UnifiedProcessRectificationInfo> processRectificationInfos = new ArrayList<UnifiedProcessRectificationInfo>();
                    for (UnifiedProcessInfo unifiedProcessInfo : processInfos) {
                        UnifiedProcessRectificationInfo unifiedProcessRectificationInfo = new UnifiedProcessRectificationInfo();
                        BeanUtils.copyProperties((Object)unifiedProcessInfo, (Object)unifiedProcessRectificationInfo);
                        unifiedProcessRectificationInfo.setProcessState("3");
                        processRectificationInfos.add(unifiedProcessRectificationInfo);
                    }
                    this.iUnifiedProcessRectificationService.saveBatch(processRectificationInfos);
                    break;
                }
                case "9": {
                    UnifiedProcessRectificationInfo unifiedProcessRectificationInfo = new UnifiedProcessRectificationInfo();
                    BeanUtils.copyProperties((Object)processInfo, (Object)unifiedProcessRectificationInfo);
                    this.iUnifiedProcessRectificationService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedProcessRectificationInfo::getSystemId, (Object)processInfo.getSystemId())).eq(UnifiedProcessRectificationInfo::getProcInstId, (Object)processInfo.getProcInstId())).set(UnifiedProcessRectificationInfo::getProcessState, (Object)processInfo.getProcessState()));
                    break;
                }
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> processUpdateClassify(UnifiedProcessInfo processInfo) {
        ApiResponse isBuildSuccess = processInfo.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedProcessInfoService.update((Object)processInfo, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).eq(UnifiedProcessInfo::getProcInstId, (Object)processInfo.getProcInstId()));
        if (HussarUtils.isNotEmpty((Object)processInfo.getProcessState())) {
            this.pushMessageCenter(processInfo);
        }
        this.updateTaskProcessDetail(processInfo);
        return ApiResponse.success();
    }

    private void pushMessageCenter(UnifiedProcessInfo processInfo) {
        logger.info("\u6d41\u7a0b\u7ed3\u675f\u63a8\u9001\u6d88\u606f\u4e2d\u5fc3\u5f00\u59cb\uff0c \u6d41\u7a0b\u72b6\u6001\u4e3a{}", (Object)processInfo.getProcessState());
        if (!PROCESS_STATE.containsKey(processInfo.getProcessState())) {
            return;
        }
        try {
            HashMap<String, Object> pushParam = new HashMap<String, Object>(8);
            pushParam.put("title", "\u5ba1\u6279\u5b8c\u6210\u63d0\u9192");
            pushParam.put("content", processInfo.getProcessName() + PROCESS_STATE.get(processInfo.getProcessState()));
            pushParam.put("actions", "\u67e5\u770b\u8be6\u60c5");
            if ("524168298611613696".equals(this.systemId)) {
                StringBuffer urlMobile = new StringBuffer(this.approvalCenterMobile);
                urlMobile.append("/auditExamine?processName=").append(processInfo.getProcessName()).append("&processStartTime=").append(processInfo.getStartTime()).append("&businessId=").append(processInfo.getBusinessId()).append("&processInsId=").append(processInfo.getProcInstId()).append("&taskId=").append("&tenantCode=").append(processInfo.getTenantCode());
                StringBuffer urlPc = new StringBuffer(this.approvalCenterPc);
                urlPc.append("/#/external/toDoTask/approvalInformation?auth_token=[pm_token]&isPortal=0&appflag=xs&instanceId=").append(processInfo.getProcInstId());
                pushParam.put("urlMobile", urlMobile.toString());
                pushParam.put("urlPc", null);
            }
            pushParam.put("userAccountNew", processInfo.getStartUserNumber());
            pushParam.put("assistantId", "0028100");
            logger.info("\u63a8\u9001\u5230\u6d88\u606f\u4e2d\u5fc3mq\uff0c \u53c2\u6570\u4e3a{}", pushParam);
            UnifiedRabbitMQUtil.send(pushParam);
        }
        catch (Exception e) {
            logger.error("\u6d88\u606f\u4e2d\u5fc3\u63a8\u9001\u5931\u8d25\uff0c{}", (Object)e.getMessage());
        }
    }

    private void pushGlodon(GlodonMainDataDto requestBody) {
        try {
            HashMap headers = Maps.newHashMap();
            headers.put("Content-type", "x-www-form-urlencoded");
            headers.put("Authorization", "Bearer cn-a6039926-0346-43a6-a461-0619a39a4a42-ut");
            String response = HttpClientUtil.httpPost(this.unifiedTodoGLDProperties.getApproveRecord(), JSONObject.toJSONString((Object)requestBody), headers);
            GlodonResponse glodonResponse = (GlodonResponse)JSONObject.parseObject((String)response, GlodonResponse.class);
            if (!glodonResponse.getResult().booleanValue()) {
                logger.info("\u63a8\u9001\u5e7f\u8054\u8fbe\u5931\u8d25:{}", (Object)glodonResponse.getErrorString());
            }
        }
        catch (Exception e) {
            logger.error("\u63a8\u9001\u5e7f\u8054\u8fbe\u51fa\u9519:{}", (Object)e.getMessage());
        }
    }

    private boolean isPushGld(UnifiedProcessInfo processInfo, UnifiedProcessInfo record) {
        return !processInfo.getProcessState().equals(record.getProcessState()) && (processInfo.getProcessState().equals(ProcessState.APPROVED.getValue()) || processInfo.getProcessState().equals(ProcessState.UNAPPROVED.getValue()) || processInfo.getProcessState().equals(ProcessState.RECTIFICATION.getValue()) || processInfo.getProcessState().equals(ProcessState.SUSPEND.getValue()));
    }

    public ApiResponse<String> processDelete(ProcessDeleteDto processInfo) {
        ApiResponse<String> isBuildSuccess = processInfo.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        List procInsList = this.unifiedProcessInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).in(UnifiedProcessInfo::getProcInstId, Arrays.asList(processInfo.getProcInstId().split(","))));
        if (processInfo.isTombstone()) {
            this.unifiedProcessInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).in(UnifiedProcessInfo::getProcInstId, Arrays.asList(processInfo.getProcInstId().split(",")))).set(UnifiedProcessInfo::getDeleteFlag, (Object)"1"));
        } else {
            if (processInfo.isCascade() && !(isBuildSuccess = this.taskDelete(new TaskDeleteDto().setSystemId(processInfo.getSystemId()).setProcInstId(processInfo.getProcInstId()))).isSuccess()) {
                return isBuildSuccess;
            }
            ArrayList<UnifiedDeleteProcessInfo> deleteProcessInfoList = new ArrayList<UnifiedDeleteProcessInfo>();
            for (String procInstId : Arrays.asList(processInfo.getProcInstId().split(","))) {
                UnifiedDeleteProcessInfo deleteProcessInfo = new UnifiedDeleteProcessInfo();
                deleteProcessInfo.setProcessInstanceId(procInstId);
                deleteProcessInfoList.add(deleteProcessInfo);
            }
            this.iUnifiedDeleteProcessInfoService.saveBatch(deleteProcessInfoList);
            this.unifiedProcessInfoService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).in(UnifiedProcessInfo::getProcInstId, Arrays.asList(processInfo.getProcInstId().split(","))));
            if (this.unifiedTodoGLDProperties.isOpen()) {
                procInsList.forEach(proc -> {
                    GlodonMainDataDto mainData = new GlodonMainDataDto();
                    mainData.setId(String.valueOf(proc.getProcInstId()));
                    mainData.setDeleted(Boolean.valueOf(true));
                    mainData.setApprovalStatus(Integer.valueOf(proc.getProcessState()));
                    SysUsers sysUsers = this.usersService.getUserByOutOriginId(proc.getStartUserId());
                    if (!HussarUtils.isNull((Object)sysUsers)) {
                        mainData.setPromoterId(sysUsers.getOutOriginId());
                    } else {
                        mainData.setPromoterId("");
                    }
                    mainData.setPromoterNo(proc.getStartUserNumber());
                    mainData.setPromoterName(proc.getStartUserName());
                    this.pushGldMain(mainData);
                });
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> processDeleteClassify(ProcessDeleteDto processInfo) {
        ApiResponse<String> isBuildSuccess = processInfo.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (processInfo.isTombstone()) {
            this.unifiedProcessInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).in(UnifiedProcessInfo::getProcInstId, Arrays.asList(processInfo.getProcInstId().split(",")))).set(UnifiedProcessInfo::getDeleteFlag, (Object)"1"));
            this.unifiedTaskInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskInfo::getSystemId, (Object)processInfo.getSystemId())).in(UnifiedTaskInfo::getProcessInstanceid, Arrays.asList(processInfo.getProcInstId().split(",")))).set(UnifiedTaskInfo::getProcessDeleteFlag, (Object)"1"));
        } else {
            if (processInfo.isCascade() && !(isBuildSuccess = this.taskDeleteClassify(new TaskDeleteDto().setSystemId(processInfo.getSystemId()).setProcInstId(processInfo.getProcInstId()))).isSuccess()) {
                return isBuildSuccess;
            }
            ArrayList<UnifiedDeleteProcessInfo> deleteProcessInfoList = new ArrayList<UnifiedDeleteProcessInfo>();
            for (String procInstId : Arrays.asList(processInfo.getProcInstId().split(","))) {
                UnifiedDeleteProcessInfo deleteProcessInfo = new UnifiedDeleteProcessInfo();
                deleteProcessInfo.setProcessInstanceId(procInstId);
                deleteProcessInfoList.add(deleteProcessInfo);
            }
            this.iUnifiedDeleteProcessInfoService.saveBatch(deleteProcessInfoList);
            this.unifiedProcessInfoService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).in(UnifiedProcessInfo::getProcInstId, Arrays.asList(processInfo.getProcInstId().split(","))));
        }
        return ApiResponse.success();
    }

    private List<UnifiedTaskInfo> wrapData(UnifiedTaskInfo unifiedTaskInfo, List<UnifiedTaskUser> taskUserList) {
        ArrayList<UnifiedTaskInfo> listResult = new ArrayList<UnifiedTaskInfo>();
        UnifiedTaskInfo wrappedUnifiedTaskInfo = new UnifiedTaskInfo();
        UnifiedProcessInfo unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid()));
        wrappedUnifiedTaskInfo.setTaskId(unifiedTaskInfo.getTaskId());
        wrappedUnifiedTaskInfo.setSystemId(unifiedTaskInfo.getSystemId());
        wrappedUnifiedTaskInfo.setCreateTime(unifiedTaskInfo.getCreateTime());
        wrappedUnifiedTaskInfo.setLastTime(unifiedTaskInfo.getLastTime());
        wrappedUnifiedTaskInfo.setDeadLine(unifiedTaskInfo.getDeadLine());
        wrappedUnifiedTaskInfo.setWebLinkurl(unifiedTaskInfo.getWebLinkurl());
        wrappedUnifiedTaskInfo.setMobileLinkurl(unifiedTaskInfo.getMobileLinkurl());
        wrappedUnifiedTaskInfo.setProcessName(unifiedTaskInfo.getProcessName());
        wrappedUnifiedTaskInfo.setTaskDefinitionkey(unifiedTaskInfo.getTaskDefinitionkey());
        wrappedUnifiedTaskInfo.setTaskName(unifiedTaskInfo.getTaskName());
        wrappedUnifiedTaskInfo.setProcessInstanceid(unifiedTaskInfo.getProcessInstanceid());
        wrappedUnifiedTaskInfo.setTaskStatus(unifiedTaskInfo.getTaskStatus());
        wrappedUnifiedTaskInfo.setPreactFlag(unifiedTaskInfo.getPreactFlag());
        wrappedUnifiedTaskInfo.setWebUrlProps(unifiedTaskInfo.getWebUrlProps());
        wrappedUnifiedTaskInfo.setMobileUrlProps(unifiedTaskInfo.getMobileUrlProps());
        wrappedUnifiedTaskInfo.setComment(unifiedTaskInfo.getComment());
        if (HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) {
            wrappedUnifiedTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            wrappedUnifiedTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            wrappedUnifiedTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            wrappedUnifiedTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            wrappedUnifiedTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            wrappedUnifiedTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            wrappedUnifiedTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            wrappedUnifiedTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            wrappedUnifiedTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            wrappedUnifiedTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            wrappedUnifiedTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            wrappedUnifiedTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            wrappedUnifiedTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            wrappedUnifiedTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            wrappedUnifiedTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            wrappedUnifiedTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            wrappedUnifiedTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            wrappedUnifiedTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            wrappedUnifiedTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            wrappedUnifiedTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            wrappedUnifiedTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            wrappedUnifiedTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        if (HussarUtils.isNotEmpty(taskUserList)) {
            for (UnifiedTaskUser unifiedTaskUser : taskUserList) {
                UnifiedTaskInfo wrappedUnifiedTaskInfoNew = new UnifiedTaskInfo();
                BeanUtils.copyProperties((Object)wrappedUnifiedTaskInfo, (Object)wrappedUnifiedTaskInfoNew);
                wrappedUnifiedTaskInfoNew.setDeptId(unifiedTaskUser.getDeptId());
                wrappedUnifiedTaskInfoNew.setDeptName(unifiedTaskUser.getDeptName());
                wrappedUnifiedTaskInfoNew.setUnitId(unifiedTaskUser.getUnitId());
                wrappedUnifiedTaskInfoNew.setUnitName(unifiedTaskUser.getUnitName());
                wrappedUnifiedTaskInfoNew.setPostId(unifiedTaskUser.getPostId());
                wrappedUnifiedTaskInfoNew.setPostName(unifiedTaskUser.getPostName());
                wrappedUnifiedTaskInfoNew.setUserId(unifiedTaskUser.getUserId());
                wrappedUnifiedTaskInfoNew.setAssigneeUserName(unifiedTaskUser.getUserName());
                wrappedUnifiedTaskInfoNew.setAssigneeUserNumber(unifiedTaskUser.getUserNumber());
                wrappedUnifiedTaskInfoNew.setAssigneeDeptId(unifiedTaskUser.getDeptId());
                wrappedUnifiedTaskInfoNew.setAssigneeDeptName(unifiedTaskUser.getDeptName());
                wrappedUnifiedTaskInfoNew.setAssigneeUnitId(unifiedTaskUser.getUnitId());
                wrappedUnifiedTaskInfoNew.setAssigneeUnitName(unifiedTaskUser.getUnitName());
                wrappedUnifiedTaskInfoNew.setAssigneeMainDeptId(unifiedTaskUser.getMainDeptId());
                wrappedUnifiedTaskInfoNew.setAssigneeMainDeptName(unifiedTaskUser.getMainDeptName());
                wrappedUnifiedTaskInfoNew.setAssigneeMainUnitId(unifiedTaskUser.getMainUnitId());
                wrappedUnifiedTaskInfoNew.setAssigneeMainUnitName(unifiedTaskUser.getMainUnitName());
                wrappedUnifiedTaskInfoNew.setCompleteTime(unifiedTaskUser.getCompleteTime());
                listResult.add(wrappedUnifiedTaskInfoNew);
            }
        } else {
            listResult.add(wrappedUnifiedTaskInfo);
        }
        return listResult;
    }

    private List<UnifiedDoneTaskInfo> encapsulationDataDone(UnifiedTaskInfo unifiedTaskInfo, List<UnifiedTaskUser> taskUserList) {
        ArrayList<UnifiedDoneTaskInfo> listResult = new ArrayList<UnifiedDoneTaskInfo>();
        UnifiedDoneTaskInfo unifiedDoneTaskInfo = new UnifiedDoneTaskInfo();
        UnifiedProcessInfo unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid()));
        unifiedDoneTaskInfo.setTaskId(unifiedTaskInfo.getTaskId());
        unifiedDoneTaskInfo.setSystemId(unifiedTaskInfo.getSystemId());
        unifiedDoneTaskInfo.setCreateTime(unifiedTaskInfo.getCreateTime());
        unifiedDoneTaskInfo.setLastTime(unifiedTaskInfo.getLastTime());
        unifiedDoneTaskInfo.setDeadLine(unifiedTaskInfo.getDeadLine());
        unifiedDoneTaskInfo.setWebLinkurl(unifiedTaskInfo.getWebLinkurl());
        unifiedDoneTaskInfo.setMobileLinkurl(unifiedTaskInfo.getMobileLinkurl());
        unifiedDoneTaskInfo.setBusinessId(unifiedTaskInfo.getBusinessId());
        unifiedDoneTaskInfo.setProcessName(unifiedTaskInfo.getProcessName());
        unifiedDoneTaskInfo.setTaskDefinitionkey(unifiedTaskInfo.getTaskDefinitionkey());
        unifiedDoneTaskInfo.setTaskName(unifiedTaskInfo.getTaskName());
        unifiedDoneTaskInfo.setProcessInstanceid(unifiedTaskInfo.getProcessInstanceid());
        unifiedDoneTaskInfo.setTaskStatus(unifiedTaskInfo.getTaskStatus());
        unifiedDoneTaskInfo.setPreactFlag(unifiedTaskInfo.getPreactFlag());
        unifiedDoneTaskInfo.setWebUrlProps(unifiedTaskInfo.getWebUrlProps());
        unifiedDoneTaskInfo.setMobileUrlProps(unifiedTaskInfo.getMobileUrlProps());
        if (HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) {
            unifiedDoneTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedDoneTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedDoneTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedDoneTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedDoneTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedDoneTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedDoneTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedDoneTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedDoneTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedDoneTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedDoneTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedDoneTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedDoneTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedDoneTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedDoneTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedDoneTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedDoneTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedDoneTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedDoneTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedDoneTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedDoneTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedDoneTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        if (HussarUtils.isNotEmpty(taskUserList)) {
            for (UnifiedTaskUser unifiedTaskUser : taskUserList) {
                UnifiedDoneTaskInfo unifiedDoneTaskInfoNew = new UnifiedDoneTaskInfo();
                BeanUtils.copyProperties((Object)unifiedDoneTaskInfo, (Object)unifiedDoneTaskInfoNew);
                unifiedDoneTaskInfoNew.setDeptId(unifiedTaskUser.getDeptId());
                unifiedDoneTaskInfoNew.setDeptName(unifiedTaskUser.getDeptName());
                unifiedDoneTaskInfoNew.setUnitId(unifiedTaskUser.getUnitId());
                unifiedDoneTaskInfoNew.setUnitName(unifiedTaskUser.getUnitName());
                unifiedDoneTaskInfoNew.setPostId(unifiedTaskUser.getPostId());
                unifiedDoneTaskInfoNew.setPostName(unifiedTaskUser.getPostName());
                unifiedDoneTaskInfoNew.setUserId(unifiedTaskUser.getUserId());
                unifiedDoneTaskInfoNew.setAssigneeUserName(unifiedTaskUser.getUserName());
                unifiedDoneTaskInfoNew.setAssigneeUserNumber(unifiedTaskUser.getUserNumber());
                unifiedDoneTaskInfoNew.setAssigneeDeptId(unifiedTaskUser.getDeptId());
                unifiedDoneTaskInfoNew.setAssigneeDeptName(unifiedTaskUser.getDeptName());
                unifiedDoneTaskInfoNew.setAssigneeUnitId(unifiedTaskUser.getUnitId());
                unifiedDoneTaskInfoNew.setAssigneeUnitName(unifiedTaskUser.getUnitName());
                unifiedDoneTaskInfoNew.setAssigneeMainDeptId(unifiedTaskUser.getMainDeptId());
                unifiedDoneTaskInfoNew.setAssigneeMainDeptName(unifiedTaskUser.getMainDeptName());
                unifiedDoneTaskInfoNew.setAssigneeMainUnitId(unifiedTaskUser.getMainUnitId());
                unifiedDoneTaskInfoNew.setAssigneeMainUnitName(unifiedTaskUser.getMainUnitName());
                unifiedDoneTaskInfoNew.setMandators(unifiedTaskUser.getMandator());
                unifiedDoneTaskInfoNew.setUserTypes(unifiedTaskUser.getUserType());
                unifiedDoneTaskInfoNew.setCompleteTime(unifiedTaskUser.getCompleteTime());
                unifiedDoneTaskInfoNew.setUserNumber(unifiedTaskUser.getUserNumber());
                listResult.add(unifiedDoneTaskInfoNew);
            }
        } else {
            listResult.add(unifiedDoneTaskInfo);
        }
        return listResult;
    }

    private List<UnifiedPendingTaskInfo> encapsulationDataPending(UnifiedTaskInfo unifiedTaskInfo, List<UnifiedTaskUser> taskUserList) {
        ArrayList<UnifiedPendingTaskInfo> listResult = new ArrayList<UnifiedPendingTaskInfo>();
        UnifiedPendingTaskInfo unifiedPendingTaskInfo = new UnifiedPendingTaskInfo();
        UnifiedProcessInfo unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid()));
        unifiedPendingTaskInfo.setTaskId(unifiedTaskInfo.getTaskId());
        unifiedPendingTaskInfo.setSystemId(unifiedTaskInfo.getSystemId());
        unifiedPendingTaskInfo.setCreateTime(unifiedTaskInfo.getCreateTime());
        unifiedPendingTaskInfo.setLastTime(unifiedTaskInfo.getLastTime());
        unifiedPendingTaskInfo.setDeadLine(unifiedTaskInfo.getDeadLine());
        unifiedPendingTaskInfo.setWebLinkurl(unifiedTaskInfo.getWebLinkurl());
        unifiedPendingTaskInfo.setMobileLinkurl(unifiedTaskInfo.getMobileLinkurl());
        unifiedPendingTaskInfo.setBusinessId(unifiedTaskInfo.getBusinessId());
        unifiedPendingTaskInfo.setProcessName(unifiedTaskInfo.getProcessName());
        unifiedPendingTaskInfo.setTaskDefinitionkey(unifiedTaskInfo.getTaskDefinitionkey());
        unifiedPendingTaskInfo.setTaskName(unifiedTaskInfo.getTaskName());
        unifiedPendingTaskInfo.setProcessInstanceid(unifiedTaskInfo.getProcessInstanceid());
        unifiedPendingTaskInfo.setTaskStatus(unifiedTaskInfo.getTaskStatus());
        unifiedPendingTaskInfo.setPreactFlag(unifiedTaskInfo.getPreactFlag());
        unifiedPendingTaskInfo.setWebUrlProps(unifiedTaskInfo.getWebUrlProps());
        unifiedPendingTaskInfo.setMobileUrlProps(unifiedTaskInfo.getMobileUrlProps());
        if (HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) {
            unifiedPendingTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedPendingTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedPendingTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedPendingTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedPendingTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedPendingTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedPendingTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedPendingTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedPendingTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedPendingTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedPendingTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedPendingTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedPendingTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedPendingTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedPendingTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedPendingTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedPendingTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedPendingTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedPendingTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedPendingTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedPendingTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedPendingTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        if (HussarUtils.isNotEmpty(taskUserList)) {
            for (UnifiedTaskUser unifiedTaskUser : taskUserList) {
                UnifiedPendingTaskInfo unifiedPendingTaskInfoNew = new UnifiedPendingTaskInfo();
                BeanUtils.copyProperties((Object)unifiedPendingTaskInfo, (Object)unifiedPendingTaskInfoNew);
                unifiedPendingTaskInfoNew.setDeptId(unifiedTaskUser.getDeptId());
                unifiedPendingTaskInfoNew.setDeptName(unifiedTaskUser.getDeptName());
                unifiedPendingTaskInfoNew.setUnitId(unifiedTaskUser.getUnitId());
                unifiedPendingTaskInfoNew.setUnitName(unifiedTaskUser.getUnitName());
                unifiedPendingTaskInfoNew.setPostId(unifiedTaskUser.getPostId());
                unifiedPendingTaskInfoNew.setPostName(unifiedTaskUser.getPostName());
                unifiedPendingTaskInfoNew.setUserId(unifiedTaskUser.getUserId());
                unifiedPendingTaskInfoNew.setMandators(unifiedTaskUser.getMandator());
                unifiedPendingTaskInfoNew.setUserTypes(unifiedTaskUser.getUserType());
                unifiedPendingTaskInfoNew.setCompleteTime(unifiedTaskUser.getCompleteTime());
                unifiedPendingTaskInfoNew.setUserNumber(unifiedTaskUser.getUserNumber());
                listResult.add(unifiedPendingTaskInfoNew);
            }
        } else {
            listResult.add(unifiedPendingTaskInfo);
        }
        return listResult;
    }

    private List<UnifiedReadedTaskInfo> encapsulationDataRead(UnifiedTaskInfo unifiedTaskInfo, List<UnifiedTaskUser> taskUserList) {
        ArrayList<UnifiedReadedTaskInfo> listResult = new ArrayList<UnifiedReadedTaskInfo>();
        UnifiedReadedTaskInfo unifiedReadedTaskInfo = new UnifiedReadedTaskInfo();
        UnifiedProcessInfo unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid()));
        unifiedReadedTaskInfo.setTaskId(unifiedTaskInfo.getTaskId());
        unifiedReadedTaskInfo.setSystemId(unifiedTaskInfo.getSystemId());
        unifiedReadedTaskInfo.setCreateTime(unifiedTaskInfo.getCreateTime());
        unifiedReadedTaskInfo.setLastTime(unifiedTaskInfo.getLastTime());
        unifiedReadedTaskInfo.setDeadLine(unifiedTaskInfo.getDeadLine());
        unifiedReadedTaskInfo.setWebLinkurl(unifiedTaskInfo.getWebLinkurl());
        unifiedReadedTaskInfo.setMobileLinkurl(unifiedTaskInfo.getMobileLinkurl());
        unifiedReadedTaskInfo.setBusinessId(unifiedTaskInfo.getBusinessId());
        unifiedReadedTaskInfo.setProcessName(unifiedTaskInfo.getProcessName());
        unifiedReadedTaskInfo.setTaskDefinitionkey(unifiedTaskInfo.getTaskDefinitionkey());
        unifiedReadedTaskInfo.setTaskName(unifiedTaskInfo.getTaskName());
        unifiedReadedTaskInfo.setProcessInstanceid(unifiedTaskInfo.getProcessInstanceid());
        unifiedReadedTaskInfo.setTaskStatus(unifiedTaskInfo.getTaskStatus());
        unifiedReadedTaskInfo.setPreactFlag(unifiedTaskInfo.getPreactFlag());
        unifiedReadedTaskInfo.setWebUrlProps(unifiedTaskInfo.getWebUrlProps());
        unifiedReadedTaskInfo.setMobileUrlProps(unifiedTaskInfo.getMobileUrlProps());
        if (HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) {
            unifiedReadedTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedReadedTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedReadedTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedReadedTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedReadedTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedReadedTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedReadedTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedReadedTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedReadedTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedReadedTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedReadedTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedReadedTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedReadedTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedReadedTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedReadedTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedReadedTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedReadedTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedReadedTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedReadedTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedReadedTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedReadedTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedReadedTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        if (HussarUtils.isNotEmpty(taskUserList)) {
            for (UnifiedTaskUser unifiedTaskUser : taskUserList) {
                UnifiedReadedTaskInfo unifiedReadedTaskInfoNew = new UnifiedReadedTaskInfo();
                BeanUtils.copyProperties((Object)unifiedReadedTaskInfo, (Object)unifiedReadedTaskInfoNew);
                unifiedReadedTaskInfoNew.setDeptId(unifiedTaskUser.getDeptId());
                unifiedReadedTaskInfoNew.setDeptName(unifiedTaskUser.getDeptName());
                unifiedReadedTaskInfoNew.setUnitId(unifiedTaskUser.getUnitId());
                unifiedReadedTaskInfoNew.setUnitName(unifiedTaskUser.getUnitName());
                unifiedReadedTaskInfoNew.setPostId(unifiedTaskUser.getPostId());
                unifiedReadedTaskInfoNew.setPostName(unifiedTaskUser.getPostName());
                unifiedReadedTaskInfoNew.setUserId(unifiedTaskUser.getUserId());
                unifiedReadedTaskInfoNew.setMandators(unifiedTaskUser.getMandator());
                unifiedReadedTaskInfoNew.setUserTypes(unifiedTaskUser.getUserType());
                unifiedReadedTaskInfoNew.setCompleteTime(unifiedTaskUser.getCompleteTime());
                unifiedReadedTaskInfoNew.setUserNumber(unifiedTaskUser.getUserNumber());
                listResult.add(unifiedReadedTaskInfoNew);
            }
        } else {
            listResult.add(unifiedReadedTaskInfo);
        }
        return listResult;
    }

    private List<UnifiedTodoTaskInfo> encapsulationDataTodo(UnifiedTaskInfo unifiedTaskInfo, List<UnifiedTaskUser> taskUserList) {
        ArrayList<UnifiedTodoTaskInfo> listResult = new ArrayList<UnifiedTodoTaskInfo>();
        UnifiedTodoTaskInfo unifiedTodoTaskInfo = new UnifiedTodoTaskInfo();
        UnifiedProcessInfo unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid()));
        unifiedTodoTaskInfo.setTaskId(unifiedTaskInfo.getTaskId());
        unifiedTodoTaskInfo.setSystemId(unifiedTaskInfo.getSystemId());
        unifiedTodoTaskInfo.setCreateTime(unifiedTaskInfo.getCreateTime());
        unifiedTodoTaskInfo.setLastTime(unifiedTaskInfo.getLastTime());
        unifiedTodoTaskInfo.setDeadLine(unifiedTaskInfo.getDeadLine());
        unifiedTodoTaskInfo.setWebLinkurl(unifiedTaskInfo.getWebLinkurl());
        unifiedTodoTaskInfo.setMobileLinkurl(unifiedTaskInfo.getMobileLinkurl());
        unifiedTodoTaskInfo.setProcessName(unifiedTaskInfo.getProcessName());
        unifiedTodoTaskInfo.setTaskDefinitionkey(unifiedTaskInfo.getTaskDefinitionkey());
        unifiedTodoTaskInfo.setTaskName(unifiedTaskInfo.getTaskName());
        unifiedTodoTaskInfo.setProcessInstanceid(unifiedTaskInfo.getProcessInstanceid());
        unifiedTodoTaskInfo.setTaskStatus(unifiedTaskInfo.getTaskStatus());
        unifiedTodoTaskInfo.setPreactFlag(unifiedTaskInfo.getPreactFlag());
        unifiedTodoTaskInfo.setWebUrlProps(unifiedTaskInfo.getWebUrlProps());
        unifiedTodoTaskInfo.setMobileUrlProps(unifiedTaskInfo.getMobileUrlProps());
        if (HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) {
            unifiedTodoTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedTodoTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedTodoTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedTodoTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedTodoTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedTodoTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedTodoTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedTodoTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedTodoTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedTodoTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedTodoTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedTodoTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedTodoTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedTodoTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedTodoTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedTodoTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedTodoTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedTodoTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedTodoTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedTodoTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedTodoTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedTodoTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        if (HussarUtils.isNotEmpty(taskUserList)) {
            for (UnifiedTaskUser unifiedTaskUser : taskUserList) {
                UnifiedTodoTaskInfo unifiedTodoTaskInfoNew = new UnifiedTodoTaskInfo();
                BeanUtils.copyProperties((Object)unifiedTodoTaskInfo, (Object)unifiedTodoTaskInfoNew);
                unifiedTodoTaskInfoNew.setDeptId(unifiedTaskUser.getDeptId());
                unifiedTodoTaskInfoNew.setDeptName(unifiedTaskUser.getDeptName());
                unifiedTodoTaskInfoNew.setUnitId(unifiedTaskUser.getUnitId());
                unifiedTodoTaskInfoNew.setUnitName(unifiedTaskUser.getUnitName());
                unifiedTodoTaskInfoNew.setPostId(unifiedTaskUser.getPostId());
                unifiedTodoTaskInfoNew.setPostName(unifiedTaskUser.getPostName());
                unifiedTodoTaskInfoNew.setUserId(unifiedTaskUser.getUserId());
                unifiedTodoTaskInfoNew.setAssigneeUserName(unifiedTaskUser.getUserName());
                unifiedTodoTaskInfoNew.setAssigneeUserNumber(unifiedTaskUser.getUserNumber());
                unifiedTodoTaskInfoNew.setAssigneeDeptId(unifiedTaskUser.getDeptId());
                unifiedTodoTaskInfoNew.setAssigneeDeptName(unifiedTaskUser.getDeptName());
                unifiedTodoTaskInfoNew.setAssigneeUnitId(unifiedTaskUser.getUnitId());
                unifiedTodoTaskInfoNew.setAssigneeUnitName(unifiedTaskUser.getUnitName());
                unifiedTodoTaskInfoNew.setAssigneeMainDeptId(unifiedTaskUser.getMainDeptId());
                unifiedTodoTaskInfoNew.setAssigneeMainDeptName(unifiedTaskUser.getMainDeptName());
                unifiedTodoTaskInfoNew.setAssigneeMainUnitId(unifiedTaskUser.getMainUnitId());
                unifiedTodoTaskInfoNew.setAssigneeMainUnitName(unifiedTaskUser.getMainUnitName());
                unifiedTodoTaskInfoNew.setMandators(unifiedTaskUser.getMandator());
                unifiedTodoTaskInfoNew.setUserTypes(unifiedTaskUser.getUserType());
                unifiedTodoTaskInfoNew.setCompleteTime(unifiedTaskUser.getCompleteTime());
                unifiedTodoTaskInfoNew.setUserNumber(unifiedTaskUser.getUserNumber());
                listResult.add(unifiedTodoTaskInfoNew);
            }
        } else {
            listResult.add(unifiedTodoTaskInfo);
        }
        return listResult;
    }

    private List<UnifiedUnReadTaskInfo> encapsulationDataUnRead(UnifiedTaskInfo unifiedTaskInfo, List<UnifiedTaskUser> taskUserList) {
        ArrayList<UnifiedUnReadTaskInfo> listResult = new ArrayList<UnifiedUnReadTaskInfo>();
        UnifiedUnReadTaskInfo unifiedUnReadTaskInfo = new UnifiedUnReadTaskInfo();
        UnifiedProcessInfo unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid()));
        unifiedUnReadTaskInfo.setTaskId(unifiedTaskInfo.getTaskId());
        unifiedUnReadTaskInfo.setSystemId(unifiedTaskInfo.getSystemId());
        unifiedUnReadTaskInfo.setCreateTime(unifiedTaskInfo.getCreateTime());
        unifiedUnReadTaskInfo.setLastTime(unifiedTaskInfo.getLastTime());
        unifiedUnReadTaskInfo.setDeadLine(unifiedTaskInfo.getDeadLine());
        unifiedUnReadTaskInfo.setWebLinkurl(unifiedTaskInfo.getWebLinkurl());
        unifiedUnReadTaskInfo.setMobileLinkurl(unifiedTaskInfo.getMobileLinkurl());
        unifiedUnReadTaskInfo.setBusinessId(unifiedTaskInfo.getBusinessId());
        unifiedUnReadTaskInfo.setProcessName(unifiedTaskInfo.getProcessName());
        unifiedUnReadTaskInfo.setTaskDefinitionkey(unifiedTaskInfo.getTaskDefinitionkey());
        unifiedUnReadTaskInfo.setTaskName(unifiedTaskInfo.getTaskName());
        unifiedUnReadTaskInfo.setProcessInstanceid(unifiedTaskInfo.getProcessInstanceid());
        unifiedUnReadTaskInfo.setTaskStatus(unifiedTaskInfo.getTaskStatus());
        unifiedUnReadTaskInfo.setPreactFlag(unifiedTaskInfo.getPreactFlag());
        unifiedUnReadTaskInfo.setWebUrlProps(unifiedTaskInfo.getWebUrlProps());
        unifiedUnReadTaskInfo.setMobileUrlProps(unifiedTaskInfo.getMobileUrlProps());
        if (HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) {
            unifiedUnReadTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedUnReadTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedUnReadTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedUnReadTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedUnReadTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedUnReadTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedUnReadTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedUnReadTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedUnReadTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedUnReadTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedUnReadTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedUnReadTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedUnReadTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedUnReadTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedUnReadTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedUnReadTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedUnReadTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedUnReadTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedUnReadTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedUnReadTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedUnReadTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedUnReadTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        if (HussarUtils.isNotEmpty(taskUserList)) {
            for (UnifiedTaskUser unifiedTaskUser : taskUserList) {
                UnifiedUnReadTaskInfo unifiedUnReadTaskInfoNew = new UnifiedUnReadTaskInfo();
                BeanUtils.copyProperties((Object)unifiedUnReadTaskInfo, (Object)unifiedUnReadTaskInfoNew);
                unifiedUnReadTaskInfoNew.setDeptId(unifiedTaskUser.getDeptId());
                unifiedUnReadTaskInfoNew.setDeptName(unifiedTaskUser.getDeptName());
                unifiedUnReadTaskInfoNew.setUnitId(unifiedTaskUser.getUnitId());
                unifiedUnReadTaskInfoNew.setUnitName(unifiedTaskUser.getUnitName());
                unifiedUnReadTaskInfoNew.setPostId(unifiedTaskUser.getPostId());
                unifiedUnReadTaskInfoNew.setPostName(unifiedTaskUser.getPostName());
                unifiedUnReadTaskInfoNew.setUserId(unifiedTaskUser.getUserId());
                unifiedUnReadTaskInfoNew.setMandators(unifiedTaskUser.getMandator());
                unifiedUnReadTaskInfoNew.setUserTypes(unifiedTaskUser.getUserType());
                unifiedUnReadTaskInfoNew.setCompleteTime(unifiedTaskUser.getCompleteTime());
                unifiedUnReadTaskInfoNew.setUserNumber(unifiedTaskUser.getUserNumber());
                listResult.add(unifiedUnReadTaskInfoNew);
            }
        } else {
            listResult.add(unifiedUnReadTaskInfo);
        }
        return listResult;
    }

    private void updateTaskProcessDetail(UnifiedProcessInfo processInfo) {
        List unifiedTaskInfos = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)processInfo.getProcInstId()), UnifiedTaskInfo::getProcessInstanceid, (Object)processInfo.getProcInstId())).eq(HussarUtils.isNotEmpty((Object)processInfo.getSystemId()), UnifiedTaskInfo::getSystemId, (Object)processInfo.getSystemId()));
        if (HussarUtils.isNotEmpty((Object)unifiedTaskInfos)) {
            new UnifiedTaskInfo().buildTaskInfo(unifiedTaskInfos, processInfo);
            this.unifiedTaskInfoService.saveOrUpdateBatch((Collection)unifiedTaskInfos);
        }
    }

    private List<UnifiedDoneTaskInfo> encapsulationDataDones(List<UnifiedDoneTaskInfo> doneTaskInfos, UnifiedProcessInfo unifiedProcessInfo) {
        for (UnifiedDoneTaskInfo unifiedDoneTaskInfo : doneTaskInfos) {
            if (!HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) continue;
            unifiedDoneTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedDoneTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedDoneTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedDoneTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedDoneTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedDoneTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedDoneTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedDoneTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedDoneTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedDoneTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedDoneTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedDoneTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedDoneTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedDoneTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedDoneTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedDoneTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedDoneTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedDoneTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedDoneTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedDoneTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedDoneTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedDoneTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        return doneTaskInfos;
    }

    private List<UnifiedPendingTaskInfo> encapsulationDataPendings(List<UnifiedPendingTaskInfo> unifiedPendingTaskInfos, UnifiedProcessInfo unifiedProcessInfo) {
        for (UnifiedPendingTaskInfo unifiedPendingTaskInfo : unifiedPendingTaskInfos) {
            if (!HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) continue;
            unifiedPendingTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedPendingTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedPendingTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedPendingTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedPendingTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedPendingTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedPendingTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedPendingTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedPendingTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedPendingTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedPendingTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedPendingTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedPendingTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedPendingTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedPendingTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedPendingTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedPendingTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedPendingTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedPendingTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedPendingTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedPendingTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedPendingTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        return unifiedPendingTaskInfos;
    }

    private List<UnifiedReadedTaskInfo> encapsulationDataReads(List<UnifiedReadedTaskInfo> unifiedReadedTaskInfos, UnifiedProcessInfo unifiedProcessInfo) {
        for (UnifiedReadedTaskInfo unifiedReadedTaskInfo : unifiedReadedTaskInfos) {
            if (!HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) continue;
            unifiedReadedTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedReadedTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedReadedTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedReadedTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedReadedTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedReadedTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedReadedTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedReadedTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedReadedTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedReadedTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedReadedTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedReadedTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedReadedTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedReadedTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedReadedTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedReadedTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedReadedTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedReadedTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedReadedTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedReadedTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedReadedTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedReadedTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        return unifiedReadedTaskInfos;
    }

    private List<UnifiedTodoTaskInfo> encapsulationDataTodos(List<UnifiedTodoTaskInfo> unifiedTodoTaskInfos, UnifiedProcessInfo unifiedProcessInfo) {
        for (UnifiedTodoTaskInfo unifiedTodoTaskInfo : unifiedTodoTaskInfos) {
            if (!HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) continue;
            unifiedTodoTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedTodoTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedTodoTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedTodoTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedTodoTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedTodoTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedTodoTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedTodoTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedTodoTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedTodoTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedTodoTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedTodoTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedTodoTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedTodoTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedTodoTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedTodoTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedTodoTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedTodoTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedTodoTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedTodoTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedTodoTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedTodoTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        return unifiedTodoTaskInfos;
    }

    private List<UnifiedUnReadTaskInfo> encapsulationDataUnReads(List<UnifiedUnReadTaskInfo> unifiedUnReadTaskInfos, UnifiedProcessInfo unifiedProcessInfo) {
        for (UnifiedUnReadTaskInfo unifiedUnReadTaskInfo : unifiedUnReadTaskInfos) {
            if (!HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) continue;
            unifiedUnReadTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedUnReadTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedUnReadTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedUnReadTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedUnReadTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedUnReadTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedUnReadTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedUnReadTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedUnReadTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedUnReadTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedUnReadTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedUnReadTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedUnReadTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedUnReadTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedUnReadTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedUnReadTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedUnReadTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedUnReadTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedUnReadTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedUnReadTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedUnReadTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedUnReadTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        return unifiedUnReadTaskInfos;
    }

    private List<UnifiedTaskInfo> encapsulationData(List<UnifiedTaskInfo> unifiedTaskInfos, UnifiedProcessInfo unifiedProcessInfo) {
        for (UnifiedTaskInfo unifiedTaskInfo : unifiedTaskInfos) {
            if (!HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) continue;
            unifiedTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        return unifiedTaskInfos;
    }

    private void addTaskUser(UserAddBatchDto userAddBatchDto) {
        List todoList = this.iUnifiedTodoTaskInfoService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTodoTaskInfo::getTaskId, (Object)userAddBatchDto.getTaskId())).eq(UnifiedTodoTaskInfo::getSystemId, (Object)userAddBatchDto.getSystemId()));
        List pendingList = this.iUnifiedPendingTaskInfoService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedPendingTaskInfo::getTaskId, (Object)userAddBatchDto.getTaskId())).eq(UnifiedPendingTaskInfo::getSystemId, (Object)userAddBatchDto.getSystemId()));
        List unReadList = this.iUnifiedUnReadTaskInfoService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedUnReadTaskInfo::getTaskId, (Object)userAddBatchDto.getTaskId())).eq(UnifiedUnReadTaskInfo::getSystemId, (Object)userAddBatchDto.getSystemId()));
        ArrayList<UnifiedTodoTaskInfo> todoListAdd = new ArrayList<UnifiedTodoTaskInfo>();
        ArrayList<UnifiedPendingTaskInfo> pendingListAdd = new ArrayList<UnifiedPendingTaskInfo>();
        ArrayList<UnifiedUnReadTaskInfo> unReadListAdd = new ArrayList<UnifiedUnReadTaskInfo>();
        if (HussarUtils.isNotEmpty((Object)userAddBatchDto.getTaskUsers())) {
            for (UnifiedTaskUser unifiedTaskUser : userAddBatchDto.getTaskUsers()) {
                if (HussarUtils.isNotEmpty((Object)todoList)) {
                    UnifiedTodoTaskInfo unifiedTodoTaskInfo = new UnifiedTodoTaskInfo();
                    BeanUtils.copyProperties(todoList.get(0), (Object)unifiedTodoTaskInfo);
                    unifiedTodoTaskInfo.setDeptId(unifiedTaskUser.getDeptId());
                    unifiedTodoTaskInfo.setDeptName(unifiedTaskUser.getDeptName());
                    unifiedTodoTaskInfo.setUnitId(unifiedTaskUser.getUnitId());
                    unifiedTodoTaskInfo.setUnitName(unifiedTaskUser.getUnitName());
                    unifiedTodoTaskInfo.setPostId(unifiedTaskUser.getPostId());
                    unifiedTodoTaskInfo.setPostName(unifiedTaskUser.getPostName());
                    unifiedTodoTaskInfo.setUserId(unifiedTaskUser.getUserId());
                    unifiedTodoTaskInfo.setAssigneeUserName(unifiedTaskUser.getUserName());
                    unifiedTodoTaskInfo.setAssigneeUserNumber(unifiedTaskUser.getUserNumber());
                    unifiedTodoTaskInfo.setAssigneeDeptId(unifiedTaskUser.getDeptId());
                    unifiedTodoTaskInfo.setAssigneeDeptName(unifiedTaskUser.getDeptName());
                    unifiedTodoTaskInfo.setAssigneeUnitId(unifiedTaskUser.getUnitId());
                    unifiedTodoTaskInfo.setAssigneeUnitName(unifiedTaskUser.getUnitName());
                    unifiedTodoTaskInfo.setAssigneeMainDeptId(unifiedTaskUser.getMainDeptId());
                    unifiedTodoTaskInfo.setAssigneeMainDeptName(unifiedTaskUser.getMainDeptName());
                    unifiedTodoTaskInfo.setAssigneeMainUnitId(unifiedTaskUser.getMainUnitId());
                    unifiedTodoTaskInfo.setAssigneeMainUnitName(unifiedTaskUser.getMainUnitName());
                    unifiedTodoTaskInfo.setMandators(unifiedTaskUser.getMandator());
                    unifiedTodoTaskInfo.setUserTypes(unifiedTaskUser.getUserType());
                    unifiedTodoTaskInfo.setCompleteTime(unifiedTaskUser.getCompleteTime());
                    unifiedTodoTaskInfo.setUserNumber(unifiedTaskUser.getUserNumber());
                    todoListAdd.add(unifiedTodoTaskInfo);
                    this.iUnifiedTodoTaskInfoService.saveOrUpdateBatch(todoListAdd);
                }
                if (HussarUtils.isNotEmpty((Object)pendingList)) {
                    UnifiedPendingTaskInfo unifiedPendingTaskInfo = new UnifiedPendingTaskInfo();
                    BeanUtils.copyProperties(pendingList.get(0), (Object)unifiedPendingTaskInfo);
                    unifiedPendingTaskInfo.setDeptId(unifiedTaskUser.getDeptId());
                    unifiedPendingTaskInfo.setDeptName(unifiedTaskUser.getDeptName());
                    unifiedPendingTaskInfo.setUnitId(unifiedTaskUser.getUnitId());
                    unifiedPendingTaskInfo.setUnitName(unifiedTaskUser.getUnitName());
                    unifiedPendingTaskInfo.setPostId(unifiedTaskUser.getPostId());
                    unifiedPendingTaskInfo.setPostName(unifiedTaskUser.getPostName());
                    unifiedPendingTaskInfo.setUserId(unifiedTaskUser.getUserId());
                    unifiedPendingTaskInfo.setMandators(unifiedTaskUser.getMandator());
                    unifiedPendingTaskInfo.setUserTypes(unifiedTaskUser.getUserType());
                    unifiedPendingTaskInfo.setCompleteTime(unifiedTaskUser.getCompleteTime());
                    unifiedPendingTaskInfo.setUserNumber(unifiedTaskUser.getUserNumber());
                    pendingListAdd.add(unifiedPendingTaskInfo);
                    this.iUnifiedPendingTaskInfoService.saveOrUpdateBatch(pendingListAdd);
                }
                if (!HussarUtils.isNotEmpty((Object)unReadList)) continue;
                UnifiedUnReadTaskInfo unifiedUnReadTaskInfo = new UnifiedUnReadTaskInfo();
                BeanUtils.copyProperties(unReadList.get(0), (Object)unifiedUnReadTaskInfo);
                unifiedUnReadTaskInfo.setDeptId(unifiedTaskUser.getDeptId());
                unifiedUnReadTaskInfo.setDeptName(unifiedTaskUser.getDeptName());
                unifiedUnReadTaskInfo.setUnitId(unifiedTaskUser.getUnitId());
                unifiedUnReadTaskInfo.setUnitName(unifiedTaskUser.getUnitName());
                unifiedUnReadTaskInfo.setPostId(unifiedTaskUser.getPostId());
                unifiedUnReadTaskInfo.setPostName(unifiedTaskUser.getPostName());
                unifiedUnReadTaskInfo.setUserId(unifiedTaskUser.getUserId());
                unifiedUnReadTaskInfo.setMandators(unifiedTaskUser.getMandator());
                unifiedUnReadTaskInfo.setUserTypes(unifiedTaskUser.getUserType());
                unifiedUnReadTaskInfo.setCompleteTime(unifiedTaskUser.getCompleteTime());
                unifiedUnReadTaskInfo.setUserNumber(unifiedTaskUser.getUserNumber());
                unReadListAdd.add(unifiedUnReadTaskInfo);
                this.iUnifiedUnReadTaskInfoService.saveOrUpdateBatch(unReadListAdd);
            }
        }
    }

    private boolean isComply(int otherQueryCondition, int mark) {
        return (otherQueryCondition & mark) == mark;
    }

    private Map<String, String> getHeaders() {
        HashMap headers = Maps.newHashMap();
        headers.put("Authorization", "Basic ZDE5Njc4YTQ4YjczZDdhOTM4NTdmNTZiMDA2NTAyZTg6NmRkZmI4ZGEzNw==");
        return headers;
    }

    private void pushGldNode(GlodonNodeDataDto requestBody) {
        ArrayList list = Lists.newArrayList();
        list.add(requestBody);
        try {
            String data = JSONObject.toJSONString((Object)list);
            logger.info("\u63a8\u9001\u8282\u70b9\u6570\u636e:{}", (Object)data);
            String response = HttpClientUtil.httpPost(this.unifiedTodoGLDProperties.getApproveNode(), data, this.getHeaders());
            GlodonResponse glodonResponse = (GlodonResponse)JSONObject.parseObject((String)response, GlodonResponse.class);
            if (0 != glodonResponse.getReturnCode()) {
                logger.info("\u63a8\u9001\u8282\u70b9\u6570\u636e\u5931\u8d25:{}", (Object)glodonResponse.getThrowable());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u63a8\u9001\u8282\u70b9\u6570\u636e\u51fa\u9519:{}", (Object)e.getMessage());
        }
    }

    private String getOaProjectId(String outOriginId) {
        List<String> fillPrefix = this.unifiedTodoGLDProperties.getFilterPrefix();
        if (HussarUtils.isEmpty((Object)outOriginId)) {
            return outOriginId;
        }
        for (String prefix : fillPrefix) {
            if (!outOriginId.contains(prefix)) continue;
            String[] split = outOriginId.split(prefix);
            return HussarUtils.isEmpty((Object)split[1]) ? outOriginId : split[1];
        }
        return outOriginId;
    }

    private void pushGldMain(GlodonMainDataDto requestBody) {
        ArrayList list = Lists.newArrayList();
        list.add(requestBody);
        try {
            String data = JSONObject.toJSONString((Object)list);
            logger.info("\u63a8\u9001\u6d41\u7a0b\u6570\u636e:{}", (Object)data);
            String response = HttpClientUtil.httpPost(this.unifiedTodoGLDProperties.getApproveRecord(), data, this.getHeaders());
            GlodonResponse glodonResponse = (GlodonResponse)JSONObject.parseObject((String)response, GlodonResponse.class);
            if (0 != glodonResponse.getReturnCode()) {
                logger.info("\u63a8\u9001\u6d41\u7a0b\u6570\u636e\u5931\u8d25:{}", (Object)glodonResponse.getThrowable());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u63a8\u9001\u6d41\u7a0b\u6570\u636e\u51fa\u9519:{}", (Object)e.getMessage());
        }
    }

    private static /* synthetic */ boolean lambda$userAddBatchClassify$37(UnifiedTaskInfo doneTaskInfo, UnifiedTaskUser t) {
        return t.getTaskId().equals(doneTaskInfo.getTaskId());
    }

    private static /* synthetic */ boolean lambda$userAddBatchClassify$36(UnifiedTaskInfo pendingTaskInfo, UnifiedTaskUser t) {
        return t.getTaskId().equals(pendingTaskInfo.getTaskId());
    }

    private static /* synthetic */ boolean lambda$userAddBatchClassify$35(UnifiedTaskInfo todoTaskInfo, UnifiedTaskUser t) {
        return t.getTaskId().equals(todoTaskInfo.getTaskId());
    }

    static {
        PROCESS_STATE.put("1", "\u5df2\u5ba1\u6279\u5b8c\u6210");
        PROCESS_STATE.put("2", "\u5ba1\u6279\u672a\u901a\u8fc7");
        PROCESS_STATE.put("3", "\u5df2\u8fd4\u56de\u6574\u6539");
        PROCESS_STATE.put("4", "\u5df2\u5f3a\u884c\u7ec8\u6b62");
        PROCESS_STATE.put("?", "\u672a\u77e5\u539f\u56e0\u7ed3\u675f");
    }
}

