/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.unifiedtodo.dto.CountQueryDto;
import com.jxdinfo.hussar.unifiedtodo.dto.QueryToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveCategoryDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveProcessInfoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateCategoryDto;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedToDoService;
import com.jxdinfo.hussar.unifiedtodo.vo.CategoryQueryVo;
import com.jxdinfo.hussar.unifiedtodo.vo.ToDoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7edf\u4e00\u5f85\u529e\u5185\u90e8\u63a5\u53e3"})
@RequestMapping(value={"/unified"})
public class UnifiedToDoPersonalMatterController {
    @Autowired
    private IUnifiedToDoService unifiedToDoServiceImpl;

    @GetMapping(value={"/unifiedtodo/listTask"})
    @ApiOperation(value="\u67e5\u8be2\u5f85\u529e", notes="\u67e5\u8be2\u5f85\u529e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="queryToDoDto", value="\u67e5\u8be2\u6761\u4ef6", required=true, paramType="query")})
    @AuditLog(moduleName="\u7edf\u4e00\u5f85\u529e\u5185\u90e8\u63a5\u53e3", eventDesc="\u67e5\u8be2\u4efb\u52a1\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SaveToDoDto>> getListTask(Page<SaveToDoDto> page, QueryToDoDto queryToDoDto) {
        if (HussarUtils.isEmpty((Object)queryToDoDto.getUserId()) && BaseSecurityUtil.getUser() != null) {
            if ("3".equals(queryToDoDto.getUserType())) {
                queryToDoDto.setCreateUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
            } else {
                queryToDoDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
            }
        }
        return this.unifiedToDoServiceImpl.getListTask(page, queryToDoDto);
    }

    @PostMapping(value={"/unifiedtodo/deleteTaskUserBatch"})
    @ApiOperation(value="\u5220\u9664\u6267\u884c\u4eba/\u6284\u9001\u4eba", notes="\u5220\u9664\u6267\u884c\u4eba/\u6284\u9001\u4eba")
    @AuditLog(moduleName="\u7edf\u4e00\u5f85\u529e\u5185\u90e8\u63a5\u53e3", eventDesc="\u5220\u9664\u6267\u884c\u4eba/\u6284\u9001\u4eba", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> deleteTaskUser(@RequestBody JSONObject jsonObject) {
        String taskIds;
        String userId = jsonObject.getString("userId");
        if (HussarUtils.isEmpty((Object)userId) && BaseSecurityUtil.getUser() != null) {
            userId = BaseSecurityUtil.getUser().getId().toString();
        }
        if (HussarUtils.isNotEmpty((Object)userId) && HussarUtils.isNotEmpty((Object)(taskIds = jsonObject.getString("taskIds")))) {
            String[] taskIdList = taskIds.split(",");
            ArrayList<UnifiedTaskUser> taskUserList = new ArrayList<UnifiedTaskUser>();
            for (String taskId : taskIdList) {
                UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
                unifiedTaskUser.setTaskId(taskId);
                unifiedTaskUser.setUserId(userId);
                unifiedTaskUser.setUserType("1");
                taskUserList.add(unifiedTaskUser);
            }
            return this.unifiedToDoServiceImpl.deleteTaskUser(taskUserList);
        }
        return ApiResponse.fail((String)"\u8bf7\u9009\u62e9\u4efb\u52a1");
    }

    @GetMapping(value={"/unifiedtodo/countTotal"})
    @ApiOperation(value="\u6839\u636e\u4eba\u5458ID\u3001\u5e94\u7528ID\u3001\u72b6\u6001\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e0b\u6216\u8005\u5f53\u524d\u4eba\u5458\u7684\u5f85\u529e/\u5df2\u529e\u6570\u91cf", notes="\u6839\u636e\u4eba\u5458ID\u3001\u5e94\u7528ID\u3001\u72b6\u6001\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e0b\u6216\u8005\u5f53\u524d\u4eba\u5458\u7684\u5f85\u529e/\u5df2\u529e\u6570\u91cf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="systemId", value="\u5e94\u7528id", required=false, paramType="query"), @ApiImplicitParam(name="userId ", value="\u7528\u6237id", required=true, paramType="query"), @ApiImplicitParam(name="executeStatus", value="\u5b8c\u6210\u72b6\u6001(0\uff1a\u5f85\u529e\uff0c1\uff1a\u5df2\u529e)", required=true, paramType="query")})
    @AuditLog(moduleName="\u7edf\u4e00\u5f85\u529e\u5185\u90e8\u63a5\u53e3", eventDesc="\u6839\u636e\u4eba\u5458ID\u3001\u5e94\u7528ID\u3001\u72b6\u6001\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e0b\u6216\u8005\u5f53\u524d\u4eba\u5458\u7684\u5f85\u529e/\u5df2\u529e\u6570\u91cf", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Long> getCountTotal(String systemId, String userId, String executeStatus) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("systemId", systemId);
        map.put("userId", userId);
        map.put("executeStatus", executeStatus);
        return this.unifiedToDoServiceImpl.getCountTotal(systemId, userId, executeStatus);
    }

    @GetMapping(value={"/unifiedtodo/queryTaskDetail"})
    @ApiOperation(value="\u67e5\u8be2\u5f85\u529e(\u901a\u7528\u7c7b\u5f85\u529e)", notes="\u67e5\u8be2\u5f85\u529e(\u901a\u7528\u7c7b\u5f85\u529e)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="todoId", value="\u4efb\u52a1\u8868id", required=true, paramType="query")})
    @AuditLog(moduleName="\u7edf\u4e00\u5f85\u529e\u5185\u90e8\u63a5\u53e3", eventDesc="\u67e5\u8be2\u5f85\u529e(\u901a\u7528\u7c7b\u5f85\u529e)", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<ToDoVo> getTaskDetail(String todoId) {
        return this.unifiedToDoServiceImpl.getToDoByTaskId(todoId);
    }

    @GetMapping(value={"/unifiedtodo/getCountAllTotal"})
    @ApiOperation(value="\u6839\u636e\u4eba\u5458ID\u3001\u5e94\u7528ID\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e0b\u6216\u8005\u5f53\u524d\u4eba\u5458\u7684\u5f85\u529e\u3001\u5df2\u529e\u3001\u50ac\u529e\u3001\u4f20\u9605\u3001\u53d1\u8d77\u6570\u91cf", notes="\u6839\u636e\u4eba\u5458ID\u3001\u5e94\u7528ID\u3001\u72b6\u6001\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e0b\u6216\u8005\u5f53\u524d\u4eba\u5458\u7684\u5f85\u529e\u3001\u5df2\u529e\u3001\u50ac\u529e\u3001\u4f20\u9605\u3001\u53d1\u8d77\u6570\u91cf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="systemId", value="\u5e94\u7528id", required=false, paramType="query"), @ApiImplicitParam(name="userId ", value="\u7528\u6237id", required=true, paramType="query"), @ApiImplicitParam(name="subject ", value="\u4efb\u52a1\u4e1a\u52a1\u63cf\u8ff0", required=false, paramType="query"), @ApiImplicitParam(name="categoryId ", value="\u5206\u7c7bid", required=false, paramType="query")})
    @AuditLog(moduleName="\u7edf\u4e00\u5f85\u529e\u5185\u90e8\u63a5\u53e3", eventDesc="\u6839\u636e\u4eba\u5458ID\u3001\u5e94\u7528ID\u3001\u72b6\u6001\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e0b\u6216\u8005\u5f53\u524d\u4eba\u5458\u7684\u5f85\u529e\u3001\u5df2\u529e\u3001\u50ac\u529e\u3001\u4f20\u9605\u3001\u53d1\u8d77\u6570\u91cf", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<JSONObject> countAllTotal(String systemId, String userId, Long categoryId, String subject) {
        if (HussarUtils.isEmpty((Object)userId) && BaseSecurityUtil.getUser() != null) {
            userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        }
        CountQueryDto countQueryDto = new CountQueryDto();
        countQueryDto.setCategoryId(categoryId);
        countQueryDto.setUserId(userId);
        countQueryDto.setSystemId(systemId);
        countQueryDto.setSubject(subject);
        return this.unifiedToDoServiceImpl.countAllTotal(countQueryDto);
    }

    @GetMapping(value={"/unifiedToDoSystem/querySystemNameList"})
    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u540d\u79f0\u5217\u8868")
    public ApiResponse<List<Map<String, Object>>> querySystemNameList() {
        return this.unifiedToDoServiceImpl.querySystemNameList();
    }

    @GetMapping(value={"/unifiedtodo/queryAllCategory"})
    @ApiOperation(value="\u67e5\u8be2\u5206\u7c7b")
    public ApiResponse<List<CategoryQueryVo>> queryAllCategory(String userId) {
        return this.unifiedToDoServiceImpl.queryAllCategory(userId);
    }

    @PostMapping(value={"/unifiedtodo/saveCategory"})
    @ApiOperation(value="\u65b0\u589e\u5206\u7c7b")
    public ApiResponse<?> saveCategory(@RequestBody SaveCategoryDto saveCategoryDto) {
        return this.unifiedToDoServiceImpl.saveCategory(saveCategoryDto);
    }

    @PostMapping(value={"/unifiedtodo/updateCategory"})
    @ApiOperation(value="\u4fee\u6539\u5206\u7c7b")
    public ApiResponse<?> updateCategory(@RequestBody UpdateCategoryDto updateCategoryDto) {
        return this.unifiedToDoServiceImpl.updateCategory(updateCategoryDto);
    }

    @PostMapping(value={"/unifiedtodo/deleteCategory"})
    @ApiOperation(value="\u5220\u9664\u5206\u7c7b")
    public ApiResponse<?> deleteCategory(@RequestBody Long id) {
        return this.unifiedToDoServiceImpl.deleteCategory(id);
    }

    @PostMapping(value={"/unifiedtodo/saveProcessInfo"})
    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u4fe1\u606f")
    public ApiResponse<?> saveProcessInfo(@RequestBody SaveProcessInfoDto saveProcessInfoDto) {
        return this.unifiedToDoServiceImpl.saveProcessInfo(saveProcessInfoDto);
    }

    @GetMapping(value={"/unifiedtodo/getUnifiedProcess"})
    @ApiOperation(value="\u67e5\u8be2\u7edf\u4e00\u5f85\u529e\u4e2d\u6307\u5b9a\u7528\u6237\u5b58\u5728\u5f85\u529e\u7684\u6d41\u7a0b", notes="\u67e5\u8be2\u7edf\u4e00\u5f85\u529e\u4e2d\u6307\u5b9a\u7528\u6237\u5b58\u5728\u5f85\u529e\u7684\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=false, paramType="query")})
    @AuditLog(moduleName="\u7edf\u4e00\u5f85\u529e\u5185\u90e8\u63a5\u53e3", eventDesc="\u67e5\u8be2\u7edf\u4e00\u5f85\u529e\u4e2d\u6307\u5b9a\u7528\u6237\u5b58\u5728\u5f85\u529e\u7684\u6d41\u7a0b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<?> getUnifiedProcess(@RequestParam(value="userId", required=false) String userId) {
        return this.unifiedToDoServiceImpl.getUnifiedProcess(userId);
    }
}

