/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.unifiedtodo.dto.CountQueryDto;
import com.jxdinfo.hussar.unifiedtodo.dto.QueryToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.RemoteTaskQueryDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveCategoryDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveProcessDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveProcessInfoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TransferTaskDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateCategoryDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateTaskUserToDoDto;
import com.jxdinfo.hussar.unifiedtodo.http.common.HttpClientUtil;
import com.jxdinfo.hussar.unifiedtodo.http.common.ResultUtil;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedToDoService;
import com.jxdinfo.hussar.unifiedtodo.vo.CategoryQueryVo;
import com.jxdinfo.hussar.unifiedtodo.vo.ToDoVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class RestIUnifiedToDoService
implements IUnifiedToDoService {
    public ApiResponse<Long> getCountTotal(String systemId, String userId, String executeStatus) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("systemId", systemId);
        map.put("userId", userId);
        map.put("executeStatus", executeStatus);
        return ResultUtil.convertApiResponse(HttpClientUtil.httpGetApiHandler("/unified/unifiedtodo/countTotal", map));
    }

    public ApiResponse<JSONObject> countAllTotal(String systemId, String userId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("systemId", systemId);
        map.put("userId", userId);
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/countAllTotal", new CountQueryDto(systemId, userId)), new JSONObject());
    }

    public ApiResponse<JSONObject> countAllTotal(CountQueryDto countQueryDto) {
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/countAllTotal", countQueryDto), new JSONObject());
    }

    public ApiResponse<String> saveTask(SaveToDoDto saveToDoDto) {
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/saveTask", ResultUtil.buildMapParam(saveToDoDto)), new String());
    }

    public ApiResponse<String> updateTask(SaveToDoDto saveToDoDto) {
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/updateTask", ResultUtil.buildMapParam(saveToDoDto)), new String());
    }

    public ApiResponse<Page<SaveToDoDto>> getListTask(Page<SaveToDoDto> page, QueryToDoDto queryToDoDto) {
        RemoteTaskQueryDto remoteTaskQueryDto = new RemoteTaskQueryDto(queryToDoDto);
        remoteTaskQueryDto.setPage(page);
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/queryTaskList", remoteTaskQueryDto), new Page());
    }

    public ApiResponse<ToDoVo> getToDoByTaskId(String todoId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("todoId", todoId);
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpGetApiHandler("/unified/unifiedtodo/queryTask", map), new ToDoVo());
    }

    public ApiResponse<String> deleteTask(String taskIds, String systemId, String processInstId) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("taskIds", taskIds);
        body.put("systemId", systemId);
        body.put("processInstId", processInstId);
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/deleteTask", body), new String());
    }

    public ApiResponse<String> updateTaskStatus(String taskId, String systemId, String processInstId, String taskStatus, String webLinkurl, String mobileLinkurl, String lastTime) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        map.put("systemId", systemId);
        map.put("processInstId", processInstId);
        map.put("taskStatus", taskStatus);
        map.put("webLinkurl", webLinkurl);
        map.put("mobileLinkurl", mobileLinkurl);
        map.put("lastTime", lastTime);
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/updateTaskStatus", map), new String());
    }

    public ApiResponse<String> updateTaskStatusWithOutFollowers(String taskId, String systemId, String processInstId, String taskStatus, String webLinkurl, String mobileLinkurl, String lastTime, String formId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        map.put("systemId", systemId);
        map.put("processInstId", processInstId);
        map.put("taskStatus", taskStatus);
        map.put("webLinkurl", webLinkurl);
        map.put("mobileLinkurl", mobileLinkurl);
        map.put("lastTime", lastTime);
        map.put("formId", formId);
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/updateTaskStatusWithOutFollowers", map), new String());
    }

    public ApiResponse<String> updateUserStatus(UnifiedTaskUser unifiedTaskUser) {
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/updateUserStatus", ResultUtil.buildMapParam(unifiedTaskUser)), new String());
    }

    public ApiResponse<String> updateTaskUser(String taskId, String systemId, String executeStatus, List<UnifiedTaskUser> executors, List<UnifiedTaskUser> followers) {
        UpdateTaskUserToDoDto updateTaskUserToDoDto = new UpdateTaskUserToDoDto();
        updateTaskUserToDoDto.setTaskId(taskId);
        updateTaskUserToDoDto.setSystemId(systemId);
        updateTaskUserToDoDto.setExecuteStatus(executeStatus);
        updateTaskUserToDoDto.setExecutors(executors);
        updateTaskUserToDoDto.setFollowers(followers);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskId", taskId);
        map.put("systemId", systemId);
        map.put("executors", executors);
        map.put("executeStatus", executeStatus);
        map.put("updateTaskUserToDoDto", updateTaskUserToDoDto);
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/updateTaskUser", map), new String());
    }

    public ApiResponse<String> updateTaskUser(String taskId, String systemId, String executeStatus, UpdateTaskUserToDoDto updateTaskUserToDoDto) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        map.put("systemId", systemId);
        map.put("executeStatus", executeStatus);
        map.put("updateTaskUserToDoDto", (String)updateTaskUserToDoDto);
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/updateTaskUser", map), new String());
    }

    public ApiResponse<String> transferTaskDeleteTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/transferTaskDeleteTaskUser", unifiedTaskUsers), new String());
    }

    public ApiResponse<String> transferUserTask(TransferTaskDto transferTaskDto) {
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/transferUserTask", ResultUtil.buildMapParam(transferTaskDto)), new String());
    }

    public ApiResponse<String> addTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/addTaskUser", unifiedTaskUsers), new String());
    }

    public ApiResponse<String> deleteTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/deleteTaskUser", unifiedTaskUsers), new String());
    }

    public ApiResponse<String> addUrgeTask(SaveToDoDto saveToDoDto) {
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/addUrgeTask", ResultUtil.buildMapParam(saveToDoDto)), new String());
    }

    public ApiResponse<String> addStartProcess(SaveProcessDto saveProcessDto) {
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/addStartProcess", ResultUtil.buildMapParam(saveProcessDto)), new String());
    }

    public ApiResponse<String> updateStartProcess(SaveProcessDto saveProcessDto) {
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/updateStartProcess", ResultUtil.buildMapParam(saveProcessDto)), new String());
    }

    public ApiResponse<String> deleteStartProcess(SaveProcessDto saveProcessDto) {
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/deleteStartProcess", ResultUtil.buildMapParam(saveProcessDto)), new String());
    }

    public ApiResponse<String> updateBusinessInfo(SaveToDoDto saveToDoDto) {
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/updateBusinessInfo", ResultUtil.buildMapParam(saveToDoDto)), new String());
    }

    public ApiResponse<List<Map<String, Object>>> querySystemNameList() {
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpGetApiHandler("/unified/unifiedtodo/querySystemNameList", new HashMap<String, Object>()), new ArrayList());
    }

    public ApiResponse<List<CategoryQueryVo>> queryAllCategory(String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        return ResultUtil.convertApiResponse3(HttpClientUtil.httpGetApiHandler("/unified/unifiedtodo/queryAllCategory", map), new ArrayList());
    }

    public ApiResponse<?> saveCategory(SaveCategoryDto categoryDto) {
        return HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/saveCategory", categoryDto);
    }

    public ApiResponse<?> updateCategory(UpdateCategoryDto updateCategoryDto) {
        return HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/updateCategory", updateCategoryDto);
    }

    public ApiResponse<?> deleteCategory(Long id) {
        return HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/deleteCategory", id);
    }

    public ApiResponse<?> saveProcessInfo(SaveProcessInfoDto saveProcessInfoDto) {
        return HttpClientUtil.httpPostApiHandler("/unified/unifiedtodo/saveProcessInfo", saveProcessInfoDto);
    }

    private static final class Api {
        public static final String getCountTotal = "/unified/unifiedtodo/countTotal";
        public static final String countAllTotal = "/unified/unifiedtodo/countAllTotal";
        public static final String saveTask = "/unified/unifiedtodo/saveTask";
        public static final String updateTask = "/unified/unifiedtodo/updateTask";
        public static final String getListTask = "/unified/unifiedtodo/queryTaskList";
        public static final String getToDoByTaskId = "/unified/unifiedtodo/queryTask";
        public static final String updateTaskStatusWithOutFollowers = "/unified/unifiedtodo/updateTaskStatusWithOutFollowers";
        public static final String updateTaskStatus = "/unified/unifiedtodo/updateTaskStatus";
        public static final String deleteTask = "/unified/unifiedtodo/deleteTask";
        public static final String updateUserStatus = "/unified/unifiedtodo/updateUserStatus";
        public static final String updateTaskUser = "/unified/unifiedtodo/updateTaskUser";
        public static final String transferTaskDeleteTaskUser = "/unified/unifiedtodo/transferTaskDeleteTaskUser";
        public static final String transferUserTask = "/unified/unifiedtodo/transferUserTask";
        public static final String addTaskUser = "/unified/unifiedtodo/addTaskUser";
        public static final String deleteTaskUser = "/unified/unifiedtodo/deleteTaskUser";
        public static final String addUrgeTask = "/unified/unifiedtodo/addUrgeTask";
        public static final String addStartProcess = "/unified/unifiedtodo/addStartProcess";
        public static final String updateStartProcess = "/unified/unifiedtodo/updateStartProcess";
        public static final String deleteStartProcess = "/unified/unifiedtodo/deleteStartProcess";
        public static final String updateBusinessInfo = "/unified/unifiedtodo/updateBusinessInfo";
        public static final String querySystemNameList = "/unified/unifiedtodo/querySystemNameList";
        public static final String queryAllCategory = "/unified/unifiedtodo/queryAllCategory";
        public static final String saveCategory = "/unified/unifiedtodo/saveCategory";
        public static final String updateCategory = "/unified/unifiedtodo/updateCategory";
        public static final String deleteCategory = "/unified/unifiedtodo/deleteCategory";
        public static final String saveProcessInfo = "/unified/unifiedtodo/saveProcessInfo";

        private Api() {
        }
    }
}

