/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tree.controller;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.tree.dto.TreeRecordConditionDto;
import com.jxdinfo.hussar.tree.model.TreeRecord;
import com.jxdinfo.hussar.tree.service.TreeRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hussarBase/treeRecord"})
@Api(tags={"\u6811\u5386\u53f2\u8bb0\u5f55\u4fe1\u606f\u8868\u914d\u7f6e"})
public class TreeRecordController
extends HussarBaseController<TreeRecord, TreeRecordService> {
    @Resource
    private TreeRecordService treeRecordService;

    @GetMapping(value={"/getTreeRecordInfo"})
    @ApiOperation(value="\u83b7\u53d6\u5386\u53f2\u8bb0\u5f55\u4fe1\u606f", notes="\u83b7\u53d6\u5386\u53f2\u8bb0\u5f55\u4fe1\u606f\u63a5\u53e3")
    @CheckPermission(value={"hussarBase:treeRecord:getTreeRecordInfo"})
    @AuditLog(moduleName="\u6811\u5386\u53f2\u8bb0\u5f55\u4fe1\u606f\u8868", eventDesc="\u83b7\u53d6\u5386\u53f2\u8bb0\u5f55\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<TreeRecord> getTreeRecordInfo(@RequestParam(value="pageId") String pageId, @RequestParam(value="componentId") String componentId) {
        return this.treeRecordService.getTreeRecordInfo(pageId, componentId);
    }

    @PostMapping(value={"/insert"})
    @ApiOperation(value="\u4fdd\u5b58\u5386\u53f2\u8bb0\u5f55\u4fe1\u606f", notes="\u4fdd\u5b58\u5386\u53f2\u8bb0\u5f55\u4fe1\u606f\u63a5\u53e3")
    @CheckPermission(value={"hussarBase:treeRecord:insert"})
    @AuditLog(moduleName="\u6811\u5386\u53f2\u8bb0\u5f55\u4fe1\u606f\u8868", eventDesc="\u4fdd\u5b58\u5386\u53f2\u8bb0\u5f55\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<String> insert(@RequestBody TreeRecordConditionDto treeRecordConditionDto) {
        return this.treeRecordService.insert(treeRecordConditionDto);
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u5386\u53f2\u8bb0\u5f55\u4fe1\u606f", notes="\u4fee\u6539\u5386\u53f2\u8bb0\u5f55\u4fe1\u606f")
    @CheckPermission(value={"hussarBase:treeRecord:update"})
    @AuditLog(moduleName="\u6811\u5386\u53f2\u8bb0\u5f55\u4fe1\u606f\u8868", eventDesc="\u4fee\u6539\u5386\u53f2\u8bb0\u5f55\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> update(@RequestBody TreeRecordConditionDto treeRecordConditionDto) {
        return this.treeRecordService.update(treeRecordConditionDto);
    }
}

