/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.theme.config.controller;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.theme.config.model.dto.AddDTO;
import com.jxdinfo.hussar.theme.config.model.dto.ReturnDTO;
import com.jxdinfo.hussar.theme.config.model.dto.ThemeDTO;
import com.jxdinfo.hussar.theme.config.model.po.SysThemeInfo;
import com.jxdinfo.hussar.theme.config.model.vo.ThemeVO;
import com.jxdinfo.hussar.theme.config.service.IHussarThemeConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/themeConfig"})
@Api(tags={"\u4e3b\u9898\u914d\u7f6e"})
@RestController
public class ThemeConfigController
extends HussarBaseController<SysThemeInfo, IHussarThemeConfigService> {
    @Autowired
    private IHussarThemeConfigService sysThemeInfoService;

    @GetMapping(value={"/getThemeCheckList"})
    @ApiOperation(value="\u83b7\u53d6\u4e3b\u9898\u6821\u9a8c\u5217\u8868", notes="\u83b7\u53d6\u4e3b\u9898\u6821\u9a8c\u5217\u8868")
    @AuditLog(moduleName="\u4e3b\u9898\u914d\u7f6e", eventDesc="\u67e5\u8be2\u4e3b\u9898\u6821\u9a8c\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Object> getThemeCheckList() {
        return this.sysThemeInfoService.getThemeCheckList();
    }

    @GetMapping(value={"/getThemeConfigRole"})
    @ApiOperation(value="\u83b7\u53d6\u4e3b\u9898\u6743\u9650", notes="\u83b7\u53d6\u4e3b\u9898\u6743\u9650")
    @AuditLog(moduleName="\u4e3b\u9898\u914d\u7f6e", eventDesc="\u67e5\u8be2\u4e3b\u9898\u6743\u9650", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> getRole() {
        return this.sysThemeInfoService.getThemeConfigRole();
    }

    @GetMapping(value={"/updateGreyScreenApplication"})
    @ApiOperation(value="\u8bbe\u7f6e\u662f\u5426\u7070\u5c4f", notes="\u8bbe\u7f6e\u662f\u5426\u7070\u5c4f")
    @CheckPermission(value={"themeConfig:updateGreyScreenApplication"})
    public ApiResponse<String> updateGreyScreenApplication(@RequestParam boolean isGreyScreen) {
        return this.sysThemeInfoService.updateGreyScreenApplication(isGreyScreen);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e3b\u9898css\u6587\u4ef6", notes="\u83b7\u53d6\u4e3b\u9898css\u6587\u4ef6")
    @GetMapping(value={"/getThemeConfigCss.css"})
    public void getThemeConfigCss(HttpServletResponse response, @ApiParam(value="\u4e3b\u9898\u914d\u7f6eid") @RequestParam Long themeId, @RequestParam(required=false) String type) throws Exception {
        this.sysThemeInfoService.getThemeConfigCss(response, themeId, type);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e3b\u9898\u8272", notes="\u83b7\u53d6\u4e3b\u9898\u8272")
    @GetMapping(value={"/getThemeColor"})
    public ApiResponse<Map<String, String>> getThemeColor() {
        return this.sysThemeInfoService.getThemeColor();
    }

    @ApiOperation(value="\u83b7\u53d6\u5217\u8868", notes="\u83b7\u53d6\u5217\u8868")
    @AuditLog(moduleName="\u4e3b\u9898\u914d\u7f6e", eventDesc="\u6839\u636e\u4e3b\u9898\u540d\u79f0\u67e5\u8be2\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/getList"})
    public ApiResponse<List<SysThemeInfo>> getList() {
        String themeName = this.getRequest().getParameter("themeName") == null ? "" : this.getRequest().getParameter("themeName");
        return this.sysThemeInfoService.getList(themeName);
    }

    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5", notes="\u83b7\u53d6\u8be6\u60c5")
    @AuditLog(moduleName="\u4e3b\u9898\u914d\u7f6e", eventDesc="\u6839\u636e\u4e3b\u9898ID\u67e5\u8be2\u4e3b\u9898\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ResponseBody
    @GetMapping(value={"/getTheme"})
    public ApiResponse<SysThemeInfo> getTheme() {
        Long id = Long.valueOf(this.getRequest().getParameter("themeId") == null ? "" : this.getRequest().getParameter("themeId"));
        return this.sysThemeInfoService.getTheme(id);
    }

    @ApiOperation(value="\u4fdd\u5b58\u4e3b\u9898\u914d\u7f6e", notes="\u4fdd\u5b58\u4e3b\u9898\u914d\u7f6e")
    @ResponseBody
    @PostMapping(value={"/saveTheme"})
    public ApiResponse<SysThemeInfo> saveTheme(@ApiParam(value="\u4e3b\u9898\u914d\u7f6ebo") @RequestBody SysThemeInfo sysThemeInfo) {
        return this.sysThemeInfoService.saveTheme(sysThemeInfo);
    }

    @ApiOperation(value="\u4fdd\u5b58\u4e3b\u9898\u914d\u7f6e", notes="\u4fdd\u5b58\u4e3b\u9898\u914d\u7f6e")
    @ResponseBody
    @PostMapping(value={"/copyTheme"})
    public ApiResponse<SysThemeInfo> copyTheme(@RequestBody SysThemeInfo sysThemeInfo) {
        return this.sysThemeInfoService.copyTheme(sysThemeInfo);
    }

    @ApiOperation(value="\u65b0\u5efa\u4e3b\u9898\u914d\u7f6e", notes="\u65b0\u5efa\u4e3b\u9898\u914d\u7f6e")
    @ResponseBody
    @PostMapping(value={"/addTheme"})
    public ApiResponse<SysThemeInfo> addTheme(@RequestBody SysThemeInfo sysThemeInfo) {
        return this.sysThemeInfoService.addTheme(sysThemeInfo);
    }

    @ApiOperation(value="\u4fee\u6539\u4e3b\u9898\u914d\u7f6e", notes="\u4fee\u6539\u4e3b\u9898\u914d\u7f6e")
    @ResponseBody
    @PostMapping(value={"/updateTheme"})
    public ApiResponse<SysThemeInfo> updateTheme(@ApiParam(value="\u4e3b\u9898\u914d\u7f6ebo") @RequestBody SysThemeInfo sysThemeInfo) {
        return this.sysThemeInfoService.updateTheme(sysThemeInfo);
    }

    @ApiOperation(value="\u5220\u9664\u4e3b\u9898\u914d\u7f6e", notes="\u5220\u9664\u4e3b\u9898\u914d\u7f6e")
    @ResponseBody
    @PostMapping(value={"/deleteThemeById"})
    public ApiResponse<Object> deleteThemeById(@ApiParam(value="\u4e3b\u9898ID") @RequestBody Long id) {
        return this.sysThemeInfoService.deleteThemeById(id);
    }

    @ApiOperation(value="\u66f4\u6362\u5f53\u524d\u4e3b\u9898", notes="\u66f4\u6362\u5f53\u524d\u4e3b\u9898")
    @AuditLog(moduleName="\u4e3b\u9898\u914d\u7f6e", eventDesc="\u6839\u636e\u4e3b\u9898ID\u66f4\u6362\u5f53\u524d\u4e3b\u9898", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @ResponseBody
    @PostMapping(value={"/updateThemeCurrentApplication"})
    @CheckPermission(value={"themeConfig:updateThemeCurrentApplication"})
    public ApiResponse<Object> updateThemeCurrentApplication(@ApiParam(value="\u4e3b\u9898id") @RequestBody Long id) {
        return this.sysThemeInfoService.updateThemeCurrentApplication(id);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e3b\u9898", notes="\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e3b\u9898")
    @ResponseBody
    @GetMapping(value={"/getCurrentApplicationTheme"})
    public ApiResponse<ThemeVO> getCurrentApplicationTheme() {
        return this.sysThemeInfoService.getCurrentApplicationTheme();
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e3b\u9898", notes="\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e3b\u9898")
    @ResponseBody
    @GetMapping(value={"/getCurrentApplicationThemeWithType"})
    public ApiResponse<ThemeVO> getCurrentApplicationThemeWithType(@RequestParam(value="type") String type) {
        return this.sysThemeInfoService.getCurrentApplicationThemeWithType(type);
    }

    @ApiOperation(value="\u67e5\u8be2\u4e3b\u9898\u989c\u8272+\u7ec4\u4ef6", notes="\u67e5\u8be2\u4e3b\u9898\u989c\u8272+\u7ec4\u4ef6")
    @AuditLog(moduleName="\u4e3b\u9898\u914d\u7f6e", eventDesc="\u6839\u636e\u4e3b\u9898ID\u67e5\u8be2\u4e3b\u9898\u989c\u8272+\u7ec4\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ResponseBody
    @PostMapping(value={"/getThemeColorAndComponent"})
    public ApiResponse<ReturnDTO> getThemeColorAndComponent(@ApiParam(value="\u4e3b\u9898dto") @RequestBody AddDTO addDTO) {
        return this.sysThemeInfoService.getThemeColorAndComponent(addDTO);
    }

    @ApiOperation(value="\u4fdd\u5b58\u4e3b\u9898", notes="\u4fdd\u5b58\u4e3b\u9898")
    @ResponseBody
    @PostMapping(value={"/saveThemeInfo"})
    public ApiResponse<Object> saveThemeInfo(@ApiParam(value="\u4e3b\u9898\u4fe1\u606fdto") @RequestBody ThemeDTO themeDTO) throws Exception {
        return this.sysThemeInfoService.saveThemeInfo(themeDTO);
    }

    @ApiOperation(value="\u5bfc\u5165\u7ec4\u4ef6", notes="\u5bfc\u5165\u7ec4\u4ef6")
    @ResponseBody
    @PostMapping(value={"/importComponent"})
    public ApiResponse<Object> imortComponent(@ApiParam(value="\u5bfc\u5165\u7ec4\u4ef6\u4fe1\u606fdto") @RequestBody ThemeDTO themeDTO) throws Exception {
        return this.sysThemeInfoService.importComponent(themeDTO);
    }

    @ApiOperation(value="\u5bfc\u5165\u4e3b\u9898", notes="\u5bfc\u5165\u4e3b\u9898")
    @ResponseBody
    @PostMapping(value={"/importTheme"})
    @CheckPermission(value={"themeConfig:importTheme"})
    public ApiResponse<Object> importTheme(@ApiParam(value="\u5bfc\u5165\u6587\u4ef6") @RequestParam(value="file") MultipartFile file) {
        return this.sysThemeInfoService.importTheme(file);
    }

    @ApiOperation(value="\u5bfc\u51fa\u4e3b\u9898", notes="\u5bfc\u51fa\u4e3b\u9898")
    @AuditLog(moduleName="\u4e3b\u9898\u914d\u7f6e", eventDesc="\u6839\u636e\u4e3b\u9898ID\u5bfc\u51fa\u4e3b\u9898", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @ResponseBody
    @GetMapping(value={"/exportTheme/{themeId}"})
    public void exportTheme(HttpServletRequest request, HttpServletResponse response, @ApiParam(value="\u4e3b\u9898id") @PathVariable Long themeId) throws Exception {
        this.sysThemeInfoService.exportTheme(request, response, themeId);
    }
}

