/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.theme.config.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipResourceReader {
    private static final String[] TEXT_FILE_EXTENSIONS = new String[]{"txt", "csv", "json", "xml", "html", "js", "css", "java", "properties"};
    private static final Charset[] SUPPORTED_CHARSETS = new Charset[]{StandardCharsets.UTF_8, StandardCharsets.ISO_8859_1, Charset.forName("GBK"), StandardCharsets.UTF_16};

    public static Map<String, String> readZipFromResources(String resourcePath) throws Exception {
        HashMap<String, String> contents = new HashMap<String, String>();
        try (InputStream is = ZipResourceReader.getResourceStream(resourcePath);
             ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                ZipResourceReader.processZipEntry(zis, entry, contents);
            }
        }
        return contents;
    }

    private static InputStream getResourceStream(String resourcePath) {
        InputStream is = ZipResourceReader.class.getClassLoader().getResourceAsStream(resourcePath);
        if (is == null) {
            throw new IllegalArgumentException("\u8d44\u6e90\u672a\u627e\u5230: " + resourcePath);
        }
        return is;
    }

    private static void processZipEntry(ZipInputStream zis, ZipEntry entry, Map<String, String> contents) throws IOException {
        int len;
        if (entry.isDirectory()) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((len = zis.read(buffer)) > 0) {
            baos.write(buffer, 0, len);
        }
        byte[] fileBytes = baos.toByteArray();
        String content = ZipResourceReader.detectAndConvertToString(fileBytes, entry.getName());
        contents.put(entry.getName(), content);
    }

    private static boolean isTextFile(String fileName) {
        String lowerName = fileName.toLowerCase();
        return Arrays.stream(TEXT_FILE_EXTENSIONS).anyMatch(ext -> lowerName.endsWith("." + ext));
    }

    private static String detectAndConvertToString(byte[] bytes, String fileName) {
        try {
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            for (Charset charset : SUPPORTED_CHARSETS) {
                try {
                    String content = new String(bytes, charset);
                    if (!ZipResourceReader.isLikelyText(content)) continue;
                    return content;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return new String(bytes);
        }
    }

    private static boolean isLikelyText(String content) {
        int controlCharCount = 0;
        for (char c : content.toCharArray()) {
            if (!Character.isISOControl(c) || c == '\n' || c == '\r' || c == '\t') continue;
            ++controlCharCount;
        }
        return (double)controlCharCount * 100.0 / (double)content.length() < 5.0;
    }

    public static void main(String[] args) {
        try {
            Map<String, String> contents = ZipResourceReader.readZipFromResources("sample.zip");
            contents.forEach((name, content) -> {
                System.out.println("\n===== \u6587\u4ef6: " + name + " =====");
                System.out.println("\u5185\u5bb9\u9884\u89c8 (\u524d200\u5b57\u7b26):");
                System.out.println(content.substring(0, Math.min(content.length(), 200)) + "...");
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

