/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.theme.config.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.LicenseInfo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.facade.theme.dto.DefaultStyleDTO;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ComponentLibStyleProfiles;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.StyleScheme;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeBase;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeVars;
import com.jxdinfo.hussar.formdesign.external.facade.theme.service.HussarDefaultStyleCacheService;
import com.jxdinfo.hussar.formdesign.external.facade.theme.service.IHussarThemeCodeGenerateService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.theme.config.constant.ThemeConstant;
import com.jxdinfo.hussar.theme.config.dao.ThemeConfigMapper;
import com.jxdinfo.hussar.theme.config.enums.ThemeExceptionEnums;
import com.jxdinfo.hussar.theme.config.model.dto.AddDTO;
import com.jxdinfo.hussar.theme.config.model.dto.ReturnDTO;
import com.jxdinfo.hussar.theme.config.model.dto.ThemeDTO;
import com.jxdinfo.hussar.theme.config.model.po.SysCustomizedComponentInfo;
import com.jxdinfo.hussar.theme.config.model.po.SysThemeInfo;
import com.jxdinfo.hussar.theme.config.model.vo.ThemeVO;
import com.jxdinfo.hussar.theme.config.service.IHussarThemeConfigService;
import com.jxdinfo.hussar.theme.config.service.IImportComponentService;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service
public class HussarThemeConfigServiceImpl
extends HussarServiceImpl<ThemeConfigMapper, SysThemeInfo>
implements IHussarThemeConfigService {
    private Logger logger = LoggerFactory.getLogger(HussarThemeConfigServiceImpl.class);
    @Autowired
    private ThemeConfigMapper themeInfoMapper;
    @Autowired(required=false)
    private HussarDefaultStyleCacheService defaultStyleCacheService;
    @Autowired(required=false)
    private IHussarThemeCodeGenerateService frontCodeGenerateService;
    @Autowired
    private ISysBaseConfigService iSysBaseConfigService;
    @Autowired(required=false)
    private IImportComponentService iImportComponentService;
    private static final String WEBDEFAULTSTYLES = "WebPage";
    private static final String MOBILEDEFAULTSTYLES = "MobilePage";
    private static final String DEFAULT_THEME_RESOURCE = "/theme/defaultTheme.zip";
    private static final String DEFAULT_THEME_VERSION = "/theme/themeVersion.json";
    private static String THEME_VERSION = "themeVersion";

    @Autowired
    public HussarThemeConfigServiceImpl() {
    }

    public List<SysThemeInfo> getDefaultTheme() {
        return this.list((Wrapper)new LambdaQueryWrapper().eq(SysThemeInfo::getThemeKind, (Object)"1"));
    }

    public StyleScheme getCurrentSysThemeInfo() {
        SysThemeInfo themeInfo = ((ThemeConfigMapper)this.baseMapper).getCurrentApplicationTheme();
        if (themeInfo == null) {
            themeInfo = (SysThemeInfo)this.getById(ThemeConstant.DEFAULT_THEME_ID);
        }
        String schemeFile = themeInfo.getSchemeFile();
        if (schemeFile == null || "".equals(schemeFile)) {
            SysThemeInfo sysThemeInfo = (SysThemeInfo)this.getById(ThemeConstant.DEFAULT_THEME_ID);
            schemeFile = sysThemeInfo.getSchemeFile();
        }
        StyleScheme styleScheme = (StyleScheme)JSON.parseObject((String)schemeFile, StyleScheme.class);
        return styleScheme;
    }

    public ApiResponse<String> getThemeConfigRole() {
        SysBaseConfig sysBaseConfig = this.iSysBaseConfigService.getSysBaseConfig("enable_theme_config_edit");
        String configValue = sysBaseConfig.getConfigValue();
        return ApiResponse.success((Object)configValue, (String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_SUCCESS_OBTAINED_TOPIC_PERM.getValue()));
    }

    public ApiResponse<String> updateGreyScreenApplication(boolean isGreyScreen) {
        if (this.iSysBaseConfigService.getSysBaseConfig("isGreyScreen") == null) {
            SysBaseConfig sysBaseConfig = new SysBaseConfig();
            sysBaseConfig.setName("\u4e00\u952e\u7f6e\u7070\u529f\u80fd");
            sysBaseConfig.setConfigKey("isGreyScreen");
            sysBaseConfig.setParentId(Long.valueOf(2L));
            sysBaseConfig.setExample("\u662f\u5426\u5f00\u542f\u4e3b\u9898\u7f6e\u7070\u529f\u80fd");
            if (isGreyScreen) {
                sysBaseConfig.setConfigValue("1");
            } else {
                sysBaseConfig.setConfigValue("0");
            }
            this.iSysBaseConfigService.saveOrUpdate((Object)sysBaseConfig);
            this.iSysBaseConfigService.setSysBaseConfigCache("isGreyScreen", sysBaseConfig);
        } else {
            SysBaseConfig sysBaseConfig = this.iSysBaseConfigService.getSysBaseConfig("isGreyScreen");
            if (isGreyScreen) {
                sysBaseConfig.setConfigValue("1");
            } else {
                sysBaseConfig.setConfigValue("0");
            }
            this.iSysBaseConfigService.saveOrUpdate((Object)sysBaseConfig);
            this.iSysBaseConfigService.setSysBaseConfigCache("isGreyScreen", sysBaseConfig);
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_SET_GREY_SCREEN_SUCCESS.getValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getThemeConfigCss(HttpServletResponse response, Long themeId, String type) throws Exception {
        SysThemeInfo themeInfo = new SysThemeInfo();
        if (themeId != null && themeId != 0L) {
            themeInfo = (SysThemeInfo)this.getById(themeId);
        } else {
            themeInfo = (SysThemeInfo)HussarCacheUtil.get((String)"theme_config", (Object)"themeConfigCss");
            if (themeInfo == null) {
                themeInfo = ((ThemeConfigMapper)this.baseMapper).getCurrentApplicationTheme();
                if (themeInfo == null) {
                    themeInfo = (SysThemeInfo)this.getById(ThemeConstant.DEFAULT_THEME_ID);
                }
                HussarCacheUtil.put((String)"theme_config", (Object)"themeConfigCss", (Object)themeInfo);
            }
        }
        String cssFile = "";
        if (themeInfo == null) {
            this.logger.error("\u65e0\u9ed8\u8ba4\u4e3b\u9898\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
        } else {
            if (this.isJson(themeInfo.getCssFile())) {
                Map defaultStyleMaps = (Map)JSON.parseObject((String)themeInfo.getCssFile(), (TypeReference)new TypeReference<HashMap<String, String>>(){}, (Feature[])new Feature[0]);
                if (HussarUtils.isEmpty((Object)type) && HussarUtils.isNotEmpty(defaultStyleMaps.get(WEBDEFAULTSTYLES)) && HussarUtils.isNotEmpty(defaultStyleMaps.get(MOBILEDEFAULTSTYLES))) {
                    cssFile = (String)defaultStyleMaps.get(WEBDEFAULTSTYLES) + (String)defaultStyleMaps.get(MOBILEDEFAULTSTYLES);
                } else {
                    if (WEBDEFAULTSTYLES.equals(type) && HussarUtils.isNotEmpty(defaultStyleMaps.get(WEBDEFAULTSTYLES))) {
                        cssFile = (String)defaultStyleMaps.get(WEBDEFAULTSTYLES);
                    }
                    if (MOBILEDEFAULTSTYLES.equals(type) && HussarUtils.isNotEmpty(defaultStyleMaps.get(MOBILEDEFAULTSTYLES))) {
                        cssFile = (String)defaultStyleMaps.get(MOBILEDEFAULTSTYLES);
                    }
                }
            } else {
                String string = cssFile = themeInfo.getCssFile() == null ? "" : themeInfo.getCssFile();
            }
            if (HussarUtils.isEmpty((Object)cssFile)) {
                themeInfo = (SysThemeInfo)this.getById(ThemeConstant.DEFAULT_THEME_ID);
                cssFile = themeInfo.getCssFile() == null ? "" : themeInfo.getCssFile();
            }
        }
        String importComponentThemeInfo = (String)HussarCacheUtil.get((String)"import_compnent", (Object)"import_compnent");
        if (importComponentThemeInfo == null) {
            List sysCustomizedComponentInfoList = this.iImportComponentService.list((Wrapper)new LambdaQueryWrapper().orderByDesc(HussarBaseEntity::getCreateTime));
            StringBuilder importComponentinfo = new StringBuilder();
            for (SysCustomizedComponentInfo sysCustomizedComponentInfo : sysCustomizedComponentInfoList) {
                if (sysCustomizedComponentInfo == null) continue;
                importComponentinfo.append(sysCustomizedComponentInfo.getCssFile());
                break;
            }
            importComponentThemeInfo = importComponentinfo.toString();
            HussarCacheUtil.put((String)"import_compnent", (Object)"import_compnent", (Object)importComponentThemeInfo);
        }
        cssFile = cssFile + importComponentThemeInfo;
        ServletOutputStream outputStream = null;
        try {
            response.setContentType("text/css");
            outputStream = response.getOutputStream();
            outputStream.write(cssFile.getBytes());
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e3b\u9898css\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            if (outputStream != null) {
                outputStream.flush();
            }
        }
    }

    public boolean isJson(String json) {
        if (HussarUtils.isNotEmpty((Object)json)) {
            try {
                JSON.parse((String)json);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public ApiResponse<Map<String, String>> getThemeColor() {
        SysThemeInfo themeInfo = (SysThemeInfo)HussarCacheUtil.get((String)"theme_config", (Object)"themeConfigCss");
        if (themeInfo == null && (themeInfo = ((ThemeConfigMapper)this.baseMapper).getCurrentApplicationTheme()) == null) {
            themeInfo = (SysThemeInfo)this.getById(ThemeConstant.DEFAULT_THEME_ID);
        }
        if (themeInfo != null) {
            String themeColor = themeInfo.getCurrentFile();
            if (themeColor == null || "".equals(themeColor)) {
                themeInfo = (SysThemeInfo)this.getById(ThemeConstant.DEFAULT_THEME_ID);
                themeColor = themeInfo.getCurrentFile() == null ? "" : themeInfo.getCurrentFile();
            }
            ThemeVars themeVars = (ThemeVars)JSON.parseObject((String)themeColor, ThemeVars.class);
            Map webThemeVars = themeVars.getWebPage();
            return ApiResponse.success((Object)webThemeVars, (String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_SUCCESS_THEME_COLOR.getValue()));
        }
        return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_NO_DEFAULT_THEME.getValue()));
    }

    public ApiResponse<List<SysThemeInfo>> getList(String themeName) {
        List<SysThemeInfo> list = this.themeInfoMapper.getList(themeName);
        return ApiResponse.success(list);
    }

    public ApiResponse<SysThemeInfo> getTheme(Long themeId) {
        SysThemeInfo sysThemeInfo = (SysThemeInfo)this.themeInfoMapper.selectById(themeId);
        if (sysThemeInfo != null) {
            return ApiResponse.success((Object)sysThemeInfo);
        }
        return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_NO_DATA.getValue()));
    }

    public ApiResponse<SysThemeInfo> saveTheme(SysThemeInfo sysThemeInfo) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (this.themeNameValidate(sysThemeInfo) != null && this.themeNameValidate(sysThemeInfo).size() > 0) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_NAME_DUPLICATED.getValue()));
        }
        sysThemeInfo.setCreateTime(LocalDateTime.now());
        if (securityUser != null) {
            sysThemeInfo.setCreator(securityUser.getId());
        }
        sysThemeInfo.setDelFlag("0");
        boolean flag = this.save((BaseEntity)sysThemeInfo);
        if (flag) {
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_CONFIG.getValue()));
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.CONFIG);
            auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_SAVE_CONFIG.getValue()));
            if (securityUser != null) {
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(securityUser.getId());
                userDetails.setUserName(securityUser.getUserName());
                auditLogModel.setUserDetails(userDetails);
                HussarTenantDefinition hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)securityUser.getTenantCode());
                if (HussarUtils.isNotEmpty((Object)hussarTenantDefinition)) {
                    userDetails.setTenantId(hussarTenantDefinition.getTenantId());
                    userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
                }
            }
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            return ApiResponse.success((Object)sysThemeInfo);
        }
        return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_SAVE_FAILED.getValue()));
    }

    public ApiResponse<SysThemeInfo> copyTheme(SysThemeInfo sysThemeInfo) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        SysThemeInfo copySysThemeInfo = ToolUtil.isNotEmpty((Object)sysThemeInfo.getId()) ? (SysThemeInfo)this.themeInfoMapper.selectById(sysThemeInfo.getId()) : (SysThemeInfo)this.themeInfoMapper.selectById(ThemeConstant.DEFAULT_THEME_ID);
        if (this.themeNameValidate(sysThemeInfo) != null && !this.themeNameValidate(sysThemeInfo).isEmpty()) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_NAME_DUPLICATED.getValue()));
        }
        SysThemeInfo newSysThemeInfo = new SysThemeInfo();
        newSysThemeInfo.setCreateTime(LocalDateTime.now());
        if (securityUser != null) {
            newSysThemeInfo.setCreator(securityUser.getId());
        }
        newSysThemeInfo.setDelFlag("0");
        newSysThemeInfo.setThemeName(sysThemeInfo.getThemeName());
        newSysThemeInfo.setCurrentApplication("0");
        newSysThemeInfo.setCurrentFile(copySysThemeInfo.getCurrentFile());
        newSysThemeInfo.setCssFile(copySysThemeInfo.getCssFile());
        newSysThemeInfo.setSchemeFile(copySysThemeInfo.getSchemeFile());
        newSysThemeInfo.setThemeCover(copySysThemeInfo.getThemeCover());
        newSysThemeInfo.setThemeKind(copySysThemeInfo.getThemeKind());
        boolean flag = this.saveOrUpdate((BaseEntity)newSysThemeInfo);
        if (flag) {
            return ApiResponse.success((Object)newSysThemeInfo);
        }
        return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_COPY_FAILED.getValue()));
    }

    public ApiResponse<SysThemeInfo> addTheme(SysThemeInfo sysThemeInfo) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        SysThemeInfo defaultSysThemeInfo = (SysThemeInfo)this.themeInfoMapper.selectById(ThemeConstant.DEFAULT_THEME_ID);
        this.logger.info("\u9ed8\u8ba4\u4e3b\u9898\u5bf9\u8c61\uff1a{}", (Object)JSON.toJSONString((Object)defaultSysThemeInfo));
        if (this.themeNameValidate(sysThemeInfo) != null && this.themeNameValidate(sysThemeInfo).size() > 0) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_NAME_DUPLICATED.getValue()));
        }
        sysThemeInfo.setCreateTime(LocalDateTime.now());
        if (securityUser != null) {
            sysThemeInfo.setCreator(securityUser.getId());
        }
        sysThemeInfo.setDelFlag("0");
        sysThemeInfo.setCurrentApplication("0");
        sysThemeInfo.setCurrentFile(defaultSysThemeInfo.getCurrentFile());
        sysThemeInfo.setCssFile(defaultSysThemeInfo.getCssFile());
        sysThemeInfo.setSchemeFile(defaultSysThemeInfo.getSchemeFile());
        this.logger.info("\u65b0\u589e\u4e3b\u9898\u5bf9\u8c61\uff1a{}", (Object)JSON.toJSONString((Object)sysThemeInfo));
        boolean flag = this.saveOrUpdate((BaseEntity)sysThemeInfo);
        if (flag) {
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_CONFIG.getValue()));
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.CONFIG);
            auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_SAVE_CONFIG.getValue()));
            if (securityUser != null) {
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(securityUser.getId());
                userDetails.setUserName(securityUser.getUserName());
                auditLogModel.setUserDetails(userDetails);
                HussarTenantDefinition hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)securityUser.getTenantCode());
                if (HussarUtils.isNotEmpty((Object)hussarTenantDefinition)) {
                    userDetails.setTenantId(hussarTenantDefinition.getTenantId());
                    userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
                }
            }
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            return ApiResponse.success((Object)sysThemeInfo);
        }
        return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_SAVE_FAILED.getValue()));
    }

    public ApiResponse<SysThemeInfo> updateTheme(SysThemeInfo sysThemeInfo) {
        boolean flag;
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (this.themeNameValidate(sysThemeInfo) != null && !this.themeNameValidate(sysThemeInfo).isEmpty()) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_NAME_DUPLICATED.getValue()));
        }
        sysThemeInfo.setLastTime(LocalDateTime.now());
        if (securityUser != null) {
            sysThemeInfo.setLastEditor(securityUser.getId());
        }
        if (flag = this.saveOrUpdate((BaseEntity)sysThemeInfo)) {
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_CONFIG.getValue()));
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.CONFIG);
            auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_MODIFY_CONFIGURATION.getValue()));
            if (securityUser != null) {
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(securityUser.getId());
                userDetails.setUserName(securityUser.getUserName());
                auditLogModel.setUserDetails(userDetails);
                HussarTenantDefinition hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)securityUser.getTenantCode());
                if (HussarUtils.isNotEmpty((Object)hussarTenantDefinition)) {
                    userDetails.setTenantId(hussarTenantDefinition.getTenantId());
                    userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
                }
            }
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            return ApiResponse.success((Object)sysThemeInfo);
        }
        return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_UPDATE_FAILED.getValue()));
    }

    public ApiResponse<Object> deleteThemeById(Long themeId) {
        if (themeId == null || themeId == 0L) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_NO_CORRESPONDING_THEME.getValue()));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = simpleDateFormat.format(new Date());
        boolean flag = this.themeInfoMapper.deleteThemeById(themeId, date);
        if (flag) {
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_CONFIG.getValue()));
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.CONFIG);
            auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_DEL_CONFIGURATION.getValue()));
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            if (securityUser != null) {
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(securityUser.getId());
                userDetails.setUserName(securityUser.getUserName());
                auditLogModel.setUserDetails(userDetails);
                HussarTenantDefinition hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)securityUser.getTenantCode());
                if (HussarUtils.isNotEmpty((Object)hussarTenantDefinition)) {
                    userDetails.setTenantId(hussarTenantDefinition.getTenantId());
                    userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
                }
            }
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_DEL_SUCCESS.getValue()));
        }
        return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_DEL_FAILED.getValue()));
    }

    public ApiResponse<Object> updateThemeCurrentApplication(Long themeId) {
        if (themeId == null || themeId == 0L) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_NO_CORRESPONDING_THEME.getValue()));
        }
        boolean flag = this.themeInfoMapper.updateThemeCurrentApplication(themeId);
        if (flag) {
            SysThemeInfo themeInfo = (SysThemeInfo)this.getById(themeId);
            HussarCacheUtil.put((String)"theme_config", (Object)"themeConfigCss", (Object)themeInfo);
            StyleScheme styleScheme = (StyleScheme)JSON.parseObject((String)themeInfo.getSchemeFile(), StyleScheme.class);
            if (LicenseInfo.getLicenseType() == 3) {
                this.frontCodeGenerateService.writeWebScss(styleScheme);
            }
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_REPLACEMENT_SUCCESS.getValue()));
        }
        return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_REPLACEMENT_FAILED.getValue()));
    }

    public ApiResponse<ThemeVO> getCurrentApplicationTheme() {
        String schemeFile;
        SysThemeInfo themeInfo = (SysThemeInfo)HussarCacheUtil.get((String)"theme_config", (Object)"themeConfigCss");
        if (themeInfo == null && (themeInfo = ((ThemeConfigMapper)this.baseMapper).getCurrentApplicationTheme()) == null) {
            themeInfo = (SysThemeInfo)this.getById(ThemeConstant.DEFAULT_THEME_ID);
        }
        if ((schemeFile = themeInfo.getSchemeFile()) == null || "".equals(schemeFile)) {
            SysThemeInfo sysThemeInfo = (SysThemeInfo)this.getById(ThemeConstant.DEFAULT_THEME_ID);
            schemeFile = sysThemeInfo.getSchemeFile();
        }
        StyleScheme styleScheme = (StyleScheme)JSON.parseObject((String)schemeFile, StyleScheme.class);
        ThemeVO themeVO = new ThemeVO();
        themeVO.setScheme(styleScheme);
        themeVO.setThemeId(themeInfo.getId());
        return ApiResponse.success((Object)themeVO);
    }

    public ApiResponse<ReturnDTO> getThemeColorAndComponent(AddDTO addDTO) {
        Long themeId = addDTO.getThemeId();
        SysThemeInfo themeInfo = new SysThemeInfo();
        themeInfo = themeId == null || themeId == 0L ? (SysThemeInfo)this.getById(ThemeConstant.DEFAULT_THEME_ID) : (SysThemeInfo)this.getById(themeId);
        String themeTitle = themeInfo.getThemeName();
        String schemeFile = themeInfo.getSchemeFile();
        String currentFile = themeInfo.getCurrentFile();
        ThemeVars themeVars = (ThemeVars)JSON.parseObject((String)currentFile, ThemeVars.class);
        StyleScheme scheme = (StyleScheme)JSON.parseObject((String)schemeFile, StyleScheme.class);
        ReturnDTO returnDTO = new ReturnDTO();
        returnDTO.setThemeName(themeTitle);
        returnDTO.setScheme(scheme);
        returnDTO.setThemeVars(themeVars);
        return ApiResponse.success((Object)returnDTO);
    }

    public ApiResponse<Object> saveThemeInfo(ThemeDTO themeDTO) throws Exception {
        boolean flag;
        Map mobileScssVars;
        Map mobileThemeVars;
        Long themeId = themeDTO.getThemeId();
        ThemeVars themeVars = themeDTO.getThemeVars();
        if (themeId == null || themeId == 0L) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_TOPIC_INFO_EMPTY.getValue()));
        }
        SysThemeInfo themeInfo = (SysThemeInfo)this.getById(themeId);
        String themeVarsJson = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)themeVars);
        themeInfo.setCurrentFile(themeVarsJson);
        DefaultStyleDTO defaultStyleDTO = themeDTO.getDefaultValues();
        Map webDefaultStyle = defaultStyleDTO.getWebPage();
        Map mobileDefaultStyle = defaultStyleDTO.getMobilePage();
        this.defaultStyleCacheService.update(defaultStyleDTO);
        ThemeVars defaultThemeVars = (ThemeVars)JSON.parseObject((String)themeInfo.getCurrentFile(), ThemeVars.class);
        Map defaultWebThemeVars = defaultThemeVars != null ? defaultThemeVars.getWebPage() : null;
        Map defaultMobileThemeVars = defaultThemeVars != null ? defaultThemeVars.getMobilePage() : null;
        String webDefaultStylesJson = this.frontCodeGenerateService.defaultStyleGenerate(webDefaultStyle, defaultWebThemeVars, themeDTO.getScheme().getThemeBase().getWebPage(), themeDTO.getScheme().getScssVars().getWebPage());
        String mobileDefaultStylesJson = this.frontCodeGenerateService.defaultStyleGenerate(mobileDefaultStyle, defaultMobileThemeVars, themeDTO.getScheme().getThemeBase().getMobilePage(), themeDTO.getScheme().getScssVars().getMobilePage());
        HashMap<String, String> defaultStyleMaps = new HashMap<String, String>();
        defaultStyleMaps.put(WEBDEFAULTSTYLES, webDefaultStylesJson);
        defaultStyleMaps.put(MOBILEDEFAULTSTYLES, mobileDefaultStylesJson);
        themeInfo.setCssFile(JSON.toJSONString(defaultStyleMaps));
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        StyleScheme styleScheme = themeDTO.getScheme();
        String content = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)styleScheme);
        themeInfo.setSchemeFile(content);
        themeInfo.setLastTime(LocalDateTime.now());
        if (securityUser != null) {
            themeInfo.setLastEditor(securityUser.getId());
        }
        ComponentLibStyleProfiles scssVars = styleScheme.getScssVars();
        ThemeBase themeBase = styleScheme.getThemeBase();
        Map webScssVars = scssVars.getWebPage();
        ThemeVars currentThemeVars = (ThemeVars)JSON.parseObject((String)themeInfo.getCurrentFile(), ThemeVars.class);
        Map webThemeVars = currentThemeVars != null ? currentThemeVars.getWebPage() : null;
        Map map = mobileThemeVars = currentThemeVars != null ? currentThemeVars.getMobilePage() : null;
        if (null != webScssVars) {
            String webCommonCssJson = this.frontCodeGenerateService.getCommonCssJsonByScssVars(WEBDEFAULTSTYLES, webScssVars, themeBase.getWebPage(), webThemeVars);
            defaultStyleMaps.put(WEBDEFAULTSTYLES, (String)defaultStyleMaps.get(WEBDEFAULTSTYLES) + webCommonCssJson);
            themeInfo.setCssFile(JSON.toJSONString(defaultStyleMaps));
        }
        if (null != (mobileScssVars = scssVars.getMobilePage())) {
            String mobileCommonCssJson = this.frontCodeGenerateService.getCommonCssJsonByScssVars(MOBILEDEFAULTSTYLES, mobileScssVars, themeBase.getMobilePage(), mobileThemeVars);
            defaultStyleMaps.put(MOBILEDEFAULTSTYLES, (String)defaultStyleMaps.get(MOBILEDEFAULTSTYLES) + mobileCommonCssJson);
            themeInfo.setCssFile(JSON.toJSONString(defaultStyleMaps));
        }
        if (!(flag = this.saveOrUpdate((BaseEntity)themeInfo))) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_FAILED_SAVE_THEME_FILE_CONTENT.getValue()));
        }
        if ("1".equals(themeInfo.getCurrentApplication())) {
            HussarCacheUtil.put((String)"theme_config", (Object)"themeConfigCss", (Object)themeInfo);
            StyleScheme styleSchemes = (StyleScheme)JSON.parseObject((String)themeInfo.getSchemeFile(), StyleScheme.class);
            this.frontCodeGenerateService.writeWebScss(styleSchemes);
        }
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_CONFIG.getValue()));
        auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.CONFIG);
        auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_SAVE_COLORS_COMPONENTS.getValue()));
        if (securityUser != null) {
            UserDetails userDetails = new UserDetails();
            userDetails.setUserId(securityUser.getId());
            userDetails.setUserName(securityUser.getUserName());
            auditLogModel.setUserDetails(userDetails);
            HussarTenantDefinition hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)securityUser.getTenantCode());
            if (HussarUtils.isNotEmpty((Object)hussarTenantDefinition)) {
                userDetails.setTenantId(hussarTenantDefinition.getTenantId());
                userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
            }
        }
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_SUCCESS_SAVE_THEME_FILE_CONTENT.getValue()));
    }

    public ApiResponse<Object> importComponent(ThemeDTO themeDTO) throws Exception {
        String themeVarsJson = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)themeDTO.getThemeVars());
        ThemeVars defaultThemeVars = (ThemeVars)JSON.parseObject((String)themeVarsJson, ThemeVars.class);
        String importComponentStylesJson = this.frontCodeGenerateService.defaultStyleGenerate(themeDTO.getDefaultValues().getWebPage(), defaultThemeVars.getWebPage(), themeDTO.getScheme().getThemeBase().getWebPage(), themeDTO.getScheme().getScssVars().getWebPage());
        SysCustomizedComponentInfo sysCustomizedComponentInfo = new SysCustomizedComponentInfo();
        sysCustomizedComponentInfo.setCssFile(importComponentStylesJson);
        this.iImportComponentService.saveOrUpdate((Object)sysCustomizedComponentInfo);
        HussarCacheUtil.put((String)"import_compnent", (Object)"import_compnent", (Object)importComponentStylesJson);
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_IMPORT_COMPONENT_SUCCESS.getValue()));
    }

    public ApiResponse<Object> importTheme(MultipartFile importFile) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (importFile == null) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_IMPORT_FAILED_FILE_EMPTY.getValue()));
        }
        try {
            String fileName = importFile.getOriginalFilename();
            if ("".equals(fileName)) {
                return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_IMPORT_FAILED_NAME_EMPTY.getValue()));
            }
            if (!fileName.endsWith(".themeConfig")) {
                return ApiResponse.fail((String)String.format(TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_IMPORT_FAILED_FILE.getValue()), ".themeConfig"));
            }
            fileName = fileName.replaceAll("(?i).themeConfig", "").replace(" ", "");
            InputStream is = importFile.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(is);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer();
            String text = null;
            while ((text = bufferedReader.readLine()) != null) {
                stringBuffer.append(text);
            }
            String content = stringBuffer.toString();
            SysThemeInfo themeInfo = (SysThemeInfo)JSON.parseObject((String)content, SysThemeInfo.class);
            if ("".equals(themeInfo) || themeInfo == null) {
                return ApiResponse.fail((String)String.format(TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_IMPORT_FAILED_FORMATTED.getValue()), ".themeConfig"));
            }
            if (themeInfo.getId() == null || themeInfo.getThemeName() == null) {
                return ApiResponse.fail((String)String.format(TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_IMPORT_FAILED_FORMATTED.getValue()), ".themeConfig"));
            }
            String themeName = fileName;
            SysThemeInfo sysThemeInfo = this.themeInfoMapper.getByThemeName(themeName);
            if (sysThemeInfo != null) {
                return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_NAME_DUPLICATED_NOT_AGAIN.getValue()));
            }
            themeInfo.setId(null);
            themeInfo.setThemeName(fileName);
            themeInfo.setCurrentApplication("0");
            themeInfo.setCreateTime(LocalDateTime.now());
            themeInfo.setLastTime(LocalDateTime.now());
            if (securityUser != null) {
                themeInfo.setCreator(securityUser.getId());
                themeInfo.setLastEditor(securityUser.getId());
            }
            this.saveOrUpdate((BaseEntity)themeInfo);
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_CONFIG.getValue()));
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.CONFIG);
            auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_IMPORT.getValue()));
            if (securityUser != null) {
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(securityUser.getId());
                userDetails.setUserName(securityUser.getUserName());
                auditLogModel.setUserDetails(userDetails);
                HussarTenantDefinition hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)securityUser.getTenantCode());
                if (HussarUtils.isNotEmpty((Object)hussarTenantDefinition)) {
                    userDetails.setTenantId(hussarTenantDefinition.getTenantId());
                    userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
                }
            }
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            return ApiResponse.fail((String)String.format(TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_IMPORT_FAILED_FORMATTED.getValue()), ".themeConfig"));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)ThemeExceptionEnums.THEME_IMPORT_SUCCESS.getValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTheme(HttpServletRequest request, HttpServletResponse response, Long themeId) throws Exception {
        SysThemeInfo themeInfo = (SysThemeInfo)this.getById(themeId);
        String name = themeInfo.getThemeName() + ".themeConfig";
        try (ServletOutputStream out = response.getOutputStream();){
            String userAgent = request.getHeader("USER-AGENT");
            String fileName = null;
            fileName = HussarUtils.isNotBlank((CharSequence)userAgent) && (userAgent.contains("MSIE") || userAgent.contains("Trident")) ? URLEncoder.encode(name, "UTF8") : (HussarUtils.isNotBlank((CharSequence)userAgent) && userAgent.contains("Mozilla") ? new String(name.getBytes(), "ISO8859-1") : URLEncoder.encode(name, "UTF8"));
            response.setContentType("application/x-download");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            String content = JSON.toJSONString((Object)themeInfo);
            out.write(content.getBytes());
        }
    }

    @HussarDs(value="#connName")
    public boolean initialDefaultTheme(String connName, String tCode) {
        return this.handleThemeInfo();
    }

    @HussarTokenDs
    public boolean updateThemeInfo() {
        boolean handleThemeInfo = this.handleThemeInfo();
        HussarCacheUtil.evict((String)"theme_config", (Object)"themeConfigCss");
        return handleThemeInfo;
    }

    private boolean handleThemeInfo() {
        try {
            List databaseSysThemeInfos = this.list((Wrapper)new LambdaQueryWrapper().eq(SysThemeInfo::getThemeKind, (Object)"1"));
            if (HussarUtils.isEmpty((Object)databaseSysThemeInfos)) {
                if (((Object)((Object)this)).getClass().getResourceAsStream(DEFAULT_THEME_RESOURCE) != null) {
                    return this.updateDefaultTheme();
                }
            } else {
                boolean isOld = false;
                String jsonContent = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(DEFAULT_THEME_VERSION), (Charset)StandardCharsets.UTF_8);
                if (ToolUtil.isNotEmpty((Object)jsonContent)) {
                    JSONObject jsonObject = JSON.parseObject((String)jsonContent);
                    for (SysThemeInfo databaseSysThemeInfo : databaseSysThemeInfos) {
                        if (Integer.parseInt(jsonObject.get((Object)"themeVersion").toString().trim()) <= Integer.parseInt(databaseSysThemeInfo.getThemeVersion())) continue;
                        isOld = true;
                        break;
                    }
                }
                if (isOld && ((Object)((Object)this)).getClass().getResourceAsStream(DEFAULT_THEME_RESOURCE) != null) {
                    return this.updateDefaultTheme();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public boolean updateDefaultTheme() throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(((Object)((Object)this)).getClass().getResourceAsStream(DEFAULT_THEME_RESOURCE));
        ZipEntry entry = zipInputStream.getNextEntry();
        ArrayList<SysThemeInfo> fileSysThemeInfos = new ArrayList<SysThemeInfo>();
        while (entry != null) {
            String text;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)zipInputStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder stringBuffer = new StringBuilder();
            while ((text = bufferedReader.readLine()) != null) {
                stringBuffer.append(text);
            }
            String content = stringBuffer.toString();
            SysThemeInfo themeInfo = (SysThemeInfo)JSON.parseObject((String)content, SysThemeInfo.class);
            fileSysThemeInfos.add(themeInfo);
            zipInputStream.closeEntry();
            entry = zipInputStream.getNextEntry();
        }
        return this.saveOrUpdateBatch(fileSysThemeInfos);
    }

    private List<SysThemeInfo> themeNameValidate(SysThemeInfo sysThemeInfo) {
        String themeName = sysThemeInfo.getThemeName();
        Long themeId = sysThemeInfo.getId();
        return this.themeInfoMapper.getRepeatingList(themeId, themeName);
    }
}

