/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.theme.config.interceptor.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.theme.config.model.po.SysThemeInfo;
import com.jxdinfo.hussar.theme.config.service.IHussarThemeConfigService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@HussarTokenDs
@Component
public class ThemeInterceptor
implements HandlerInterceptor {
    @Resource
    private IHussarThemeConfigService iHussarThemeConfigService;
    private static final String DEFAULT_THEME_RESOURCE = "/theme/defaultTheme.zip";
    private static final String DEFAULT_THEME_VERSION = "/theme/themeVersion.json";
    private static String THEME_VERSION = "themeVersion";

    public synchronized boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (BaseSecurityUtil.getUser() != null && BaseSecurityUtil.getUser().getTenantCode() != null) {
            THEME_VERSION = THEME_VERSION + BaseSecurityUtil.getUser().getTenantCode();
        }
        if (HussarCacheUtil.get((String)"theme_version", (Object)THEME_VERSION) == null) {
            List databaseSysThemeInfos = this.iHussarThemeConfigService.list((Wrapper)new LambdaQueryWrapper().eq(SysThemeInfo::getThemeKind, (Object)"1"));
            if (HussarUtils.isEmpty((Object)databaseSysThemeInfos)) {
                if (this.getClass().getResourceAsStream(DEFAULT_THEME_RESOURCE) != null) {
                    return this.updateDefaultTheme();
                }
            } else {
                boolean isOld = false;
                String jsonContent = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(DEFAULT_THEME_VERSION), (Charset)StandardCharsets.UTF_8);
                if (ToolUtil.isNotEmpty((Object)jsonContent)) {
                    JSONObject jsonObject = JSON.parseObject((String)jsonContent);
                    for (SysThemeInfo databaseSysThemeInfo : databaseSysThemeInfos) {
                        if (Integer.parseInt(jsonObject.get((Object)"themeVersion").toString().trim()) <= Integer.parseInt(databaseSysThemeInfo.getThemeVersion())) continue;
                        isOld = true;
                        break;
                    }
                }
                if (!isOld) {
                    HussarCacheUtil.put((String)"theme_version", (Object)THEME_VERSION, (Object)true);
                }
                if (isOld && this.getClass().getResourceAsStream(DEFAULT_THEME_RESOURCE) != null) {
                    return this.updateDefaultTheme();
                }
            }
        }
        return true;
    }

    public boolean updateDefaultTheme() throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(this.getClass().getResourceAsStream(DEFAULT_THEME_RESOURCE));
        ZipEntry entry = zipInputStream.getNextEntry();
        ArrayList<SysThemeInfo> fileSysThemeInfos = new ArrayList<SysThemeInfo>();
        while (entry != null) {
            String text;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)zipInputStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder stringBuffer = new StringBuilder();
            while ((text = bufferedReader.readLine()) != null) {
                stringBuffer.append(text);
            }
            String content = stringBuffer.toString();
            SysThemeInfo themeInfo = (SysThemeInfo)JSON.parseObject((String)content, SysThemeInfo.class);
            fileSysThemeInfos.add(themeInfo);
            zipInputStream.closeEntry();
            entry = zipInputStream.getNextEntry();
        }
        HussarCacheUtil.put((String)"theme_version", (Object)THEME_VERSION, (Object)true);
        return this.iHussarThemeConfigService.saveOrUpdateBatch(fileSysThemeInfos);
    }
}

