/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.theme.config.runner;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1000000)
@DependsOn(value={"springContextHolder"})
public class ClearHussarThemeCacheRunner
implements ApplicationRunner {
    private static Logger LOGGER = LoggerFactory.getLogger(ClearHussarThemeCacheRunner.class);
    @Resource
    private HussarTenantProperties hussarTenantProperties;

    public void run(ApplicationArguments args) throws Exception {
        List tenants;
        LOGGER.info("\u6e05\u9664\u4e3b\u9898\u914d\u7f6e\u7f13\u5b58");
        String cacheKey = "themeConfigCss";
        HussarFixedCacheUtil.evict((String)"theme_config", (Object)cacheKey);
        if (this.hussarTenantProperties.isEnabled() && HussarUtils.isNotEmpty(tenants = ((ISysTenantService)SpringContextHolder.getBean(ISysTenantService.class)).list().stream().filter(item -> item.getTenantStatus().equals("1")).collect(Collectors.toList()))) {
            for (SysTenant tenant : tenants) {
                HussarContextHolder.setTenant((String)tenant.getConnName(), (String)tenant.getTenantCode());
                HussarCacheUtil.evict((String)"theme_config", (Object)cacheKey);
            }
        }
    }
}

