/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.url.service.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantCommonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@DependsOn(value={"springContextHolder"})
@Service(value="com.jxdinfo.hussar.tenant.url.service.impl.urlTenantTypeParseServiceImpl")
public class UrlTenantTypeParseServiceImpl
implements IHussarTenantCommonService {
    @Autowired
    private IHussarBaseTenantService hussarBaseTenantService;

    public HussarTenantDefinition parse() {
        String tcode = TenantCommonUtil.getTenantCodeByUrl();
        if (HussarUtils.isNotBlank((CharSequence)tcode)) {
            return this.search(tcode);
        }
        return new DefaultTenant();
    }

    private HussarTenantDefinition search(String tcode) {
        HussarTenantDefinition tenantByTenantCode = TenantCacheUtil.loadFromCacheByTenantCode((String)tcode);
        if (HussarUtils.isEmpty((Object)tenantByTenantCode)) {
            if (tcode.equalsIgnoreCase("0")) {
                return new DefaultTenant();
            }
            tenantByTenantCode = this.hussarBaseTenantService.getTenantByTenantCode(tcode);
            if (HussarUtils.isEmpty((Object)tenantByTenantCode)) {
                throw new BaseException("\u672a\u67e5\u8be2\u5230\u79df\u6237\u7f16\u7801\u4e3a" + tcode + "\u7684\u79df\u6237\u4fe1\u606f");
            }
        }
        return tenantByTenantCode;
    }
}

