/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.url.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.tenant.common.dto.QueryTenantDto;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.impl.AbstractHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.util.TenantUtil;
import com.jxdinfo.hussar.tenant.url.dao.SysTenantUrlMapper;
import com.jxdinfo.hussar.tenant.url.event.AfterCreateTenantEvent;
import com.jxdinfo.hussar.tenant.url.model.SolitaryurlTenant;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.tenant.url.service.impl.hussarBaseSolitaryurlTenantServiceImpl")
public class HussarBaseSolitaryurlTenantServiceImpl
extends AbstractHussarBaseTenantService<SolitaryurlTenant>
implements ApplicationContextAware {
    @Autowired
    private ISysUsersService usersService;
    @Autowired
    private ISysTenantService sysTenantService;
    @Resource
    private SysTenantUrlMapper sysTenantUrlMapper;
    private ApplicationContext applicationContext;

    public Page<SolitaryurlTenant> searchTenant(QueryTenantDto queryTenantDto) {
        Page page = new Page(queryTenantDto.getCurrent(), queryTenantDto.getSize());
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("tenantCode", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantCode()));
        queryOrgParams.put("tenantName", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantName()));
        queryOrgParams.put("tenantStatus", queryTenantDto.getTenantStatus());
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        this.updateTenantStatus();
        List<SolitaryurlTenant> solitaryurlTenants = this.sysTenantUrlMapper.searchSolitaryurlTenant(page, queryOrgParams);
        page.setRecords(solitaryurlTenants);
        return page;
    }

    public SolitaryurlTenant findTenantById(Long tenantId) {
        HussarTenantDefinition tenantByTenantId = this.getTenantByTenantId(tenantId);
        return (SolitaryurlTenant)TenantUtil.convert((HussarTenantDefinition)tenantByTenantId, SolitaryurlTenant.class);
    }

    public void initTenantAdmin(String connName, SolitaryurlTenant solitaryTenant) {
        SysUsers sysUsers = new SysUsers();
        sysUsers.setId(TenantConstant.ADMIN_USER);
        sysUsers.setUserName(solitaryTenant.getLinkman());
        sysUsers.setMobile(solitaryTenant.getContactNumber());
        sysUsers.setUserAccount(solitaryTenant.getUserAccount());
        TenantUtil.setDefaultUserFields((SysUsers)sysUsers);
        String encodeSecure = TenantUtil.getEncodeSecure((String)solitaryTenant.getSecure());
        sysUsers.setPassword(encodeSecure);
        this.usersService.save(connName, (Object)sysUsers);
        solitaryTenant.setTenantAdminId(sysUsers.getId());
    }

    public void saveTenant(SolitaryurlTenant solitaryTenant) {
        SysTenant tenant = TenantUtil.convert2SysTenant((HussarTenantDefinition)solitaryTenant);
        this.sysTenantService.saveOrUpdate((Object)tenant);
    }

    public void afterAddTenant(SolitaryurlTenant solitaryurlTenant) {
        this.applicationContext.publishEvent((ApplicationEvent)new AfterCreateTenantEvent(solitaryurlTenant));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

