/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.url;

import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityResponse;
import com.jxdinfo.hussar.support.security.core.session.TokenSession;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.security.plugin.oauth2.SecurityOAuth2Manager;
import com.jxdinfo.hussar.support.security.plugin.oauth2.config.SecurityOAuth2Config;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.HussarSecurityAuthenticationService;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.HussarSecurityOAuth2InterceptorCustomizers;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.dto.SecurityAuthenticationDto;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Util;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.AccessTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.support.TokenModel;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TenantDeveloperCustomizers
implements HussarSecurityOAuth2InterceptorCustomizers {
    private static Logger logger = LoggerFactory.getLogger(TenantDeveloperCustomizers.class);
    @Autowired(required=false)
    private HussarSecurityAuthenticationService hussarSecurityAuthenticationService;
    @Resource
    private IHussarTenantCommonService hussarTenantCommonService;

    public int order() {
        return -1;
    }

    public void customize(SecurityRequest securityRequest, SecurityResponse securityResponse) {
        try {
            SecurityOAuth2Config securityOAuth2Config = SecurityOAuth2Manager.getConfig();
            String accessToken = securityRequest.getHeader(securityOAuth2Config.getHeaderTokenKey());
            if (HussarUtils.isEmpty((Object)accessToken)) {
                return;
            }
            HussarTenantDefinition tenantDefinition = this.hussarTenantCommonService.parse();
            if (HussarUtils.isEmpty((Object)tenantDefinition)) {
                return;
            }
            String tenantCode = tenantDefinition.getTenantCode();
            if (HussarUtils.isEmpty((Object)tenantCode)) {
                return;
            }
            UserDetails tenantUserDetails = HussarSecurityUtils.getLoginUserDetails((String)accessToken);
            TokenModel mainTokenModel = SecurityOAuth2Util.getTokenModelByAcessToken((String)accessToken, (String)"");
            if (HussarUtils.isEmpty((Object)mainTokenModel) || !(mainTokenModel instanceof AccessTokenModel)) {
                return;
            }
            AccessTokenModel mainAccessTokenModel = (AccessTokenModel)mainTokenModel;
            if (HussarUtils.isNotEmpty((Object)tenantUserDetails)) {
                this.renewMainToken(mainAccessTokenModel);
                return;
            }
            TokenSession mainTokenSession = SecurityUtil.getTokenSession((String)mainAccessTokenModel.loginTicket, (String)"");
            String accountName = (String)mainTokenSession.getUserDetails().getExtendUserMap("account");
            SecurityAuthenticationDto dto = new SecurityAuthenticationDto();
            dto.setUsername(accountName);
            dto.setPassword("123456");
            dto.setClientId("hussar-base");
            dto.setTenantCode(tenantCode);
            HashMap<String, String> extendMap = new HashMap<String, String>();
            extendMap.put("loginType", "tenant_developer_login");
            extendMap.put("loginCode", dto.getUsername());
            extendMap.put("swagger", "1");
            extendMap.put("specify-access-token", accessToken);
            dto.setParamsMapExcludeParam(extendMap);
            this.hussarSecurityAuthenticationService.securityPassword(dto);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f00\u53d1\u4eba\u5458\u4ece\u5e94\u7528\u5f00\u53d1\u5e73\u53f0\u8fdb\u5165\u79df\u6237\u7cfb\u7edf\u514d\u767b\u5f55\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    private void renewMainToken(AccessTokenModel mainAccessTokenModel) {
        SecurityOAuth2Config securityOAuth2Config = SecurityOAuth2Manager.getConfig();
        if (securityOAuth2Config.getRefreshTokenThreshold() <= 0L) {
            return;
        }
        if (securityOAuth2Config.getEnableRenewal().booleanValue()) {
            SecurityUtil.updateAllLoginTokenTimeout((String)mainAccessTokenModel.loginTicket, (long)86400L, (String)mainAccessTokenModel.tenantCode);
            SecurityOAuth2Util.updateAllAccessTokenTimeout((String)mainAccessTokenModel.accessToken, (long)1800L, (long)86400L, (String)mainAccessTokenModel.tenantCode);
        }
    }
}

