/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.url.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.tenant.common.dto.QueryTenantDto;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.impl.AbstractHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.util.TenantUtil;
import com.jxdinfo.hussar.tenant.url.dao.SysTenantUrlMapper;
import com.jxdinfo.hussar.tenant.url.model.SolitaryurlTenant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.tenant.url.service.impl.hussarBaseSolitaryurlTenantServiceImpl")
public class HussarBaseSolitaryurlTenantServiceImpl
extends AbstractHussarBaseTenantService<SolitaryurlTenant> {
    @Autowired
    private ISysUsersService usersService;
    @Autowired
    private ISysTenantService sysTenantService;
    @Resource
    private SysTenantUrlMapper sysTenantUrlMapper;

    public Page<SolitaryurlTenant> searchTenant(QueryTenantDto queryTenantDto) {
        Page page = new Page(queryTenantDto.getCurrent(), queryTenantDto.getSize());
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("tenantCode", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantCode()));
        queryOrgParams.put("tenantName", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantName()));
        queryOrgParams.put("tenantStatus", queryTenantDto.getTenantStatus());
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        this.updateTenantStatus();
        List<SolitaryurlTenant> solitaryurlTenants = this.sysTenantUrlMapper.searchSolitaryurlTenant(page, queryOrgParams);
        page.setRecords(solitaryurlTenants);
        return page;
    }

    public List<SysTenant> dropDownBoxTenant() {
        return this.sysTenantService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantStatus, (Object)"1"));
    }

    public SolitaryurlTenant findTenantById(Long tenantId) {
        HussarTenantDefinition tenantByTenantId = this.getTenantByTenantId(tenantId);
        return (SolitaryurlTenant)TenantUtil.convert((HussarTenantDefinition)tenantByTenantId, SolitaryurlTenant.class);
    }

    public void initTenantAdmin(String connName, SolitaryurlTenant solitaryTenant) {
        ArrayList<SysUsers> list = new ArrayList<SysUsers>();
        SysUsers sysUsers = new SysUsers();
        sysUsers.setId(TenantConstant.ADMIN_USER);
        sysUsers.setUserName(solitaryTenant.getLinkman());
        sysUsers.setMobile(solitaryTenant.getContactNumber());
        sysUsers.setUserAccount(solitaryTenant.getUserAccount());
        TenantUtil.setDefaultUserFields((SysUsers)sysUsers);
        String encodeSecure = TenantUtil.getEncodeSecure((String)solitaryTenant.getSecure());
        sysUsers.setPassword(encodeSecure);
        list.add(sysUsers);
        if ("hussar-workflow".equals(solitaryTenant.getClientId())) {
            SysUsers users = new SysUsers();
            users.setId(TenantConstant.OM_USER);
            users.setUserName(solitaryTenant.getOmName());
            users.setUserAccount(solitaryTenant.getOmAccount());
            users.setCreator(solitaryTenant.getTenantId());
            TenantUtil.setDefaultUserFields((SysUsers)users);
            users.setPassword(TenantUtil.getEncodeSecure((String)solitaryTenant.getOmPwd()));
            list.add(users);
        }
        this.usersService.saveBatch(connName, list);
        solitaryTenant.setTenantAdminId(sysUsers.getId());
    }

    public void saveTenant(SolitaryurlTenant solitaryTenant) {
        SysTenant tenant = TenantUtil.convert2SysTenant((HussarTenantDefinition)solitaryTenant);
        this.sysTenantService.saveOrUpdate((Object)tenant);
    }
}

