/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.util;

import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import org.springframework.beans.BeanUtils;

public class TenantUtil {
    public static boolean removeDefaultRole = true;

    private TenantUtil() {
    }

    public static <T extends HussarTenantDefinition> SysTenant convert2SysTenant(T definition) {
        SysTenant tenant = new SysTenant();
        tenant.setId(definition.getTenantId());
        tenant.setTenantCode(definition.getTenantCode());
        tenant.setTenantName(definition.getTenantName());
        tenant.setTenantDomain(definition.getTenantDomain());
        tenant.setTenantAdminId(definition.getTenantAdminId());
        tenant.setConnName(definition.getConnName());
        tenant.setTenantSeq(definition.getTenantSeq());
        tenant.setGitUrl(definition.getGitUrl());
        tenant.setGitToken(definition.getGitToken());
        tenant.setTenantIconType(definition.getTenantIconType());
        tenant.setTenantIcon(definition.getTenantIcon());
        tenant.setTenantIconColor(definition.getTenantIconColor());
        tenant.setTenantDescription(definition.getTenantDescription());
        tenant.setTenantVersion(definition.getTenantVersion());
        if (definition.getTimeLimit().booleanValue()) {
            tenant.setTimeLimit("1");
            tenant.setStartTime(definition.getStartTime());
            tenant.setEndTime(definition.getEndTime());
        } else {
            tenant.setTimeLimit("0");
        }
        if (definition.getUserQuantityLimit().booleanValue()) {
            tenant.setUserQuantityLimit("1");
            tenant.setMaxUsers(definition.getMaxUsers());
        } else {
            tenant.setUserQuantityLimit("0");
        }
        tenant.setTenantStatus(definition.getTenantStatus());
        return tenant;
    }

    public static <T extends HussarTenantDefinition> T convert(HussarTenantDefinition definition, Class<T> clazz) {
        try {
            HussarTenantDefinition t = (HussarTenantDefinition)clazz.newInstance();
            BeanUtils.copyProperties((Object)definition, (Object)t);
            return (T)t;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public static void setDefaultUserFields(SysUsers sysUsers) {
        sysUsers.setAccountStatus(UserStatus.OK.getCode());
        sysUsers.setIsCpublic("0");
        sysUsers.setTypeProperty("1");
        sysUsers.setSecurityLevel(Integer.valueOf(3));
        sysUsers.setMaxSessions(Integer.valueOf(-1));
        sysUsers.setCorporationId(Long.valueOf(11L));
        sysUsers.setDepartmentId(Long.valueOf(11L));
        sysUsers.setIsSys("1");
        sysUsers.setLoginIpLimit("0");
        sysUsers.setLoginTimeLimit("0");
    }

    public static String getEncodeSecure(String secure) {
        return ((AbstractCredentialsMatcher)SpringContextHolder.getBean(AbstractCredentialsMatcher.class)).passwordEncode(String.valueOf(secure).getBytes());
    }
}

