/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.CoreVersion;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.EntityUtils;
import com.jxdinfo.hussar.common.utils.ExceptionUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.factory.DatabaseFactory;
import com.jxdinfo.hussar.datasource.service.IHussarBaseSQLExecutor;
import com.jxdinfo.hussar.datasource.util.DbUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.tenant.common.dao.SysTenantUpgradeMapper;
import com.jxdinfo.hussar.tenant.common.dto.QuerySysTenantSqlDto;
import com.jxdinfo.hussar.tenant.common.dto.QueryUpgradeDto;
import com.jxdinfo.hussar.tenant.common.dto.SysTenantUpgradeCountDto;
import com.jxdinfo.hussar.tenant.common.dto.TenantUpgradeEnhanceDto;
import com.jxdinfo.hussar.tenant.common.dto.TenantUpgradeQueryConditionDto;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantDatasource;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.model.SysTenantSql;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgrade;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgradeRecord;
import com.jxdinfo.hussar.tenant.common.model.TenantUpgradeMicroServiceInfo;
import com.jxdinfo.hussar.tenant.common.model.UpgradeMicroServiceModel;
import com.jxdinfo.hussar.tenant.common.service.ICheckMicroService;
import com.jxdinfo.hussar.tenant.common.service.IOutSideExecutUpgradeService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantDataSourceService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantSqlService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeCheckService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeService;
import com.jxdinfo.hussar.tenant.common.service.IUpgradeJsonLoadService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.common.vo.SysTenantUpgradeVo;
import com.jxdinfo.hussar.tenant.common.vo.UpgradeVersionSelector;
import com.jxdinfo.hussar.tenant.common.vo.UpgradeVersionVo;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service(value="com.jxdinfo.hussar.tenant.service.impl.sysTenantUpgradeServiceImpl")
public class SysTenantUpgradeServiceImpl
extends HussarServiceImpl<SysTenantUpgradeMapper, SysTenantUpgrade>
implements ISysTenantUpgradeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysTenantUpgradeServiceImpl.class);
    private static final String MASTER = "master";
    private static final String UPGRADING_STATUS = "2";
    private static final String UPGRADE_FAIL_STATUS = "0";
    private static final String UPGRADE_SUCCESS_STATUS = "1";
    private static final String UPGRADE_SELECT_TYPE_SOME = "1";
    @Lazy
    @Autowired
    private ISysTenantService sysTenantService;
    @Autowired
    private ISysTenantDataSourceService sysTenantDataSourceService;
    @Autowired
    private IHussarBaseSQLExecutor hussarBaseSqlExecutor;
    @Autowired
    private ISysTenantRecordService sysTenantRecordService;
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Autowired
    private DynamicDatasourceService dynamicDataSourceService;
    @Autowired
    private ISysTenantSqlService sysTenantSqlService;
    @Autowired
    private SysTenantUpgradeMapper sysTenantUpgradeMapper;
    @Autowired
    private ISysTenantUpgradeRecordService sysTenantUpgradeRecordService;
    @Autowired
    private IUpgradeJsonLoadService upgradeJsonLoadService;
    @Autowired
    private ISysTenantUpgradeCheckService sysTenantUpgradeCheckService;

    public Page<SysTenantUpgrade> search(QueryUpgradeDto queryUpgradeDto) {
        Page page = new Page();
        long size = queryUpgradeDto.getSize();
        long current = queryUpgradeDto.getCurrent();
        String tenantCode = queryUpgradeDto.getTenantCode();
        String serviceName = queryUpgradeDto.getServiceName();
        String updateStatus = queryUpgradeDto.getUpdateStatus();
        page.setSize(size);
        page.setCurrent(current);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)tenantCode)) {
            wrapper.like(SysTenantUpgrade::getTenantCode, (Object)StringUtils.trim((String)tenantCode));
        }
        if (StringUtils.isNotBlank((CharSequence)serviceName)) {
            wrapper.eq(SysTenantUpgrade::getServiceName, (Object)StringUtils.trim((String)serviceName));
        }
        if (StringUtils.isNotBlank((CharSequence)updateStatus)) {
            wrapper.eq(SysTenantUpgrade::getUpdateStatus, (Object)StringUtils.trim((String)updateStatus));
        }
        wrapper.orderByAsc(HussarBaseEntity::getCreateTime);
        Page result = (Page)this.page((IPage)page, (Wrapper)wrapper);
        List records = result.getRecords();
        if (HussarUtils.isNotEmpty((Object)records)) {
            for (SysTenantUpgrade upgrade : records) {
                upgrade.setTenantName(TenantCacheUtil.loadFromCacheByTenantCode((String)upgrade.getTenantCode()).getTenantName());
            }
        }
        return result;
    }

    public void updateSingle() {
        Executor hussarBaseTenantExecutor;
        this.checkHasTenant();
        this.checkSingle();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysTenant::getTenantStatus, (Object)UPGRADE_FAIL_STATUS);
        wrapper.ne(SysTenant::getConnName, (Object)UPGRADE_FAIL_STATUS);
        wrapper.orderByAsc(HussarBaseEntity::getCreateTime);
        List list = this.sysTenantService.list((Wrapper)wrapper);
        if (HussarUtils.isNotEmpty((Object)list) && (hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor()) != null) {
            hussarBaseTenantExecutor.execute(() -> this.asyncUpdateSingle(list));
        }
    }

    private void checkSingle() {
        List list = this.list();
        if (HussarUtils.isNotEmpty((Object)list)) {
            Optional<SysTenantUpgrade> any = list.parallelStream().filter(item -> item.getUpdateStatus().equals(UPGRADE_FAIL_STATUS)).findAny();
            if (any.isPresent()) {
                throw new BaseException("\u8bf7\u9996\u5148\u5904\u7406\u5b8c\u4e0a\u6b21\u5347\u7ea7\u5931\u8d25\u7684\u79df\u6237\uff01");
            }
            List ids = EntityUtils.toList((Collection)list, SysTenantUpgrade::getId);
            this.removeByIds(ids);
        }
    }

    private void checkMicroService(String serviceName) {
        LambdaQueryWrapper upgradeWrapper;
        List list;
        if (EnvironmentUtil.isMicroService()) {
            ((ICheckMicroService)SpringContextHolder.getBean(ICheckMicroService.class)).checkHealthyByServiceName(serviceName);
        }
        if (HussarUtils.isNotEmpty((Object)(list = this.list((Wrapper)(upgradeWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantUpgrade::getServiceName, (Object)serviceName)))))) {
            Optional<SysTenantUpgrade> any = list.parallelStream().filter(item -> item.getUpdateStatus().equals(UPGRADE_FAIL_STATUS) && item.getServiceName().equalsIgnoreCase(serviceName)).findAny();
            if (any.isPresent()) {
                throw new BaseException("\u8bf7\u9996\u5148\u5904\u7406\u5b8c\u670d\u52a1" + serviceName + "\u4e0a\u6b21\u5347\u7ea7\u5931\u8d25\u7684\u79df\u6237");
            }
            List ids = EntityUtils.toList((Collection)list, SysTenantUpgrade::getId);
            this.removeByIds(ids);
        }
    }

    public void updateSingleById(Long id) {
        Executor hussarBaseTenantExecutor;
        boolean platformTenant;
        SysTenantUpgrade sysTenantUpgrade = (SysTenantUpgrade)this.getById(id);
        AssertUtil.isNotNull((Object)sysTenantUpgrade, (String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u5347\u7ea7\u4fe1\u606f\uff01");
        Long tenantId = sysTenantUpgrade.getTenantId();
        SysTenant tenant = (SysTenant)this.sysTenantService.getById((Serializable)tenantId);
        if (tenant != null && !(platformTenant = tenant.getConnName().equals(MASTER)) && (hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor()) != null) {
            hussarBaseTenantExecutor.execute(() -> this.asyncUpdateSingleOne(sysTenantUpgrade, tenant));
        }
    }

    public String viewTenantUpgrade(Long id) {
        SysTenantUpgrade upgrade = (SysTenantUpgrade)this.getById(id);
        if (HussarUtils.isNotEmpty((Object)upgrade)) {
            return upgrade.getUpdateError();
        }
        return null;
    }

    public void updateMicroServiceById(Long id) {
        SysTenantUpgrade upgrade = (SysTenantUpgrade)this.getById(id);
        AssertUtil.isNotNull((Object)upgrade, (String)"\u672a\u67e5\u8be2\u76f8\u5e94\u7684\u79df\u6237\u5347\u7ea7\u8bb0\u5f55\u4fe1\u606f\uff01");
        String serviceName = upgrade.getServiceName();
        String tenantCode = upgrade.getTenantCode();
        this.updateMicroService(serviceName, tenantCode);
    }

    private void updateMicroService(String serviceName, String tenantCode) {
        String currentServiceName = EnvironmentUtil.getServiceName((boolean)true);
        List list = this.sysTenantService.getTenantByServiceName(serviceName);
        AssertUtil.isNotEmpty((Collection)list, (String)("\u672a\u67e5\u8be2\u5230\u79df\u6237\u7f16\u7801\u4e3a" + tenantCode + "\u7684\u79df\u6237\u4fe1\u606f\uff01"));
        if (HussarUtils.isEmpty((Object)list)) {
            return;
        }
        List<Object> upgradeList = new ArrayList<SysTenantUpgrade>();
        if (HussarUtils.isBlank((CharSequence)tenantCode)) {
            this.saveTenantUpgradeLong(serviceName, list, upgradeList);
        } else {
            if (UPGRADE_FAIL_STATUS.equals(tenantCode)) {
                return;
            }
            LambdaQueryWrapper wrapperQuery = new LambdaQueryWrapper();
            wrapperQuery.eq(SysTenantUpgrade::getServiceName, (Object)serviceName);
            wrapperQuery.eq(SysTenantUpgrade::getTenantCode, (Object)tenantCode);
            upgradeList = this.list((Wrapper)wrapperQuery);
        }
        if (Objects.equals(serviceName, currentServiceName)) {
            this.matchCurrentServiceAsyncUpdate(tenantCode, currentServiceName, list);
        } else {
            UpgradeMicroServiceModel upgradeMicroServiceModel = new UpgradeMicroServiceModel();
            upgradeMicroServiceModel.setServiceName(serviceName);
            upgradeMicroServiceModel.setCaller(currentServiceName);
            ArrayList<TenantUpgradeMicroServiceInfo> detail = new ArrayList<TenantUpgradeMicroServiceInfo>();
            List tenantCodes = EntityUtils.toList((Collection)list, SysTenant::getTenantCode);
            List records = this.sysTenantRecordService.list((Wrapper)new LambdaQueryWrapper().in(SysTenantRecord::getTenantCode, (Collection)tenantCodes));
            Map recordMap = EntityUtils.toMap((Collection)records, SysTenantRecord::getTenantCode);
            for (SysTenantUpgrade sysTenantUpgrade : upgradeList) {
                TenantUpgradeMicroServiceInfo info = this.getTenantUpgradeMicroServiceInfo(serviceName, recordMap, sysTenantUpgrade);
                detail.add(info);
            }
            if (HussarUtils.isEmpty((Object)records)) {
                return;
            }
            upgradeMicroServiceModel.setTenantUpgradeMicroServiceInfoList(detail);
            IOutSideExecutUpgradeService outSideExecutUpgradeService = (IOutSideExecutUpgradeService)SpringContextHolder.getBean(IOutSideExecutUpgradeService.class);
            outSideExecutUpgradeService.executUpgrade(upgradeMicroServiceModel, serviceName);
        }
    }

    @NotNull
    private TenantUpgradeMicroServiceInfo getTenantUpgradeMicroServiceInfo(String serviceName, Map<String, SysTenantRecord> recordMap, SysTenantUpgrade upgrade) {
        TenantUpgradeMicroServiceInfo info = new TenantUpgradeMicroServiceInfo();
        info.setTenantCode(upgrade.getTenantCode());
        info.setConnName(upgrade.getConnName());
        JSONArray jsonArray = (JSONArray)JSON.parseObject((String)recordMap.get(upgrade.getTenantCode()).getTenantParams()).get((Object)"storagePropertiesList");
        for (Object object : jsonArray) {
            String jdbcUrl = ((JSONObject)object).getString("jdbcUrl");
            String infoServiceName = ((JSONObject)object).getString("serviceName");
            String creation = ((JSONObject)object).getString("creation");
            if (!"1".equals(creation)) {
                if (!HussarUtils.isNotBlank((CharSequence)jdbcUrl) || !infoServiceName.equals(serviceName)) continue;
                info.setDbType(DbUtil.getDbType((String)jdbcUrl));
                continue;
            }
            ItemDataSource datasourceByPoolName = this.dynamicDataSourceService.getDatasourceByPoolName(info.getConnName());
            info.setDbType(DbUtil.getDbType((String)datasourceByPoolName.getUrl()));
        }
        return info;
    }

    private void matchCurrentServiceAsyncUpdate(String tenantCode, String currentServiceName, List<SysTenant> list) {
        Executor hussarBaseTenantExecutor;
        if (HussarUtils.isNotEmpty(list) && (hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor()) != null) {
            hussarBaseTenantExecutor.execute(() -> {
                for (SysTenant tenant : list) {
                    if (UPGRADE_FAIL_STATUS.equals(tenantCode)) continue;
                    this.asyncUpdateMicroServiceOne(currentServiceName, tenant);
                }
            });
        }
    }

    private void saveTenantUpgradeLong(String serviceName, List<SysTenant> list, List<SysTenantUpgrade> upgradeList) {
        for (SysTenant sysTenant : list) {
            if (MASTER.equalsIgnoreCase(sysTenant.getConnName())) continue;
            SysTenantUpgrade upgrade = new SysTenantUpgrade();
            upgrade.setUpdateStatus(UPGRADING_STATUS);
            upgrade.setConnName(sysTenant.getConnName());
            upgrade.setServiceName(serviceName);
            upgrade.setTenantCode(sysTenant.getTenantCode());
            upgrade.setTenantId(sysTenant.getId());
            upgrade.setTenantName(sysTenant.getTenantName());
            upgradeList.add(upgrade);
        }
        this.saveBatch(upgradeList);
    }

    public void updateMicroService(String serviceName) {
        this.checkMicroService(serviceName);
        this.updateMicroService(serviceName, null);
    }

    private void asyncUpdateMicroServiceOne(String serviceName, SysTenant tenant) {
        String connName = tenant.getConnName();
        if (MASTER.equalsIgnoreCase(connName)) {
            return;
        }
        SysTenantUpgrade sysTenantUpgrade = (SysTenantUpgrade)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantUpgrade::getTenantCode, (Object)tenant.getTenantCode())).eq(SysTenantUpgrade::getServiceName, (Object)serviceName));
        LambdaQueryWrapper datasourceWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasource::getConnName, (Object)connName);
        SysTenantDatasource sysTenantDatasource = (SysTenantDatasource)this.sysTenantDataSourceService.getOne((Wrapper)datasourceWrapper, false);
        boolean hasScripts = false;
        if (HussarUtils.isNotEmpty((Object)sysTenantDatasource)) {
            String dbUrl = sysTenantDatasource.getJdbcUrl();
            String dbType = DbUtil.getDbType((String)dbUrl);
            try {
                Object[] upgradeExecuteSqlScripts = DatabaseFactory.get((String)dbType).getUpgradeExecuteSQLScripts();
                hasScripts = HussarUtils.isNotEmpty((Object[])upgradeExecuteSqlScripts);
                if (hasScripts) {
                    hasScripts = this.executeAndRecordTenantSqlScript(serviceName, sysTenantUpgrade, tenant, connName, hasScripts, dbType, (Resource[])upgradeExecuteSqlScripts);
                }
            }
            catch (Exception e) {
                sysTenantUpgrade.setUpdateStatus(UPGRADE_FAIL_STATUS);
                sysTenantUpgrade.setUpdateError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
                LOGGER.error("\u5347\u7ea7\u670d\u52a1\u3010" + serviceName + "\u3011- \u79df\u6237\uff1a" + tenant.getTenantCode() + "\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            }
            if (hasScripts) {
                this.saveOrUpdate((BaseEntity)sysTenantUpgrade);
            }
        }
    }

    private void checkResource(Resource resource, String sqlPath) throws IOException {
        String updateScript = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        boolean check = StringUtils.isNotBlank((CharSequence)updateScript);
        if (!check) {
            throw new BaseException("\u8bf7\u68c0\u67e5classpath:" + sqlPath + "\u8def\u5f84\u4e0b\u5347\u7ea7\u811a\u672c\u662f\u5426\u6b63\u786e");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncUpdateSingleOne(SysTenantUpgrade sysTenantUpgrade, SysTenant tenant) {
        String connName = tenant.getConnName();
        sysTenantUpgrade.setTenantCode(tenant.getTenantCode());
        sysTenantUpgrade.setTenantId(tenant.getId());
        sysTenantUpgrade.setConnName(connName);
        sysTenantUpgrade.setServiceName("");
        LambdaQueryWrapper datasourceWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasource::getConnName, (Object)connName);
        new LambdaQueryWrapper().eq(SysTenantDatasource::getConnName, (Object)connName);
        SysTenantDatasource sysTenantDatasource = (SysTenantDatasource)this.sysTenantDataSourceService.getOne((Wrapper)datasourceWrapper, false);
        boolean hasScripts = false;
        if (HussarUtils.isNotEmpty((Object)sysTenantDatasource)) {
            String dbUrl = sysTenantDatasource.getJdbcUrl();
            String dbType = DbUtil.getDbType((String)dbUrl);
            try {
                Object[] upgradeExecuteSqlScripts = DatabaseFactory.get((String)dbType).getUpgradeExecuteSQLScripts();
                hasScripts = HussarUtils.isNotEmpty((Object[])upgradeExecuteSqlScripts);
                if (hasScripts) {
                    hasScripts = this.executeAndRecordTenantSqlScript("", sysTenantUpgrade, tenant, connName, hasScripts, dbType, (Resource[])upgradeExecuteSqlScripts);
                }
            }
            catch (Exception e) {
                sysTenantUpgrade.setUpdateStatus(UPGRADE_FAIL_STATUS);
                sysTenantUpgrade.setUpdateError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
                LOGGER.error("\u5347\u7ea7" + tenant.getTenantCode() + "\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            }
            finally {
                if (hasScripts) {
                    this.saveOrUpdate((BaseEntity)sysTenantUpgrade);
                }
            }
        }
    }

    private boolean executeAndRecordTenantSqlScript(String serviceName, SysTenantUpgrade sysTenantUpgrade, SysTenant tenant, String connName, boolean hasScripts, String dbType, Resource[] upgradeExecuteSqlScripts) throws Exception {
        QuerySysTenantSqlDto querySysTenantSqlDto = new QuerySysTenantSqlDto();
        querySysTenantSqlDto.setTenantId(tenant.getId());
        querySysTenantSqlDto.setServiceName(serviceName);
        String currentSqlPath = this.sysTenantSqlService.getCurrentSqlPath(querySysTenantSqlDto);
        int i = 0;
        for (Resource resource : upgradeExecuteSqlScripts) {
            boolean isAdd;
            String uri = resource.getURI().toString();
            String sqlPath = uri.substring(uri.indexOf("tenantsql"));
            this.checkResource(resource, sqlPath);
            if (currentSqlPath.compareTo(sqlPath) >= 0) continue;
            ++i;
            SysTenantSql sysTenantSql = (SysTenantSql)this.sysTenantSqlService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantSql::getTenantId, (Object)tenant.getId())).eq(SysTenantSql::getSqlPath, (Object)sqlPath)).eq(SysTenantSql::getServiceName, (Object)serviceName));
            boolean bl = isAdd = sysTenantSql == null;
            if (isAdd) {
                sysTenantSql = new SysTenantSql();
            }
            sysTenantSql.setConnName(connName);
            sysTenantSql.setTenantId(tenant.getId());
            sysTenantSql.setTenantCode(tenant.getTenantCode());
            sysTenantSql.setServiceName(serviceName);
            sysTenantSql.setSqlPath(sqlPath);
            this.hussarBaseSqlExecutor.execTenantSqlFile(connName, dbType, resource, true);
            sysTenantSql.setExecuteStatus("1");
            sysTenantSql.setErrorMsg("");
            if (isAdd) {
                this.sysTenantSqlService.save((Object)sysTenantSql);
                continue;
            }
            this.sysTenantSqlService.updateById((Object)sysTenantSql);
        }
        if (i == 0) {
            hasScripts = false;
            if (StringUtils.isNotBlank((CharSequence)serviceName)) {
                LOGGER.info("\u79df\u6237:{},\u5fae\u670d\u52a1:{}\u6ca1\u6709\u9700\u8981\u5347\u7ea7\u7684\u811a\u672c", (Object)tenant.getTenantCode(), (Object)serviceName);
            } else {
                LOGGER.info("\u79df\u6237{}\u6ca1\u6709\u9700\u8981\u5347\u7ea7\u7684\u811a\u672c", (Object)tenant.getTenantCode());
            }
        }
        sysTenantUpgrade.setUpdateStatus("1");
        return hasScripts;
    }

    private void asyncUpdateSingle(List<SysTenant> list) {
        for (SysTenant tenant : list) {
            SysTenantUpgrade sysTenantUpgrade = new SysTenantUpgrade();
            this.asyncUpdateSingleOne(sysTenantUpgrade, tenant);
        }
    }

    private void checkHasTenant() {
        List list = this.sysTenantService.list((Wrapper)new LambdaQueryWrapper().ne(SysTenant::getTenantStatus, (Object)UPGRADE_FAIL_STATUS));
        if (HussarUtils.isEmpty((Object)list)) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u79df\u6237\uff01");
        }
    }

    public IPage<SysTenantUpgradeVo> upgradeList(TenantUpgradeQueryConditionDto tenantUpgradeQueryConditionDto) {
        String tenantCode_ = tenantUpgradeQueryConditionDto.getTenantCode();
        tenantUpgradeQueryConditionDto.setTenantCode(SqlQueryUtil.transferSpecialChar((String)tenantCode_));
        String currentVersion = CoreVersion.getFrameworkVersion();
        Page pager = HussarPageUtils.convert((PageInfo)new PageInfo(tenantUpgradeQueryConditionDto.getCurrent(), tenantUpgradeQueryConditionDto.getSize()));
        Page<SysTenantUpgradeVo> resultPage = this.sysTenantUpgradeMapper.getTenantUpgradeList((Page<SysTenantUpgradeVo>)pager, tenantUpgradeQueryConditionDto);
        List records = resultPage.getRecords();
        List tenantCodeList = records.stream().map(SysTenantUpgradeVo::getTenantCode).collect(Collectors.toList());
        if (HussarUtils.isEmpty(tenantCodeList)) {
            return resultPage;
        }
        Map sysTenantStatusMap = ((LambdaQueryChainWrapper)this.sysTenantUpgradeRecordService.lambdaQuery().in(SysTenantUpgradeRecord::getTenantCode, tenantCodeList)).list().stream().collect(Collectors.groupingBy(SysTenantUpgradeRecord::getTenantCode, Collectors.mapping(SysTenantUpgradeRecord::getUpdateStatus, Collectors.toSet())));
        LinkedHashMap<String, String> sysTenantVersionMap = new LinkedHashMap<String, String>();
        for (SysTenantUpgradeVo record : records) {
            sysTenantVersionMap.put(record.getTenantCode(), record.getTenantVersion());
        }
        for (SysTenantUpgradeVo record : records) {
            String tenantCode = record.getTenantCode();
            Set upgradeStatusSet = sysTenantStatusMap.getOrDefault(tenantCode, new HashSet());
            upgradeStatusSet.removeIf("1"::equals);
            boolean canUpgrade = upgradeStatusSet.isEmpty() && !currentVersion.equals(record.getTenantVersion()) && HussarUtils.isNotEmpty(sysTenantVersionMap.get(tenantCode));
            record.setCanUpgrade(Boolean.valueOf(canUpgrade));
        }
        return resultPage;
    }

    public Integer getMaxByTenantCode(String tenantCode) {
        Integer max = this.sysTenantUpgradeMapper.getMaxByTenantCode(tenantCode);
        if (null == max || max < 1) {
            return 1;
        }
        return max;
    }

    public IPage<SysTenantUpgrade> tenantUpgradeLogs(TenantUpgradeQueryConditionDto tenantUpgradeQueryConditionDto) {
        Long tenantId = ((SysTenant)((LambdaQueryChainWrapper)this.sysTenantService.lambdaQuery().eq(SysTenant::getTenantCode, (Object)tenantUpgradeQueryConditionDto.getTenantCode())).one()).getId();
        String upgradeFromVersion = ((SysTenantUpgradeRecord)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysTenantUpgradeRecordService.lambdaQuery().eq(SysTenantUpgradeRecord::getTenantCode, (Object)tenantUpgradeQueryConditionDto.getTenantCode())).orderByDesc(HussarBaseEntity::getCreateTime)).list().get(0)).getFromVersion();
        SysTenantUpgradeCountDto sysTenantUpgradeCountDto = new SysTenantUpgradeCountDto();
        sysTenantUpgradeCountDto.setFromVersion(upgradeFromVersion);
        sysTenantUpgradeCountDto.setTenantId(tenantId);
        int start = this.getUpgradeStep(sysTenantUpgradeCountDto);
        Page pager = HussarPageUtils.convert((PageInfo)new PageInfo(tenantUpgradeQueryConditionDto.getCurrent(), tenantUpgradeQueryConditionDto.getSize()));
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)this.lambdaQuery().getWrapper().eq(SysTenantUpgrade::getTenantCode, (Object)tenantUpgradeQueryConditionDto.getTenantCode())).orderByAsc(SysTenantUpgrade::getUpgradeStep);
        if (!tenantUpgradeQueryConditionDto.getShowAll().booleanValue()) {
            wrapper.ge(SysTenantUpgrade::getUpgradeStep, (Object)start);
        }
        return this.page((IPage)pager, (Wrapper)wrapper);
    }

    public String upgradeStatus(TenantUpgradeEnhanceDto tenantUpgradeEnhanceDto) {
        List tenantlist;
        String currentVersion = CoreVersion.getFrameworkVersion();
        List noUpgradingAndFailInAll = (List)HussarCacheUtil.get((String)"CAN_UPGRADE_IN_ALL", (Object)tenantUpgradeEnhanceDto.getSelectType());
        if ("1".equals(tenantUpgradeEnhanceDto.getSelectType())) {
            tenantlist = tenantUpgradeEnhanceDto.getTenantCodes();
        } else if (HussarUtils.isNotEmpty((Object)noUpgradingAndFailInAll)) {
            tenantlist = noUpgradingAndFailInAll.stream().filter(sysTenant -> !currentVersion.equals(sysTenant.getTenantVersion())).map(HussarTenantDefinition::getTenantCode).collect(Collectors.toList());
        } else {
            return UPGRADE_FAIL_STATUS;
        }
        LOGGER.info("====================\u5f53\u524d\u5347\u7ea7\u79df\u6237\uff1a{}====================", (Object)tenantlist);
        Set sysTenantRecordSet = ((LambdaQueryChainWrapper)this.sysTenantUpgradeRecordService.lambdaQuery().in(SysTenantUpgradeRecord::getTenantCode, (Collection)tenantlist)).list().stream().map(SysTenantUpgradeRecord::getUpdateStatus).collect(Collectors.toSet());
        if (sysTenantRecordSet.contains(UPGRADE_FAIL_STATUS)) {
            HussarCacheUtil.evict((String)"CAN_UPGRADE_IN_ALL", (Object)tenantUpgradeEnhanceDto.getSelectType());
            return UPGRADE_FAIL_STATUS;
        }
        if (sysTenantRecordSet.contains(UPGRADING_STATUS)) {
            return UPGRADING_STATUS;
        }
        HussarCacheUtil.evict((String)"CAN_UPGRADE_IN_ALL", (Object)tenantUpgradeEnhanceDto.getSelectType());
        return "1";
    }

    public UpgradeVersionVo getUpgradeVersions(TenantUpgradeEnhanceDto tenantUpgradeEnhanceDto) {
        UpgradeVersionVo upgradeVersionVo = new UpgradeVersionVo();
        List sysTenantList = ((LambdaQueryChainWrapper)this.sysTenantService.lambdaQuery().in("1".equals(tenantUpgradeEnhanceDto.getSelectType()), SysTenant::getTenantCode, (Collection)tenantUpgradeEnhanceDto.getTenantCodes())).list();
        if (!this.existCanUpgradeTenants(sysTenantList).booleanValue()) {
            upgradeVersionVo.setWarnMsg("\u6240\u6709\u79df\u6237\u5747\u4e0d\u53ef\u5347\u7ea7");
            return upgradeVersionVo;
        }
        Set tenantVersionSet = sysTenantList.stream().map(SysTenant::getTenantVersion).collect(Collectors.toSet());
        String currentVersion = CoreVersion.getFrameworkVersion();
        tenantVersionSet.remove(currentVersion);
        LinkedHashMap tenantVersionOrderMap = new LinkedHashMap(this.upgradeJsonLoadService.getVersionOrderMap());
        tenantVersionOrderMap.keySet().retainAll(tenantVersionSet);
        int maxOrder = (Integer)tenantVersionOrderMap.values().stream().max(Integer::compareTo).orElseThrow(() -> new BaseException("\u79df\u6237\u5f85\u5347\u7ea7\u7248\u672c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u5347\u7ea7\u914d\u7f6e\uff01"));
        ArrayList updateVersionSelectorList = new ArrayList();
        LinkedHashMap upgradeVersionOrderMap = new LinkedHashMap(this.upgradeJsonLoadService.getVersionOrderMap());
        upgradeVersionOrderMap.entrySet().stream().filter(entry -> (Integer)entry.getValue() > maxOrder).sorted(Map.Entry.comparingByValue()).forEach(entry -> {
            UpgradeVersionSelector upgradeVersionLabelValue = new UpgradeVersionSelector();
            upgradeVersionLabelValue.setLabel((String)entry.getKey());
            upgradeVersionLabelValue.setValue((String)entry.getKey());
            updateVersionSelectorList.add(upgradeVersionLabelValue);
        });
        upgradeVersionVo.setUpgradeVersionLableValueList(updateVersionSelectorList);
        return upgradeVersionVo;
    }

    private Boolean existCanUpgradeTenants(List<SysTenant> sysTenantList) {
        String currentVersion = CoreVersion.getFrameworkVersion();
        List notLatestVersionTenantList = sysTenantList.stream().filter(sysTenant -> HussarUtils.isNotEmpty((Object)sysTenant.getTenantVersion())).filter(sysTenant -> !currentVersion.equals(sysTenant.getTenantVersion())).collect(Collectors.toList());
        if (HussarUtils.isEmpty(notLatestVersionTenantList)) {
            return false;
        }
        sysTenantList.retainAll(notLatestVersionTenantList);
        List notLatestVersionTenantCodeList = notLatestVersionTenantList.stream().map(SysTenant::getTenantCode).collect(Collectors.toList());
        Map tenantUpgradeStatusMap = ((LambdaQueryChainWrapper)this.sysTenantUpgradeRecordService.lambdaQuery().in(SysTenantUpgradeRecord::getTenantCode, notLatestVersionTenantCodeList)).list().stream().collect(Collectors.groupingBy(SysTenantUpgradeRecord::getTenantCode, Collectors.mapping(SysTenantUpgradeRecord::getUpdateStatus, Collectors.toSet())));
        List upgradingOrFailTenantCodes = tenantUpgradeStatusMap.entrySet().stream().filter(tenantUpgradeStatusMapEntry -> ((Set)tenantUpgradeStatusMapEntry.getValue()).contains(UPGRADE_FAIL_STATUS) || ((Set)tenantUpgradeStatusMapEntry.getValue()).contains(UPGRADING_STATUS)).map(Map.Entry::getKey).collect(Collectors.toList());
        List upgradingOrFailTenantList = sysTenantList.stream().filter(sysTenant -> upgradingOrFailTenantCodes.contains(sysTenant.getTenantCode())).collect(Collectors.toList());
        sysTenantList.removeAll(upgradingOrFailTenantList);
        return !sysTenantList.isEmpty();
    }

    public Boolean updateBatchTenantUpgrade(List<SysTenantUpgrade> tenantUpgradeList) {
        return this.updateBatchById(tenantUpgradeList);
    }

    public Boolean updateTenantUpgrade(SysTenantUpgrade sysTenantUpgrade) {
        return this.updateById((BaseEntity)sysTenantUpgrade);
    }

    public long countNeSuccess(SysTenantUpgradeCountDto sysTenantUpgradeCountDto) {
        Long tenantId = sysTenantUpgradeCountDto.getTenantId();
        Integer start = sysTenantUpgradeCountDto.getStart();
        LambdaQueryWrapper upgradewrapper = new LambdaQueryWrapper();
        upgradewrapper.eq(SysTenantUpgrade::getTenantId, (Object)tenantId);
        upgradewrapper.ge(SysTenantUpgrade::getUpgradeStep, (Object)start);
        upgradewrapper.ne(SysTenantUpgrade::getUpdateStatus, (Object)"1");
        return this.count((Wrapper)upgradewrapper);
    }

    public long countFail(SysTenantUpgradeCountDto sysTenantUpgradeCountDto) {
        Long tenantId = sysTenantUpgradeCountDto.getTenantId();
        Integer start = sysTenantUpgradeCountDto.getStart();
        LambdaQueryWrapper upgradewrapper = new LambdaQueryWrapper();
        upgradewrapper.eq(SysTenantUpgrade::getTenantId, (Object)tenantId);
        upgradewrapper.ge(SysTenantUpgrade::getUpgradeStep, (Object)start);
        upgradewrapper.eq(SysTenantUpgrade::getUpdateStatus, (Object)UPGRADE_FAIL_STATUS);
        return this.count((Wrapper)upgradewrapper);
    }

    public Integer getUpgradeStep(SysTenantUpgradeCountDto sysTenantUpgradeCountDto) {
        String nextVersion = this.upgradeJsonLoadService.getNextVersion(sysTenantUpgradeCountDto.getFromVersion());
        Integer result = this.sysTenantUpgradeMapper.getUpgradeStep(sysTenantUpgradeCountDto.getTenantId(), nextVersion);
        if (result == null) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u7248\u672c\u53f7\u4e3a" + nextVersion + "\u7684\u5347\u7ea7\u6b65\u9aa4");
        }
        return result;
    }
}

