/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.tenant.common.dao.SysTenantUpgradeMapper;
import com.jxdinfo.hussar.tenant.common.dto.TenantUpgradeEnhanceDto;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgrade;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeCheckService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service(value="com.jxdinfo.hussar.tenant.service.impl.SysTenantUpgradeCheckServiceImpl")
public class SysTenantUpgradeCheckServiceImpl
implements ISysTenantUpgradeCheckService {
    private static final String UPGRADE_SELECT_TYPE_SOME = "1";
    private static final String UPGRADE_SELECT_TYPE_ALL = "2";
    @Autowired
    private ISysTenantService sysTenantService;
    @Resource
    private SysTenantUpgradeMapper sysTenantUpgradeMapper;

    public List<HussarTenantDefinition> checkUpgrade(TenantUpgradeEnhanceDto tenantUpgradeEnhanceDto) {
        Set<String> noNeeedUpgradeSet;
        List tenantCodes = tenantUpgradeEnhanceDto.getTenantCodes();
        String selectType = tenantUpgradeEnhanceDto.getSelectType();
        String toVersion = tenantUpgradeEnhanceDto.getToVersion();
        List<Object> tenantList = new ArrayList<HussarTenantDefinition>();
        List sysTenantUpgradeList = new ArrayList();
        ArrayList<String> statusList = new ArrayList<String>(2);
        statusList.add("0");
        statusList.add(UPGRADE_SELECT_TYPE_ALL);
        if (UPGRADE_SELECT_TYPE_SOME.equals(selectType)) {
            if (HussarUtils.isEmpty((Object)tenantCodes)) {
                // empty if block
            }
            for (String tenantCode : tenantCodes) {
                HussarTenantDefinition tenantByTenantCode = this.sysTenantService.getTenantByTenantCode(tenantCode);
                tenantList.add(tenantByTenantCode);
            }
            sysTenantUpgradeList = this.sysTenantUpgradeMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysTenantUpgrade::getTenantCode, (Collection)tenantCodes)).in(SysTenantUpgrade::getUpdateStatus, statusList));
        } else if (UPGRADE_SELECT_TYPE_ALL.equals(selectType)) {
            Map normalTenants = this.sysTenantService.getNormalTenants();
            tenantList.addAll(normalTenants.values().stream().filter(i -> !i.getTenantCode().equals("0")).collect(Collectors.toList()));
            sysTenantUpgradeList = this.sysTenantUpgradeMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysTenantUpgrade::getUpdateStatus, statusList));
        }
        if (HussarUtils.isNotEmpty(sysTenantUpgradeList)) {
            Set errorTenantCodeSet = sysTenantUpgradeList.stream().map(item -> item.getTenantCode()).collect(Collectors.toSet());
            if (!UPGRADE_SELECT_TYPE_SOME.equals(selectType)) {
                Set finalErrorTenantCodeSet = errorTenantCodeSet;
                tenantList = tenantList.stream().filter(i -> !finalErrorTenantCodeSet.contains(i.getTenantCode())).collect(Collectors.toList());
            }
        }
        if (HussarUtils.isNotEmpty(noNeeedUpgradeSet = this.getNoNeedUpgrade(toVersion, tenantList)) && !UPGRADE_SELECT_TYPE_SOME.equals(selectType)) {
            Set<String> finalNoNeeedUpgradeSet = noNeeedUpgradeSet;
            tenantList = tenantList.stream().filter(i -> !finalNoNeeedUpgradeSet.contains(i.getTenantCode())).collect(Collectors.toList());
        }
        return tenantList;
    }

    @NotNull
    private Set<String> getNoNeedUpgrade(String toVersion, List<HussarTenantDefinition> tenantList) {
        HashSet<String> noNeeedUpgradeSet = new HashSet<String>();
        for (HussarTenantDefinition hussarTenantDefinition : tenantList) {
            String tenantVersion = hussarTenantDefinition.getTenantVersion();
            if (!StringUtils.isBlank((CharSequence)tenantVersion)) continue;
            noNeeedUpgradeSet.add(hussarTenantDefinition.getTenantCode());
        }
        return noNeeedUpgradeSet;
    }
}

