/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgrade;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgradeRecord;
import com.jxdinfo.hussar.tenant.common.service.IHussarRetryEnhanceService;
import com.jxdinfo.hussar.tenant.common.service.IOutSideExecuteStepListService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantExecuteStepListService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service(value="com.jxdinfo.hussar.tenant.common.service.impl.HussarRetryEnhanceServiceImpl")
public class HussarRetryEnhanceServiceImpl
implements IHussarRetryEnhanceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarRetryEnhanceServiceImpl.class);
    @Autowired
    private ISysTenantUpgradeService sysTenantUpgradeService;
    @Autowired
    private ISysTenantUpgradeRecordService sysTenantUpgradeRecordService;
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Autowired(required=false)
    private IOutSideExecuteStepListService outSideExecuteStepListService;
    @Autowired
    private ISysTenantExecuteStepListService sysTenantExecuteStepListService;
    private static Map<String, String> statusMap = new HashMap<String, String>();

    public void replay(String tenantCode) {
        statusMap.put(tenantCode, "2");
        boolean isEnableMicroService = EnvironmentUtil.isMicroService();
        LOGGER.info("\u5f53\u524d\u73af\u5883\uff1a{}", (Object)(isEnableMicroService ? "\u5fae\u670d\u52a1" : "\u5355\u4f53"));
        if (isEnableMicroService) {
            this.upgradeMicroService(tenantCode, statusMap);
        } else {
            this.upgradeSingle(tenantCode, statusMap);
        }
    }

    public String getUpgradeStatus(String tenantCode) {
        return statusMap.get(tenantCode);
    }

    private void upgradeSingle(String tenantCode, Map<String, String> statusMap) {
        List sysTenantUpgradeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysTenantUpgradeService.lambdaQuery().eq(SysTenantUpgrade::getTenantCode, (Object)tenantCode)).ne(SysTenantUpgrade::getUpdateStatus, (Object)"1")).orderByAsc(SysTenantUpgrade::getUpgradeStep)).list();
        if (HussarUtils.isEmpty((Object)sysTenantUpgradeList)) {
            return;
        }
        Executor asyncExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        asyncExecutor.execute(() -> {
            this.sysTenantExecuteStepListService.executeBatch(sysTenantUpgradeList);
            SysTenantUpgradeRecord record = this.sysTenantUpgradeRecordService.getLatestRecord(tenantCode);
            if (null != record) {
                statusMap.put(tenantCode, record.getUpdateStatus());
            }
        });
    }

    private void upgradeMicroService(String tenantCode, Map<String, String> statusMap) {
        Map<String, List> retryingUpgradesMap = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysTenantUpgradeService.lambdaQuery().eq(SysTenantUpgrade::getTenantCode, (Object)tenantCode)).ne(SysTenantUpgrade::getUpdateStatus, (Object)"1")).list().stream().collect(Collectors.groupingBy(SysTenantUpgrade::getServiceName, Collectors.collectingAndThen(Collectors.toList(), list -> {
            list.sort(Comparator.comparingInt(SysTenantUpgrade::getUpgradeStep));
            return list;
        })));
        Executor asyncExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        for (Map.Entry<String, List> retryingUpgradesEntry : retryingUpgradesMap.entrySet()) {
            asyncExecutor.execute(() -> {
                this.outSideExecuteStepListService.executeBatch((List)retryingUpgradesEntry.getValue(), (String)retryingUpgradesEntry.getKey());
                SysTenantUpgradeRecord record = this.sysTenantUpgradeRecordService.getLatestRecord(tenantCode);
                if (null != record) {
                    statusMap.put(tenantCode, record.getUpdateStatus());
                }
            });
        }
    }
}

