/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.controller;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.tenant.common.dto.AddTenantRegisterDto;
import com.jxdinfo.hussar.tenant.common.dto.EditTenantRegisterDto;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRegisterService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u79df\u6237\u670d\u52a1\u6ce8\u518c"})
@RestController(value="com.jxdinfo.hussar.tenant.common.controller.hussarBaseTenantServiceRegisterController")
@RequestMapping(value={"/hussarBase/tenant"})
public class HussarBaseTenantServiceRegisterController {
    @Autowired
    private ISysTenantRegisterService tenantRegisterService;

    @PostMapping(value={"/addTenantRegister"})
    @ApiOperation(value="\u79df\u6237\u670d\u52a1\u6ce8\u518c", notes="\u79df\u6237\u670d\u52a1\u6ce8\u518c")
    @AuditLog(moduleName="\u79df\u6237\u7ba1\u7406", eventDesc="\u79df\u6237\u670d\u52a1\u6ce8\u518c", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"hussarBase:tenant:addTenantRegister"})
    public ApiResponse<Boolean> addTenantRegister(@ApiParam(value="\u65b0\u589e\u79df\u6237\u670d\u52a1\u6ce8\u518cDTO") @RequestBody AddTenantRegisterDto addTenantRegisterDto) {
        this.checkMicroService();
        return ApiResponse.success((Object)this.tenantRegisterService.addTenantRegister(addTenantRegisterDto));
    }

    @PostMapping(value={"/editTenantRegister"})
    @ApiOperation(value="\u7f16\u8f91\u79df\u6237\u670d\u52a1", notes="\u7f16\u8f91\u79df\u6237\u670d\u52a1")
    @AuditLog(moduleName="\u79df\u6237\u7ba1\u7406", eventDesc="\u7f16\u8f91\u79df\u6237\u670d\u52a1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"hussarBase:tenant:editTenantRegister"})
    public ApiResponse<Boolean> editTenantRegister(@ApiParam(value="\u4fee\u6539\u79df\u6237\u670d\u52a1\u6ce8\u518cDTO") @RequestBody EditTenantRegisterDto editTenantRegisterDto) {
        this.checkMicroService();
        return ApiResponse.success((Object)this.tenantRegisterService.editTenantRegister(editTenantRegisterDto));
    }

    @PostMapping(value={"/checkDeleteTenantRegister"})
    @ApiOperation(value="\u5220\u9664\u79df\u6237\u670d\u52a1", notes="\u68c0\u67e5\u5220\u9664\u79df\u6237\u670d\u52a1")
    @AuditLog(moduleName="\u79df\u6237\u7ba1\u7406", eventDesc="\u5220\u9664\u79df\u6237\u670d\u52a1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> checkDeleteTenantRegister(@ApiParam(value="\u5220\u9664\u79df\u6237\u670d\u52a1\u6ce8\u518cDTO") @RequestBody Long id) {
        this.checkMicroService();
        return ApiResponse.success((String)this.tenantRegisterService.checkDeleteTenantRegister(id));
    }

    @PostMapping(value={"/deleteTenantRegister"})
    @ApiOperation(value="\u5220\u9664\u79df\u6237\u670d\u52a1", notes="\u5220\u9664\u79df\u6237\u670d\u52a1")
    @AuditLog(moduleName="\u79df\u6237\u7ba1\u7406", eventDesc="\u5220\u9664\u79df\u6237\u670d\u52a1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @CheckPermission(value={"hussarBase:tenant:deleteTenantRegister"})
    public ApiResponse<Boolean> deleteTenantRegister(@ApiParam(value="\u5220\u9664\u79df\u6237\u670d\u52a1\u6ce8\u518cDTO") @RequestBody Long id) {
        this.checkMicroService();
        return ApiResponse.success((Object)this.tenantRegisterService.deleteTenantRegister(id));
    }

    private void checkMicroService() {
        boolean microService = EnvironmentUtil.isMicroService();
        if (!microService) {
            throw new BaseException("\u975e\u5fae\u670d\u52a1\u73af\u5883\uff01");
        }
    }
}

