/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.config;

import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.support.thread.config.HussarTpProperties;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
@EnableAsync
@Import(value={HussarTpProperties.class})
@AutoConfigureBefore(value={HussarThreadPoolConfiguration.class})
public class HussarTenantAsyncConfiguration
extends HussarThreadPoolConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(HussarTenantAsyncConfiguration.class);

    public void beforeSubmit(Map<String, Object> parameters) {
        logger.debug("\u83b7\u53d6\u5f53\u524d\u79df\u6237\u4fe1\u606f\u3001\u8bf7\u6c42\u4fe1\u606f");
        String tcode = HussarContextHolder.getHussarTenant().getTenantCode();
        String connName = HussarContextHolder.getConnName();
        ServletRequestAttributes hussarServletRequestAttributes = HussarContextHolder.getNewServletRequestAttributes((String)tcode);
        parameters.put("tcode", tcode);
        parameters.put("connName", connName);
        parameters.put("hussarServletRequestAttributes", hussarServletRequestAttributes);
        Locale locale = LocaleContextHolder.getLocale();
        parameters.put("language", locale);
    }

    public void beforeExecute(Map<String, Object> parameters) {
        logger.debug("\u6267\u884c\u4e1a\u52a1\u903b\u8f91\u524d\u7ed1\u5b9a\u5f53\u524d\u79df\u6237\u4fe1\u606f\u3001\u8bf7\u6c42\u4fe1\u606f");
        String tcode = (String)parameters.get("tcode");
        String connName = (String)parameters.get("connName");
        ServletRequestAttributes hussarServletRequestAttributes = (ServletRequestAttributes)parameters.get("hussarServletRequestAttributes");
        HussarContextHolder.setTenant((String)connName, (String)tcode);
        RequestContextHolder.setRequestAttributes((RequestAttributes)hussarServletRequestAttributes);
        Locale locale = (Locale)parameters.get("language");
        Locale.setDefault(locale);
    }
}

