/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.UpdateInfoVo;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.crypto.properties.HussarEncryptProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.security.service.PasswordEncryptService;
import com.jxdinfo.hussar.tenant.common.dto.ResetTenantSecureDto;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantSecureService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import java.io.Serializable;
import java.util.Set;
import javax.annotation.Resource;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service(value="com.jxdinfo.hussar.tenant.common.service.impl.hussarBaseTenantSecureServiceImpl")
public class HussarBaseTenantSecureServiceImpl
implements IHussarBaseTenantSecureService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarBaseTenantSecureServiceImpl.class);
    @Resource
    private HussarEncryptProperties hussarEncryptProperties;
    @Resource
    private PasswordEncryptService passwordEncryptService;
    @Resource
    private Validator validator;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Autowired
    private ISysUsersService sysUsersService;
    @Lazy
    @Autowired(required=false)
    private ISysTenantService tenantService;
    @Resource
    private IHussarPwdConfigService hussarPwdConfigService;
    @Resource
    private ISysTenantRecordService tenantRecordService;

    private String validate(Object object) {
        Set validate = this.validator.validate(object, new Class[0]);
        if (HussarUtils.isNotEmpty((Object)validate)) {
            return ((ConstraintViolation)validate.iterator().next()).getMessage();
        }
        return null;
    }

    public UpdateInfoVo resetTenantPwd(ResetTenantSecureDto resetPwdDto) {
        String paramJson = JSON.toJSONString((Object)resetPwdDto);
        LOGGER.info("\u6267\u884c\u79df\u6237\u5bc6\u7801\u91cd\u7f6e,\u53c2\u6570\uff1a{}", (Object)paramJson);
        String validateMsg = this.validate(resetPwdDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        Long tenantId = resetPwdDto.getTenantId();
        SysTenant sysTenant = (SysTenant)this.tenantService.getById((Serializable)tenantId);
        String connName = sysTenant.getConnName();
        String adminPwd = StringUtils.trimToEmpty((String)resetPwdDto.getSuperSecure());
        String newPwd = StringUtils.trimToEmpty((String)resetPwdDto.getTenantSecure());
        String cPwd = StringUtils.trimToEmpty((String)resetPwdDto.getTenantSecureRepeat());
        if (this.hussarEncryptProperties.isEnablePwEncryption()) {
            adminPwd = this.passwordEncryptService.decrypt(adminPwd);
            newPwd = this.passwordEncryptService.decrypt(newPwd);
            cPwd = this.passwordEncryptService.decrypt(cPwd);
        }
        String aPwd = this.credentialsMatcher.passwordEncode(adminPwd.getBytes());
        SysTenantRecord sysTenantRecord = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantId, (Object)sysTenant.getId()));
        String oldSecure = null;
        if (HussarUtils.isNotEmpty((Object)sysTenantRecord)) {
            String paramStr = sysTenantRecord.getTenantParams();
            JSONObject paramObject = JSON.parseObject((String)paramStr);
            oldSecure = this.credentialsMatcher.passwordEncode(paramObject.getString("secure").getBytes());
        }
        UpdateInfoVo updateInfoVo = new UpdateInfoVo();
        if (!aPwd.equals(oldSecure)) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("resetFailPwdError");
            return updateInfoVo;
        }
        if (!newPwd.equals(cPwd)) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("resetFailPwdNotSame");
            return updateInfoVo;
        }
        String regular = this.hussarPwdConfigService.getPwdComplexityRegular().replace("/", "");
        String hint = this.hussarPwdConfigService.getUnmatchedHintMark();
        String unmatchedHint = this.hussarPwdConfigService.getUnmatchedHint();
        String pwdRule = this.hussarPwdConfigService.getPwdRule();
        if (!newPwd.matches(regular)) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("unmatchedHintMark");
            updateInfoVo.setPwdRule(pwdRule);
            updateInfoVo.setHintMark(hint);
            updateInfoVo.setMsg(unmatchedHint);
            return updateInfoVo;
        }
        String nPwd = this.credentialsMatcher.passwordEncode(newPwd.getBytes());
        this.sysUsersService.resetTenantPwd(connName, sysTenant.getTenantCode(), sysTenant.getTenantAdminId(), nPwd);
        updateInfoVo.setSuccess(true);
        if (HussarUtils.isNotEmpty((Object)sysTenantRecord)) {
            String paramStr = sysTenantRecord.getTenantParams();
            JSONObject paramObject = JSON.parseObject((String)paramStr);
            paramObject.put("secure", (Object)newPwd);
            sysTenantRecord.setTenantParams(JSON.toJSONString((Object)paramObject));
            this.tenantRecordService.updateById((Object)sysTenantRecord);
        }
        return updateInfoVo;
    }
}

