/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.CoreVersion;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.EntityUtils;
import com.jxdinfo.hussar.common.utils.ExceptionUtil;
import com.jxdinfo.hussar.common.utils.HussarReflectionUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.general.common.service.IHussarTenantConfigService;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.iam.client.dto.ClientDto;
import com.jxdinfo.hussar.iam.client.service.IHussarIamClientModelService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.tenant.common.factory.StorageFactory;
import com.jxdinfo.hussar.tenant.common.model.HussarMethod;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.MiddleStep;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.model.SysTenantSecure;
import com.jxdinfo.hussar.tenant.common.model.SysTenantSql;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgrade;
import com.jxdinfo.hussar.tenant.common.model.TenantDbModel;
import com.jxdinfo.hussar.tenant.common.model.TenantPermissionData;
import com.jxdinfo.hussar.tenant.common.service.IAsyncUpdateTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.ICheckMicroService;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.service.IOutSideCreateStorageService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantDataSourceService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRegisterService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantSecureService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantSqlService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantLogUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantUtil;
import com.jxdinfo.hussar.theme.config.service.IHussarThemeConfigService;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public abstract class AbstractHussarBaseTenantService<T extends HussarTenantDefinition>
implements IHussarBaseTenantService<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHussarBaseTenantService.class);
    @Lazy
    @Autowired(required=false)
    protected ISysTenantService tenantService;
    @Autowired
    protected ISysUserRoleService sysUserRoleService;
    @Autowired
    protected ISysRoleFunctionsService roleFunctionsService;
    @Autowired
    protected ISysRolesService sysRolesService;
    @Autowired
    protected ISysFunctionsService functionsService;
    @Autowired
    protected IHussarIamClientModelService iamClientModelService;
    @Autowired
    protected ISysTenantSecureService tenantSecureService;
    @Autowired
    protected ISysTenantLogService sysTenantLogService;
    @Autowired
    protected DynamicDatasourceService dynamicDatasourceService;
    @Autowired
    protected ISysResourcesService resourcesService;
    @Autowired
    protected ISysIdtableService sysIdtableService;
    @Autowired
    protected IHussarValidateService validateService;
    @Autowired
    protected ISysTenantDataSourceService sysTenantDataSourceService;
    @Autowired
    protected ISysRoleResourceService roleResourceService;
    @Autowired
    protected ISysTenantRecordService tenantRecordService;
    @Autowired
    protected ISysTenantUpgradeService sysTenantUpgradeService;
    @Autowired
    protected IAsyncUpdateTenantLogService asyncUpdateTenantLogService;
    @Autowired
    protected ISysTenantRegisterService sysTenantRegisterService;
    @Autowired
    protected HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Autowired
    protected ISysTenantSqlService sysTenantSqlService;
    @Autowired
    protected IHussarThemeConfigService iHussarThemeConfigService;

    protected abstract List<TenantDbModel> checkAndGetTenantDbModelList(T var1);

    protected abstract void createDbInSingleEnvironment(T var1, List<TenantDbModel> var2, HussarTenantDefinition var3, List<Map<String, Object>> var4, String var5);

    protected abstract void createDbInMicroServiceEnvironment(T var1, List<TenantDbModel> var2, HussarTenantDefinition var3, List<Map<String, Object>> var4, String var5, Map<String, TenantDbModel> var6);

    protected abstract List<MiddleStep> defineDynamicStep(T var1);

    protected abstract void executeStepFail(MiddleStep var1, T var2, List<TenantDbModel> var3);

    protected abstract void executeStepSuccess(int var1, T var2, List<TenantDbModel> var3);

    protected abstract boolean canExecute(int var1, T var2, List<TenantDbModel> var3);

    protected abstract Object[] getParamValues(int var1, T var2, List<TenantDbModel> var3);

    protected abstract void checkEditTenant(T var1);

    protected abstract void updateSpecificData(T var1, Collection<String> var2, List<TenantDbModel> var3);

    protected abstract void deleteSpecificData(SysTenant var1);

    public HussarTenantDefinition getTenantByTenantCode(String tenantCode) {
        return this.tenantService.getTenantByTenantCode(tenantCode);
    }

    public HussarTenantDefinition getTenantByTenantId(Long tenantId) {
        return this.tenantService.getTenantByTenantId(tenantId);
    }

    public HussarTenantDefinition getTenantByDomain(String domain) {
        return this.tenantService.getTenantByDomain(domain);
    }

    public ApiResponse<String> addTenant(T t) {
        Long tenantId = IdWorker.getId(t);
        t.setTenantId(tenantId);
        t.setTenantStatus("3");
        t.setTenantVersion(CoreVersion.getFrameworkVersion());
        if (EnvironmentUtil.isMicroService()) {
            try {
                ((ICheckMicroService)SpringContextHolder.getBean(ICheckMicroService.class)).checkHealthy();
            }
            catch (Exception e) {
                return ApiResponse.fail((String)e.getMessage());
            }
        }
        List<TenantDbModel> tenantDbModelList = null;
        try {
            tenantDbModelList = this.checkAndGetTenantDbModelList(t);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
        try {
            this.checkData(t);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
        TenantCacheUtil.putTenat2Cache(t);
        TenantCacheUtil.putTenantDataSourceCacheBatch(t);
        SysTenant sysTenant = TenantUtil.convert2SysTenant(t);
        this.tenantService.save((Object)sysTenant);
        LOGGER.info("\u521b\u5efa\u79df\u6237START{}", (Object)t.getTenantCode());
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        List<TenantDbModel> tenantDbModelListCopy = tenantDbModelList;
        if (hussarBaseTenantExecutor != null) {
            hussarBaseTenantExecutor.execute(() -> this.asyncAdd(t, tenantDbModelListCopy));
        }
        return ApiResponse.success((String)"\u79df\u6237\u521b\u5efa\u4e2d");
    }

    protected void checkDb(TenantDbModel dto) {
        String creation = dto.getCreation();
        SysDataSourceDto sysDataSourceDto = dto.getSysDataSourceDto();
        String jdbcUrl = sysDataSourceDto.getJdbcUrl();
        String userName = sysDataSourceDto.getUserName();
        String password = sysDataSourceDto.getPassword();
        this.checkDbConnection(creation, jdbcUrl, userName, password);
    }

    private void checkDbConnection(String creation, String jdbcUrl, String userName, String password) throws BaseException {
        String msg;
        block20: {
            msg = "";
            String className = "";
            try {
                className = DriverManager.getDriver(jdbcUrl).getClass().getName();
                Class.forName(className);
            }
            catch (Exception var5) {
                throw new BaseException("\u52a0\u8f7d\u9a71\u52a8\u7c7b" + className + "\u5931\u8d25");
            }
            try (Connection connection = DriverManager.getConnection(jdbcUrl, userName, password);){
                if (creation.equals("2")) {
                    ResultSet tables = connection.getMetaData().getTables(connection.getCatalog(), connection.getSchema(), null, new String[]{"TABLE"});
                    if (tables.next()) {
                        msg = "\u68c0\u6d4b\u5230\u81ea\u4e3b\u521b\u5efa\u3010" + jdbcUrl + "\u3011\u975e\u7a7a\u5e93\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u6570\u636e\u5e93\u540d\u79f0";
                    }
                } else {
                    msg = "\u6570\u636e\u6e90\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165";
                }
            }
            catch (Exception e) {
                if (!creation.equals("2")) break block20;
                msg = "\u79df\u6237\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new BaseException(msg);
        }
    }

    public void deleteTenant(Long tenantId) {
        AssertUtil.isNotNull((Object)tenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        SysTenant tenant = (SysTenant)this.tenantService.getById((Serializable)tenantId);
        AssertUtil.isNotNull((Object)tenant, (String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f");
        String tenantCode = tenant.getTenantCode();
        tenant.setTenantStatus("0");
        this.tenantService.updateById((Object)tenant);
        HussarTenantDefinition hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode);
        if (HussarUtils.isNotEmpty((Object)hussarTenantDefinition)) {
            hussarTenantDefinition.setTenantStatus("0");
            TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)hussarTenantDefinition);
        }
        try {
            LOGGER.info("\u5220\u9664\u79df\u6237\u5347\u7ea7\u65e5\u5fd7\u7b49\u4fe1\u606f");
            this.sysTenantLogService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode));
            this.tenantSecureService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantSecure::getTenantCode, (Object)tenantCode));
            this.sysTenantSqlService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantSql::getTenantCode, (Object)tenantCode));
            this.sysTenantUpgradeService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantUpgrade::getTenantCode, (Object)tenantCode));
            this.tenantRecordService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)tenantCode));
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u79df\u6237\u5347\u7ea7\u65e5\u5fd7\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        this.deleteSpecificData(tenant);
    }

    private void dealFail(String tenantCode) {
        SysTenant sysTenant = (SysTenant)this.tenantService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantCode, (Object)tenantCode));
        if (HussarUtils.isNotEmpty((Object)sysTenant)) {
            sysTenant.setTenantStatus("4");
            this.tenantService.updateById((Object)sysTenant);
            HussarTenantDefinition definition = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode);
            if (HussarUtils.isNotEmpty((Object)definition)) {
                definition.setTenantStatus("4");
                TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)definition);
            }
        }
    }

    public void asyncAdd(T t, List<TenantDbModel> tenantDbModelList) {
        String connName = t.getConnName();
        String currentServiceName = EnvironmentUtil.getServiceName();
        String tenantCode = t.getTenantCode();
        try {
            this.createDb(t, tenantDbModelList);
            LOGGER.info("\u521b\u5efa\u6570\u636e\u6e90{}\u5b8c\u6210", (Object)connName);
        }
        catch (Exception e) {
            this.dynamicDatasourceService.removeDynamicDatasource(connName);
            this.dealFail(tenantCode);
            LOGGER.info("\u521b\u5efa\u6570\u636e\u5b58\u50a8{}\u5931\u8d25", (Object)connName);
            throw e;
        }
        SysTenantLog beforeAddTenantLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(81));
        if (HussarUtils.isEmpty((Object)beforeAddTenantLog)) {
            beforeAddTenantLog = TenantLogUtil.newBeforeAddTenantLog(t);
        }
        try {
            this.beforeAddTenant(t);
            LOGGER.info("\u524d\u7f6e\u64cd\u4f5c\u5b8c\u6210");
            beforeAddTenantLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(beforeAddTenantLog);
        }
        catch (Exception e) {
            this.dealFail(tenantCode);
            beforeAddTenantLog.setExecStatus(Integer.valueOf(0));
            beforeAddTenantLog.setErrorTimes(Integer.valueOf(beforeAddTenantLog.getErrorTimes() + 1));
            beforeAddTenantLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(beforeAddTenantLog);
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)("0:\u6dfb\u52a0\u9879\u76ee\u4e4b\u524d\u7684\u64cd\u4f5c\u5931\u8d25" + e.getMessage()));
            LOGGER.error("\u6dfb\u52a0\u79df\u6237\u4e4b\u524d\u7684\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
        HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)"3:\u914d\u7f6e\u9879\u76ee\u7528\u6237\u3001\u6743\u9650\u7b49\u4fe1\u606f");
        this.executeMiddleStep(t, tenantDbModelList, currentServiceName, tenantCode);
        SysTenantLog saveTenantLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(88));
        if (HussarUtils.isEmpty((Object)saveTenantLog)) {
            saveTenantLog = TenantLogUtil.newSaveTenantLog(t);
        }
        try {
            this.saveTenant(t);
            LOGGER.info("\u4fdd\u5b58\u79df\u6237\u57fa\u7840\u4fe1\u606f\u5b8c\u6210");
            saveTenantLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(saveTenantLog);
        }
        catch (Exception e) {
            this.dealFail(tenantCode);
            saveTenantLog.setExecStatus(Integer.valueOf(0));
            saveTenantLog.setErrorTimes(Integer.valueOf(saveTenantLog.getErrorTimes() + 1));
            saveTenantLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(saveTenantLog);
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)("0:\u4fdd\u5b58\u9879\u76ee\u57fa\u7840\u4fe1\u606f\u5931\u8d25" + e.getMessage()));
            LOGGER.error("\u4fdd\u5b58\u79df\u6237\u57fa\u7840\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        SysTenantLog initialThemeLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(94));
        if (HussarUtils.isEmpty((Object)initialThemeLog)) {
            initialThemeLog = TenantLogUtil.newInitialThemeLog(t);
        }
        try {
            this.iHussarThemeConfigService.initialDefaultTheme(connName, t.getTenantCode());
            LOGGER.info("\u521d\u59cb\u5316\u79df\u6237\u4e3b\u9898\u5b8c\u6210");
            initialThemeLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initialThemeLog);
        }
        catch (Exception e) {
            this.dealFail(tenantCode);
            initialThemeLog.setExecStatus(Integer.valueOf(0));
            initialThemeLog.setErrorTimes(Integer.valueOf(initialThemeLog.getErrorTimes() + 1));
            initialThemeLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initialThemeLog);
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)("0:\u521d\u59cb\u5316\u79df\u6237\u4e3b\u9898\u5931\u8d25" + e.getMessage()));
            LOGGER.error("\u521d\u59cb\u5316\u79df\u6237\u4e3b\u9898\u5931\u8d25", (Throwable)e);
        }
        SysTenantLog afterAddTenantLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(150));
        if (HussarUtils.isEmpty((Object)afterAddTenantLog)) {
            afterAddTenantLog = TenantLogUtil.newAfterAddTenantLog(t);
        }
        try {
            this.afterAddTenant(t);
            LOGGER.info("\u540e\u7f6e\u64cd\u4f5c\u5b8c\u6210");
            afterAddTenantLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(afterAddTenantLog);
        }
        catch (Exception e) {
            this.dealFail(tenantCode);
            afterAddTenantLog.setExecStatus(Integer.valueOf(0));
            afterAddTenantLog.setErrorTimes(Integer.valueOf(saveTenantLog.getErrorTimes() + 1));
            afterAddTenantLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(afterAddTenantLog);
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)"0:\u6dfb\u52a0\u9879\u76ee\u4e4b\u540e\u7684\u64cd\u4f5c\u5931\u8d25");
            LOGGER.error("\u6dfb\u52a0\u79df\u6237\u4e4b\u540e\u7684\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
        this.updateTenantRecord(t);
        this.tenantService.updateTenantStatus(t.getTenantCode());
        HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)"4:\u9879\u76ee\u521b\u5efa\u5b8c\u6210\uff01");
    }

    private void updateTenantRecord(T t) {
        HussarTenantDefinition hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)t.getTenantCode());
        if (HussarUtils.isNotEmpty((Object)hussarTenantDefinition)) {
            List storagePropertiesList = hussarTenantDefinition.getStoragePropertiesList();
            for (Map temp : storagePropertiesList) {
                String serviceNameTemp = (String)temp.get("serviceName");
                serviceNameTemp = HussarUtils.isBlank((CharSequence)serviceNameTemp) ? "single" : serviceNameTemp;
                Map map = TenantCacheUtil.loadDatasourceFromCache((String)t.getTenantCode(), (String)serviceNameTemp);
                if (HussarUtils.isEmpty((Object)map)) continue;
                temp.putAll(map);
            }
            TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)hussarTenantDefinition);
            SysTenantRecord tenantRecord = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)hussarTenantDefinition.getTenantCode()));
            tenantRecord.setTenantParams(JSON.toJSONString((Object)hussarTenantDefinition));
            this.tenantRecordService.updateById((Object)tenantRecord);
        }
    }

    private void executeMiddleStep(T t, List<TenantDbModel> tenantDbModelList, String currentServiceName, String tenantCode) {
        List<MiddleStep> middleSteps = this.defineDynamicStep(t);
        for (MiddleStep step : middleSteps) {
            Integer stepNo = step.getStepNo();
            if (!this.canExecute(stepNo, t, tenantDbModelList)) continue;
            SysTenantLog tenantLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, stepNo);
            Object[] methodParamValues = this.getParamValues(stepNo, t, tenantDbModelList);
            if (HussarUtils.isEmpty((Object)tenantLog)) {
                tenantLog = TenantLogUtil.tenantLogOfStep((MiddleStep)step, t, (Object[])methodParamValues);
            }
            try {
                String beanName = tenantLog.getBeanName();
                String methodName = tenantLog.getMethodName();
                String getMethodParams = tenantLog.getMethodParams();
                HussarMethod hm = (HussarMethod)JSON.parseObject((String)getMethodParams, HussarMethod.class);
                HussarReflectionUtils.springInvokeMethod((String)beanName, (String)methodName, (Class[])hm.getParamClass(), (Object[])methodParamValues);
                this.executeStepSuccess(stepNo, t, tenantDbModelList);
                LOGGER.info("{}\u5b8c\u6210", (Object)tenantLog.getMethodDesc());
                tenantLog.setExecStatus(Integer.valueOf(1));
                this.asyncUpdateTenantLogService.tenantlogUpdate(tenantLog);
            }
            catch (Exception e) {
                this.dealFail(tenantCode);
                this.executeStepFail(step, t, tenantDbModelList);
                tenantLog.setExecStatus(Integer.valueOf(0));
                tenantLog.setErrorTimes(Integer.valueOf(tenantLog.getErrorTimes() + 1));
                tenantLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
                this.asyncUpdateTenantLogService.tenantlogUpdate(tenantLog);
                LOGGER.error(tenantLog.getMethodDesc() + "\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public void initTenantPermissionData(String connName) {
        List functionsList;
        List resourcesList = this.resourcesService.list(connName);
        if (HussarUtils.isNotEmpty((Object)resourcesList)) {
            this.buildRelationOfResource(connName, resourcesList);
        }
        if (HussarUtils.isNotEmpty((Object)(functionsList = this.functionsService.list(connName)))) {
            this.buildRelationOfFunction(connName, functionsList);
        }
        LOGGER.info("\u521d\u59cb\u5316\u79df\u6237\u6743\u9650\u5b8c\u6210");
    }

    private void buildRelationOfResource(String connName, Collection<SysResources> resourcesList) {
        ArrayList<SysRoleResource> roleResourceList = new ArrayList<SysRoleResource>();
        if (HussarUtils.isNotEmpty(resourcesList)) {
            for (SysResources resources : resourcesList) {
                SysRoleResource roleResource = new SysRoleResource();
                roleResource.setResourceId(resources.getId());
                roleResource.setRoleId(TenantConstant.ADMIN_ROLE);
                roleResource.setRelationSource("2");
                roleResourceList.add(roleResource);
            }
            this.roleResourceService.saveBatch(connName, roleResourceList);
        }
    }

    private void buildRelationOfFunction(String connName, Collection<SysFunctions> functionsList) {
        ArrayList<SysRoleFunctions> roleFunctionsList = new ArrayList<SysRoleFunctions>();
        if (HussarUtils.isNotEmpty(functionsList)) {
            for (SysFunctions function : functionsList) {
                SysRoleFunctions roleFunctions = new SysRoleFunctions();
                roleFunctions.setFunctionId(function.getId());
                roleFunctions.setRoleId(TenantConstant.ADMIN_ROLE);
                roleFunctionsList.add(roleFunctions);
            }
            this.roleFunctionsService.saveBatch(connName, roleFunctionsList);
        }
    }

    public void checkData(T t) {
        T definition = t;
        String tenantCode = definition.getTenantCode();
        long tenantId = definition.getTenantId();
        String validateMsg = this.validateService.validate(definition);
        if (StringUtils.isNotBlank((CharSequence)validateMsg)) {
            throw new BaseException(validateMsg);
        }
        Optional<SysTenant> anyTenantCode = this.tenantService.list().stream().filter(item -> item.getTenantCode().equalsIgnoreCase(tenantCode)).findAny();
        if (anyTenantCode.isPresent()) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u79df\u6237\u7f16\u7801\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
        }
        this.checkBaseTenantProperty(t);
        String connName = definition.getConnName();
        this.tenantRecordService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)tenantCode));
        SysTenantRecord sysTenantRecord = new SysTenantRecord();
        sysTenantRecord.setTenantId(Long.valueOf(tenantId));
        sysTenantRecord.setConnName(definition.getConnName());
        sysTenantRecord.setTenantCode(tenantCode);
        sysTenantRecord.setConnName(connName);
        sysTenantRecord.setTenantClass(t.getClass().getName());
        sysTenantRecord.setTenantParams(JSON.toJSONString(t));
        this.tenantRecordService.save((Object)sysTenantRecord);
    }

    protected void createDb(T t, List<TenantDbModel> tenantDbModelList) {
        T definition = t;
        List storagePropertiesList = definition.getStoragePropertiesList();
        boolean isMicroservice = EnvironmentUtil.isMicroService();
        String currentServiceName = EnvironmentUtil.getServiceName((boolean)isMicroservice);
        if (HussarUtils.isNotEmpty((Object)storagePropertiesList)) {
            HashMap<String, TenantDbModel> tenantDbModelMap = new HashMap<String, TenantDbModel>();
            for (TenantDbModel td : tenantDbModelList) {
                if (!StringUtils.isNotBlank((CharSequence)td.getServiceName())) continue;
                tenantDbModelMap.put(td.getServiceName(), td);
            }
            if (isMicroservice) {
                this.createDbInMicroServiceEnvironment(t, tenantDbModelList, (HussarTenantDefinition)definition, storagePropertiesList, currentServiceName, (Map<String, TenantDbModel>)tenantDbModelMap);
            } else {
                this.createDbInSingleEnvironment(t, tenantDbModelList, (HussarTenantDefinition)definition, storagePropertiesList, currentServiceName);
            }
        }
    }

    protected void createDbOfSingle(T t, List<TenantDbModel> tenantDbModelList, HussarTenantDefinition definition, List<Map<String, Object>> storagePropertiesList, String currentServiceName) {
        LOGGER.info("\u5f00\u59cb\u521b\u5efa\u6570\u636e\u5b58\u50a8");
        HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)"2:\u521d\u59cb\u5316\u9879\u76ee\u6570\u636e\u5e93\uff08\u6570\u636e\u5e93\u521d\u59cb\u5316\u65f6\u95f4\u8f83\u957f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u51e0\u5206\u949f\uff09");
        Map<String, Object> storageProperties = storagePropertiesList.get(0);
        String storageType = (String)storageProperties.get("storageType");
        storageProperties.put("tenantCode", definition.getTenantCode());
        storageProperties.put("connName", definition.getConnName());
        SysTenantLog createDb = this.getSysTenantCreateDbLog(t, currentServiceName, storageProperties, tenantDbModelList.get(0));
        try {
            StorageFactory.get((String)storageType).createDatabaseAndInitData(storageProperties, tenantDbModelList.get(0));
            SysTenantRecord recordTemp = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)definition.getTenantCode()), false);
            if (HussarUtils.isNotEmpty((Object)recordTemp)) {
                recordTemp.setTenantParams(JSON.toJSONString(t));
                this.tenantRecordService.updateById((Object)recordTemp);
            }
            createDb.setExecStatus(Integer.valueOf(1));
            TenantCacheUtil.putTenantDataSourceCache((String)t.getTenantCode(), storageProperties);
            this.asyncUpdateTenantLogService.tenantlogUpdate(createDb);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            createDb.setExecStatus(Integer.valueOf(0));
            createDb.setErrorTimes(Integer.valueOf(createDb.getErrorTimes() + 1));
            createDb.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(createDb);
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)("0:\u521b\u5efa\u6570\u636e\u5b58\u50a8\u51fa\u9519\uff01" + e.getMessage()));
            throw new BaseException("\u521b\u5efa\u6570\u636e\u5b58\u50a8\u51fa\u9519\uff01", (Throwable)e);
        }
    }

    protected void createDbOfMicroService(T t, List<TenantDbModel> tenantDbModelList, HussarTenantDefinition definition, List<Map<String, Object>> storagePropertiesList, String currentServiceName, Map<String, TenantDbModel> tenantDbModelMap) {
        LOGGER.info("\u5f00\u59cb\u521b\u5efa\u5fae\u670d\u52a1\u6570\u636e\u5b58\u50a8");
        ArrayList<Map<String, Object>> storagePropertiesListOther = new ArrayList<Map<String, Object>>();
        Map<String, Object> masterstorageProperties = new HashMap<String, Object>();
        masterstorageProperties = this.splitStoragePropertiesMap(storagePropertiesList, currentServiceName, storagePropertiesListOther, masterstorageProperties);
        TenantDbModel tenantDbModelMaster = tenantDbModelMap.get(currentServiceName);
        SysTenantLog createDb = this.getSysTenantCreateDbLog(t, currentServiceName, masterstorageProperties, tenantDbModelMaster);
        try {
            String storageType = (String)masterstorageProperties.get("storageType");
            if (HussarUtils.isBlank((CharSequence)storageType)) {
                storageType = "rdb";
            }
            StorageFactory.get((String)storageType).createDatabaseAndInitData(masterstorageProperties, tenantDbModelMaster);
            SysTenantRecord recordTemp = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)definition.getTenantCode()), false);
            if (HussarUtils.isNotEmpty((Object)recordTemp)) {
                recordTemp.setTenantParams(JSON.toJSONString(t));
                this.tenantRecordService.updateById((Object)recordTemp);
            }
            createDb.setExecStatus(Integer.valueOf(1));
            TenantCacheUtil.putTenantDataSourceCache((String)t.getTenantCode(), masterstorageProperties);
            this.asyncUpdateTenantLogService.tenantlogUpdate(createDb);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            createDb.setExecStatus(Integer.valueOf(0));
            createDb.setErrorTimes(Integer.valueOf(createDb.getErrorTimes() + 1));
            createDb.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(createDb);
            throw new BaseException("\u521b\u5efa\u5fae\u670d\u52a1\u6570\u636e\u5b58\u50a8\u51fa\u9519\uff01", (Throwable)e);
        }
        if (HussarUtils.isEmpty(storagePropertiesListOther)) {
            return;
        }
        IOutSideCreateStorageService outSideCreateStorageService = (IOutSideCreateStorageService)SpringContextHolder.getBean(IOutSideCreateStorageService.class);
        AssertUtil.isNotNull((Object)outSideCreateStorageService, (String)"\u83b7\u53d6IOutSideCreateStorageService\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5f15\u5165hussar-tenant-outside\u5305\uff01");
        int startNo = 11;
        this.saveMicroServiceTenantLog(t, tenantDbModelMap, storagePropertiesListOther, startNo);
        for (Map map : storagePropertiesListOther) {
            Boolean flag;
            String serviceName = (String)map.get("serviceName");
            try {
                IHussarTenantConfigService hussarTenantConfigService = (IHussarTenantConfigService)SpringContextHolder.getBean(IHussarTenantConfigService.class);
                flag = hussarTenantConfigService.checkTenant((String)map.get("serviceName"));
            }
            catch (Exception e) {
                LOGGER.error("\u6821\u9a8c\u5fae\u670d\u52a1{}\u662f\u5426\u5f00\u542f\u591a\u79df\u6237\u5931\u8d25", (Object)serviceName);
                String tenantCode = definition.getTenantCode();
                SysTenantLog updateLog = (SysTenantLog)this.sysTenantLogService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode)).eq(SysTenantLog::getServiceName, (Object)serviceName));
                AssertUtil.isNotNull((Object)updateLog, (String)("\u672a\u67e5\u8be2\u5230\u79df\u6237\u7f16\u7801\u4e3a" + tenantCode + ",\u5fae\u670d\u52a1\u540d\u79f0\u4e3a" + serviceName + "\u7684\u65e5\u5fd7\u4fe1\u606f\uff01"));
                updateLog.setExecStatus(Integer.valueOf(0));
                updateLog.setExecError("\u6821\u9a8c\u662f\u5426\u5f00\u542f\u591a\u79df\u6237\u5931\u8d25");
                updateLog.setErrorTimes(Integer.valueOf(updateLog.getErrorTimes() + 1));
                LOGGER.info("\u79df\u6237\u7f16\u7801={}\u5fae\u670d\u52a1\u540d\u79f0={}\u6267\u884c\u56de\u8c03\u66f4\u65b0\u65e5\u5fd7\u5b8c\u6bd5", (Object)tenantCode, (Object)serviceName);
                this.asyncUpdateTenantLogService.tenantlogUpdate(updateLog);
                continue;
            }
            if (flag.booleanValue()) {
                Optional<TenantDbModel> optionalTenantDbModel = tenantDbModelList.stream().filter(i -> i.isMicroservice() && i.getServiceName().equalsIgnoreCase(serviceName)).findFirst();
                if (!optionalTenantDbModel.isPresent()) continue;
                TenantDbModel tenantDbModel = optionalTenantDbModel.get();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("storageProperties", map);
                params.put("tenantDbModel", JSON.toJSONString((Object)tenantDbModel));
                outSideCreateStorageService.dealCreateStorage(params, serviceName);
                continue;
            }
            LOGGER.error("\u5fae\u670d\u52a1{}\u672a\u5f00\u542f\u591a\u79df\u6237\u6216\u672a\u5f15\u5165\u591a\u79df\u6237\u4f9d\u8d56", (Object)serviceName);
            String tenantCode = definition.getTenantCode();
            SysTenantLog updateLog = (SysTenantLog)this.sysTenantLogService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode)).eq(SysTenantLog::getServiceName, (Object)serviceName));
            AssertUtil.isNotNull((Object)updateLog, (String)("\u672a\u67e5\u8be2\u5230\u79df\u6237\u7f16\u7801\u4e3a" + tenantCode + ",\u5fae\u670d\u52a1\u540d\u79f0\u4e3a" + serviceName + "\u7684\u65e5\u5fd7\u4fe1\u606f\uff01"));
            updateLog.setExecStatus(Integer.valueOf(0));
            updateLog.setExecError("\u672a\u5f00\u542f\u591a\u79df\u6237\u6216\u672a\u5f15\u5165\u591a\u79df\u6237\u4f9d\u8d56");
            updateLog.setErrorTimes(Integer.valueOf(updateLog.getErrorTimes() + 1));
            LOGGER.info("\u79df\u6237\u7f16\u7801={}\u5fae\u670d\u52a1\u540d\u79f0={}\u6267\u884c\u56de\u8c03\u66f4\u65b0\u65e5\u5fd7\u5b8c\u6bd5", (Object)tenantCode, (Object)serviceName);
            this.asyncUpdateTenantLogService.tenantlogUpdate(updateLog);
        }
    }

    protected void saveMicroServiceTenantLog(T t, Map<String, TenantDbModel> tenantDbModelMap, List<Map<String, Object>> storagePropertiesListOther, int startNo) {
        ArrayList<SysTenantLog> serviceLogs = new ArrayList<SysTenantLog>();
        for (Map<String, Object> outSideStorageProperties : storagePropertiesListOther) {
            String serviceNameTemp = (String)outSideStorageProperties.get("serviceName");
            SysTenantLog createDbTemp = this.getSysTenantCreateDbLog(t, serviceNameTemp, outSideStorageProperties, tenantDbModelMap.get(serviceNameTemp));
            createDbTemp.setStepNo(Integer.valueOf(startNo++));
            serviceLogs.add(createDbTemp);
        }
        this.sysTenantLogService.saveBatch(serviceLogs);
    }

    protected Map<String, Object> splitStoragePropertiesMap(List<Map<String, Object>> storagePropertiesList, String currentServiceName, List<Map<String, Object>> storagePropertiesListOther, Map<String, Object> masterstorageProperties) {
        for (Map<String, Object> storageProperties : storagePropertiesList) {
            String serviceName = (String)storageProperties.get("serviceName");
            if (serviceName.equalsIgnoreCase(currentServiceName)) {
                masterstorageProperties = storageProperties;
                continue;
            }
            storagePropertiesListOther.add(storageProperties);
        }
        return masterstorageProperties;
    }

    protected SysTenantLog getSysTenantCreateDbLog(T t, String currentServiceName, Map<String, Object> masterstorageProperties, TenantDbModel tenantDbModel) {
        SysTenantLog createDb = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(2));
        if (HussarUtils.isEmpty((Object)createDb)) {
            createDb = TenantLogUtil.newCreateDbLog(t.getClass(), (String)t.getTenantCode(), (String)t.getConnName(), (String)currentServiceName, masterstorageProperties, (TenantDbModel)tenantDbModel);
        }
        return createDb;
    }

    public abstract void saveTenant(T var1);

    public void initTenantAdminRole(String connName, Long userId) {
        SysRoles adminRole = new SysRoles();
        adminRole.setId(TenantConstant.ADMIN_ROLE);
        adminRole.setRolePermission("ADMIN_ROLE");
        adminRole.setRoleName("\u7ba1\u7406\u5458\u89d2\u8272");
        adminRole.setRoleAlias("\u7ba1\u7406\u5458\u89d2\u8272");
        adminRole.setIsSys("1");
        adminRole.setGroupId(Long.valueOf(1450785135866925059L));
        adminRole.setRoleOrder(Integer.valueOf(10));
        this.sysRolesService.save(connName, (Object)adminRole);
        this.sysUserRoleService.saveUserRole(connName, userId);
    }

    public void initClientInfo(String connName, HussarTenantDefinition definition) throws BaseException {
        try {
            ClientDto clientDto = new ClientDto();
            long id = IdWorker.getId((Object)clientDto);
            clientDto.setId(Long.valueOf(id));
            clientDto.setClientId(String.valueOf(definition.getTenantId()));
            clientDto.setClientSecret(UUID.randomUUID().toString().replace("-", ""));
            clientDto.setAccessTokenValidTime(1800L);
            definition.setClientId(clientDto.getClientId());
            definition.setClientSecret(clientDto.getClientSecret());
            this.iamClientModelService.saveClientModels(connName, clientDto);
            SysTenantSecure sysTenantSecure = new SysTenantSecure();
            sysTenantSecure.setTenantId(definition.getTenantId());
            sysTenantSecure.setTenantCode(definition.getTenantCode());
            sysTenantSecure.setClientId(clientDto.getClientId());
            sysTenantSecure.setClientSecret(clientDto.getClientSecret());
            this.tenantSecureService.save((Object)sysTenantSecure);
            SysTenant tenant = TenantUtil.convert2SysTenant(definition);
            this.tenantService.updateById((Object)tenant);
            TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)definition);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public TenantPermissionData subtract(TenantPermissionData a, TenantPermissionData b) {
        TenantPermissionData ret = new TenantPermissionData();
        Collection afunctionModules = a.getFunctionModules();
        Collection afunctions = a.getFunctions();
        Collection aresourceModules = a.getResourceModules();
        Collection aresources = a.getResources();
        Collection amenus = a.getMenus();
        Collection afunctionResources = a.getFunctionResources();
        Collection bfunctionModules = b.getFunctionModules();
        Set bfunctionModuleIds = EntityUtils.toSet((Collection)bfunctionModules, SysFunctionModules::getId);
        Collection bfunctions = b.getFunctions();
        Set bfunctionIds = EntityUtils.toSet((Collection)bfunctions, SysFunctions::getId);
        Collection bresourceModules = b.getResourceModules();
        Set bresourceModuleIds = EntityUtils.toSet((Collection)bresourceModules, SysResourceModules::getId);
        Collection bresources = b.getResources();
        Set bresourceIds = EntityUtils.toSet((Collection)bresources, SysResources::getId);
        Collection bmenus = b.getMenus();
        Set bmenuIds = EntityUtils.toSet((Collection)bmenus, SysMenu::getId);
        Collection bfunctionResources = b.getFunctionResources();
        Set functionModules = afunctionModules.stream().filter(e -> !bfunctionModuleIds.contains(e.getId())).collect(Collectors.toSet());
        Set functions = afunctions.stream().filter(e -> !bfunctionIds.contains(e.getId())).collect(Collectors.toSet());
        Set resourceModules = aresourceModules.stream().filter(e -> !bresourceModuleIds.contains(e.getId())).collect(Collectors.toSet());
        Set resources = aresources.stream().filter(e -> !bresourceIds.contains(e.getId())).collect(Collectors.toSet());
        Set menus = amenus.stream().filter(e -> !bmenuIds.contains(e.getId())).collect(Collectors.toSet());
        HashSet<SysFunctionResources> functionResources = new HashSet<SysFunctionResources>();
        for (SysFunctionResources asysFunctionResources : afunctionResources) {
            for (SysFunctionResources bsysFunctionResources : bfunctionResources) {
                if (asysFunctionResources.getResourceId().equals(bsysFunctionResources.getResourceId()) && asysFunctionResources.getFunctionId().equals(bsysFunctionResources.getFunctionId())) continue;
                functionResources.add(asysFunctionResources);
            }
        }
        ret.setFunctions(functions);
        ret.setFunctionModules(functionModules);
        ret.setResources(resources);
        ret.setResourceModules(resourceModules);
        ret.setMenus(menus);
        ret.setFunctionResources(functionResources);
        return ret;
    }

    public void editTenant(T t) {
        this.checkEditTenant(t);
        boolean microService = EnvironmentUtil.isMicroService();
        if (microService) {
            ((ICheckMicroService)SpringContextHolder.getBean(ICheckMicroService.class)).checkHealthy();
        }
        String currentServiceName = EnvironmentUtil.getServiceName((boolean)microService);
        SysTenant tenant = TenantUtil.convert2SysTenant(t);
        LocalDateTime now = LocalDateTime.now();
        this.dealOverdueTenant(t, tenant, now);
        List storagePropertiesList = t.getStoragePropertiesList();
        List tenantDbModelList = this.sysTenantDataSourceService.ofTenant(t);
        List sysTenantLogs = this.sysTenantLogService.listByTenantCode(tenant.getTenantCode());
        Set<String> serviceNames = this.getServiceNames(sysTenantLogs);
        this.updateSpecificData(t, serviceNames, tenantDbModelList);
        SysTenantRecord recordTemp = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantId, (Object)tenant.getId()));
        if (HussarUtils.isNotEmpty((Object)recordTemp)) {
            recordTemp.setTenantParams(JSON.toJSONString(t));
            this.tenantRecordService.updateById((Object)recordTemp);
        }
        if (!microService) {
            return;
        }
        this.dealOtherMicroService(t, currentServiceName, tenant, storagePropertiesList, tenantDbModelList, serviceNames);
    }

    private void dealOtherMicroService(T t, String currentServiceName, SysTenant tenant, List<Map<String, Object>> storagePropertiesList, List<TenantDbModel> tenantDbModelList, Set<String> serviceNames) {
        List<Map<String, Object>> storagePropertiesListOther = this.getOtherMicroServiceStoragePropertiesMaps(t, currentServiceName, storagePropertiesList, serviceNames);
        if (HussarUtils.isEmpty(storagePropertiesListOther)) {
            return;
        }
        tenant.setTenantStatus("3");
        HussarTenantDefinition hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)tenant.getTenantCode());
        if (HussarUtils.isNotEmpty((Object)hussarTenantDefinition)) {
            hussarTenantDefinition.setTenantStatus("3");
            TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)hussarTenantDefinition);
        }
        this.tenantService.updateById((Object)tenant);
        Integer maxCreateDbStepNo = this.sysTenantLogService.getMaxCreateDbStepNo(tenant.getTenantCode());
        ArrayList<SysTenantLog> serviceLogs = new ArrayList<SysTenantLog>();
        HashMap<String, TenantDbModel> tenantDbModelMap = new HashMap<String, TenantDbModel>();
        for (TenantDbModel tenantDbModel : tenantDbModelList) {
            if (StringUtils.isBlank((CharSequence)tenantDbModel.getServiceName())) continue;
            tenantDbModelMap.put(tenantDbModel.getServiceName(), tenantDbModel);
        }
        for (Map map : storagePropertiesListOther) {
            map.put("caller", EnvironmentUtil.getServiceName());
            String serviceNameTemp = (String)map.get("serviceName");
            SysTenantLog createDbTemp = this.getSysTenantCreateDbLog(t, serviceNameTemp, map, (TenantDbModel)tenantDbModelMap.get(serviceNameTemp));
            maxCreateDbStepNo = maxCreateDbStepNo + 1;
            createDbTemp.setStepNo(maxCreateDbStepNo);
            serviceLogs.add(createDbTemp);
        }
        this.sysTenantLogService.saveBatch(serviceLogs);
        IOutSideCreateStorageService outSideCreateStorageService = (IOutSideCreateStorageService)SpringContextHolder.getBean(IOutSideCreateStorageService.class);
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>(storagePropertiesListOther);
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        if (hussarBaseTenantExecutor != null) {
            hussarBaseTenantExecutor.execute(() -> {
                for (Map outSideStorageProperties : storagePropertiesListOtherCopy) {
                    String serviceName = (String)outSideStorageProperties.get("serviceName");
                    Optional<TenantDbModel> optionTenantDbModel = tenantDbModelList.stream().filter(i -> i.isMicroservice() && i.getServiceName().equalsIgnoreCase(serviceName)).findFirst();
                    TenantDbModel tenantDbModel = optionTenantDbModel.get();
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("storageProperties", outSideStorageProperties);
                    params.put("tenantDbModel", JSON.toJSONString((Object)tenantDbModel));
                    outSideCreateStorageService.dealCreateStorage(params, serviceName);
                }
            });
        }
    }

    private List<Map<String, Object>> getOtherMicroServiceStoragePropertiesMaps(T t, String currentServiceName, List<Map<String, Object>> storagePropertiesList, Set<String> serviceNames) {
        ArrayList<Map<String, Object>> storagePropertiesListOther = new ArrayList();
        if (HussarUtils.isNotEmpty(serviceNames)) {
            for (Map<String, Object> storagePropertiesMap : storagePropertiesList) {
                storagePropertiesMap.put("tenantCode", t.getTenantCode());
                storagePropertiesMap.put("connName", t.getConnName());
                storagePropertiesMap.put("caller", currentServiceName);
                String serviceName = (String)storagePropertiesMap.get("serviceName");
                String serviceUsed = (String)storagePropertiesMap.get("inUse");
                if (!serviceNames.contains(serviceName) && HussarUtils.isNotBlank((CharSequence)serviceUsed) && "1".equals(serviceUsed)) {
                    storagePropertiesListOther.add(storagePropertiesMap);
                }
                if (!serviceNames.contains(serviceName) || !HussarUtils.isNotBlank((CharSequence)serviceUsed)) continue;
                storagePropertiesMap.put("inUse", "");
            }
        } else {
            storagePropertiesListOther = storagePropertiesList;
        }
        return storagePropertiesListOther;
    }

    @NotNull
    private Set<String> getServiceNames(List<SysTenantLog> sysTenantLogs) {
        Set<String> serviceNames = new HashSet<String>();
        if (HussarUtils.isNotEmpty(sysTenantLogs)) {
            serviceNames = sysTenantLogs.stream().map(SysTenantLog::getServiceName).collect(Collectors.toSet());
        }
        return serviceNames;
    }

    private void dealOverdueTenant(T t, SysTenant tenant, LocalDateTime now) {
        if ("1".equals(tenant.getTimeLimit()) && "2".equals(tenant.getTenantStatus()) && tenant.getEndTime().isAfter(now)) {
            tenant.setTenantStatus("1");
            t.setTenantStatus("1");
        }
        if ("0".equals(tenant.getTimeLimit()) && "2".equals(tenant.getTenantStatus())) {
            tenant.setTenantStatus("1");
            t.setTenantStatus("1");
        }
        TenantCacheUtil.putTenat2Cache(t);
        this.tenantService.updateById((Object)tenant);
    }

    public void updateTenantStatus() {
        ArrayList status = Lists.newArrayList((Object[])new String[]{"4", "2", "0"});
        List list = this.tenantService.list((Wrapper)new LambdaQueryWrapper().notIn(SysTenant::getTenantStatus, (Collection)status));
        if (HussarUtils.isEmpty((Object)list)) {
            return;
        }
        for (SysTenant sysTenant : list) {
            String tenantCode = sysTenant.getTenantCode();
            List allLogList = this.sysTenantLogService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode));
            Optional<SysTenantLog> any = allLogList.stream().filter(item -> Objects.equals(item.getStepNo(), 150)).findAny();
            List errorLogList = allLogList.stream().filter(item -> item.getExecStatus().equals(0)).collect(Collectors.toList());
            List executeLogList = allLogList.stream().filter(item -> item.getExecStatus().equals(2)).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty((Object)allLogList) && HussarUtils.isEmpty(errorLogList) && HussarUtils.isEmpty(executeLogList) && any.isPresent()) {
                this.updateTenantStatus(tenantCode, "1");
                LOGGER.info("\u66f4\u65b0\u79df\u6237{}\u72b6\u6001\u4e3a\u6b63\u5e38", (Object)tenantCode);
            }
            if (HussarUtils.isNotEmpty(errorLogList)) {
                this.updateTenantStatus(tenantCode, "4");
                LOGGER.info("\u66f4\u65b0\u79df\u6237{}\u72b6\u6001\u4e3a\u521b\u5efa\u5931\u8d25", (Object)tenantCode);
                continue;
            }
            if (!HussarUtils.isNotEmpty((Object)allLogList) || !HussarUtils.isNotEmpty(executeLogList)) continue;
            this.updateTenantStatus(tenantCode, "3");
            LOGGER.info("\u66f4\u65b0\u79df\u6237{}\u72b6\u6001\u4e3a\u521b\u5efa\u4e2d", (Object)tenantCode);
        }
    }

    public void updateTenantStatus(String tenantCode, String tenantStatus) {
        SysTenant sysTenant = (SysTenant)this.tenantService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantCode, (Object)tenantCode), false);
        if (HussarUtils.isNotEmpty((Object)sysTenant)) {
            sysTenant.setTenantStatus(tenantStatus);
            this.tenantService.updateById((Object)sysTenant);
            HussarTenantDefinition tenantByTenantCode = this.tenantService.getTenantByTenantCode(tenantCode);
            tenantByTenantCode.setTenantStatus(tenantStatus);
            SysTenantRecord sysTenantRecord = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)tenantCode));
            sysTenantRecord.setTenantParams(JSON.toJSONString((Object)tenantByTenantCode));
            this.tenantRecordService.updateById((Object)sysTenantRecord);
            TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)tenantByTenantCode);
        }
    }
}

