/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ExceptionUtil;
import com.jxdinfo.hussar.common.utils.HussarReflectionUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.model.HussarMethod;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRegister;
import com.jxdinfo.hussar.tenant.common.model.TenantDbModel;
import com.jxdinfo.hussar.tenant.common.service.IAsyncUpdateTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.service.IHussarRetryService;
import com.jxdinfo.hussar.tenant.common.service.IOutSideCreateStorageService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantDataSourceService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRegisterService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.tenant.service.impl.hussarRetryServiceImpl")
public class HussarRetryServiceImpl
implements IHussarRetryService {
    private static Logger LOGGER = LoggerFactory.getLogger(HussarRetryServiceImpl.class);
    @Autowired
    private ISysTenantLogService sysTenantLogService;
    @Autowired
    private ISysTenantRecordService tenantRecordService;
    @Autowired
    private IAsyncUpdateTenantLogService asyncUpdateTenantLogService;
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Autowired
    private ISysTenantRegisterService sysTenantRegisterService;
    @Autowired
    private ISysTenantDataSourceService sysTenantDataSourceService;

    @HussarTransactional
    public void replay(String tenantCode) {
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        if (hussarBaseTenantExecutor != null) {
            hussarBaseTenantExecutor.execute(() -> this.asyncReplay(tenantCode, null));
        }
    }

    public void replayOne(String tenantCode, Integer stepNo) {
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        if (hussarBaseTenantExecutor != null) {
            hussarBaseTenantExecutor.execute(() -> this.asyncReplay(tenantCode, stepNo));
        }
    }

    public Map<String, Object> checkRegisterService(String tenantCode, Integer stepNo) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("checkFlag", true);
        result.put("msg", "");
        if (stepNo == null) {
            return result;
        }
        LambdaQueryWrapper eq = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode);
        eq.eq(SysTenantLog::getTenantCode, (Object)tenantCode);
        eq.orderByAsc(SysTenantLog::getStepNo);
        List logList = this.sysTenantLogService.list((Wrapper)eq);
        if (HussarUtils.isEmpty((Object)logList)) {
            return result;
        }
        AtomicBoolean timeFlag = new AtomicBoolean(false);
        AtomicLong timeInterval = new AtomicLong(0L);
        List<SysTenantLog> errorLogList = this.initErrorLogList(timeFlag, timeInterval, stepNo, logList);
        if (timeFlag.get()) {
            result.put("checkFlag", false);
            result.put("msg", "\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7" + timeInterval + "\u5206\u949f\u540e\u91cd\u8bd5");
            return result;
        }
        if (HussarUtils.isEmpty(errorLogList)) {
            return result;
        }
        Map logErrorMap = errorLogList.stream().collect(Collectors.toMap(SysTenantLog::getStepNo, Function.identity()));
        SysTenantLog createDbLog = (SysTenantLog)logErrorMap.get(2);
        if (HussarUtils.isNotEmpty((Object)createDbLog)) {
            return result;
        }
        if (this.checkOtherMicroService(result, errorLogList)) {
            return result;
        }
        return result;
    }

    private boolean checkOtherMicroService(Map<String, Object> result, List<SysTenantLog> errorLogList) {
        ArrayList<String> serviceNameList = new ArrayList<String>();
        for (SysTenantLog log : errorLogList) {
            if (log.getStepNo() < 11 || log.getStepNo() > 80) continue;
            Object paramValue1 = ((HussarMethod)JSON.parseObject((String)log.getMethodParams(), HussarMethod.class)).getParamValues()[0];
            Map storageProperties = (Map)JSON.parseObject((String)JSON.toJSONString((Object)paramValue1), (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
            String serviceName = (String)storageProperties.get("serviceName");
            serviceNameList.add(serviceName);
        }
        if (HussarUtils.isNotEmpty(serviceNameList)) {
            List registers = this.sysTenantRegisterService.list();
            List serviceNames = registers.stream().map(SysTenantRegister::getServiceName).collect(Collectors.toList());
            for (String name : serviceNameList) {
                if (serviceNames.contains(name)) continue;
                result.put("checkFlag", false);
                result.put("msg", "\u5fae\u670d\u52a1\uff1a" + name + "\u672a\u6ce8\u518c");
                return true;
            }
        }
        return false;
    }

    private List<SysTenantLog> initErrorLogList(AtomicBoolean timeFlag, AtomicLong timeInterval, Integer stepNo, List<SysTenantLog> logList) {
        ArrayList<SysTenantLog> errorLogList = new ArrayList<SysTenantLog>();
        for (SysTenantLog log : logList) {
            long currentT;
            if (log.getExecStatus().equals(0) && Objects.equals(log.getStepNo(), stepNo)) {
                errorLogList.add(log);
            }
            if (!log.getExecStatus().equals(2) || !Objects.equals(log.getStepNo(), stepNo)) continue;
            LocalDateTime createTime = log.getCreateTime();
            long createT = createTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            if (createT + 300000L < (currentT = System.currentTimeMillis())) {
                errorLogList.add(log);
                continue;
            }
            timeFlag.set(true);
            timeInterval.set((createT + 300000L - currentT) / 60000L);
            long num = (createT + 300000L - currentT) % 60000L;
            if (num == 0L) break;
            timeInterval.incrementAndGet();
            break;
        }
        return errorLogList;
    }

    @HussarTransactional
    private void asyncReplay(String tenantCode, Integer stepNo) {
        List<SysTenantLog> errorLogList = this.getSysTenantLogs(tenantCode, stepNo);
        if (errorLogList == null) {
            return;
        }
        if (HussarUtils.isEmpty(errorLogList)) {
            return;
        }
        Map logErrorMap = errorLogList.stream().collect(Collectors.toMap(SysTenantLog::getStepNo, Function.identity()));
        SysTenantLog createDbLog = (SysTenantLog)logErrorMap.get(2);
        if (HussarUtils.isNotEmpty((Object)createDbLog)) {
            this.dealCreateDb(tenantCode, createDbLog);
        } else {
            ArrayList<SysTenantLog> remain = new ArrayList<SysTenantLog>();
            ArrayList<Map<String, Object>> storagePropertiesListOther = new ArrayList<Map<String, Object>>();
            ArrayList<SysTenantLog> tenantLogs = new ArrayList<SysTenantLog>();
            for (SysTenantLog log : errorLogList) {
                if (log.getStepNo() >= 11 && log.getStepNo() <= 80) {
                    Object paramValue1 = ((HussarMethod)JSON.parseObject((String)log.getMethodParams(), HussarMethod.class)).getParamValues()[0];
                    Map storageProperties = (Map)JSON.parseObject((String)JSON.toJSONString((Object)paramValue1), (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
                    storagePropertiesListOther.add(storageProperties);
                    log.setExecStatus(Integer.valueOf(2));
                    tenantLogs.add(log);
                    continue;
                }
                remain.add(log);
            }
            this.dealOtherMicroServiceCreateStorage(tenantCode, stepNo, storagePropertiesListOther, tenantLogs);
            if (HussarUtils.isNotEmpty(remain)) {
                this.invokeTenantMethod(remain);
            }
        }
    }

    private void invokeTenantMethod(List<SysTenantLog> remain) {
        for (SysTenantLog log : remain) {
            String beanName = log.getBeanName();
            String methodName = log.getMethodName();
            String getMethodParams = log.getMethodParams();
            HussarMethod hm = (HussarMethod)JSON.parseObject((String)getMethodParams, HussarMethod.class);
            List<Object> values = this.getMethodParamValues(log, hm);
            if (Objects.equals(log.getStepNo(), 87)) {
                try {
                    log.setExecStatus(Integer.valueOf(2));
                    this.sysTenantLogService.updateById((Object)log);
                    log.setExecStatus(Integer.valueOf(1));
                    this.asyncUpdateTenantLogService.tenantlogUpdate(log);
                }
                catch (Exception e) {
                    LOGGER.error("\u91cd\u8bd5\u9519\u8bef\uff1a", (Throwable)e);
                    log.setErrorTimes(Integer.valueOf(log.getErrorTimes() + 1));
                    this.asyncUpdateTenantLogService.tenantlogUpdate(log);
                }
                continue;
            }
            try {
                log.setExecStatus(Integer.valueOf(2));
                this.sysTenantLogService.updateById((Object)log);
                HussarReflectionUtils.springInvokeMethod((String)beanName, (String)methodName, (Class[])hm.getParamClass(), (Object[])values.toArray());
                log.setExecStatus(Integer.valueOf(1));
                this.asyncUpdateTenantLogService.tenantlogUpdate(log);
            }
            catch (Exception e) {
                LOGGER.error("\u91cd\u8bd5\u9519\u8bef\uff1a", (Throwable)e);
                log.setErrorTimes(Integer.valueOf(log.getErrorTimes() + 1));
                log.setExecStatus(Integer.valueOf(0));
                this.asyncUpdateTenantLogService.tenantlogUpdate(log);
            }
        }
    }

    @NotNull
    private List<Object> getMethodParamValues(SysTenantLog log, HussarMethod hm) {
        boolean convert;
        ArrayList values = Lists.newArrayList();
        boolean bl = convert = Objects.equals(log.getStepNo(), 81) || Objects.equals(log.getStepNo(), 150) || Objects.equals(log.getStepNo(), 88);
        if (convert) {
            for (Object obj : hm.getParamValues()) {
                if (obj instanceof JSONObject) {
                    try {
                        values.add(JSON.parseObject((String)JSON.toJSONString((Object)obj), (Class)hm.getTenantEntiryClass()));
                    }
                    catch (Exception e) {
                        values.add(obj);
                    }
                    continue;
                }
                values.add(obj);
            }
        } else {
            values = Lists.newArrayList((Object[])hm.getParamValues());
        }
        return values;
    }

    private void dealOtherMicroServiceCreateStorage(String tenantCode, Integer stepNo, List<Map<String, Object>> storagePropertiesListOther, List<SysTenantLog> tenantLogs) {
        HussarTenantDefinition hussarTenantDefinition;
        if (!EnvironmentUtil.isMicroService()) {
            return;
        }
        if (HussarUtils.isNotEmpty(tenantLogs)) {
            this.sysTenantLogService.updateBatchById(tenantLogs);
        }
        if ((hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode)) == null) {
            hussarTenantDefinition = ((IHussarBaseTenantService)SpringContextHolder.getBean(IHussarBaseTenantService.class)).getTenantByTenantCode(tenantCode);
        }
        List tenantDbModelList = this.sysTenantDataSourceService.ofTenant(hussarTenantDefinition);
        List registers = this.sysTenantRegisterService.list();
        List serviceNames = registers.stream().map(SysTenantRegister::getServiceName).collect(Collectors.toList());
        if (HussarUtils.isEmpty(storagePropertiesListOther)) {
            return;
        }
        IOutSideCreateStorageService outSideCreateStorageService = (IOutSideCreateStorageService)SpringContextHolder.getBean(IOutSideCreateStorageService.class);
        for (Map<String, Object> outSideStorageProperties : storagePropertiesListOther) {
            Optional<TenantDbModel> optionalTenantDbModel;
            outSideStorageProperties.put("caller", EnvironmentUtil.getServiceName((boolean)true));
            String serviceName = (String)outSideStorageProperties.get("serviceName");
            if (HussarUtils.isNotEmpty((Object)stepNo)) {
                AssertUtil.isTrue((boolean)serviceNames.contains(serviceName), (String)("\u5fae\u670d\u52a1\uff1a" + serviceName + "\u672a\u6ce8\u518c"));
            }
            if (!(optionalTenantDbModel = tenantDbModelList.stream().filter(i -> StringUtils.isNotBlank((CharSequence)serviceName) && i.getServiceName().equalsIgnoreCase(serviceName)).findFirst()).isPresent()) continue;
            TenantDbModel tenantDbModel = optionalTenantDbModel.get();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("storageProperties", outSideStorageProperties);
            params.put("tenantDbModel", JSON.toJSONString((Object)tenantDbModel));
            outSideCreateStorageService.dealCreateStorage(params, serviceName);
        }
    }

    private void dealCreateDb(String tenantCode, SysTenantLog createDbLog) {
        SysTenantRecord sysTenantRecord = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)tenantCode));
        String paramStr = sysTenantRecord.getTenantParams();
        String className = sysTenantRecord.getTenantClass();
        createDbLog.setExecStatus(Integer.valueOf(2));
        this.sysTenantLogService.updateById((Object)createDbLog);
        try {
            Object obj = JSON.parseObject((String)paramStr, Class.forName(className));
            List tenantDbModelList = this.sysTenantDataSourceService.ofTenant((HussarTenantDefinition)obj);
            ((IHussarBaseTenantService)SpringContextHolder.getBean(IHussarBaseTenantService.class)).asyncAdd(obj, tenantDbModelList);
        }
        catch (Exception e) {
            e.printStackTrace();
            createDbLog.setExecStatus(Integer.valueOf(0));
            createDbLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.sysTenantLogService.updateById((Object)createDbLog);
        }
    }

    @Nullable
    private List<SysTenantLog> getSysTenantLogs(String tenantCode, Integer stepNo) {
        LambdaQueryWrapper eq = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode);
        eq.eq(SysTenantLog::getTenantCode, (Object)tenantCode);
        eq.orderByAsc(SysTenantLog::getStepNo);
        List logList = this.sysTenantLogService.list((Wrapper)eq);
        if (HussarUtils.isEmpty((Object)logList)) {
            return null;
        }
        List<SysTenantLog> errorLogList = logList.stream().filter(item -> {
            if (stepNo != null) {
                return (item.getExecStatus().equals(0) || item.getExecStatus().equals(2)) && Objects.equals(item.getStepNo(), stepNo);
            }
            return item.getExecStatus().equals(0);
        }).collect(Collectors.toList());
        return errorLogList;
    }
}

