/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.tenant.common.dto.InitTenantUpgradeDto;
import com.jxdinfo.hussar.tenant.common.dto.TenantUpgradeEnhanceDto;
import com.jxdinfo.hussar.tenant.common.entity.UpgradeOptionConfig;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRegister;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgrade;
import com.jxdinfo.hussar.tenant.common.service.IInitTenantUpgradeService;
import com.jxdinfo.hussar.tenant.common.service.IOutSideExecuteStepListService;
import com.jxdinfo.hussar.tenant.common.service.IOutSideInitTenantUpgradeService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantExecuteStepListService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRegisterService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeCheckService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeEnhanceService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeMetaInfoService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeService;
import com.jxdinfo.hussar.tenant.common.service.IUpgradeOptionConfigService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import com.jxdinfo.hussar.tenant.common.vo.AllUpgradeInfo;
import com.jxdinfo.hussar.tenant.common.vo.InitTenantUpgradeVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service(value="com.jxdinfo.hussar.tenant.service.impl.SysTenantUpgradeEnhanceServiceImpl")
public class SysTenantUpgradeEnhanceServiceImpl
implements ISysTenantUpgradeEnhanceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysTenantUpgradeEnhanceServiceImpl.class);
    @Autowired
    private ISysTenantUpgradeService sysTenantUpgradeService;
    @Autowired
    private ISysTenantUpgradeMetaInfoService sysTenantUpgradeMetaInfoService;
    @Autowired(required=false)
    private ISysTenantRegisterService sysTenantRegisterService;
    @Autowired(required=false)
    private IOutSideExecuteStepListService outSideExecuteStepListService;
    @Autowired(required=false)
    private IOutSideInitTenantUpgradeService outSideInitTenantUpgradeService;
    @Autowired
    private ISysTenantUpgradeRecordService sysTenantUpgradeRecordService;
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Autowired
    private ISysTenantExecuteStepListService sysTenantExecuteStepListService;
    @Autowired
    private IUpgradeOptionConfigService upgradeOptionConfigService;
    @Autowired
    private IInitTenantUpgradeService initTenantUpgradeService;
    @Autowired
    private ISysTenantUpgradeCheckService sysTenantUpgradeCheckService;

    public void upgradeFixVersion(TenantUpgradeEnhanceDto tenantUpgradeEnhanceDto) {
        boolean isEnableMicroService = EnvironmentUtil.isMicroService();
        LOGGER.info("\u5f53\u524d\u73af\u5883\uff1a{}", (Object)(isEnableMicroService ? "\u5fae\u670d\u52a1" : "\u5355\u4f53"));
        List tenantList = this.sysTenantUpgradeCheckService.checkUpgrade(tenantUpgradeEnhanceDto);
        HussarCacheUtil.put((String)"CAN_UPGRADE_IN_ALL", (Object)tenantUpgradeEnhanceDto.getSelectType(), (Object)tenantList);
        String toVersion = tenantUpgradeEnhanceDto.getToVersion();
        this.sysTenantUpgradeMetaInfoService.init();
        AllUpgradeInfo allUpgradeInfo = this.initTenantUpgrade(tenantList, toVersion);
        List master = allUpgradeInfo.getMaster();
        List other = allUpgradeInfo.getOtherTenantUpgradeList();
        Executor asyncExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        if (HussarUtils.isNotEmpty((Object)master) && HussarUtils.isEmpty((Object)other)) {
            asyncExecutor.execute(() -> this.sysTenantExecuteStepListService.executeBatch(master));
        }
        if (HussarUtils.isNotEmpty((Object)master) && HussarUtils.isNotEmpty((Object)other)) {
            asyncExecutor.execute(() -> this.sysTenantExecuteStepListService.executeBatch(master));
            for (List tenantUpgradeList : other) {
                asyncExecutor.execute(() -> {
                    String serviceName = ((SysTenantUpgrade)tenantUpgradeList.get(0)).getServiceName();
                    this.outSideExecuteStepListService.executeBatch(tenantUpgradeList, serviceName);
                });
            }
        }
    }

    private AllUpgradeInfo initTenantUpgrade(List<HussarTenantDefinition> tenantList, String toVersion) {
        AllUpgradeInfo allUpgradeInfo = new AllUpgradeInfo();
        ArrayList<List> other = new ArrayList<List>();
        allUpgradeInfo.setOtherTenantUpgradeList(other);
        List registerList = null;
        if (EnvironmentUtil.isMicroService()) {
            List allRegisterList = this.sysTenantRegisterService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantRegister::getRegStatus, (Object)"1")).orderByAsc(HussarBaseEntity::getCreateTime));
            registerList = allRegisterList.stream().filter(item -> !item.getServiceName().equalsIgnoreCase(EnvironmentUtil.getServiceName())).collect(Collectors.toList());
        }
        UpgradeOptionConfig upgradeOptionConfig = this.upgradeOptionConfigService.get();
        InitTenantUpgradeDto initTenantUpgradeDto = new InitTenantUpgradeDto();
        initTenantUpgradeDto.setTenantList(tenantList);
        initTenantUpgradeDto.setToVersion(toVersion);
        initTenantUpgradeDto.setUpgradeOptionConfig(upgradeOptionConfig);
        InitTenantUpgradeVo initTenantUpgradeVo = this.initTenantUpgradeService.initTenantUpgradeMaster(initTenantUpgradeDto);
        List tenantUpgradeList = initTenantUpgradeVo.getTenantUpgradeList();
        List tenantUpgradeRecordList = initTenantUpgradeVo.getTenantUpgradeRecordList();
        if (HussarUtils.isNotEmpty((Object)tenantUpgradeList)) {
            this.sysTenantUpgradeService.saveBatch((Collection)tenantUpgradeList);
            this.sysTenantUpgradeRecordService.saveBatch((Collection)tenantUpgradeRecordList);
            allUpgradeInfo.setMaster(tenantUpgradeList);
        }
        if (HussarUtils.isNotEmpty(registerList)) {
            for (SysTenantRegister sr : registerList) {
                String serviceName = sr.getServiceName();
                InitTenantUpgradeDto initTenantUpgradeDtoOther = new InitTenantUpgradeDto();
                initTenantUpgradeDtoOther.setTenantList(tenantList);
                initTenantUpgradeDtoOther.setToVersion(toVersion);
                initTenantUpgradeDtoOther.setUpgradeOptionConfig(upgradeOptionConfig);
                InitTenantUpgradeVo initTenantUpgradeOtherVo = this.outSideInitTenantUpgradeService.initTenantUpgrade(initTenantUpgradeDtoOther, serviceName);
                List tenantUpgradeListOther = initTenantUpgradeOtherVo.getTenantUpgradeList();
                if (!HussarUtils.isNotEmpty((Object)tenantUpgradeListOther)) continue;
                this.sysTenantUpgradeService.saveBatch((Collection)tenantUpgradeListOther);
                other.add(tenantUpgradeListOther);
            }
        }
        return allUpgradeInfo;
    }
}

