/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidConfig;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.EncrypDes;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.factory.DatabaseFactory;
import com.jxdinfo.hussar.datasource.model.RDBStorageDefinition;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.IHussarBaseDatabaseOperateService;
import com.jxdinfo.hussar.datasource.util.DbUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.tenant.common.constant.TenantCommonConstant;
import com.jxdinfo.hussar.tenant.common.dao.SysTenantDataSourceMapper;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenantDatasource;
import com.jxdinfo.hussar.tenant.common.model.TenantDbModel;
import com.jxdinfo.hussar.tenant.common.service.IOutSideUpdateTenantDataSourceService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantDataSourceService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service(value="com.jxdinfo.hussar.tenant.common.service.impl.sysTenantDataSourceServiceImpl")
public class SysTenantDataSourceServiceImpl
extends HussarServiceImpl<SysTenantDataSourceMapper, SysTenantDatasource>
implements ISysTenantDataSourceService {
    @Autowired
    private DynamicDatasourceService dynamicDatasourceService;
    @Autowired(required=false)
    private IOutSideUpdateTenantDataSourceService outSideUpdateTenantDataSourceService;
    @Value(value="${spring.datasource.dynamic.datasource.master.db-mode:}")
    private String dbMode;
    @Resource
    private DynamicDataSourceProperties dynamicDataSourceProperties;

    public List<TenantDbModel> ofTenant(HussarTenantDefinition definition) {
        boolean isMicroservice = EnvironmentUtil.isMicroService();
        String currentServiceName = EnvironmentUtil.getServiceName();
        ArrayList<TenantDbModel> list = new ArrayList<TenantDbModel>();
        List storagePropertiesList = definition.getStoragePropertiesList();
        String connName = definition.getConnName();
        String tenantCode = definition.getTenantCode();
        if (isMicroservice) {
            for (Map storageProperties : storagePropertiesList) {
                list.add(this.get(isMicroservice, connName, tenantCode, storageProperties, currentServiceName));
            }
        } else {
            Map storageProperties = (Map)storagePropertiesList.get(0);
            storageProperties.put("tenantCode", definition.getTenantCode());
            storageProperties.put("connName", definition.getConnName());
            storageProperties.put("datasourceType", "1");
            list.add(this.get(isMicroservice, connName, tenantCode, storageProperties, currentServiceName));
        }
        return list;
    }

    private TenantDbModel get(boolean isMicroservice, String connName, String tenantCode, Map<String, Object> storageProperties, String currentServiceName) {
        DataSourceProperty dataSourceProperty;
        TenantDbModel tenantDbModel = new TenantDbModel();
        storageProperties.put("tenantCode", tenantCode);
        storageProperties.put("connName", connName);
        storageProperties.put("datasourceType", "1");
        String serviceName = "";
        Map datasource = this.dynamicDataSourceProperties.getDatasource();
        DruidConfig druid = null;
        if (HussarUtils.isNotEmpty((Object)datasource) && HussarUtils.isNotEmpty((Object)(dataSourceProperty = (DataSourceProperty)datasource.get("master"))) && HussarUtils.isNotEmpty((Object)(druid = dataSourceProperty.getDruid()))) {
            String s = JSON.toJSONString((Object)druid);
            storageProperties.put("properties", s);
        }
        if (isMicroservice) {
            serviceName = (String)storageProperties.get("serviceName");
            if (StringUtils.isBlank((CharSequence)serviceName)) {
                throw new BaseException("\u5fae\u670d\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!serviceName.equalsIgnoreCase(currentServiceName)) {
                storageProperties.put("caller", currentServiceName);
                tenantDbModel.setCaller(currentServiceName);
                tenantDbModel.setServiceName(serviceName);
            } else {
                tenantDbModel.setServiceName(currentServiceName);
            }
        }
        tenantDbModel.setMicroservice(isMicroservice);
        String json = JSON.toJSONString(storageProperties);
        RDBStorageDefinition storageDefinition = (RDBStorageDefinition)JSON.parseObject((String)json, RDBStorageDefinition.class);
        if (HussarUtils.isNotEmpty((Object)druid)) {
            HussarUtils.copy((Object)druid, (Object)storageDefinition);
        }
        String creation = storageDefinition.getCreation();
        tenantDbModel.setCreation(creation);
        SysDataSourceDto sysDataSourceDto = null;
        if (creation.equals("1")) {
            sysDataSourceDto = this.getSchemaInfo(isMicroservice, connName, storageProperties, currentServiceName);
            sysDataSourceDto.setTenantCode(storageDefinition.getTenantCode());
            if (HussarUtils.isNotEmpty((Object)this.dbMode)) {
                sysDataSourceDto.setDbMode(this.dbMode);
            } else if (HussarUtils.isNotEmpty((Object)storageDefinition.getDbMode())) {
                sysDataSourceDto.setDbMode(storageDefinition.getDbMode());
            }
            String dbType = DbUtil.getDbType((String)sysDataSourceDto.getJdbcUrl());
            IHussarBaseDatabaseOperateService operateService = DatabaseFactory.get((String)dbType);
            operateService.setParametersByMaster(sysDataSourceDto);
        } else {
            sysDataSourceDto = this.getSysDataSourceDtoFromTenant(storageDefinition);
            try {
                sysDataSourceDto.setDriverClass(DriverManager.getDriver(sysDataSourceDto.getJdbcUrl()).getClass().getName());
            }
            catch (SQLException e) {
                throw new BaseException("\u83b7\u53d6\u9a71\u52a8\u5931\u8d25", (Throwable)e);
            }
        }
        storageProperties.put("jdbcUrl", sysDataSourceDto.getJdbcUrl());
        storageProperties.put("dbName", sysDataSourceDto.getDbName());
        storageProperties.put("userName", sysDataSourceDto.getUserName());
        storageProperties.put("password", sysDataSourceDto.getPassword());
        storageProperties.put("driverClass", sysDataSourceDto.getDriverClass());
        tenantDbModel.setSysDataSourceDto(sysDataSourceDto);
        return tenantDbModel;
    }

    private SysDataSourceDto getSchemaInfo(boolean isMicroservice, String connName, Map<String, Object> storageProperties, String currentServiceName) {
        String dbName = connName;
        String tempConnName = connName;
        String serviceName = "";
        SysDataSourceDto sysDataSourceDto = new SysDataSourceDto();
        ItemDataSource itemDataSource = this.dynamicDatasourceService.getDatasourceByPoolName("master");
        if (isMicroservice) {
            String caller = (String)storageProperties.get("caller");
            serviceName = (String)storageProperties.get("serviceName");
            if (!serviceName.equalsIgnoreCase(currentServiceName) && StringUtils.isNotBlank((CharSequence)caller)) {
                this.getSchemaInfoOfMicroService(tempConnName, sysDataSourceDto, storageProperties, serviceName);
            } else {
                this.setDatasourceProperties(tempConnName, sysDataSourceDto, itemDataSource);
            }
        } else {
            this.setDatasourceProperties(tempConnName, sysDataSourceDto, itemDataSource);
        }
        long id = IdWorker.getId((Object)sysDataSourceDto);
        sysDataSourceDto.setId(Long.valueOf(id));
        sysDataSourceDto.setDbName(dbName);
        sysDataSourceDto.setDatasourceType("1");
        sysDataSourceDto.setStatus("1");
        sysDataSourceDto.setLazyEnable(TenantCommonConstant.LAZY);
        return sysDataSourceDto;
    }

    private void setDatasourceProperties(String tempConnName, SysDataSourceDto sysDataSourceDto, ItemDataSource itemDataSource) {
        sysDataSourceDto.setUserName(itemDataSource.getUsername());
        sysDataSourceDto.setPassword(itemDataSource.getPassword());
        sysDataSourceDto.setDriverClass(itemDataSource.getDriverClassName());
        sysDataSourceDto.setJdbcUrl(itemDataSource.getUrl());
        sysDataSourceDto.setConnName(tempConnName);
    }

    private void getSchemaInfoOfMicroService(String connName, SysDataSourceDto sysDataSourceDto, Map<String, Object> storageProperties, String serviceName) {
        SysDataSource sysDataSourceMasterZh = this.outSideUpdateTenantDataSourceService.getMasterOfService(serviceName);
        if (null != sysDataSourceMasterZh && StringUtils.isNotBlank((CharSequence)sysDataSourceMasterZh.getJdbcUrl())) {
            sysDataSourceDto.setUserName(sysDataSourceMasterZh.getUserName());
            try {
                EncrypDes encrypDes = new EncrypDes();
                sysDataSourceDto.setPassword(encrypDes.decrypt(sysDataSourceMasterZh.getPassword()));
            }
            catch (Exception e) {
                throw new BaseException("\u52a0\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
            }
        } else {
            throw new BaseException("\u5fae\u670d\u52a1\u3010" + serviceName + "\u3011\u83b7\u53d6\u4e3b\u6570\u636e\u6e90\u4e3anull");
        }
        sysDataSourceDto.setConnName(connName);
        sysDataSourceDto.setDriverClass(sysDataSourceMasterZh.getDriverClass());
        sysDataSourceDto.setJdbcUrl(sysDataSourceMasterZh.getJdbcUrl());
        storageProperties.put("connName", connName);
    }

    private SysDataSourceDto getSysDataSourceDtoFromTenant(RDBStorageDefinition definition) {
        SysDataSourceDto sysDataSourceDto = new SysDataSourceDto();
        sysDataSourceDto.setId(Long.valueOf(IdWorker.getId((Object)sysDataSourceDto)));
        sysDataSourceDto.setJdbcUrl(definition.getJdbcUrl());
        sysDataSourceDto.setConnName(definition.getConnName());
        sysDataSourceDto.setDbName(definition.getDbName());
        sysDataSourceDto.setUserName(definition.getUserName());
        sysDataSourceDto.setPassword(definition.getPassword());
        sysDataSourceDto.setDatasourceType("1");
        sysDataSourceDto.setStatus("1");
        sysDataSourceDto.setTenantCode(definition.getTenantCode());
        if (HussarUtils.isNotEmpty((Object)definition.getDbMode())) {
            sysDataSourceDto.setDbMode(definition.getDbMode());
        }
        if (HussarUtils.isNotEmpty((Object)definition.getPattern())) {
            sysDataSourceDto.setCurrentSchema(definition.getPattern());
        }
        if (HussarUtils.isNotEmpty((Object)definition.getProperties())) {
            sysDataSourceDto.setProperties(definition.getProperties());
        }
        sysDataSourceDto.setLazyEnable(TenantCommonConstant.LAZY);
        return sysDataSourceDto;
    }
}

