/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.runner;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.tenant.common.constant.StepConstants;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantLogUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.tenant.runner.tenantStatusCheckServiceRunner")
@Order(value=900003)
public class TenantStatusCheckServiceRunner
implements ApplicationRunner {
    @Autowired
    private ISysTenantLogService sysTenantLogService;
    @Autowired
    private ISysTenantService sysTenantService;

    public void run(ApplicationArguments args) throws Exception {
        LambdaQueryWrapper eqTenant = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantStatus, (Object)"3")).or()).eq(SysTenant::getTenantStatus, (Object)"4");
        List sysTenantList = this.sysTenantService.list((Wrapper)eqTenant);
        boolean isMicroservice = EnvironmentUtil.isMicroService();
        if (!isMicroservice && sysTenantList != null && sysTenantList.size() > 0) {
            for (int i = 0; i < sysTenantList.size(); ++i) {
                SysTenant sysTenant = (SysTenant)sysTenantList.get(i);
                LambdaQueryWrapper eq = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)sysTenant.getTenantCode());
                List sysTenantLogList = this.sysTenantLogService.list((Wrapper)eq);
                if (sysTenantLogList != null && sysTenantLogList.size() > 0) {
                    List createDb;
                    List collect = sysTenantLogList.stream().filter(sysTenantLog -> !sysTenantLog.getStepNo().equals(StepConstants.CREATE_DB)).collect(Collectors.toList());
                    if (collect != null && collect.size() > 0) {
                        this.sysTenantLogService.removeByIds(collect);
                    }
                    if ((createDb = sysTenantLogList.stream().filter(sysTenantLog -> sysTenantLog.getStepNo().equals(StepConstants.CREATE_DB)).collect(Collectors.toList())) != null && "1".equals(String.valueOf(createDb.size()))) {
                        SysTenantLog sysTenantLog2 = (SysTenantLog)createDb.get(0);
                        sysTenantLog2.setExecError("\u521b\u5efa\u5931\u8d25");
                        sysTenantLog2.setExecStatus(Integer.valueOf(0));
                        this.sysTenantLogService.updateById((Object)sysTenantLog2);
                    }
                } else {
                    HussarTenantDefinition definition = this.sysTenantService.getTenantByTenantId(sysTenant.getId());
                    String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
                    List storagePropertiesList = definition.getStoragePropertiesList();
                    SysTenantLog sysTenantLog3 = TenantLogUtil.newCreateDbLog(definition.getClass(), (String)definition.getTenantCode(), (String)definition.getConnName(), (String)currentServiceName, (Map)((Map)storagePropertiesList.get(0)));
                    sysTenantLog3.setExecStatus(Integer.valueOf(0));
                    sysTenantLog3.setExecError("\u521b\u5efa\u5931\u8d25");
                    this.sysTenantLogService.save((Object)sysTenantLog3);
                }
                sysTenant.setTenantStatus("4");
                this.sysTenantService.updateById((Object)sysTenant);
            }
        }
    }
}

