/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.EntityUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.dao.SysTenantRegisterMapper;
import com.jxdinfo.hussar.tenant.common.dto.AddTenantRegisterDto;
import com.jxdinfo.hussar.tenant.common.dto.EditTenantRegisterDto;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRegister;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRegisterService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.common.vo.TenantRegisterVo;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service(value="com.jxdinfo.hussar.tenant.service.impl.sysTenantRegisterServiceImpl")
public class SysTenantRegisterServiceImpl
extends HussarServiceImpl<SysTenantRegisterMapper, SysTenantRegister>
implements ISysTenantRegisterService {
    @Autowired
    protected IHussarValidateService validateService;
    @Autowired
    private ISysTenantRecordService sysTenantRecordService;
    @Autowired
    private ISysTenantLogService sysTenantLogService;

    public List<SysTenantRegister> serviceRegisterList(String regName) {
        if (HussarUtils.isNotBlank((CharSequence)regName)) {
            HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
            queryOrgParams.put("regName", SqlQueryUtil.transferSpecialChar((String)regName));
            queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
            return ((SysTenantRegisterMapper)this.getBaseMapper()).queryTenantRegisterList(queryOrgParams);
        }
        return this.list();
    }

    public List<TenantRegisterVo> viewTenantRegister(String tenantCode) {
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantRegister::getRegStatus, (Object)"1"));
        ArrayList result = Lists.newArrayList();
        if (HussarUtils.isNotEmpty((Object)list)) {
            SysTenantRecord record = (SysTenantRecord)this.sysTenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)tenantCode), false);
            AssertUtil.isNotNull((Object)record, (String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u7684\u521b\u5efa\u8bb0\u5f55\uff01");
            for (SysTenantRegister sysTenantRegister : list) {
                TenantRegisterVo tenantRegisterVo = new TenantRegisterVo();
                BeanUtils.copyProperties((Object)sysTenantRegister, (Object)tenantRegisterVo);
                tenantRegisterVo.setInUse("1");
                result.add(tenantRegisterVo);
            }
            Map tenantRegisterMap = EntityUtils.toMap((Collection)result, TenantRegisterVo::getServiceName);
            String paramStr = record.getTenantParams();
            JSONArray jsonArray = (JSONArray)JSON.parseObject((String)paramStr).get((Object)"storagePropertiesList");
            for (Object object : jsonArray) {
                String serviceName = ((JSONObject)object).getString("serviceName");
                if (!HussarUtils.isNotBlank((CharSequence)serviceName) || tenantRegisterMap.get(serviceName) == null) continue;
                ((TenantRegisterVo)tenantRegisterMap.get(serviceName)).setInUse("2");
            }
            result = new ArrayList(tenantRegisterMap.values());
        }
        return result;
    }

    public Boolean addTenantRegister(AddTenantRegisterDto addTenantRegisterDto) {
        String validateMsg = this.validateService.validate((Object)addTenantRegisterDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String serviceName = addTenantRegisterDto.getServiceName().trim();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantRegister::getServiceName, (Object)serviceName);
        AssertUtil.isFalse((this.count((Wrapper)wrapper) > 0L ? 1 : 0) != 0, (String)("\u5fae\u670d\u52a1" + serviceName + "\u5df2\u5b58\u5728\uff01"));
        SysTenantRegister tenantRegister = new SysTenantRegister();
        tenantRegister.setRegName(addTenantRegisterDto.getRegName().trim());
        tenantRegister.setServiceName(serviceName);
        tenantRegister.setRegStatus("1");
        return this.save((BaseEntity)tenantRegister);
    }

    public Boolean editTenantRegister(EditTenantRegisterDto editTenantRegisterDto) {
        String validateMsg = this.validateService.validate((Object)editTenantRegisterDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String serviceName = editTenantRegisterDto.getServiceName().trim();
        String regName = editTenantRegisterDto.getRegName().trim();
        Long id = editTenantRegisterDto.getId();
        String regStatus = editTenantRegisterDto.getRegStatus();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantRegister::getServiceName, (Object)serviceName)).ne(SysTenantRegister::getId, (Object)id);
        AssertUtil.isFalse((this.count((Wrapper)wrapper) > 0L ? 1 : 0) != 0, (String)("\u5fae\u670d\u52a1" + serviceName + "\u5df2\u5b58\u5728\uff01"));
        SysTenantRegister tenantRegister = new SysTenantRegister();
        tenantRegister.setId(id);
        tenantRegister.setRegName(regName);
        tenantRegister.setRegStatus(regStatus);
        return this.updateById((BaseEntity)tenantRegister);
    }

    @HussarTransactional
    public Boolean deleteTenantRegister(Long id) {
        SysTenantRegister tenantRegister = (SysTenantRegister)this.getById(id);
        String serviceName = tenantRegister.getServiceName();
        List recordListlist = this.sysTenantRecordService.list();
        if (HussarUtils.isNotEmpty((Object)recordListlist)) {
            for (SysTenantRecord record : recordListlist) {
                String tenantParams = record.getTenantParams();
                JSONObject jsonObject = JSON.parseObject((String)tenantParams);
                String tenantCode = jsonObject.getString("tenantCode");
                JSONArray jsonArray = (JSONArray)jsonObject.get((Object)"storagePropertiesList");
                JSONArray newJsonArray = new JSONArray();
                for (Object o : jsonArray) {
                    JSONObject jsonObjectTemp = (JSONObject)o;
                    String serviceNameTemp = jsonObjectTemp.getString("serviceName");
                    if (!HussarUtils.isNotBlank((CharSequence)serviceNameTemp) || serviceName.equals(serviceNameTemp)) continue;
                    newJsonArray.add(o);
                }
                HussarTenantDefinition hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode);
                if (HussarUtils.isNotEmpty((Object)hussarTenantDefinition)) {
                    List storagePropertiesList = hussarTenantDefinition.getStoragePropertiesList();
                    ArrayList<Map> newStoragePropertiesList = new ArrayList<Map>();
                    for (Map map : storagePropertiesList) {
                        String serviceNameTemp = (String)map.get("serviceName");
                        if (!HussarUtils.isNotBlank((CharSequence)serviceNameTemp) || serviceNameTemp.equals(serviceName)) continue;
                        newStoragePropertiesList.add(map);
                    }
                    hussarTenantDefinition.setStoragePropertiesList(newStoragePropertiesList);
                    TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)hussarTenantDefinition);
                }
                jsonObject.put("storagePropertiesList", (Object)newJsonArray);
                record.setTenantParams(JSON.toJSONString((Object)jsonObject));
            }
            this.sysTenantRecordService.updateBatchById((Collection)recordListlist);
        }
        this.sysTenantLogService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantLog::getServiceName, (Object)serviceName));
        return this.removeById(id);
    }

    public String checkDeleteTenantRegister(Long id) {
        Set serviceNames;
        String result = "";
        AssertUtil.isNotNull((Object)id, (String)"\u7f3a\u5c11id\u53c2\u6570\uff01");
        SysTenantRegister tenantRegister = (SysTenantRegister)this.getById(id);
        AssertUtil.isNotNull((Object)tenantRegister, (String)"\u672a\u67e5\u8be2\u5230\u6ce8\u518c\u7684\u79df\u6237\u670d\u52a1\uff01");
        List sysTenantLogs = this.sysTenantLogService.list();
        if (HussarUtils.isNotEmpty((Object)sysTenantLogs) && (serviceNames = sysTenantLogs.stream().map(SysTenantLog::getServiceName).collect(Collectors.toSet())).contains(tenantRegister.getServiceName())) {
            result = "\u670d\u52a1" + tenantRegister.getServiceName() + "\u5b58\u5728\u4e8e\u5df2\u521b\u5efa\u7684\u79df\u6237\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f";
        }
        return result;
    }
}

