/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.register.controller;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.register.service.IHussarNacosService;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRegister;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRegisterService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import com.jxdinfo.hussar.tenant.common.vo.TenantRegisterVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u79df\u6237\u670d\u52a1\u6ce8\u518c"})
@RestController(value="com.jxdinfo.hussar.tenant.common.controller.hussarBaseTenantServiceRegisterNacosController")
@RequestMapping(value={"/hussarBase/tenant"})
public class HussarBaseTenantServiceRegisterNacosController {
    @Autowired
    private ISysTenantRegisterService tenantRegisterService;
    @Autowired
    private IHussarNacosService hussarNacosService;

    @GetMapping(value={"/serviceRegisterList"})
    @ApiOperation(value="\u79df\u6237\u79df\u6237\u670d\u52a1\u5217\u8868", notes="\u79df\u6237\u79df\u6237\u670d\u52a1\u5217\u8868")
    @AuditLog(moduleName="\u79df\u6237\u7ba1\u7406", eventDesc="\u67e5\u8be2\u79df\u6237\u670d\u52a1\u6ce8\u518c\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<TenantRegisterVo>> serviceRegisterList(@ApiParam(value="\u6ce8\u518c\u540d\u79f0") @RequestParam(required=false) String regName) {
        this.checkMicroService();
        ArrayList<TenantRegisterVo> result = new ArrayList<TenantRegisterVo>();
        List registers = this.tenantRegisterService.serviceRegisterList(regName);
        if (HussarUtils.isNotEmpty((Object)registers)) {
            for (SysTenantRegister register : registers) {
                boolean flag = this.hussarNacosService.isHealth(register.getServiceName());
                TenantRegisterVo vo = new TenantRegisterVo();
                BeanUtils.copyProperties((Object)register, (Object)vo);
                if (!flag) {
                    vo.setServiceStatus("0");
                } else {
                    vo.setServiceStatus("1");
                }
                result.add(vo);
            }
        }
        return ApiResponse.success(result);
    }

    @GetMapping(value={"/viewTenantRegister"})
    @ApiOperation(value="\u67e5\u8be2\u79df\u6237\u8be6\u7ec6\u4fe1\u606f", notes="\u67e5\u8be2\u79df\u6237\u8be6\u7ec6\u4fe1\u606f")
    @AuditLog(moduleName="\u79df\u6237\u7ba1\u7406", eventDesc="\u67e5\u8be2\u79df\u6237\u670d\u52a1\u6ce8\u518c\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<TenantRegisterVo>> viewTenantRegister(@ApiParam(value="\u79df\u6237id") @RequestParam String tenantCode) {
        this.checkMicroService();
        return ApiResponse.success((Object)this.tenantRegisterService.viewTenantRegister(tenantCode));
    }

    private void checkMicroService() {
        boolean microService = EnvironmentUtil.isMicroService();
        if (!microService) {
            throw new BaseException("\u975e\u5fae\u670d\u52a1\u73af\u5883\uff01");
        }
    }
}

