/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.onsystem.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.model.SysUsersAdditionalInfo;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersAddtionalInfoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserBaseService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.onsystem.constant.OnSystemTenantConstants;
import com.jxdinfo.hussar.tenant.onsystem.dto.DesignateDeveloperDto;
import com.jxdinfo.hussar.tenant.onsystem.model.SysTenantDeveloper;
import com.jxdinfo.hussar.tenant.onsystem.service.HussarBaseOnSystemTenantService;
import com.jxdinfo.hussar.tenant.onsystem.service.ISysTenantDeveloperService;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class HussarBaseOnSystemTenantServiceImpl
implements HussarBaseOnSystemTenantService {
    @Autowired
    private ISysTenantService sysTenantService;
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private ISysTenantDeveloperService sysTenantDeveloperService;
    @Autowired
    private ISysStruUserBaseService sysStruUserBaseService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysUsersAddtionalInfoService sysUsersAddtionalInfoService;
    @Autowired
    private ISysStaffService sysStaffService;
    @Autowired
    private ISysStruStaffService sysStruStaffService;

    public String getAddTenantLogFromCache(String tenantCode) {
        Object addTenantLog = HussarCacheUtil.get((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode));
        if (HussarUtils.isNotEmpty((Object)addTenantLog)) {
            return (String)addTenantLog;
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)"CACHE_NOT_EXIST", (String)"\u7f13\u5b58\u4e0d\u5b58\u5728"));
    }

    @HussarTransactional
    public String designateDeveloper(DesignateDeveloperDto designateDeveloperDto) {
        List mainUsers;
        String res = TranslateUtil.getTranslateName((String)"SAVE_SUCCESS", (String)"\u4fdd\u5b58\u6210\u529f");
        HussarTenantDefinition definition = TenantCacheUtil.loadFromCacheByTenantCode((String)designateDeveloperDto.getTenantCode());
        if (HussarUtils.isEmpty((Object)definition)) {
            definition = this.sysTenantService.getTenantByTenantId(designateDeveloperDto.getTenantId());
        }
        if (HussarUtils.isEmpty((Object)definition)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)"GET_PROJECT_INFO_ERR", (String)"\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5f02\u5e38\uff0ctenantId =") + designateDeveloperDto.getTenantId());
        }
        String connName = definition.getConnName();
        if (HussarUtils.isNotEmpty((Object)designateDeveloperDto.getAddDeveloperIds()) && HussarUtils.isNotEmpty((Object)(mainUsers = this.sysUsersService.listByIds((Collection)designateDeveloperDto.getAddDeveloperIds())))) {
            List staffIds = mainUsers.stream().map(SysUsers::getEmployeeId).distinct().collect(Collectors.toList());
            List staffs = this.sysStaffService.listByIds(staffIds);
            Map staffMap = staffs.stream().collect(Collectors.toMap(SysStaff::getId, Function.identity()));
            ArrayList addList = new ArrayList();
            ArrayList tenantUsers = new ArrayList();
            ArrayList tenantStaffs = new ArrayList();
            ArrayList tenantUserRoles = new ArrayList();
            ArrayList tenantStruUsers = new ArrayList();
            ArrayList tenantStruStaffs = new ArrayList();
            ArrayList tenantUserAddition = new ArrayList();
            mainUsers.forEach(user -> {
                SysStruUser one;
                SysTenantDeveloper tenantDelegateUser = new SysTenantDeveloper();
                tenantDelegateUser.setUserId(user.getId());
                tenantDelegateUser.setTenantId(designateDeveloperDto.getTenantId());
                addList.add(tenantDelegateUser);
                SysUsers sysUsers = new SysUsers();
                BeanUtil.copy((Object)user, (Object)sysUsers);
                sysUsers.setAccountStatus(UserStatus.OK.getCode());
                sysUsers.setMaxSessions(Integer.valueOf(-1));
                tenantUsers.add(sysUsers);
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(user.getId());
                sysUserRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                tenantUserRoles.add(sysUserRole);
                SysUserRole sysUserRole2 = new SysUserRole();
                sysUserRole2.setUserId(user.getId());
                sysUserRole2.setGrantedRole(SysUserAndRole.DEVELOP_ROLE.getValue());
                sysUserRole2.setAdminOption(UserRoleStatus.OK.getCode());
                tenantUserRoles.add(sysUserRole2);
                SysUsersAdditionalInfo sysUsersAdditionalInfo = new SysUsersAdditionalInfo();
                SysUsersAdditionalInfo additonalInfo = (SysUsersAdditionalInfo)this.sysUsersAddtionalInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsersAdditionalInfo::getUserId, (Object)user.getId()));
                sysUsersAdditionalInfo.setUserId(user.getId());
                if (HussarUtils.isNotEmpty((Object)additonalInfo)) {
                    sysUsersAdditionalInfo.setGitToken(additonalInfo.getGitToken());
                    sysUsersAdditionalInfo.setUserExtendId(additonalInfo.getUserExtendId());
                    tenantUserAddition.add(sysUsersAdditionalInfo);
                }
                if (HussarUtils.isEmpty((Object)(one = (SysStruUser)this.sysStruUserBaseService.getOne(connName, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)user.getId())).eq(SysStruUser::getStruId, (Object)OnSystemTenantConstants.TEAM_STRU_ID))))) {
                    SysStruUser sysStruUser = new SysStruUser();
                    sysStruUser.setStruId(OnSystemTenantConstants.TEAM_STRU_ID);
                    sysStruUser.setUserId(user.getId());
                    tenantStruUsers.add(sysStruUser);
                }
                if (HussarUtils.isNotEmpty((Object)staffMap) && HussarUtils.isNotEmpty((Object)user.getEmployeeId()) && HussarUtils.isNotEmpty(staffMap.get(user.getEmployeeId()))) {
                    SysStaff staff = (SysStaff)staffMap.get(user.getEmployeeId());
                    SysStaff sysStaff = new SysStaff();
                    BeanUtil.copy((Object)staff, (Object)sysStaff);
                    tenantStaffs.add(staff);
                    List list = this.sysStruStaffService.list(connName, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)user.getEmployeeId())).eq(SysStruStaff::getStruId, (Object)OnSystemTenantConstants.TEAM_STRU_ID));
                    if (HussarUtils.isEmpty((Object)list)) {
                        SysStruStaff sysStruStaff = new SysStruStaff();
                        sysStruStaff.setStruId(OnSystemTenantConstants.TEAM_STRU_ID);
                        sysStruStaff.setStaffId(user.getEmployeeId());
                        tenantStruStaffs.add(sysStruStaff);
                    }
                }
            });
            Map<Long, String> userIdAndAccounts = mainUsers.stream().collect(Collectors.toMap(SysUsers::getId, SysUsers::getUserAccount));
            List userList = this.sysUsersService.list(connName, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysUsers::getUserAccount, userIdAndAccounts.values())).notIn(SysUsers::getId, userIdAndAccounts.keySet()));
            if (HussarUtils.isNotEmpty((Object)userList)) {
                String str = userList.stream().map(SysUsers::getUserAccount).collect(Collectors.joining(","));
                throw new BaseException(String.format(TranslateUtil.getTranslateName((String)"ACCOUNT_EXIST", (String)"\u4e0b\u5217\u8d26\u53f7\u5df2\u5b58\u5728: %s"), str));
            }
            this.sysTenantDeveloperService.saveBatch(addList);
            this.sysUsersService.saveOrUpdateBatch(connName, tenantUsers);
            this.sysUserRoleService.saveOrUpdateBatch(connName, tenantUserRoles);
            this.sysStruUserBaseService.saveOrUpdateBatch(connName, tenantStruUsers);
            this.sysStaffService.saveOrUpdateBatch(connName, tenantStaffs);
            this.sysStruStaffService.saveOrUpdateBatch(connName, tenantStruStaffs);
            String tenantType = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("hussar.core.tenant.type");
            if ("onsystem".equals(tenantType) && HussarUtils.isNotEmpty(tenantUserAddition)) {
                this.sysUsersAddtionalInfoService.saveOrUpdateBatch(connName, tenantUserAddition);
            }
        }
        if (HussarUtils.isNotEmpty((Object)designateDeveloperDto.getRetrieveDeveloperIds())) {
            SysTenant sysTenant = (SysTenant)this.sysTenantService.getById((Serializable)designateDeveloperDto.getTenantId());
            if (designateDeveloperDto.getRetrieveDeveloperIds().contains(sysTenant.getCreator())) {
                designateDeveloperDto.getRetrieveDeveloperIds().remove(sysTenant.getCreator());
                res = TranslateUtil.getTranslateName((String)"SAVE_SUCCESS_EXCEPT_CREATOR", (String)"\u9664\u9879\u76ee\u521b\u5efa\u8005\u5916\u4fdd\u5b58\u6210\u529f");
            }
            if (HussarUtils.isEmpty((Object)designateDeveloperDto.getRetrieveDeveloperIds())) {
                return res;
            }
            this.sysTenantDeveloperService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDeveloper::getTenantId, (Object)designateDeveloperDto.getTenantId())).in(SysTenantDeveloper::getUserId, (Collection)designateDeveloperDto.getRetrieveDeveloperIds()));
            List tenantUsers = this.sysUsersService.listByIds(connName, (Collection)designateDeveloperDto.getRetrieveDeveloperIds());
            if (HussarUtils.isNotEmpty((Object)tenantUsers)) {
                tenantUsers.forEach(user -> user.setAccountStatus(UserStatus.CANCEL.getCode()));
                this.sysUsersService.updateBatchById(connName, (Collection)tenantUsers);
            }
        }
        return res;
    }

    public Page<SysTenant> developList(PageInfo pageInfo, String tenantName) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        List list = this.sysTenantDeveloperService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantDeveloper::getUserId, (Object)securityUser.getUserId()));
        if (HussarUtils.isEmpty((Object)list)) {
            return new Page();
        }
        List ids = list.stream().map(SysTenantDeveloper::getTenantId).collect(Collectors.toList());
        List createTenantIds = this.sysTenantService.list((Wrapper)Wrappers.lambdaQuery().eq(HussarBaseEntity::getCreator, (Object)securityUser.getUserId())).stream().map(SysTenant::getId).collect(Collectors.toList());
        ids.addAll(createTenantIds);
        return (Page)this.sysTenantService.page((IPage)new Page(pageInfo.getCurrent(), pageInfo.getSize()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysTenant::getId, ids)).in(SysTenant::getTenantStatus, new Object[]{"1", "3"})).like(SysTenant::getTenantName, (Object)tenantName)).orderByDesc(HussarBaseEntity::getCreateTime));
    }

    public List<SysUsers> getDevelopers(Long tenantId) {
        List<Object> developers = new ArrayList<SysUsers>();
        List list = this.sysTenantDeveloperService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantDeveloper::getTenantId, (Object)tenantId));
        if (HussarUtils.isNotEmpty((Object)list)) {
            List userIds = list.stream().map(SysTenantDeveloper::getUserId).collect(Collectors.toList());
            developers = this.sysUsersService.listByIds(userIds);
        }
        return developers;
    }
}

