/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.onsystem.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.http.HussarHttpServletRequest;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityResponse;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.security.plugin.oauth2.SecurityOAuth2Manager;
import com.jxdinfo.hussar.support.security.plugin.oauth2.config.SecurityOAuth2Config;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.HussarSecurityAuthenticationService;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.HussarSecurityOAuth2InterceptorCustomizers;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.dto.SecurityAuthenticationDto;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Util;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.AccessTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.support.TokenModel;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.tenant.common.util.TenantUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class TenantDeveloperCustomizers
implements HussarSecurityOAuth2InterceptorCustomizers {
    private static final Logger logger = LoggerFactory.getLogger(TenantDeveloperCustomizers.class);
    private final ConcurrentHashMap<String, Object> tenantLockMap = new ConcurrentHashMap();
    @Autowired(required=false)
    private HussarSecurityAuthenticationService hussarSecurityAuthenticationService;
    @Resource
    private IHussarTenantCommonService hussarTenantCommonService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysUserRoleService sysUserRoleService;

    public int order() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customize(SecurityRequest securityRequest, SecurityResponse securityResponse) {
        block12: {
            try {
                Object tenantLock;
                SecurityOAuth2Config securityOauth2Config = SecurityOAuth2Manager.getConfig();
                String accessToken = securityRequest.getHeader(securityOauth2Config.getHeaderTokenKey());
                if (HussarUtils.isEmpty((Object)accessToken)) {
                    return;
                }
                HussarTenantDefinition tenantDefinition = this.hussarTenantCommonService.parse();
                if (HussarUtils.isEmpty((Object)tenantDefinition)) {
                    return;
                }
                String tenantCode = tenantDefinition.getTenantCode();
                if (HussarUtils.isEmpty((Object)tenantCode) || "0".equals(tenantCode)) {
                    return;
                }
                SecurityUser userDetails = BaseSecurityUtil.getUser();
                if (!HussarUtils.isNotEmpty((Object)userDetails) || !"0".equals(userDetails.getTenantCode())) break block12;
                TokenModel masterTokenModel = SecurityOAuth2Util.getTokenModelByAcessToken((String)accessToken, null);
                if (HussarUtils.isEmpty((Object)masterTokenModel) || !(masterTokenModel instanceof AccessTokenModel)) {
                    return;
                }
                String tenantToken = accessToken + "_" + tenantCode;
                securityRequest.setHeaderForce(securityOauth2Config.getHeaderTokenKey(), tenantToken);
                Environment environment = SpringContextHolder.environment;
                String tokenHeader = environment.getProperty("hussar.security.oauth2.header-token-key");
                ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                HussarHttpServletRequest hussarHttpServletRequest = new HussarHttpServletRequest(servletRequestAttributes.getRequest());
                hussarHttpServletRequest.addHeader(tokenHeader, tenantToken);
                ServletRequestAttributes newServletRequestAttributes = new ServletRequestAttributes((HttpServletRequest)hussarHttpServletRequest);
                RequestContextHolder.setRequestAttributes((RequestAttributes)newServletRequestAttributes);
                UserDetails tenantUserDetails = HussarSecurityUtils.getLoginUserDetails((String)tenantToken);
                if (HussarUtils.isNotEmpty((Object)tenantUserDetails)) {
                    this.renewMainToken((AccessTokenModel)masterTokenModel);
                    return;
                }
                Object object = tenantLock = this.tenantLockMap.computeIfAbsent(tenantCode, k -> new Object());
                synchronized (object) {
                    String connName;
                    long count;
                    tenantUserDetails = HussarSecurityUtils.getLoginUserDetails((String)tenantToken);
                    if (HussarUtils.isNotEmpty((Object)tenantUserDetails)) {
                        this.renewMainToken((AccessTokenModel)masterTokenModel);
                        return;
                    }
                    List roleIds = (List)userDetails.getExtendUserMap("rolesList");
                    if (HussarUtils.isNotEmpty((Object)roleIds) && roleIds.contains(String.valueOf(SysUserAndRole.SUPERADMIN_ROLE.getValue())) && (count = this.sysUsersService.count(connName = tenantDefinition.getConnName(), (Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)userDetails.getAccount()))) <= 0L) {
                        Long userId = userDetails.getUserId();
                        this.createSuperAdminUser(connName, userId, userDetails.getAccount());
                        this.createSuperAdminRoles(connName, userId);
                    }
                    SecurityAuthenticationDto dto = new SecurityAuthenticationDto();
                    dto.setUsername(userDetails.getAccount());
                    dto.setPassword("123456");
                    dto.setClientId("hussar-base");
                    dto.setTenantCode(tenantCode);
                    HashMap<String, String> extendMap = new HashMap<String, String>();
                    extendMap.put("loginType", "tenant_developer_login");
                    extendMap.put("loginCode", dto.getUsername());
                    extendMap.put("swagger", "1");
                    extendMap.put("specify-access-token", tenantToken);
                    extendMap.put(securityOauth2Config.getPasswordlessKey(), "true");
                    dto.setParamsMapExcludeParam(extendMap);
                    this.hussarSecurityAuthenticationService.securityPassword(dto);
                }
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u5f00\u53d1\u4eba\u5458\u4ece\u5e94\u7528\u5f00\u53d1\u5e73\u53f0\u8fdb\u5165\u79df\u6237\u7cfb\u7edf\u514d\u767b\u5f55\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void createSuperAdminUser(String connName, Long userId, String userAccount) {
        SysUsers adminUser = new SysUsers();
        adminUser.setId(userId);
        adminUser.setUserName(userAccount);
        adminUser.setUserAccount(userAccount);
        adminUser.setAccountStatus(UserStatus.OK.getCode());
        adminUser.setIsCpublic("0");
        adminUser.setTypeProperty("1");
        adminUser.setSecurityLevel(Integer.valueOf(3));
        adminUser.setMaxSessions(Integer.valueOf(-1));
        adminUser.setCorporationId(Long.valueOf(11L));
        adminUser.setDepartmentId(Long.valueOf(11L));
        adminUser.setIsSys("1");
        adminUser.setLoginIpLimit("0");
        adminUser.setLoginTimeLimit("0");
        adminUser.setPassword(TenantUtil.getEncodeSecure((String)"123456"));
        this.sysUsersService.save(connName, (Object)adminUser);
    }

    private void createSuperAdminRoles(String connName, Long userId) {
        List<SysUserRole> tenantUserRoles = Arrays.asList(this.createUserRole(userId, TenantConstant.ADMIN_ROLE), this.createUserRole(userId, SysUserAndRole.DEVELOP_ROLE.getValue()));
        this.sysUserRoleService.saveBatch(connName, tenantUserRoles);
    }

    private SysUserRole createUserRole(Long userId, Long roleId) {
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(userId);
        userRole.setGrantedRole(roleId);
        userRole.setAdminOption(UserRoleStatus.OK.getCode());
        return userRole;
    }

    private void renewMainToken(AccessTokenModel mainAccessTokenModel) {
        SecurityOAuth2Config securityOauth2Config = SecurityOAuth2Manager.getConfig();
        if (securityOauth2Config.getRefreshTokenThreshold() <= 0L) {
            return;
        }
        if (securityOauth2Config.getEnableRenewal().booleanValue()) {
            SecurityUtil.updateAllLoginTokenTimeout((String)mainAccessTokenModel.loginTicket, (long)86400L);
            SecurityOAuth2Util.updateAllAccessTokenTimeout((String)mainAccessTokenModel.accessToken, (long)1800L, (long)86400L);
        }
    }
}

