/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.onsystem.service.feign.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantCommonUtil;
import com.jxdinfo.hussar.utils.TranslateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@DependsOn(value={"springContextHolder"})
@Service(value="com.jxdinfo.hussar.tenant.onsystem.service.feign.impl.remoteOnSystemTenantTypeParseServiceImpl")
public class RemoteOnSystemTenantTypeParseServiceImpl
implements IHussarTenantCommonService {
    @Autowired
    private ISysTenantService tenantService;

    public HussarTenantDefinition parse() {
        String tenantCode = TenantCommonUtil.getTenantCodeByUrl();
        if (HussarUtils.isNotBlank((CharSequence)tenantCode)) {
            return this.search(tenantCode);
        }
        return new DefaultTenant();
    }

    public HussarTenantDefinition search(String tenantCode) {
        HussarTenantDefinition tenantByTenantCode = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode);
        if (HussarUtils.isEmpty((Object)tenantByTenantCode)) {
            if ("0".equalsIgnoreCase(tenantCode)) {
                return new DefaultTenant();
            }
            tenantByTenantCode = this.tenantService.getTenantByTenantCode(tenantCode);
            if (HussarUtils.isEmpty((Object)tenantByTenantCode)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)"TENANT_CODE_NULL", (String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u7f16\u7801\u4fe1\u606f\uff1a") + tenantCode);
            }
        }
        return tenantByTenantCode;
    }
}

