/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.groupingmodel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.tenant.groupingmodel.model.StruUserChangeLog;
import com.jxdinfo.hussar.tenant.groupingmodel.service.IStruUserChangeLogService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISyncStruUserDataService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISyncTenantSuccessFlagService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SyncStruUserDataProcessor
implements BasicProcessor {
    private static final Logger log = LoggerFactory.getLogger(SyncStruUserDataProcessor.class);
    @Resource
    private IStruUserChangeLogService struUserChangeLogService;
    @Resource
    private ISyncStruUserDataService syncStruUserDataService;
    @Resource
    private ISyncTenantSuccessFlagService syncTenantSuccessFlagService;

    public ProcessResult process(TaskContext taskContext) throws Exception {
        HashMap errorMsg = new HashMap();
        errorMsg.put("sysStaffs", new ArrayList());
        errorMsg.put("sysUsers", new ArrayList());
        errorMsg.put("sysStrus", new ArrayList());
        errorMsg.put("sysOrgans", new ArrayList());
        errorMsg.put("sysOffices", new ArrayList());
        log.info("\u8fd0\u884c\u540c\u6b65\u7ec4\u7ec7\u673a\u6784\u63a5\u53e3\uff0c\u7528\u6765\u540c\u6b65\u7ec4\u7ec7\u673a\u6784\u4eba\u5458");
        List list = this.struUserChangeLogService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(StruUserChangeLog::getStatus, (Object)0)).or()).eq(StruUserChangeLog::getStatus, (Object)2)).orderByAsc(HussarBaseEntity::getLastTime));
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.info("\u8fd0\u884c\u540c\u6b65\u7ec4\u7ec7\u673a\u6784\u63a5\u53e3\uff0c\u65e0\u9700\u8981\u540c\u6b65\u7684\u6570\u636e");
            return new ProcessResult(true);
        }
        log.info("\u8fd0\u884c\u540c\u6b65\u7ec4\u7ec7\u673a\u6784\u63a5\u53e3\uff0c\u540c\u6b65\u6570\u636e\u6761\u6570\uff1a{}", (Object)list.size());
        list.forEach(changeLog -> {
            String tableName = changeLog.getTableName().toLowerCase();
            try {
                log.info("\u8fd0\u884c\u540c\u6b65\u7ec4\u7ec7\u673a\u6784\u63a5\u53e3\uff0c\u540c\u6b65{}\uff1a{}", (Object)tableName, (Object)changeLog.toString());
                switch (tableName) {
                    case "sys_stru": {
                        this.syncStruUserDataService.syncSysStru(changeLog, errorMsg);
                        break;
                    }
                    case "sys_organ": {
                        this.syncStruUserDataService.syncSysOrgan(changeLog, errorMsg);
                        break;
                    }
                    case "sys_office": {
                        this.syncStruUserDataService.syncSysOffice(changeLog, errorMsg);
                        break;
                    }
                    case "sys_staff": {
                        this.syncStruUserDataService.syncSysStaff(changeLog, errorMsg);
                        break;
                    }
                    case "sys_stru_staff": {
                        this.syncStruUserDataService.syncSysStruStaff(changeLog);
                        break;
                    }
                    case "sys_users": {
                        this.syncStruUserDataService.syncSysUsers(changeLog, errorMsg);
                        break;
                    }
                    case "sys_stru_user": {
                        this.syncStruUserDataService.syncSysStruUser(changeLog);
                        break;
                    }
                    case "sys_organ_type": {
                        this.syncStruUserDataService.syncSysOrganType(changeLog);
                        break;
                    }
                    case "sys_stru_rule": {
                        this.syncStruUserDataService.syncSysStruRule(changeLog);
                        break;
                    }
                    default: {
                        log.info("\u6ca1\u6709\u627e\u5230\u53ef\u540c\u6b65\u7684\u65b9\u6cd5\uff0ctableName\uff1a{}", (Object)tableName);
                    }
                }
                log.info("\u8fd0\u884c\u540c\u6b65\u7ec4\u7ec7\u673a\u6784\u63a5\u53e3\u7ed3\u675f\uff0c\u540c\u6b65{}\uff1a{}", (Object)tableName, (Object)changeLog.toString());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
        String result = JsonUtil.toJson(errorMsg);
        return new ProcessResult(true, result);
    }
}

