/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.groupingmodel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.util.TenantAuthorizationUtils;
import com.jxdinfo.hussar.tenant.common.util.TenantUtil;
import com.jxdinfo.hussar.tenant.groupingmodel.dto.TenantTernaryAccountDto;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SolitaryGroupingModelTenant;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SysTenantMultUser;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SysTenantStru;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysTenantMultUserService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysTenantStruService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.TenantGroupingModelService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.TenantOrganizationUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantGroupingModelServiceImpl
implements TenantGroupingModelService {
    @Autowired
    private ISysUsersService usersService;
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private ISysStruUserService sysStruUserService;
    @Autowired
    private ISysStruStaffService sysStruStaffService;
    @Autowired
    private ISysStaffService sysStaffService;
    @Autowired
    private TenantOrganizationUserService tenantOrganizationUserService;
    @Autowired
    private ISysOrganService sysOrganService;
    @Autowired
    private ISysOfficeService sysOfficeService;
    @Autowired
    private ISysTenantMultUserService tenantMultUserService;
    @Autowired
    private ISysTenantStruService sysTenantStruService;

    @HussarTransactional
    public void initTenantThreeAdmin(String connName, SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        ArrayList<SysUsers> sysUsersList = new ArrayList<SysUsers>();
        ArrayList<SysStaff> sysStaffList = new ArrayList<SysStaff>();
        ArrayList<SysUserRole> sysUserRoleList = new ArrayList<SysUserRole>();
        ArrayList<SysTenantMultUser> tenantMultUsers = new ArrayList<SysTenantMultUser>();
        int initSeq = 1;
        int initUserType = 0;
        String securitySecrecy = solitaryGroupingModelTenant.getSecuritySecrecy().getUserAccount();
        String securityAudit = solitaryGroupingModelTenant.getSecurityAudit().getUserAccount();
        String systemManage = solitaryGroupingModelTenant.getSystemManage().getUserAccount();
        HashSet<String> userAccounts = new HashSet<String>();
        userAccounts.add(securitySecrecy);
        userAccounts.add(securityAudit);
        userAccounts.add(systemManage);
        if (userAccounts.size() != 3 || this.usersService.count((Wrapper)new LambdaQueryWrapper().in(SysUsers::getUserAccount, userAccounts)) > 0L) {
            throw new BaseException("\u79df\u6237\u521b\u5efa\u5931\u8d25\uff0c\u4e09\u5458\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        LinkedHashMap<Long, TenantTernaryAccountDto> roleAccountMap = new LinkedHashMap<Long, TenantTernaryAccountDto>();
        roleAccountMap.put(1450785935166925011L, solitaryGroupingModelTenant.getSecuritySecrecy());
        roleAccountMap.put(1450781935868925962L, solitaryGroupingModelTenant.getSecurityAudit());
        roleAccountMap.put(1450715195867925063L, solitaryGroupingModelTenant.getSystemManage());
        for (Map.Entry ternaryAccountDto : roleAccountMap.entrySet()) {
            int staffSeq = initSeq;
            List staffs = this.sysStaffService.list((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SysStaff::getStaffOrder}).orderByDesc(SysStaff::getStaffOrder));
            if (HussarUtils.isNotEmpty((Object)staffs)) {
                staffSeq = ((SysStaff)staffs.get(0)).getStaffOrder() + initSeq;
            }
            int usersSeq = initSeq;
            List sysUserSeq = this.usersService.list((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SysUsers::getUserOrder}).orderByDesc(SysUsers::getUserOrder));
            if (HussarUtils.isNotEmpty((Object)sysUserSeq)) {
                usersSeq = ((SysUsers)sysUserSeq.get(0)).getUserOrder() + initSeq;
            }
            ++initSeq;
            SysStaff sysStaff = new SysStaff();
            long staffId = IdWorker.getId((Object)sysStaff);
            sysStaff.setId(Long.valueOf(staffId));
            sysStaff.setName(((TenantTernaryAccountDto)ternaryAccountDto.getValue()).getStaffName());
            sysStaff.setStaffOrder(Integer.valueOf(staffSeq));
            sysStaff.setStaffCode(String.valueOf(staffId));
            sysStaffList.add(sysStaff);
            SysUsers sysUsers = new SysUsers();
            long usersId = IdWorker.getId((Object)sysUsers);
            sysUsers.setId(Long.valueOf(usersId));
            sysUsers.setEmployeeId(Long.valueOf(staffId));
            sysUsers.setUserName(((TenantTernaryAccountDto)ternaryAccountDto.getValue()).getStaffName());
            sysUsers.setUserAccount(((TenantTernaryAccountDto)ternaryAccountDto.getValue()).getUserAccount());
            TenantUtil.setDefaultUserFields((SysUsers)sysUsers);
            sysUsers.setPassword(TenantUtil.getEncodeSecure((String)"123456"));
            sysUsers.setUserOrder(Integer.valueOf(usersSeq));
            sysUsersList.add(sysUsers);
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(Long.valueOf(usersId));
            sysUserRole.setGrantedRole((Long)ternaryAccountDto.getKey());
            sysUserRole.setAdminOption("1");
            sysUserRoleList.add(sysUserRole);
            SysTenantMultUser sysTenantMultUser = new SysTenantMultUser();
            sysTenantMultUser.setTenantId(solitaryGroupingModelTenant.getTenantId());
            sysTenantMultUser.setUserId(Long.valueOf(usersId));
            sysTenantMultUser.setUserType(String.valueOf(initUserType++));
            tenantMultUsers.add(sysTenantMultUser);
        }
        this.usersService.saveBatch(sysUsersList);
        this.sysStaffService.saveBatch(sysStaffList);
        this.tenantMultUserService.saveBatch(tenantMultUsers);
        this.tenantOrganizationUserService.initTernaryUserInfo(connName, sysStaffList, sysUsersList, sysUserRoleList);
    }

    @HussarTransactional
    public void updateTenantTernaryAdmin(String connName, SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        Map<String, Long> tenantMultUserMap = this.tenantMultUserService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantMultUser::getTenantId, (Object)solitaryGroupingModelTenant.getTenantId())).stream().collect(Collectors.toMap(SysTenantMultUser::getUserType, SysTenantMultUser::getUserId));
        if (HussarUtils.isEmpty(tenantMultUserMap)) {
            this.initTenantThreeAdmin(connName, solitaryGroupingModelTenant);
            return;
        }
        ArrayList<SysStaff> sysStaffList = new ArrayList<SysStaff>();
        ArrayList<SysUsers> sysUsersList = new ArrayList<SysUsers>();
        for (Map.Entry<String, Long> tenantMultUser : tenantMultUserMap.entrySet()) {
            Long usersId = null;
            String name = "";
            if ("0".equals(tenantMultUser.getKey())) {
                usersId = tenantMultUserMap.get("0");
                name = solitaryGroupingModelTenant.getSecuritySecrecy().getStaffName();
            } else if ("1".equals(tenantMultUser.getKey())) {
                usersId = tenantMultUserMap.get("1");
                name = solitaryGroupingModelTenant.getSecurityAudit().getStaffName();
            } else if ("2".equals(tenantMultUser.getKey())) {
                usersId = tenantMultUserMap.get("2");
                name = solitaryGroupingModelTenant.getSystemManage().getStaffName();
            }
            if (HussarUtils.isEmpty((Object)usersId)) {
                throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u7c7b\u578b\u7684\u7528\u6237");
            }
            SysUsers sysUsers = this.usersService.getById(usersId);
            sysUsers.setUserName(name);
            SysStaff sysStaff = (SysStaff)this.sysStaffService.getById((Serializable)sysUsers.getEmployeeId());
            sysStaff.setName(name);
            sysStaffList.add(sysStaff);
            sysUsersList.add(sysUsers);
        }
        this.sysStaffService.saveOrUpdateBatch(sysStaffList);
        this.usersService.saveOrUpdateBatch(sysUsersList);
        this.tenantOrganizationUserService.updateTernaryUserInfo(connName, sysStaffList, sysUsersList);
    }

    @HussarTransactional
    public void initTenantStruAndUsers(String connName, SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        Long tenantId = solitaryGroupingModelTenant.getTenantId();
        this.sysTenantStruService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantStru::getTenantId, (Object)tenantId));
        this.tenantOrganizationUserService.removeSyncTenantStruAndUsers(connName);
        List struIdList = solitaryGroupingModelTenant.getStruIdList();
        if (HussarUtils.isNotEmpty((Object)struIdList)) {
            ArrayList<SysTenantStru> sysTenantStrus = new ArrayList<SysTenantStru>();
            for (Long struId : struIdList) {
                SysTenantStru sysTenantStru = new SysTenantStru();
                sysTenantStru.setStruId(struId);
                sysTenantStru.setTenantId(tenantId);
                sysTenantStrus.add(sysTenantStru);
            }
            Set struIdChild = TenantAuthorizationUtils.getStruChild((List)this.sysStruService.list(), (List)struIdList);
            List sysStruList = this.sysStruService.listByIds((Collection)struIdChild);
            TenantAuthorizationUtils.noParentSetParent((List)sysStruList, (Long)11L);
            List organId = sysStruList.stream().map(SysStru::getOrganId).collect(Collectors.toList());
            List sysOrgans = this.sysOrganService.listByIds(organId);
            List sysOffices = this.sysOfficeService.list((Wrapper)new LambdaQueryWrapper().in(SysOffice::getStruId, (Collection)struIdChild));
            List sysStruUserList = this.sysStruUserService.list((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, (Collection)struIdChild));
            Set userIds = null;
            List sysUsers = null;
            List sysStaffs = null;
            List sysStruStaffList = null;
            if (HussarUtils.isNotEmpty((Object)sysStruUserList)) {
                userIds = sysStruUserList.stream().map(SysStruUser::getUserId).collect(Collectors.toSet());
                sysUsers = this.usersService.listByIds(userIds);
                List sysStaffIds = sysUsers.stream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
                sysStaffs = this.sysStaffService.listByIds(sysStaffIds);
                sysStruStaffList = this.sysStruStaffService.list((Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, sysStaffIds));
            }
            this.sysTenantStruService.saveBatch(sysTenantStrus);
            this.tenantOrganizationUserService.syncTenantStruAndUsers(connName, sysStruList, sysOrgans, sysOffices, sysStruUserList, userIds, sysUsers, sysStaffs, sysStruStaffList);
        }
    }
}

