/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.groupingmodel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.tenant.groupingmodel.model.StruUserChangeLog;
import com.jxdinfo.hussar.tenant.groupingmodel.service.IStruUserChangeLogService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISyncStruUserDataService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SyncStruUserDataProcessor
implements BasicProcessor {
    private static Logger log = LoggerFactory.getLogger(SyncStruUserDataProcessor.class);
    @Resource
    private IStruUserChangeLogService struUserChangeLogService;
    @Resource
    private ISyncStruUserDataService syncStruUserDataService;

    public ProcessResult process(TaskContext taskContext) throws Exception {
        List list = this.struUserChangeLogService.list((Wrapper)Wrappers.lambdaQuery().eq(StruUserChangeLog::getStatus, (Object)0));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ProcessResult(true);
        }
        list.forEach(changeLog -> {
            String tableName = changeLog.getTableName().toLowerCase();
            try {
                switch (tableName) {
                    case "sys_stru": {
                        this.syncStruUserDataService.syncSysStru(changeLog);
                        break;
                    }
                    case "sys_organ": {
                        this.syncStruUserDataService.syncSysOrgan(changeLog);
                        break;
                    }
                    case "sys_office": {
                        this.syncStruUserDataService.syncSysOffice(changeLog);
                        break;
                    }
                    case "sys_staff": {
                        this.syncStruUserDataService.syncSysStaff(changeLog);
                        break;
                    }
                    case "sys_stru_staff": {
                        this.syncStruUserDataService.syncSysStruStaff(changeLog);
                        break;
                    }
                    case "sys_users": {
                        this.syncStruUserDataService.syncSysUsers(changeLog);
                        break;
                    }
                    case "sys_stru_user": {
                        this.syncStruUserDataService.syncSysStruUser(changeLog);
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
        return new ProcessResult(true);
    }
}

