/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.groupingmodel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysLoginUserIdentity;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserIdentityService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.base.cloud.dto.ResourceGrantedAuthority;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.properties.HussarDynamicProperties;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.groupingmodel.dao.SysTenantStruMapper;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SysTenantMultUser;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SysTenantStru;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISwitchTenantService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysTenantMultUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
public class SwitchTenantServiceImpl
implements ISwitchTenantService {
    private static final Long[] ADMINS = new Long[]{716665713812840448L, 1450757642371981314L, 716671816189616128L, 1450757642371981314L, 1450757481235202050L, 1450757642371981324L};
    @Resource
    private ISysTenantService sysTenantService;
    @Resource
    private SysTenantStruMapper tenantStruMapper;
    @Resource
    private ISysUsersService usersService;
    @Resource
    private HussarDynamicProperties hussarDynamicProperties;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysStruRoleService sysStruRoleService;
    @Resource
    private ISysTenantMultUserService tenantMultUserService;
    @Resource
    private ISysStruUserService sysStruUserService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private IHussarBaseUserIdentityService hussarBaseUserIdentityService;

    public List<SysTenant> switchTenantList(Long userId) {
        List resultList = this.sysTenantService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantStatus, (Object)"1")).orderByAsc(SysTenant::getTenantSeq)).orderByDesc(HussarBaseEntity::getCreateTime));
        if (!ArrayUtils.contains((Object[])ADMINS, (Object)userId)) {
            SysTenantMultUser tenantMultUser = (SysTenantMultUser)this.tenantMultUserService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysTenantMultUser::getUserId, (Object)userId));
            List tenantUerIds = resultList.stream().map(SysTenant::getTenantAdminId).collect(Collectors.toList());
            if (tenantMultUser != null) {
                SysTenant sysTenant = (SysTenant)this.sysTenantService.getById((Serializable)tenantMultUser.getTenantId());
                resultList.clear();
                resultList.add(sysTenant);
            } else if (tenantUerIds.contains(userId)) {
                SysTenant sysTenant = (SysTenant)this.sysTenantService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantAdminId, (Object)userId));
                resultList.clear();
                resultList.add(sysTenant);
            } else {
                List struByStruIds;
                HashSet struCollection = Sets.newHashSet();
                List sysStruUserList = this.sysStruUserService.list((Wrapper)Wrappers.lambdaQuery().eq(SysStruUser::getUserId, (Object)userId));
                if (CollectionUtils.isNotEmpty((Collection)sysStruUserList) && (struByStruIds = this.sysStruService.getStruByStruIds(sysStruUserList.stream().map(SysStruUser::getStruId).collect(Collectors.toList()))) != null) {
                    for (SysStru sysStru : struByStruIds) {
                        Set collect = Arrays.stream(sysStru.getStruFid().split("/")).filter(HussarUtils::isNotBlank).map(Long::parseLong).collect(Collectors.toSet());
                        struCollection.addAll(collect);
                    }
                }
                List tenantStrus = this.tenantStruMapper.selectList((Wrapper)Wrappers.lambdaQuery());
                List tenantIdList = tenantStrus.stream().filter(t -> struCollection.contains(t.getStruId())).map(SysTenantStru::getTenantId).collect(Collectors.toList());
                resultList = resultList.stream().filter(r -> tenantIdList.contains(r.getId()) || "0".equals(r.getTenantCode())).collect(Collectors.toList());
            }
        }
        return resultList;
    }

    public SysTenant getDefaultTenant(String username) {
        SysUsers sysUsers = (SysUsers)this.usersService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysUsers::getUserAccount, (Object)username));
        if (null == sysUsers || ArrayUtils.contains((Object[])ADMINS, (Object)sysUsers.getId())) {
            SysTenant defaultTenant = new SysTenant();
            defaultTenant.setTenantCode("0");
            defaultTenant.setTenantName("\u5e73\u53f0\u7ea7");
            defaultTenant.setConnName("master");
            return defaultTenant;
        }
        List<SysTenant> tenantList = this.switchTenantList(sysUsers.getId());
        ArrayList collect = tenantList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SysTenant>(Comparator.comparing(SysTenant::getTenantSeq).thenComparing(Comparator.comparing(HussarBaseEntity::getCreateTime).reversed()))), ArrayList::new));
        if (HussarUtils.isNotEmpty((Object)collect)) {
            return (SysTenant)collect.get(0);
        }
        SysTenant defaultTenant = new SysTenant();
        defaultTenant.setTenantCode("0");
        defaultTenant.setTenantName("\u5e73\u53f0\u7ea7");
        defaultTenant.setConnName("master");
        return defaultTenant;
    }

    @HussarDs(value="#connName")
    public Boolean switchTenant(String connName, HussarTenantDefinition tenantInfo) {
        UserDetails userDetails = this.getUserDetails(tenantInfo);
        List rolesList = this.sysUserRoleService.getRolesByUserId(userDetails.getUserId());
        HussarSecurityUtils.putSessionExtend((String)"gradeAdmin", (Object)(ToolUtil.isNotEmpty((Object)rolesList) && rolesList.contains(SysUserAndRole.GRADEADMIN_ROLE.getValue()) ? 1 : 0));
        List sysStruUserList = this.sysStruUserService.list((Wrapper)Wrappers.lambdaQuery().eq(SysStruUser::getUserId, (Object)userDetails.getUserId()));
        if (CollectionUtils.isNotEmpty((Collection)sysStruUserList)) {
            List struIds = sysStruUserList.stream().map(SysStruUser::getStruId).collect(Collectors.toList());
            List roleList = this.sysStruRoleService.getRolesByStruIds(struIds);
            if (HussarUtils.isNotEmpty((Object)rolesList)) {
                rolesList.addAll(roleList);
            }
        }
        userDetails.addExtendUserMap("rolesList", (Object)rolesList);
        ResourceGrantedAuthority resourceGrantedAuthority = this.getPermissionByRoleIds(rolesList, userDetails.getUserId(), connName);
        userDetails.addExtendUserMap("permissions", (Object)resourceGrantedAuthority.getGrantAuthorityList());
        HussarSecurityUtils.updateUserDetails((UserDetails)userDetails);
        SysLoginUserIdentity loginUserIdentity = this.hussarBaseUserIdentityService.getOne(connName, userDetails.getUserId());
        if (HussarUtils.isEmpty((Object)loginUserIdentity)) {
            Object struId;
            SysLoginUserIdentity sysLoginUserIdentity = new SysLoginUserIdentity();
            sysLoginUserIdentity.setUserId(userDetails.getUserId());
            Object postId = userDetails.getExtendUserMap().get("postId");
            if (HussarUtils.isNotEmpty(postId)) {
                sysLoginUserIdentity.setPostId(Long.valueOf(postId + ""));
            }
            if (HussarUtils.isNotEmpty(struId = userDetails.getExtendUserMap().get("deptId"))) {
                sysLoginUserIdentity.setStruId(Long.valueOf(struId + ""));
            }
            this.hussarBaseUserIdentityService.save(connName, sysLoginUserIdentity);
        }
        return Boolean.TRUE;
    }

    @NotNull
    private UserDetails getUserDetails(HussarTenantDefinition tenantInfo) {
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        userDetails.addExtendUserMap(this.hussarDynamicProperties.getDatasourceKeyByHeader(), (Object)tenantInfo.getConnName());
        userDetails.setTenantId(tenantInfo.getTenantId());
        userDetails.setTenantCode(tenantInfo.getTenantCode());
        userDetails.addExtendUserMap("tenantName", (Object)tenantInfo.getTenantName());
        userDetails.addExtendUserMap("tcode", (Object)tenantInfo.getTenantCode());
        userDetails.addExtendUserMap("connName", (Object)tenantInfo.getConnName());
        return userDetails;
    }

    private ResourceGrantedAuthority getPermissionByRoleIds(List<Long> roleList, Long userId, String connName) {
        List<String> resourcePermissions;
        ResourceGrantedAuthority resourceGrantedAuthority = new ResourceGrantedAuthority();
        if (roleList.contains(SysUserAndRole.SUPERADMIN_ROLE.getValue()) || roleList.contains(SysUserAndRole.DEVELOP_ROLE.getValue())) {
            List resourcesList = this.sysResourcesService.list(connName);
            resourcePermissions = new ArrayList();
            for (SysResources resources : resourcesList) {
                resourcePermissions.add(resources.getPermissions());
            }
        } else {
            resourcePermissions = this.sysResourcesService.queryPermissionsByRoleIds(roleList);
        }
        if (HussarUtils.isNotEmpty(resourcePermissions)) {
            resourceGrantedAuthority.setGrantAuthorityList(resourcePermissions);
        }
        return resourceGrantedAuthority;
    }
}

