/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.groupingmodel.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.groupingmodel.dao.SysSyncTenantLogMapper;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SysSyncTenantLog;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysSyncTenantLogService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.SyncTenantStruUserStaffService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ISysSyncTenantLogServiceImpl
extends HussarServiceImpl<SysSyncTenantLogMapper, SysSyncTenantLog>
implements ISysSyncTenantLogService {
    @Autowired
    private SyncTenantStruUserStaffService struUserStaffService;

    @HussarTransactional
    public void compensateData() {
        List sysSyncTenantLogs = this.list((Wrapper)new LambdaQueryWrapper().orderByAsc(HussarBaseEntity::getCreateTime));
        if (HussarUtils.isNotEmpty((Object)sysSyncTenantLogs)) {
            Set<Long> delCurrDateId = this.dealHaveDelData(sysSyncTenantLogs);
            if (HussarUtils.isNotEmpty(delCurrDateId)) {
                List syncTenantLogsListRemove = sysSyncTenantLogs.stream().filter(item -> delCurrDateId.contains(item.getCurrDateId())).collect(Collectors.toList());
                sysSyncTenantLogs.removeAll(syncTenantLogsListRemove);
            }
            ArrayList<String> existCurrDataId = new ArrayList<String>();
            Map<String, List<SysSyncTenantLog>> sysSyncTenantLogMap = sysSyncTenantLogs.stream().collect(Collectors.groupingBy(SysSyncTenantLog::getDateAndTenantId));
            for (SysSyncTenantLog sysSyncTenantLog : sysSyncTenantLogs) {
                List sysStruUsersOld;
                List sysStruUsersNew;
                SysUsers sysUsersOld;
                SysUsers sysUsersNew;
                Long currDateId = sysSyncTenantLog.getCurrDateId();
                Long tenantId = sysSyncTenantLog.getTenantId();
                String dateAndTenantId = currDateId.toString() + tenantId;
                if (existCurrDataId.contains(dateAndTenantId)) continue;
                existCurrDataId.add(dateAndTenantId);
                super.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysSyncTenantLog::getCurrDateId, (Object)currDateId)).eq(SysSyncTenantLog::getTenantId, (Object)tenantId));
                List<SysSyncTenantLog> currDateTenantLogList = sysSyncTenantLogMap.get(dateAndTenantId);
                SysSyncTenantLog lastSuccessLog = currDateTenantLogList.stream().filter(item -> "0".equals(item.getIsSuccess())).reduce((first, second) -> second).orElse(null);
                if (lastSuccessLog != null) {
                    int lastIndex = currDateTenantLogList.lastIndexOf(lastSuccessLog);
                    List<SysSyncTenantLog> subsequentLogs = currDateTenantLogList.subList(lastIndex, currDateTenantLogList.size());
                    if (!HussarUtils.isNotEmpty(subsequentLogs)) continue;
                    for (SysSyncTenantLog subsequentLog : subsequentLogs) {
                        int operateType = subsequentLog.getOperateType();
                        JSONObject contentObject = JSON.parseObject((String)subsequentLog.getContent());
                        switch (operateType) {
                            case 2: {
                                sysUsersNew = (SysUsers)JSON.parseObject((String)contentObject.get((Object)"sysUsersNew").toString(), SysUsers.class);
                                sysUsersOld = (SysUsers)JSON.parseObject((String)contentObject.get((Object)"sysUsersOld").toString(), SysUsers.class);
                                sysStruUsersNew = JSON.parseArray((String)contentObject.get((Object)"sysStruUsersNew").toString(), SysStruUser.class);
                                sysStruUsersOld = JSON.parseArray((String)contentObject.get((Object)"sysStruUsersOld").toString(), SysStruUser.class);
                                this.struUserStaffService.syncUpdateUser(Collections.singletonList(sysUsersNew), Collections.singletonList(sysUsersOld), sysStruUsersNew, sysStruUsersOld, tenantId);
                                break;
                            }
                            case 5: {
                                SysStru sysStrus = (SysStru)JSON.parseObject((String)contentObject.get((Object)"sysStrus").toString(), SysStru.class);
                                SysOrgan sysOrgans = (SysOrgan)JSON.parseObject((String)contentObject.get((Object)"sysOrgans").toString(), SysOrgan.class);
                                this.struUserStaffService.syncUpdateStru(Collections.singletonList(sysStrus), Collections.singletonList(sysOrgans), tenantId);
                                break;
                            }
                        }
                    }
                    continue;
                }
                for (SysSyncTenantLog currDateTenantLog : currDateTenantLogList) {
                    int operateType = currDateTenantLog.getOperateType();
                    JSONObject contentObject = JSON.parseObject((String)currDateTenantLog.getContent());
                    switch (operateType) {
                        case 1: {
                            SysUsers sysUsers = (SysUsers)JSON.parseObject((String)contentObject.get((Object)"sysUsers").toString(), SysUsers.class);
                            List sysStruUsers = JSON.parseArray((String)contentObject.get((Object)"sysStruUsers").toString(), SysStruUser.class);
                            this.struUserStaffService.syncAddUser(Collections.singletonList(sysUsers), sysStruUsers, tenantId);
                            break;
                        }
                        case 2: {
                            sysUsersNew = (SysUsers)JSON.parseObject((String)contentObject.get((Object)"sysUsersNew").toString(), SysUsers.class);
                            sysUsersOld = (SysUsers)JSON.parseObject((String)contentObject.get((Object)"sysUsersOld").toString(), SysUsers.class);
                            sysStruUsersNew = JSON.parseArray((String)contentObject.get((Object)"sysStruUsersNew").toString(), SysStruUser.class);
                            sysStruUsersOld = JSON.parseArray((String)contentObject.get((Object)"sysStruUsersOld").toString(), SysStruUser.class);
                            this.struUserStaffService.syncUpdateUser(Collections.singletonList(sysUsersNew), Collections.singletonList(sysUsersOld), sysStruUsersNew, sysStruUsersOld, tenantId);
                            break;
                        }
                        case 4: {
                            SysStru sysStrusAdd = (SysStru)JSON.parseObject((String)contentObject.get((Object)"sysStrus").toString(), SysStru.class);
                            SysOrgan sysOrgansAdd = (SysOrgan)JSON.parseObject((String)contentObject.get((Object)"sysOrgans").toString(), SysOrgan.class);
                            SysOffice sysOffices = (SysOffice)JSON.parseObject((String)contentObject.get((Object)"sysOffices").toString(), SysOffice.class);
                            this.struUserStaffService.syncAddStru(Collections.singletonList(sysStrusAdd), Collections.singletonList(sysOrgansAdd), Collections.singletonList(sysOffices), tenantId);
                            break;
                        }
                        case 5: {
                            SysStru sysStrus = (SysStru)JSON.parseObject((String)contentObject.get((Object)"sysStrus").toString(), SysStru.class);
                            SysOrgan sysOrgans = (SysOrgan)JSON.parseObject((String)contentObject.get((Object)"sysOrgans").toString(), SysOrgan.class);
                            this.struUserStaffService.syncUpdateStru(Collections.singletonList(sysStrus), Collections.singletonList(sysOrgans), tenantId);
                            break;
                        }
                    }
                }
            }
        }
    }

    private Set<Long> dealHaveDelData(List<SysSyncTenantLog> sysSyncTenantLogs) {
        List sysSyncTenantLogsDel = sysSyncTenantLogs.stream().filter(item -> HussarUtils.equals((Object)item.getOperateType(), (Object)3) || HussarUtils.equals((Object)item.getOperateType(), (Object)6)).collect(Collectors.toList());
        HashSet<Long> delCurrDateId = new HashSet<Long>();
        for (SysSyncTenantLog sysSyncTenantLogDel : sysSyncTenantLogsDel) {
            String isSuccess = sysSyncTenantLogDel.getIsSuccess();
            Long tenantId = sysSyncTenantLogDel.getTenantId();
            Long currDateId = sysSyncTenantLogDel.getCurrDateId();
            super.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysSyncTenantLog::getCurrDateId, (Object)currDateId)).eq(SysSyncTenantLog::getTenantId, (Object)tenantId));
            if ("1".equals(isSuccess)) {
                int operateType = sysSyncTenantLogDel.getOperateType();
                JSONObject contentObject = JSON.parseObject((String)sysSyncTenantLogDel.getContent());
                switch (operateType) {
                    case 3: {
                        String userIdsString = contentObject.get((Object)"userIds").toString();
                        Long userIds = (Long)JSON.parseObject((String)userIdsString, Long.class);
                        this.struUserStaffService.syncDeleteUser(Collections.singletonList(userIds), tenantId);
                        break;
                    }
                    case 6: {
                        Long struIds = (Long)JSON.parseObject((String)contentObject.get((Object)"struIds").toString(), Long.class);
                        Long organIds = (Long)JSON.parseObject((String)contentObject.get((Object)"organIds").toString(), Long.class);
                        this.struUserStaffService.syncDeleteStru(Collections.singletonList(struIds), Collections.singletonList(organIds), tenantId);
                        break;
                    }
                }
            }
            delCurrDateId.add(currDateId);
        }
        return delCurrDateId;
    }
}

