/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.groupingmodel.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.ExceptionUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.tenant.common.dto.QueryTenantDto;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.MiddleStep;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantDatasource;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.model.TenantDbModel;
import com.jxdinfo.hussar.tenant.common.service.impl.AbstractHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantLogUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantUtil;
import com.jxdinfo.hussar.tenant.groupingmodel.dao.SysTenantGroupingModelMapper;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SolitaryGroupingModelTenant;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SysTenantDatasourceGroup;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SysTenantMultUser;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SysTenantStru;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysTenantDatasourceGroupService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysTenantMultUserService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysTenantStruService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.TenantGroupingModelService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.TenantOrganizationUserService;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.tenant.groupingmodel.service.impl.hussarBaseSolitaryGroupingModelTenantServiceImpl")
public class HussarBaseSolitaryGroupingModelTenantServiceImpl
extends AbstractHussarBaseTenantService<SolitaryGroupingModelTenant> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarBaseSolitaryGroupingModelTenantServiceImpl.class);
    @Resource
    private SysTenantGroupingModelMapper sysTenantGroupingModelMapper;
    @Autowired
    private ISysTenantStruService sysTenantStruService;
    @Autowired
    private ISysTenantDatasourceGroupService sysTenantDatasourceGroupService;
    @Autowired
    private DatasourceService datasourceService;
    @Autowired
    private TenantGroupingModelService tenantGroupingModelService;
    @Autowired
    private ISysUsersService usersService;
    @Autowired
    private ISysTenantMultUserService tenantMultUserService;
    @Autowired
    private ISysBaseConfigService baseConfigService;
    @Autowired
    private ISysStaffService sysStaffService;
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private TenantOrganizationUserService tenantOrganizationUserService;

    public Page<SolitaryGroupingModelTenant> searchTenant(QueryTenantDto queryTenantDto) {
        Page page = new Page(queryTenantDto.getCurrent(), queryTenantDto.getSize());
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("tenantCode", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantCode()));
        queryOrgParams.put("tenantName", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantName()));
        queryOrgParams.put("tenantStatus", queryTenantDto.getTenantStatus());
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<SolitaryGroupingModelTenant> solitaryGroupingModelTenants = this.sysTenantGroupingModelMapper.searchSolitaryGroupingModelTenant((Page<SolitaryGroupingModelTenant>)page, queryOrgParams);
        page.setRecords(solitaryGroupingModelTenants);
        return page;
    }

    public SolitaryGroupingModelTenant findTenantById(Long tenantId) {
        HussarTenantDefinition tenantByTenantId = this.getTenantByTenantId(tenantId);
        return (SolitaryGroupingModelTenant)TenantUtil.convert((HussarTenantDefinition)tenantByTenantId, SolitaryGroupingModelTenant.class);
    }

    public void initTenantAdmin(String connName, SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        SysUsers sysUsers = new SysUsers();
        sysUsers.setUserName(solitaryGroupingModelTenant.getLinkman());
        sysUsers.setMobile(solitaryGroupingModelTenant.getContactNumber());
        String userAccount = solitaryGroupingModelTenant.getUserAccount();
        if (this.usersService.count((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)userAccount)) > 0L) {
            throw new BaseException("\u7528\u6237\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        sysUsers.setUserAccount(userAccount);
        TenantUtil.setDefaultUserFields((SysUsers)sysUsers);
        String encodeSecure = TenantUtil.getEncodeSecure((String)solitaryGroupingModelTenant.getSecure());
        sysUsers.setPassword(encodeSecure);
        Integer userOrder = this.usersService.getUserMaxOrder();
        userOrder = HussarUtils.isEmpty((Object)userOrder) ? Integer.valueOf(1) : Integer.valueOf(userOrder + 1);
        sysUsers.setUserOrder(userOrder);
        this.usersService.save((Object)sysUsers);
        this.usersService.save(connName, (Object)sysUsers);
        solitaryGroupingModelTenant.setTenantAdminId(sysUsers.getId());
    }

    public void afterAddTenant(SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        String connName = solitaryGroupingModelTenant.getConnName();
        this.baseConfigService.update(connName, null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysBaseConfig::getConfigKey, (Object)"allow_change_pwd")).set(SysBaseConfig::getConfigValue, (Object)"1"));
        HussarCacheUtil.evictKeysLike((String)"base_config", (String)"allow_change_pwd");
    }

    public void initTenantThreeAdmin(String connName, SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        this.tenantGroupingModelService.initTenantThreeAdmin(connName, solitaryGroupingModelTenant);
    }

    public void updateTenantTernaryAdmin(String connName, SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        this.tenantGroupingModelService.updateTenantTernaryAdmin(connName, solitaryGroupingModelTenant);
    }

    protected List<TenantDbModel> checkAndGetTenantDbModelList(SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        List tenantDbModelList = this.sysTenantDataSourceService.ofTenant((HussarTenantDefinition)solitaryGroupingModelTenant);
        boolean microService = EnvironmentUtil.isMicroService();
        if (microService) {
            this.checkGroupingModelOfMicroService(solitaryGroupingModelTenant);
        }
        for (TenantDbModel dto : tenantDbModelList) {
            String msg;
            block19: {
                String creation = dto.getCreation();
                SysDataSourceDto sysDataSourceDto = dto.getSysDataSourceDto();
                String jdbcUrl = sysDataSourceDto.getJdbcUrl();
                String userName = sysDataSourceDto.getUserName();
                String password = sysDataSourceDto.getPassword();
                msg = "";
                String className = "";
                try {
                    className = DriverManager.getDriver(jdbcUrl).getClass().getName();
                    Class.forName(className);
                }
                catch (Exception var5) {
                    throw new BaseException("\u52a0\u8f7d\u9a71\u52a8\u7c7b" + className + "\u5931\u8d25");
                }
                try (Connection connection = DriverManager.getConnection(jdbcUrl, userName, password);){
                    ResultSet tables = connection.getMetaData().getTables(connection.getCatalog(), connection.getSchema(), null, new String[]{"TABLE"});
                    if (!tables.next()) {
                        msg = "\u68c0\u6d4b\u5230\u81ea\u4e3b\u521b\u5efa\u3010" + jdbcUrl + "\u3011\u7a7a\u5e93\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u6570\u636e\u5e93\u540d\u79f0";
                    }
                }
                catch (Exception e) {
                    if (!creation.equals("2")) break block19;
                    msg = "\u79df\u6237\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25";
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)msg)) continue;
            throw new BaseException(msg);
        }
        return tenantDbModelList;
    }

    private void checkGroupingModelOfMicroService(SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        boolean notMaster;
        String connName = solitaryGroupingModelTenant.getConnName();
        boolean bl = notMaster = HussarUtils.isNotBlank((CharSequence)connName) && !connName.equalsIgnoreCase("master");
        if (!notMaster) {
            throw new BaseException("\u975e\u6cd5\u6570\u636e\u6e90\u540d\u79f0");
        }
        if (connName.contains("-") || connName.contains("_")) {
            throw new BaseException("\u6570\u636e\u6e90\u540d\u79f0\u4e0d\u80fd\u5305\u542b-\u6216\u8005_");
        }
        Set allDatasourcesName = this.dynamicDatasourceService.getAllDatasourcesName();
        boolean contains = false;
        if (HussarUtils.isNotEmpty((Object)allDatasourcesName)) {
            for (String dsName : allDatasourcesName) {
                if (!dsName.equalsIgnoreCase(connName)) continue;
                contains = true;
                break;
            }
        }
        if (contains) {
            throw new BaseException("\u6570\u636e\u6e90\u540d\u79f0\u91cd\u590d");
        }
        Optional<SysTenantDatasource> anyDs = this.sysTenantDataSourceService.list().stream().filter(item -> item.getConnName().equalsIgnoreCase(connName)).findAny();
        if (anyDs.isPresent()) {
            throw new BaseException("\u6570\u636e\u6e90\u540d\u79f0\u91cd\u590d");
        }
        List storagePropertiesList = solitaryGroupingModelTenant.getStoragePropertiesList();
        if (HussarUtils.isEmpty((Object)storagePropertiesList)) {
            throw new BaseException("\u79df\u6237\u6570\u636e\u5b58\u50a8\u4fe1\u606f\u4e3a\u7a7a");
        }
    }

    protected void createDbInSingleEnvironment(SolitaryGroupingModelTenant solitaryGroupingModelTenant, List<TenantDbModel> tenantDbModelList, HussarTenantDefinition definition, List<Map<String, Object>> storagePropertiesList, String currentServiceName) {
        this.createDbOfSingle((HussarTenantDefinition)solitaryGroupingModelTenant, tenantDbModelList, definition, storagePropertiesList, currentServiceName);
    }

    protected void createDbInMicroServiceEnvironment(SolitaryGroupingModelTenant solitaryGroupingModelTenant, List<TenantDbModel> tenantDbModelList, HussarTenantDefinition definition, List<Map<String, Object>> storagePropertiesList, String currentServiceName, Map<String, TenantDbModel> tenantDbModelMap) {
        this.createDbOfMicroService((HussarTenantDefinition)solitaryGroupingModelTenant, tenantDbModelList, definition, storagePropertiesList, currentServiceName, tenantDbModelMap);
    }

    protected List<MiddleStep> defineDynamicStep(SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        String defaultBeanName = "com.jxdinfo.hussar.tenant.groupingmodel.service.impl.hussarBaseSolitaryGroupingModelTenantServiceImpl";
        ArrayList<MiddleStep> result = new ArrayList<MiddleStep>();
        MiddleStep step1 = new MiddleStep();
        step1.setStepNo(Integer.valueOf(82));
        step1.setBeanName(defaultBeanName);
        step1.setMethodName("initTenantPermissionData");
        step1.setMethodDesc("\u79df\u6237\u5e93\u63d2\u5165\u6743\u9650\u6570\u636e");
        Class[] initTenantPermissionDataParamClass = new Class[]{String.class};
        step1.setParamClass(initTenantPermissionDataParamClass);
        result.add(step1);
        MiddleStep step2 = new MiddleStep();
        step2.setStepNo(Integer.valueOf(90));
        step2.setBeanName(defaultBeanName);
        step2.setMethodName("initTenantStruAndUsers");
        step2.setMethodDesc("\u540c\u6b65\u7ec4\u7ec7\u53ca\u7528\u6237\u4fe1\u606f");
        Class[] initTenantStruAndUsersParamClass = new Class[]{String.class, SolitaryGroupingModelTenant.class};
        step2.setParamClass(initTenantStruAndUsersParamClass);
        result.add(step2);
        MiddleStep step3 = new MiddleStep();
        step3.setStepNo(Integer.valueOf(91));
        step3.setBeanName(defaultBeanName);
        step3.setMethodName("initTenantDataSource");
        step3.setMethodDesc("\u521d\u59cb\u5316\u79df\u6237\u4e0e\u6570\u636e\u6e90\u5173\u8054\u5173\u7cfb");
        Class[] initTenantDataSourceParamClass = new Class[]{SolitaryGroupingModelTenant.class};
        step3.setParamClass(initTenantDataSourceParamClass);
        result.add(step3);
        MiddleStep step4 = new MiddleStep();
        step4.setStepNo(Integer.valueOf(92));
        step4.setBeanName(defaultBeanName);
        step4.setMethodName("initTenantThreeAdmin");
        step4.setMethodDesc("\u521d\u59cb\u5316\u79df\u6237\u4e09\u5458\u7ba1\u7406\u5458");
        Class[] initTenantThreeAdminParamClass = new Class[]{String.class, SolitaryGroupingModelTenant.class};
        step4.setParamClass(initTenantThreeAdminParamClass);
        result.add(step4);
        MiddleStep step5 = new MiddleStep();
        step5.setStepNo(Integer.valueOf(86));
        step5.setBeanName(defaultBeanName);
        step5.setMethodName("initClientInfo");
        step5.setMethodDesc("\u521d\u59cb\u5316\u79df\u6237\u5ba2\u6237\u7aef\u8ba4\u8bc1\u4fe1\u606f");
        Class[] initClientInfoParamClass = new Class[]{String.class, SolitaryGroupingModelTenant.class};
        step5.setParamClass(initClientInfoParamClass);
        result.add(step5);
        return result;
    }

    protected void executeStepFail(int stepNo, SolitaryGroupingModelTenant solitaryGroupingModelTenant, List<TenantDbModel> tenantDbModelList) {
    }

    protected void executeStepSuccess(int stepNo, SolitaryGroupingModelTenant solitaryGroupingModelTenant, List<TenantDbModel> tenantDbModelList) {
    }

    protected boolean canExecute(int stepNo, SolitaryGroupingModelTenant solitaryGroupingModelTenant, List<TenantDbModel> tenantDbModelList) {
        if (92 == stepNo) {
            SysBaseConfig sysBaseConfig = this.baseConfigService.getSysBaseConfig("protection_status");
            return HussarUtils.isNotEmpty((Object)sysBaseConfig) && sysBaseConfig.getConfigValue().equals("3");
        }
        return true;
    }

    protected Object[] getParamValues(int stepNo, SolitaryGroupingModelTenant solitaryGroupingModelTenant, List<TenantDbModel> tenantDbModelList) {
        String connName = solitaryGroupingModelTenant.getConnName();
        if (82 == stepNo) {
            Object[] arr = new Object[]{connName};
            return arr;
        }
        if (90 == stepNo || 92 == stepNo || 86 == stepNo) {
            Object[] arr = new Object[]{connName, solitaryGroupingModelTenant};
            return arr;
        }
        if (91 == stepNo) {
            Object[] arr = new Object[]{solitaryGroupingModelTenant};
            return arr;
        }
        return new Object[0];
    }

    protected void checkEditTenant(SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        if (this.isCreateDbFail(solitaryGroupingModelTenant)) {
            List<TenantDbModel> tenantDbModelList = this.checkAndGetTenantDbModelList(solitaryGroupingModelTenant);
            Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
            List<TenantDbModel> finalTenantDbModelList = tenantDbModelList;
            hussarBaseTenantExecutor.execute(() -> this.asyncAdd((HussarTenantDefinition)solitaryGroupingModelTenant, finalTenantDbModelList));
            return;
        }
    }

    protected void updateSpecificData(SolitaryGroupingModelTenant t, Collection<String> serviceNames, List<TenantDbModel> tenantDbModelList) {
        boolean updateTenantSource = this.isUpdateTenantSource(t);
        String currentServiceName = EnvironmentUtil.getServiceName();
        if (updateTenantSource) {
            LOGGER.info("\u5f00\u59cb\u66f4\u65b0\u6570\u636e\u5e93\u8fde\u63a5");
            List storagePropertiesList = t.getStoragePropertiesList();
            for (Map storageProperties : storagePropertiesList) {
                String serviceName = (String)storageProperties.get("serviceName");
                String serviceUsed = (String)storageProperties.get("inUse");
                if (HussarUtils.isNotEmpty(serviceNames) && !serviceNames.contains(serviceName) && HussarUtils.isNotBlank((CharSequence)serviceUsed) && "1".equals(serviceUsed)) continue;
                storageProperties.put("tenantCode", t.getTenantCode());
                storageProperties.put("connName", t.getConnName());
                SysTenantLog createDb = this.getSysTenantCreateDbLog((HussarTenantDefinition)t, currentServiceName, storageProperties, tenantDbModelList.get(0));
                try {
                    createDb.setExecStatus(Integer.valueOf(1));
                    TenantCacheUtil.putTenantDataSourceCache((String)t.getTenantCode(), (Map)storageProperties);
                    this.asyncUpdateTenantLogService.tenantlogUpdate(createDb);
                }
                catch (Exception e) {
                    createDb.setExecStatus(Integer.valueOf(0));
                    createDb.setErrorTimes(Integer.valueOf(createDb.getErrorTimes() + 1));
                    createDb.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
                    this.asyncUpdateTenantLogService.tenantlogUpdate(createDb);
                    throw new BaseException("\u66f4\u65b0\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519\uff01", (Throwable)e);
                }
            }
            SysTenantLog initTenantDataSourceLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(91));
            if (HussarUtils.isEmpty((Object)initTenantDataSourceLog)) {
                initTenantDataSourceLog = TenantLogUtil.initTenantDataSourceInfoLog((HussarTenantDefinition)t);
            }
            try {
                this.initTenantDataSource(t);
                LOGGER.info("\u66f4\u65b0\u79df\u6237\u4e0e\u6570\u636e\u6e90\u5173\u8054\u5173\u7cfb\u5b8c\u6210");
                initTenantDataSourceLog.setExecStatus(Integer.valueOf(1));
                this.asyncUpdateTenantLogService.tenantlogUpdate(initTenantDataSourceLog);
            }
            catch (Exception e) {
                initTenantDataSourceLog.setExecStatus(Integer.valueOf(0));
                initTenantDataSourceLog.setErrorTimes(Integer.valueOf(initTenantDataSourceLog.getErrorTimes() + 1));
                initTenantDataSourceLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
                this.asyncUpdateTenantLogService.tenantlogUpdate(initTenantDataSourceLog);
                LOGGER.error("\u66f4\u65b0\u79df\u6237\u4e0e\u6570\u636e\u6e90\u5173\u8054\u5173\u7cfb\u5931\u8d25", (Throwable)e);
            }
        }
        String connName = t.getConnName();
        SysTenantLog initTenantStruAndUsersLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(90));
        if (HussarUtils.isEmpty((Object)initTenantStruAndUsersLog)) {
            initTenantStruAndUsersLog = TenantLogUtil.initTenantStruAndUsersInfoLog((HussarTenantDefinition)t);
        }
        try {
            if (this.isUpdateTenantStru(t) || updateTenantSource) {
                this.initTenantStruAndUsers(connName, t);
                LOGGER.info("\u540c\u6b65\u7ec4\u7ec7\u53ca\u7528\u6237\u4fe1\u606f\u5b8c\u6210");
                initTenantStruAndUsersLog.setExecStatus(Integer.valueOf(1));
                this.asyncUpdateTenantLogService.tenantlogUpdate(initTenantStruAndUsersLog);
            }
        }
        catch (Exception e) {
            initTenantStruAndUsersLog.setExecStatus(Integer.valueOf(0));
            initTenantStruAndUsersLog.setErrorTimes(Integer.valueOf(initTenantStruAndUsersLog.getErrorTimes() + 1));
            initTenantStruAndUsersLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initTenantStruAndUsersLog);
            LOGGER.error("\u540c\u6b65\u7ec4\u7ec7\u53ca\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        SysTenantLog initTenantThreeAdminLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(93));
        if (HussarUtils.isEmpty((Object)initTenantThreeAdminLog)) {
            initTenantThreeAdminLog = TenantLogUtil.updateTenantTernaryAdminLog((HussarTenantDefinition)t);
        }
        try {
            this.updateTenantTernaryAdmin(connName, t);
            LOGGER.info("\u66f4\u65b0\u79df\u6237\u4e09\u5458\u7ba1\u7406\u5458\u5b8c\u6210");
            initTenantThreeAdminLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initTenantThreeAdminLog);
        }
        catch (Exception e) {
            initTenantThreeAdminLog.setExecStatus(Integer.valueOf(0));
            initTenantThreeAdminLog.setErrorTimes(Integer.valueOf(initTenantThreeAdminLog.getErrorTimes() + 1));
            initTenantThreeAdminLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initTenantThreeAdminLog);
            LOGGER.error("\u66f4\u65b0\u79df\u6237\u4e09\u5458\u7ba1\u7406\u5458\u5931\u8d25", (Throwable)e);
        }
    }

    protected void deleteSpecificData(SysTenant tenant) {
        String connName = tenant.getConnName();
        Long tenantId = tenant.getId();
        SysBaseConfig sysBaseConfig = this.baseConfigService.getSysBaseConfig("protection_status");
        if (HussarUtils.isEmpty((Object)sysBaseConfig) || !sysBaseConfig.getConfigValue().equals("3")) {
            try {
                LOGGER.info("\u5220\u9664\u79df\u6237\u7ba1\u7406\u5458\u4fe1\u606f");
                this.sysUsersService.removeById((Serializable)tenant.getTenantAdminId());
                this.sysUsersService.removeById(connName, (Serializable)tenant.getTenantAdminId());
            }
            catch (Exception e) {
                LOGGER.error("\u5220\u9664\u79df\u6237\u7ba1\u7406\u5458\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        }
        try {
            LOGGER.info("\u5220\u9664\u79df\u6237\u591a\u7528\u6237\u5173\u8054\u4fe1\u606f");
            List userIds = this.tenantMultUserService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantMultUser::getTenantId, (Object)tenantId)).stream().map(SysTenantMultUser::getUserId).collect(Collectors.toList());
            this.tenantMultUserService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantMultUser::getTenantId, (Object)tenantId));
            if (HussarUtils.isNotEmpty(userIds)) {
                List staffIds = this.sysUsersService.listByIds(userIds).stream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
                this.sysUsersService.removeByIds(userIds);
                this.sysStaffService.removeByIds(staffIds);
                this.tenantOrganizationUserService.removeTernaryUserInfo(connName, staffIds, userIds);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u79df\u6237\u591a\u7528\u6237\u5173\u8054\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        try {
            LOGGER.info("\u5220\u9664\u79df\u6237\u7ec4\u7ec7\u5173\u8054\u4fe1\u606f");
            this.sysTenantStruService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantStru::getTenantId, (Object)tenantId));
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u79df\u6237\u7ec4\u7ec7\u5173\u8054\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        try {
            LOGGER.info("\u5220\u9664\u79df\u6237\u6570\u636e\u6e90\u5173\u8054\u8868\u4fe1\u606f");
            this.removeTenantDatasource(tenantId);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u79df\u6237\u6570\u636e\u6e90\u5173\u8054\u8868\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    public void saveTenant(SolitaryGroupingModelTenant solitaryTenant) {
        SysTenant tenant = TenantUtil.convert2SysTenant((HussarTenantDefinition)solitaryTenant);
        this.tenantService.saveOrUpdate((Object)tenant);
    }

    public boolean isUpdateTenantStru(SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        List sysTenantStrus = this.sysTenantStruService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantStru::getTenantId, (Object)solitaryGroupingModelTenant.getTenantId()));
        List struIdListNew = solitaryGroupingModelTenant.getStruIdList();
        if (HussarUtils.isEmpty((Object)sysTenantStrus) && HussarUtils.isNotEmpty((Object)struIdListNew)) {
            return true;
        }
        if (HussarUtils.isNotEmpty((Object)struIdListNew)) {
            List struIds = sysTenantStrus.stream().map(SysTenantStru::getStruId).collect(Collectors.toList());
            return struIds.size() != struIdListNew.size() || !struIdListNew.containsAll(struIds);
        }
        return false;
    }

    public boolean isUpdateTenantSource(SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        boolean microService = EnvironmentUtil.isMicroService();
        Long tenantId = solitaryGroupingModelTenant.getTenantId();
        if (!microService) {
            SysTenantDatasourceGroup sysTenantDatasources = (SysTenantDatasourceGroup)this.sysTenantDatasourceGroupService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).isNull(SysTenantDatasourceGroup::getServiceName));
            if (HussarUtils.isNotEmpty((Object)sysTenantDatasources)) {
                Long datasourceIdNew;
                Long dbIdOld = sysTenantDatasources.getDbId();
                return !HussarUtils.equals((Object)dbIdOld, (Object)(datasourceIdNew = solitaryGroupingModelTenant.getDatasourceId()));
            }
        } else {
            List storagePropertiesListNew = solitaryGroupingModelTenant.getStoragePropertiesList();
            int newDatasourceCount = storagePropertiesListNew.size();
            SysTenantRecord sysTenantRecord = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantId, (Object)tenantId));
            HussarTenantDefinition hussarTenantDefinition = (HussarTenantDefinition)JSON.parseObject((String)sysTenantRecord.getTenantParams(), HussarTenantDefinition.class);
            List storagePropertiesListOld = hussarTenantDefinition.getStoragePropertiesList();
            int oldDatasourceCount = storagePropertiesListOld.size();
            for (Map storagePropertiesNewMap : storagePropertiesListNew) {
                String serviceName = storagePropertiesNewMap.get("serviceName").toString();
                if (newDatasourceCount != oldDatasourceCount) {
                    return true;
                }
                Map storagePropertiesOldMap = storagePropertiesListOld.stream().filter(item -> item.get("serviceName").toString().equals(serviceName)).findFirst().orElse(null);
                if (storagePropertiesOldMap == null) {
                    return true;
                }
                if (HussarUtils.equals(storagePropertiesOldMap.get("jdbcUrl"), storagePropertiesNewMap.get("jdbcUrl")) && HussarUtils.equals(storagePropertiesOldMap.get("remark"), storagePropertiesNewMap.get("remark"))) continue;
                return true;
            }
        }
        return false;
    }

    public void initTenantStruAndUsers(String connName, SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        this.tenantGroupingModelService.initTenantStruAndUsers(connName, solitaryGroupingModelTenant);
    }

    public void initTenantDataSource(SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        Long tenantId = solitaryGroupingModelTenant.getTenantId();
        this.removeTenantDatasource(tenantId);
        boolean microService = EnvironmentUtil.isMicroService();
        if (microService) {
            String currentServiceName = EnvironmentUtil.getServiceName((boolean)true);
            List storagePropertiesList = solitaryGroupingModelTenant.getStoragePropertiesList();
            boolean flag = false;
            for (Map storageProperties : storagePropertiesList) {
                if (!currentServiceName.equals(storageProperties.get("serviceName").toString())) continue;
                Long dbId = ((SysDataSource)this.datasourceService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysDataSource::getConnName, (Object)solitaryGroupingModelTenant.getConnName()))).getId();
                SysTenantDatasourceGroup sysTenantDatasource = new SysTenantDatasourceGroup();
                sysTenantDatasource.setTenantId(tenantId);
                sysTenantDatasource.setDbId(dbId);
                sysTenantDatasource.setServiceName(currentServiceName);
                this.sysTenantDatasourceGroupService.save((Object)sysTenantDatasource);
                flag = true;
            }
            if (!flag) {
                throw new BaseException("\u672a\u627e\u5230\u9ed8\u8ba4\u670d\u52a1\u540d\u5bf9\u5e94\u7684serviceName");
            }
        } else {
            SysTenantDatasourceGroup sysTenantDatasource = new SysTenantDatasourceGroup();
            sysTenantDatasource.setTenantId(tenantId);
            sysTenantDatasource.setDbId(solitaryGroupingModelTenant.getDatasourceId());
            sysTenantDatasource.setServiceName(null);
            this.sysTenantDatasourceGroupService.save((Object)sysTenantDatasource);
        }
    }

    public boolean isCreateDbFail(SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        return 2 == solitaryGroupingModelTenant.getStepNo();
    }

    public void removeTenantDatasource(Long tenantId) {
        this.sysTenantDatasourceGroupService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId));
    }
}

