/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.groupingmodel.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.datasource.manager.api.entity.SysDatasourceConfig;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.manager.plugin.datasource.service.DatasourceConfigService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SysTenantDatasourceGroup;
import com.jxdinfo.hussar.tenant.groupingmodel.service.HussarBaseGroupingModelDatasourceService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysTenantDatasourceGroupService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.datasource.DataSourceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
public class HussarBaseGroupingModelDatasourceServiceImpl
implements HussarBaseGroupingModelDatasourceService {
    @Autowired
    private DatasourceService datasourceService;
    @Autowired
    private ISysTenantDatasourceGroupService sysTenantDatasourceService;
    private final DynamicDatasourceService dynamicDatasourceService;
    private final DatasourceConfigService datasourceConfigService;
    private final DynamicDataSourceProperties dataSourceProperties;
    private final HussarTenantProperties tenantProperties;

    public HussarBaseGroupingModelDatasourceServiceImpl(DynamicDatasourceService dynamicDatasourceService, DatasourceConfigService datasourceConfigService, DynamicDataSourceProperties dataSourceProperties, HussarTenantProperties tenantProperties) {
        this.dynamicDatasourceService = dynamicDatasourceService;
        this.datasourceConfigService = datasourceConfigService;
        this.dataSourceProperties = dataSourceProperties;
        this.tenantProperties = tenantProperties;
    }

    @DSTransactional
    public List<SysDataSource> deleteDataSource(List<String> ids) {
        if (HussarUtils.isEmpty(ids)) {
            throw new HussarException("\u53c2\u6570\u4f20\u9012\u4e3a\u7a7a\uff01");
        }
        List idList = ids.stream().map(HussarUtils::toLong).collect(Collectors.toList());
        List list = this.datasourceService.listByIds(idList);
        if (!this.datasourceService.removeByIds(idList)) {
            throw new DataSourceException("\u5220\u9664\u6570\u636e\u6e90\u5931\u8d25");
        }
        this.datasourceConfigService.remove((Wrapper)new LambdaQueryWrapper().in(SysDatasourceConfig::getDbId, idList));
        for (SysDataSource sysDataSource : list) {
            if (!HussarUtils.isNotEmpty((Object)sysDataSource.getConnName())) continue;
            this.dynamicDatasourceService.removeDynamicDatasource(sysDataSource.getConnName());
        }
        if (this.sysTenantDatasourceService.count((Wrapper)new LambdaQueryWrapper().in(SysTenantDatasourceGroup::getDbId, ids)) > 0L) {
            throw new BaseException("\u6570\u636e\u6e90\u5df2\u7ed1\u5b9a\u79df\u6237\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        return list;
    }

    public List<SysDataSource> getListByType(String datasourceType, String tenantCode) {
        List dbIds;
        if (HussarUtils.isEmpty((Object)datasourceType)) {
            throw new HussarException("\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysDataSource::getDatasourceType, (Object)datasourceType)).eq(HussarDelflagEntity::getDelFlag, (Object)"0")).orderByDesc(HussarBaseEntity::getCreateTime);
        if (HussarUtils.isEmpty((Object)tenantCode)) {
            queryWrapper.eq(SysDataSource::getTenantCode, (Object)"0");
        } else {
            queryWrapper.eq(SysDataSource::getTenantCode, (Object)tenantCode);
        }
        if ("1".equals(datasourceType) && HussarUtils.isNotEmpty(dbIds = this.sysTenantDatasourceService.list().stream().map(SysTenantDatasourceGroup::getDbId).collect(Collectors.toList()))) {
            queryWrapper.notIn(SysDataSource::getId, dbIds);
        }
        return this.datasourceService.list((Wrapper)queryWrapper);
    }
}

