/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.groupingmodel.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.support.service.TableMetaSupportService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeColumnData;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeData;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeRowData;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.handler.AuditLogParser;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.support.MybatisInvocation;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.support.sqlhandler.SelectAuditSqlHandler;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.utils.MybatisUtils;
import com.jxdinfo.hussar.tenant.groupingmodel.dto.SysStruSyncDto;
import com.jxdinfo.hussar.tenant.groupingmodel.model.StruUserChangeLog;
import com.jxdinfo.hussar.tenant.groupingmodel.service.IStruUserChangeLogService;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;

@Intercepts(value={@Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="batch", args={Statement.class})})
public class StruUserMybatisInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(StruUserMybatisInterceptor.class);
    private static final String[] MONITORED_TABLES = new String[]{"sys_stru", "sys_office", "sys_organ", "sys_staff", "sys_stru_staff", "sys_users", "sys_stru_user"};
    private static final String MYBATIS_TARGET_NAME = "h";
    private static final String PREPARED_STATEMENT_LOGGER_COLUMNVALUES = "columnValues";
    private TableMetaSupportService metaSupportService;
    @Lazy
    @Resource
    private IStruUserChangeLogService struUserChangeLogService;

    public StruUserMybatisInterceptor(TableMetaSupportService metaSupportService) {
        this.metaSupportService = metaSupportService;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        return this.doInterceptor(invocation);
    }

    private Object doInterceptor(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        PluginUtils.MPStatementHandler mpStatementHandler = PluginUtils.mpStatementHandler((StatementHandler)statementHandler);
        MappedStatement mappedStatement = mpStatementHandler.mappedStatement();
        String sql = statementHandler.getBoundSql().getSql().toLowerCase();
        String tableName = this.extractTableName(sql);
        if (tableName == null || !this.isMonitoredTable(tableName)) {
            return invocation.proceed();
        }
        if (!this.isDataModificationCommand(mappedStatement)) {
            return invocation.proceed();
        }
        if (!this.isMaster()) {
            return invocation.proceed();
        }
        return this.struUserSyncHandler(invocation, this.metaSupportService);
    }

    public Object struUserSyncHandler(Invocation invocation, TableMetaSupportService metaSupportService) throws Throwable {
        SelectAuditSqlHandler selectAuditSqlHandler = new SelectAuditSqlHandler(invocation);
        MybatisInvocation mybatisInvocation = selectAuditSqlHandler.createMybatisInvocation(metaSupportService);
        List<ChangeRowData> changeRowDataList = null;
        changeRowDataList = this.preDoStruUserSyncHandler(mybatisInvocation);
        Object result = invocation.proceed();
        this.postDoStruUserSyncHandler(mybatisInvocation, changeRowDataList);
        return result;
    }

    public List<ChangeRowData> preDoStruUserSyncHandler(MybatisInvocation mybatisInvocation) {
        List changeRows = null;
        AuditLogParser auditLogParser = mybatisInvocation.getAuditLogParser();
        MappedStatement mappedStatement = mybatisInvocation.getMappedStatement();
        BoundSql boundSql = mybatisInvocation.getBoundSql();
        Method method = MybatisUtils.getMethod((MappedStatement)mappedStatement);
        try {
            if (HussarUtils.isEmpty((Object)auditLogParser)) {
                return null;
            }
            changeRows = auditLogParser.parseBefore(mybatisInvocation);
            if (CollectionUtils.isNotEmpty((Collection)changeRows)) {
                changeRows = changeRows.stream().filter(c -> {
                    List<String> monitoredTables = Arrays.asList(MONITORED_TABLES);
                    return monitoredTables.contains(c.getTableName().toLowerCase());
                }).collect(Collectors.toList());
            }
            return changeRows;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5ba1\u8ba1\u65e5\u5fd7\u5728\u6267\u884cpreDoStruUserSyncHandler\u65f6\u51fa\u9519\uff0cmethod:[{}],sql\u8bed\u53e5:[{}]", (Object)method.getName(), (Object)boundSql.getSql());
        }
        catch (Throwable throwable) {
            log.error("\u5ba1\u8ba1\u65e5\u5fd7\u5728\u6267\u884cpreDoStruUserSyncHandler\u65f6\u51fa\u9519\uff0cmethod:[{}],sql\u8bed\u53e5:[{}]", (Object)method.getName(), (Object)boundSql.getSql());
            throwable.printStackTrace();
        }
        return changeRows;
    }

    public void postDoStruUserSyncHandler(MybatisInvocation mybatisInvocation, List<ChangeRowData> changeRows) {
        MappedStatement mappedStatement = mybatisInvocation.getMappedStatement();
        BoundSql boundSql = mybatisInvocation.getBoundSql();
        Method method = MybatisUtils.getMethod((MappedStatement)mappedStatement);
        AuditLogParser auditLogParser = mybatisInvocation.getAuditLogParser();
        try {
            changeRows = auditLogParser.parseAfter(mybatisInvocation, changeRows);
            if (CollectionUtils.isEmpty((Collection)changeRows)) {
                return;
            }
            ArrayList changeLogList = Lists.newArrayList();
            changeRows.forEach(row -> {
                String schemaName = row.getSchemaName();
                if ("master".equals(schemaName)) {
                    ChangeData changeData;
                    log.info("\u6267\u884c\u7684SQL\u8bed\u53e5: {}", (Object)boundSql.getSql());
                    String tableName = row.getTableName();
                    TableInfo tableInfo = TableInfoHelper.getTableInfo((String)tableName);
                    if (tableInfo == null) {
                        tableInfo = TableInfoHelper.getTableInfo((String)tableName.toUpperCase());
                    }
                    List fieldList = tableInfo.getFieldList();
                    Map changeColumnMap = row.getChangeColumnMap();
                    List beforeColumnList = row.getBeforeColumnList();
                    Object pkVaule = "1";
                    if (Objects.equals(row.getSqlCommandType(), SqlCommandType.UPDATE.name())) {
                        pkVaule = row.getPKColumnData().getPkVaule();
                    } else if (Objects.equals(row.getSqlCommandType(), SqlCommandType.DELETE.name())) {
                        changeData = (ChangeData)changeColumnMap.get(tableInfo.getKeyColumn());
                        pkVaule = changeData.getOldValue();
                    } else if (Objects.equals(row.getSqlCommandType(), SqlCommandType.INSERT.name())) {
                        changeData = (ChangeData)changeColumnMap.get(tableInfo.getKeyColumn());
                        pkVaule = changeData.getNewValue();
                    }
                    StruUserChangeLog changeLog = new StruUserChangeLog();
                    changeLog.setTableName(tableName);
                    changeLog.setMethod(row.getSqlCommandType());
                    changeLog.setStatus(Integer.valueOf(0));
                    changeLog.setRecordId(String.valueOf(pkVaule));
                    String recordValue = "";
                    String recordClass = "";
                    switch (tableName.toLowerCase()) {
                        case "sys_stru": {
                            SysStru sysStru = new SysStru();
                            sysStru.setId(Long.valueOf(Long.parseLong(changeLog.getRecordId())));
                            fieldList.forEach(field -> this.buildEntity((TableFieldInfo)field, (Object)sysStru, changeColumnMap));
                            SysStruSyncDto sysStruSyncDto = new SysStruSyncDto();
                            HussarUtils.copy((Object)sysStru, (Object)sysStruSyncDto);
                            if (CollectionUtils.isNotEmpty((Collection)beforeColumnList)) {
                                Optional<ChangeColumnData> any = beforeColumnList.stream().filter(b -> "PARENT_ID".equals(b.getName())).findAny();
                                any.ifPresent(changeColumnData -> sysStruSyncDto.setOldParentId(Long.valueOf(changeColumnData.getValue() + "")));
                            }
                            recordValue = JSONObject.toJSONString((Object)sysStruSyncDto);
                            recordClass = sysStruSyncDto.getClass().getName();
                            break;
                        }
                        case "sys_office": {
                            SysOffice sysOffice = new SysOffice();
                            sysOffice.setId(Long.valueOf(Long.parseLong(changeLog.getRecordId())));
                            fieldList.forEach(field -> this.buildEntity((TableFieldInfo)field, (Object)sysOffice, changeColumnMap));
                            recordValue = JSONObject.toJSONString((Object)sysOffice);
                            recordClass = sysOffice.getClass().getName();
                            break;
                        }
                        case "sys_organ": {
                            SysOrgan sysOrgan = new SysOrgan();
                            sysOrgan.setId(Long.valueOf(Long.parseLong(changeLog.getRecordId())));
                            fieldList.forEach(field -> this.buildEntity((TableFieldInfo)field, (Object)sysOrgan, changeColumnMap));
                            recordValue = JSONObject.toJSONString((Object)sysOrgan);
                            recordClass = sysOrgan.getClass().getName();
                            break;
                        }
                        case "sys_staff": {
                            SysStaff sysStaff = new SysStaff();
                            sysStaff.setId(Long.valueOf(Long.parseLong(changeLog.getRecordId())));
                            fieldList.forEach(field -> this.buildEntity((TableFieldInfo)field, (Object)sysStaff, changeColumnMap));
                            recordValue = JSONObject.toJSONString((Object)sysStaff);
                            recordClass = sysStaff.getClass().getName();
                            break;
                        }
                        case "sys_stru_staff": {
                            SysStruStaff sysStruStaff = new SysStruStaff();
                            sysStruStaff.setId(Long.valueOf(Long.parseLong(changeLog.getRecordId())));
                            fieldList.forEach(field -> this.buildEntity((TableFieldInfo)field, (Object)sysStruStaff, changeColumnMap));
                            recordValue = JSONObject.toJSONString((Object)sysStruStaff);
                            recordClass = sysStruStaff.getClass().getName();
                            break;
                        }
                        case "sys_users": {
                            SysUsers sysUsers = new SysUsers();
                            sysUsers.setId(Long.valueOf(Long.parseLong(changeLog.getRecordId())));
                            fieldList.forEach(field -> this.buildEntity((TableFieldInfo)field, (Object)sysUsers, changeColumnMap));
                            recordValue = JSONObject.toJSONString((Object)sysUsers);
                            recordClass = sysUsers.getClass().getName();
                            break;
                        }
                        case "sys_stru_user": {
                            SysStruUser sysStruUser = new SysStruUser();
                            sysStruUser.setId(Long.valueOf(Long.parseLong(changeLog.getRecordId())));
                            fieldList.forEach(field -> this.buildEntity((TableFieldInfo)field, (Object)sysStruUser, changeColumnMap));
                            recordValue = JSONObject.toJSONString((Object)sysStruUser);
                            recordClass = sysStruUser.getClass().getName();
                        }
                    }
                    changeLog.setRecordValue(recordValue);
                    changeLog.setRecordClass(recordClass);
                    changeLogList.add(changeLog);
                }
            });
            this.struUserChangeLogService.saveBatch((Collection)changeLogList);
        }
        catch (Exception e) {
            log.error("\u5ba1\u8ba1\u65e5\u5fd7\u5728\u6267\u884cpostDoStruUserSyncHandler\u65f6\u51fa\u9519\uff0cmethod:[{}],sql\u8bed\u53e5:[{}],\u5f02\u5e38\u4fe1\u606f:{}", new Object[]{method.getName(), MybatisUtils.formatSql((String)boundSql.getSql()), e.getMessage()});
        }
        catch (Throwable throwable) {
            log.error("\u5ba1\u8ba1\u65e5\u5fd7\u5728\u6267\u884cpostDoStruUserSyncHandler\u65f6\u51fa\u9519\uff0cmethod:[{}],sql\u8bed\u53e5:[{}],\u5f02\u5e38\u4fe1\u606f:{}", new Object[]{method.getName(), MybatisUtils.formatSql((String)boundSql.getSql()), throwable.getMessage()});
        }
    }

    private <T> void buildEntity(TableFieldInfo field, T t, Map<String, ChangeData> changeColumnMap) {
        Class<?> clazz = t.getClass();
        ChangeData changeData = changeColumnMap.get(field.getColumn());
        if (changeData != null) {
            Field nameField = null;
            try {
                nameField = clazz.getDeclaredField(field.getProperty());
                nameField.setAccessible(true);
                nameField.set(t, changeData.getNewValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public List<Object> getParamColumnMapping(Object object) {
        try {
            MetaObject metaObject = SystemMetaObject.forObject((Object)object);
            List columnValues = (List)metaObject.metaObjectForProperty(MYBATIS_TARGET_NAME).getValue(PREPARED_STATEMENT_LOGGER_COLUMNVALUES);
            return columnValues;
        }
        catch (Exception e) {
            log.error("MybatisUtils extandMybatisInvocation \u5931\u8d25");
            return Lists.newArrayList();
        }
    }

    private boolean isMaster() {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (null == user) {
            return false;
        }
        return "master".equals(user.getConnName());
    }

    private boolean isDataModificationCommand(MappedStatement mappedStatement) {
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        return sqlCommandType == SqlCommandType.INSERT || sqlCommandType == SqlCommandType.UPDATE || sqlCommandType == SqlCommandType.DELETE;
    }

    private boolean isMonitoredTable(String tableName) {
        for (String monitoredTable : MONITORED_TABLES) {
            if (!tableName.contains(monitoredTable)) continue;
            return true;
        }
        return false;
    }

    private String extractTableName(String sql) {
        String tableName = null;
        if (sql.startsWith("insert")) {
            tableName = sql.split(" ")[2];
        } else if (sql.startsWith("update")) {
            tableName = sql.split(" ")[1];
        } else if (sql.startsWith("delete")) {
            tableName = sql.split(" ")[2];
        }
        return tableName != null ? tableName.replaceAll("`", "") : null;
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }
}

