/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.groupingmodel.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.Encrypt;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.groupingmodel.dto.SysStruSyncDto;
import com.jxdinfo.hussar.tenant.groupingmodel.model.StruUserChangeLog;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SyncTenantSuccessFlag;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SysTenantStru;
import com.jxdinfo.hussar.tenant.groupingmodel.service.IStruUserChangeLogService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISyncStruUserDataService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISyncTenantSuccessFlagService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysTenantStruService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;

@Service
public class SyncStruUserDataServiceImpl
implements ISyncStruUserDataService {
    @Resource
    private ISysTenantStruService tenantStruService;
    @Resource
    private ISysTenantService tenantService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysOfficeService sysOfficeService;
    @Resource
    private ISysOrganService sysOrganService;
    @Resource
    private ISysStruStaffService sysStruStaffService;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysStruUserService sysStruUserService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private IStruUserChangeLogService struUserChangeLogService;
    @Resource
    private ISyncTenantSuccessFlagService syncTenantSuccessFlagService;
    @Resource
    private Encrypt encrypt;

    public void syncSysStru(StruUserChangeLog changeLog) throws ClassNotFoundException {
        List<SysTenant> tenantList = "DELETE".equals(changeLog.getMethod()) ? this.tenantService.list((Wrapper)Wrappers.lambdaQuery().eq(SysTenant::getTenantStatus, (Object)"1")) : this.getTenantList(changeLog.getRecordId());
        if (CollectionUtils.isEmpty(tenantList)) {
            changeLog.setStatus(Integer.valueOf(1));
            this.struUserChangeLogService.updateById((Object)changeLog);
            return;
        }
        Class clazz = ClassUtils.forName((String)changeLog.getRecordClass(), (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
        SysStruSyncDto sysStruSyncDto = (SysStruSyncDto)JSONObject.parseObject((String)changeLog.getRecordValue(), (Class)clazz);
        SysStru sysStru = new SysStru();
        HussarUtils.copy((Object)sysStruSyncDto, (Object)sysStru);
        Long parentId = sysStru.getParentId();
        Boolean isSuccess = true;
        ArrayList flagList = Lists.newArrayList();
        tenantList = this.filterTenant(tenantList, changeLog.getId());
        for (SysTenant tenant : tenantList) {
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(changeLog.getId());
            flag.setTenantId(tenant.getId());
            String connName = tenant.getConnName();
            if ("master".equals(connName)) continue;
            try {
                switch (changeLog.getMethod()) {
                    case "UPDATE": {
                        SysUsers principalUser;
                        this.sysStruService.updateById(connName, (Object)sysStru);
                        if (null == sysStru.getPrincipalId() || (principalUser = this.sysUsersService.getById(sysStru.getPrincipalId())) == null) break;
                        this.sysUsersService.saveOrUpdate(connName, (Object)principalUser);
                        break;
                    }
                    case "INSERT": {
                        SysUsers principalUser;
                        SysStru tenantStru = (SysStru)this.sysStruService.getById(connName, (Serializable)sysStru);
                        if (tenantStru != null) break;
                        this.sysStruService.save(connName, (Object)sysStru);
                        if (null == sysStru.getPrincipalId() || (principalUser = this.sysUsersService.getById(sysStru.getPrincipalId())) == null) break;
                        this.sysUsersService.saveOrUpdate(connName, (Object)principalUser);
                        break;
                    }
                    case "DELETE": {
                        this.sysStruService.removeById(connName, (Object)sysStru);
                    }
                }
                flag.setSuccessFlag(Integer.valueOf(1));
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
            }
            flagList.add(flag);
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        if (null != parentId && "UPDATE".equals(changeLog.getMethod())) {
            isSuccess = this.parentAdd(parentId, changeLog.getId(), sysStru.getId(), isSuccess);
            isSuccess = this.parentDel(sysStruSyncDto.getOldParentId(), changeLog.getId(), sysStru.getId(), isSuccess);
        }
        if (isSuccess.booleanValue()) {
            changeLog.setStatus(Integer.valueOf(1));
        }
        this.struUserChangeLogService.updateById((Object)changeLog);
    }

    private Boolean parentAdd(Long parentId, Long logId, Long struId, Boolean isSuccess) {
        List<SysTenant> tenantList = this.getTenantList(parentId);
        if (CollectionUtils.isEmpty(tenantList)) {
            return true;
        }
        ArrayList flagList = Lists.newArrayList();
        tenantList = this.filterTenant(tenantList, logId);
        for (SysTenant tenant : tenantList) {
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(logId);
            flag.setTenantId(tenant.getId());
            try {
                SysStru sysStru;
                String connName = tenant.getConnName();
                if ("master".equals(connName) || (sysStru = (SysStru)this.sysStruService.getById((Serializable)struId)) == null) continue;
                this.sysStruService.saveOrUpdate(connName, (Object)sysStru);
                SysOffice sysOffice = (SysOffice)this.sysOfficeService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysOffice::getStruId, (Object)struId));
                this.sysOfficeService.saveOrUpdate(connName, sysOffice);
                SysOrgan sysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)sysStru.getOrganId());
                this.sysOrganService.saveOrUpdate(connName, (Object)sysOrgan);
                List usersList = this.sysUsersService.list((Wrapper)Wrappers.lambdaQuery().eq(SysUsers::getDepartmentId, (Object)sysStru.getId()));
                if (CollectionUtils.isEmpty((Collection)usersList)) continue;
                this.sysUsersService.saveOrUpdateBatch(connName, (Collection)usersList);
                List userIds = usersList.stream().map(SysUsers::getId).collect(Collectors.toList());
                List employeeIds = usersList.stream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
                this.sysUserRoleService.savePublicBatch(connName, userIds);
                List sysStruUserList = this.sysStruUserService.list((Wrapper)Wrappers.lambdaQuery().in(SysStruUser::getUserId, userIds));
                this.sysStruUserService.saveOrUpdateBatch(connName, sysStruUserList);
                List staffList = this.sysStaffService.list((Wrapper)Wrappers.lambdaQuery().in(SysStaff::getId, employeeIds));
                this.sysStaffService.saveOrUpdateBatch(connName, staffList);
                List struStaffList = this.sysStruStaffService.list((Wrapper)Wrappers.lambdaQuery().in(SysStruStaff::getStaffId, employeeIds));
                this.sysStruStaffService.saveOrUpdateBatch(connName, struStaffList);
                flag.setSuccessFlag(Integer.valueOf(1));
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
            }
            flagList.add(flag);
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        return isSuccess;
    }

    private Boolean parentDel(Long parentId, Long logId, Long struId, Boolean isSuccess) {
        List<SysTenant> tenantList = this.getTenantList(parentId);
        if (CollectionUtils.isEmpty(tenantList)) {
            return true;
        }
        ArrayList flagList = Lists.newArrayList();
        tenantList = this.filterTenant(tenantList, logId);
        for (SysTenant tenant : tenantList) {
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(logId);
            flag.setTenantId(tenant.getId());
            try {
                SysStru sysStru;
                String connName = tenant.getConnName();
                if ("master".equals(connName) || (sysStru = (SysStru)this.sysStruService.getById(connName, (Serializable)struId)) == null) continue;
                this.sysStruService.removeById(connName, (Serializable)struId);
                this.sysOfficeService.remove(connName, (Wrapper)Wrappers.lambdaQuery().eq(SysOffice::getStruId, (Object)struId));
                this.sysOrganService.removeById(connName, (Serializable)sysStru.getOrganId());
                List usersList = this.sysUsersService.list(connName, (Wrapper)Wrappers.lambdaQuery().eq(SysUsers::getDepartmentId, (Object)sysStru.getId()));
                if (CollectionUtils.isEmpty((Collection)usersList)) continue;
                List userIds = usersList.stream().map(SysUsers::getId).collect(Collectors.toList());
                List employeeIds = usersList.stream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
                this.sysUsersService.removeByIds(connName, userIds);
                this.sysUserRoleService.removePublicBatch(connName, userIds);
                this.sysStruUserService.remove(connName, (Wrapper)Wrappers.lambdaQuery().in(SysStruUser::getUserId, userIds));
                this.sysStaffService.remove(connName, (Wrapper)Wrappers.lambdaQuery().in(SysStaff::getId, employeeIds));
                this.sysStruStaffService.remove(connName, (Wrapper)Wrappers.lambdaQuery().in(SysStruStaff::getStaffId, employeeIds));
                flag.setSuccessFlag(Integer.valueOf(1));
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
            }
            flagList.add(flag);
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        return isSuccess;
    }

    public void syncSysOrgan(StruUserChangeLog changeLog) throws ClassNotFoundException {
        List<SysTenant> tenantList;
        if ("DELETE".equals(changeLog.getMethod())) {
            tenantList = this.tenantService.list((Wrapper)Wrappers.lambdaQuery().eq(SysTenant::getTenantStatus, (Object)"1"));
        } else {
            String organId = changeLog.getRecordId();
            SysStru sysStru = (SysStru)this.sysStruService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysStru::getOrganId, (Object)organId));
            if (null == sysStru) {
                changeLog.setStatus(Integer.valueOf(1));
                this.struUserChangeLogService.updateById((Object)changeLog);
                return;
            }
            tenantList = this.getTenantList(sysStru.getId());
        }
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            changeLog.setStatus(Integer.valueOf(1));
            this.struUserChangeLogService.updateById((Object)changeLog);
            return;
        }
        Class clazz = ClassUtils.forName((String)changeLog.getRecordClass(), (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
        SysOrgan sysOrgan = (SysOrgan)JSONObject.parseObject((String)changeLog.getRecordValue(), (Class)clazz);
        boolean isSuccess = true;
        ArrayList flagList = Lists.newArrayList();
        tenantList = this.filterTenant(tenantList, changeLog.getId());
        for (SysTenant tenant : tenantList) {
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(changeLog.getId());
            flag.setTenantId(tenant.getId());
            if ("master".equals(tenant.getConnName())) continue;
            try {
                switch (changeLog.getMethod()) {
                    case "UPDATE": {
                        this.sysOrganService.updateById(tenant.getConnName(), (Object)sysOrgan);
                        break;
                    }
                    case "INSERT": {
                        this.sysOrganService.saveOrUpdate(tenant.getConnName(), (Object)sysOrgan);
                        break;
                    }
                    case "DELETE": {
                        this.sysOrganService.removeById(tenant.getConnName(), (Object)sysOrgan);
                    }
                }
                flag.setSuccessFlag(Integer.valueOf(1));
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
            }
            flagList.add(flag);
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        if (isSuccess) {
            changeLog.setStatus(Integer.valueOf(1));
        }
        this.struUserChangeLogService.updateById((Object)changeLog);
    }

    public void syncSysStaff(StruUserChangeLog changeLog) throws ClassNotFoundException {
        List<SysTenant> tenantList;
        if ("DELETE".equals(changeLog.getMethod())) {
            tenantList = this.tenantService.list((Wrapper)Wrappers.lambdaQuery().eq(SysTenant::getTenantStatus, (Object)"1"));
        } else {
            List struStaffList = this.sysStruStaffService.list((Wrapper)Wrappers.lambdaQuery().eq(SysStruStaff::getStaffId, (Object)changeLog.getRecordId()));
            if (CollectionUtils.isEmpty((Collection)struStaffList)) {
                changeLog.setStatus(Integer.valueOf(1));
                this.struUserChangeLogService.updateById((Object)changeLog);
                return;
            }
            List<Long> struIds = struStaffList.stream().map(SysStruStaff::getStruId).collect(Collectors.toList());
            tenantList = this.getTenantList(struIds);
        }
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            changeLog.setStatus(Integer.valueOf(1));
            this.struUserChangeLogService.updateById((Object)changeLog);
            return;
        }
        Class clazz = ClassUtils.forName((String)changeLog.getRecordClass(), (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
        SysStaff sysStaff = (SysStaff)JSONObject.parseObject((String)changeLog.getRecordValue(), (Class)clazz);
        if (HussarUtils.isNotEmpty((Object)sysStaff.getIdcard())) {
            sysStaff.setIdcard(this.encrypt.decrypt(sysStaff.getIdcard()));
        }
        boolean isSuccess = true;
        ArrayList flagList = Lists.newArrayList();
        tenantList = this.filterTenant(tenantList, changeLog.getId());
        for (SysTenant tenant : tenantList) {
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(changeLog.getId());
            flag.setTenantId(tenant.getId());
            if ("master".equals(tenant.getConnName())) continue;
            try {
                switch (changeLog.getMethod()) {
                    case "UPDATE": {
                        sysStaff = (SysStaff)this.sysStaffService.getById((Serializable)sysStaff.getId());
                        this.sysStaffService.updateById(tenant.getConnName(), sysStaff);
                        break;
                    }
                    case "INSERT": {
                        this.sysStaffService.saveOrUpdate(tenant.getConnName(), sysStaff);
                        break;
                    }
                    case "DELETE": {
                        this.sysStaffService.removeById(tenant.getConnName(), sysStaff);
                    }
                }
                flag.setSuccessFlag(Integer.valueOf(1));
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
            }
            flagList.add(flag);
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        if (isSuccess) {
            changeLog.setStatus(Integer.valueOf(1));
        }
        this.struUserChangeLogService.updateById((Object)changeLog);
    }

    public void syncSysStruStaff(StruUserChangeLog changeLog) throws ClassNotFoundException {
        List<SysTenant> tenantList;
        if ("DELETE".equals(changeLog.getMethod())) {
            tenantList = this.tenantService.list((Wrapper)Wrappers.lambdaQuery().eq(SysTenant::getTenantStatus, (Object)"1"));
        } else {
            SysStruStaff sysStruStaff = (SysStruStaff)this.sysStruStaffService.getById((Serializable)((Object)changeLog.getRecordId()));
            if (null == sysStruStaff) {
                changeLog.setStatus(Integer.valueOf(1));
                this.struUserChangeLogService.updateById((Object)changeLog);
                return;
            }
            tenantList = this.getTenantList(sysStruStaff.getStruId());
        }
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            changeLog.setStatus(Integer.valueOf(1));
            this.struUserChangeLogService.updateById((Object)changeLog);
            return;
        }
        Class clazz = ClassUtils.forName((String)changeLog.getRecordClass(), (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
        SysStruStaff sysStruStaff = (SysStruStaff)JSONObject.parseObject((String)changeLog.getRecordValue(), (Class)clazz);
        boolean isSuccess = true;
        ArrayList flagList = Lists.newArrayList();
        tenantList = this.filterTenant(tenantList, changeLog.getId());
        for (SysTenant tenant : tenantList) {
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(changeLog.getId());
            flag.setTenantId(tenant.getId());
            String connName = tenant.getConnName();
            if ("master".equals(connName)) continue;
            try {
                switch (changeLog.getMethod()) {
                    case "UPDATE": {
                        this.sysStruStaffService.updateById(connName, sysStruStaff);
                        break;
                    }
                    case "INSERT": {
                        SysStaff masterStaff;
                        SysStaff tenantStaff = this.sysStaffService.getById(connName, (Serializable)sysStruStaff.getStaffId());
                        if (null == tenantStaff && null != (masterStaff = (SysStaff)this.sysStaffService.getById((Serializable)sysStruStaff.getStaffId()))) {
                            this.sysStaffService.saveOrUpdate(connName, masterStaff);
                        }
                        this.sysStruStaffService.saveOrUpdate(tenant.getConnName(), sysStruStaff);
                        break;
                    }
                    case "DELETE": {
                        this.sysStruStaffService.removeById(tenant.getConnName(), sysStruStaff);
                        SysStruStaff tenantSysStruStaff = this.sysStruStaffService.getById(connName, (Serializable)sysStruStaff.getId());
                        if (null == tenantSysStruStaff) break;
                        this.sysStruStaffService.removeById(connName, sysStruStaff);
                        List list = this.sysStruStaffService.list(connName, (Wrapper)Wrappers.lambdaQuery().eq(SysStruStaff::getStaffId, (Object)tenantSysStruStaff.getStaffId()));
                        if (!CollectionUtils.isEmpty((Collection)list)) break;
                        this.sysStaffService.removeById(connName, (Serializable)tenantSysStruStaff.getStaffId());
                    }
                }
                flag.setSuccessFlag(Integer.valueOf(1));
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
            }
            flagList.add(flag);
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        if (isSuccess) {
            changeLog.setStatus(Integer.valueOf(1));
        }
        this.struUserChangeLogService.updateById((Object)changeLog);
    }

    public void syncSysUsers(StruUserChangeLog changeLog) throws ClassNotFoundException {
        List<SysTenant> tenantList;
        if ("DELETE".equals(changeLog.getMethod())) {
            tenantList = this.tenantService.list((Wrapper)Wrappers.lambdaQuery().eq(SysTenant::getTenantStatus, (Object)"1"));
        } else {
            SysUsers sysUsers = (SysUsers)this.sysUsersService.getById((Serializable)((Object)changeLog.getRecordId()));
            if (null == sysUsers) {
                changeLog.setStatus(Integer.valueOf(1));
                this.struUserChangeLogService.updateById((Object)changeLog);
                return;
            }
            List sysStruUserList = this.sysStruUserService.list((Wrapper)Wrappers.lambdaQuery().eq(SysStruUser::getUserId, (Object)sysUsers.getId()));
            if (CollectionUtils.isEmpty((Collection)sysStruUserList)) {
                changeLog.setStatus(Integer.valueOf(1));
                this.struUserChangeLogService.updateById((Object)changeLog);
                return;
            }
            List<Long> struIds = sysStruUserList.stream().map(SysStruUser::getStruId).collect(Collectors.toList());
            tenantList = this.getTenantList(struIds);
        }
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            changeLog.setStatus(Integer.valueOf(1));
            this.struUserChangeLogService.updateById((Object)changeLog);
            return;
        }
        Class clazz = ClassUtils.forName((String)changeLog.getRecordClass(), (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
        SysUsers sysUsers = (SysUsers)JSONObject.parseObject((String)changeLog.getRecordValue(), (Class)clazz);
        if (HussarUtils.isNotEmpty((Object)sysUsers.getTelephone())) {
            sysUsers.setTelephone(this.encrypt.decrypt(sysUsers.getTelephone()));
        }
        if (HussarUtils.isNotEmpty((Object)sysUsers.getMobile())) {
            sysUsers.setMobile(this.encrypt.decrypt(sysUsers.getMobile()));
        }
        boolean isSuccess = true;
        ArrayList flagList = Lists.newArrayList();
        tenantList = this.filterTenant(tenantList, changeLog.getId());
        for (SysTenant tenant : tenantList) {
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(changeLog.getId());
            flag.setTenantId(tenant.getId());
            if ("master".equals(tenant.getConnName())) continue;
            try {
                switch (changeLog.getMethod()) {
                    case "UPDATE": {
                        this.sysUsersService.updateById(tenant.getConnName(), (Object)sysUsers);
                        break;
                    }
                    case "INSERT": {
                        this.sysUsersService.saveOrUpdate(tenant.getConnName(), (Object)sysUsers);
                        SysUserRole record = (SysUserRole)this.sysUserRoleService.getOne(tenant.getConnName(), (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)sysUsers.getId())).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.PUBLIC_ROLE.getValue()));
                        if (record != null) break;
                        SysUserRole userRole = new SysUserRole();
                        userRole.setUserId(sysUsers.getId());
                        userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
                        userRole.setAdminOption("1");
                        this.sysUserRoleService.saveOrUpdate(tenant.getConnName(), (Object)userRole);
                        break;
                    }
                    case "DELETE": {
                        this.sysUsersService.removeById(tenant.getConnName(), (Object)sysUsers);
                        this.sysUserRoleService.remove(tenant.getConnName(), (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)sysUsers.getId())).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.PUBLIC_ROLE.getValue()));
                    }
                }
                flag.setSuccessFlag(Integer.valueOf(1));
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
            }
            flagList.add(flag);
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        if (isSuccess) {
            changeLog.setStatus(Integer.valueOf(1));
        }
        this.struUserChangeLogService.updateById((Object)changeLog);
    }

    public void syncSysStruUser(StruUserChangeLog changeLog) throws ClassNotFoundException {
        List<SysTenant> tenantList;
        if ("DELETE".equals(changeLog.getMethod())) {
            tenantList = this.tenantService.list((Wrapper)Wrappers.lambdaQuery().eq(SysTenant::getTenantStatus, (Object)"1"));
        } else {
            SysStruUser sysStruUser = (SysStruUser)this.sysStruUserService.getById((Serializable)((Object)changeLog.getRecordId()));
            if (null == sysStruUser) {
                changeLog.setStatus(Integer.valueOf(1));
                this.struUserChangeLogService.updateById((Object)changeLog);
                return;
            }
            tenantList = this.getTenantList(sysStruUser.getStruId());
        }
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            changeLog.setStatus(Integer.valueOf(1));
            this.struUserChangeLogService.updateById((Object)changeLog);
            return;
        }
        Class clazz = ClassUtils.forName((String)changeLog.getRecordClass(), (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
        SysStruUser sysStruUser = (SysStruUser)JSONObject.parseObject((String)changeLog.getRecordValue(), (Class)clazz);
        boolean isSuccess = true;
        ArrayList flagList = Lists.newArrayList();
        tenantList = this.filterTenant(tenantList, changeLog.getId());
        for (SysTenant tenant : tenantList) {
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(changeLog.getId());
            flag.setTenantId(tenant.getId());
            String connName = tenant.getConnName();
            if ("master".equals(connName)) continue;
            try {
                switch (changeLog.getMethod()) {
                    case "UPDATE": {
                        this.sysStruUserService.updateById(connName, sysStruUser);
                        break;
                    }
                    case "INSERT": {
                        SysUsers masterUser;
                        SysUsers tenantUser = (SysUsers)this.sysUsersService.getById(connName, (Serializable)sysStruUser.getUserId());
                        if (null == tenantUser && null != (masterUser = this.sysUsersService.getById(sysStruUser.getUserId()))) {
                            this.sysUsersService.saveOrUpdate(connName, (Object)masterUser);
                            SysUserRole record = (SysUserRole)this.sysUserRoleService.getOne(connName, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)masterUser.getId())).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.PUBLIC_ROLE.getValue()));
                            if (record == null) {
                                SysUserRole userRole = new SysUserRole();
                                userRole.setUserId(masterUser.getId());
                                userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
                                userRole.setAdminOption("1");
                                this.sysUserRoleService.saveOrUpdate(tenant.getConnName(), (Object)userRole);
                            }
                        }
                        this.sysStruUserService.saveOrUpdate(connName, sysStruUser);
                        break;
                    }
                    case "DELETE": {
                        SysStruUser tenantSysStruUser = this.sysStruUserService.getById(connName, (Serializable)sysStruUser.getId());
                        if (null == tenantSysStruUser) break;
                        this.sysStruUserService.removeById(connName, sysStruUser);
                        List list = this.sysStruUserService.list(connName, (Wrapper)Wrappers.lambdaQuery().eq(SysStruUser::getUserId, (Object)tenantSysStruUser.getUserId()));
                        if (!CollectionUtils.isEmpty((Collection)list)) break;
                        this.sysUsersService.removeById(connName, (Serializable)tenantSysStruUser.getUserId());
                        this.sysUserRoleService.remove(connName, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)tenantSysStruUser.getUserId())).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.PUBLIC_ROLE.getValue()));
                    }
                }
                flag.setSuccessFlag(Integer.valueOf(1));
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
            }
            flagList.add(flag);
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        if (isSuccess) {
            changeLog.setStatus(Integer.valueOf(1));
        }
        this.struUserChangeLogService.updateById((Object)changeLog);
    }

    public void syncSysOffice(StruUserChangeLog changeLog) throws ClassNotFoundException {
        SysOffice sysOffice;
        List<SysTenant> tenantList;
        if ("DELETE".equals(changeLog.getMethod())) {
            tenantList = this.tenantService.list((Wrapper)Wrappers.lambdaQuery().eq(SysTenant::getTenantStatus, (Object)"1"));
        } else {
            String officeId = changeLog.getRecordId();
            sysOffice = (SysOffice)this.sysOfficeService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysOffice::getId, (Object)officeId));
            if (null == sysOffice) {
                changeLog.setStatus(Integer.valueOf(1));
                this.struUserChangeLogService.updateById((Object)changeLog);
                return;
            }
            tenantList = this.getTenantList(sysOffice.getStruId());
        }
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            changeLog.setStatus(Integer.valueOf(1));
            this.struUserChangeLogService.updateById((Object)changeLog);
            return;
        }
        Class clazz = ClassUtils.forName((String)changeLog.getRecordClass(), (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
        sysOffice = (SysOffice)JSONObject.parseObject((String)changeLog.getRecordValue(), (Class)clazz);
        boolean isSuccess = true;
        ArrayList flagList = Lists.newArrayList();
        tenantList = this.filterTenant(tenantList, changeLog.getId());
        for (SysTenant tenant : tenantList) {
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(changeLog.getId());
            flag.setTenantId(tenant.getId());
            if ("master".equals(tenant.getConnName())) continue;
            try {
                switch (changeLog.getMethod()) {
                    case "UPDATE": {
                        sysOffice = (SysOffice)this.sysOfficeService.getById((Serializable)sysOffice.getId());
                        this.sysOfficeService.updateById(tenant.getConnName(), sysOffice);
                        break;
                    }
                    case "INSERT": {
                        this.sysOfficeService.saveOrUpdate(tenant.getConnName(), sysOffice);
                        break;
                    }
                    case "DELETE": {
                        this.sysOfficeService.removeById(tenant.getConnName(), sysOffice);
                    }
                }
                flag.setSuccessFlag(Integer.valueOf(1));
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
            }
            flagList.add(flag);
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        if (isSuccess) {
            changeLog.setStatus(Integer.valueOf(1));
        }
        this.struUserChangeLogService.updateById((Object)changeLog);
    }

    private List<SysTenant> getTenantList(Object struId) {
        SysStru sysStru = (SysStru)this.sysStruService.getById((Serializable)((Object)String.valueOf(struId)));
        if (sysStru == null) {
            return Lists.newArrayList();
        }
        List<String> struIds = Arrays.asList(sysStru.getStruFid().split("/"));
        List sysTenantStruList = this.tenantStruService.list((Wrapper)Wrappers.lambdaQuery().in(SysTenantStru::getStruId, struIds));
        if (CollectionUtils.isEmpty((Collection)sysTenantStruList)) {
            return Lists.newArrayList();
        }
        List tenantIds = sysTenantStruList.stream().map(SysTenantStru::getTenantId).collect(Collectors.toList());
        List tenantList = this.tenantService.list((Wrapper)Wrappers.lambdaQuery().in(SysTenant::getId, tenantIds));
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            return Lists.newArrayList();
        }
        return tenantList;
    }

    private List<SysTenant> getTenantList(List<Long> struIds) {
        List struList = this.sysStruService.getStruByStruIds(struIds);
        HashSet fullStruIds = Sets.newHashSet();
        for (SysStru sysStru : struList) {
            fullStruIds.addAll(Arrays.asList(sysStru.getStruFid().split("/")));
        }
        List sysTenantStruList = this.tenantStruService.list((Wrapper)Wrappers.lambdaQuery().in(SysTenantStru::getStruId, (Collection)fullStruIds));
        if (CollectionUtils.isEmpty((Collection)sysTenantStruList)) {
            return Lists.newArrayList();
        }
        List tenantIds = sysTenantStruList.stream().map(SysTenantStru::getTenantId).collect(Collectors.toList());
        List tenantList = this.tenantService.list((Wrapper)Wrappers.lambdaQuery().in(SysTenant::getId, tenantIds));
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            return Lists.newArrayList();
        }
        return tenantList;
    }

    private List<SysTenant> filterTenant(List<SysTenant> tenantList, Long logId) {
        List successFlagList = this.syncTenantSuccessFlagService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getSuccessFlag, (Object)1)).eq(SyncTenantSuccessFlag::getLogId, (Object)logId));
        if (CollectionUtils.isNotEmpty((Collection)successFlagList)) {
            List successTenantIds = successFlagList.stream().map(SyncTenantSuccessFlag::getTenantId).collect(Collectors.toList());
            tenantList = tenantList.stream().filter(t -> !successTenantIds.contains(t.getId())).collect(Collectors.toList());
        }
        return tenantList;
    }
}

