/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.groupingmodel.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantCommonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@DependsOn(value={"springContextHolder"})
@Service(value="com.jxdinfo.hussar.tenant.groupingmodel.service.impl.GroupingModelTenantTypeParseServiceImpl")
public class GroupingModelTenantTypeParseServiceImpl
implements IHussarTenantCommonService {
    @Autowired
    private IHussarBaseTenantService hussarBaseTenantService;

    public HussarTenantDefinition parse() {
        String tcode = TenantCommonUtil.getTenantCodeByUrl();
        if (HussarUtils.isNotBlank((CharSequence)tcode)) {
            return this.search(tcode);
        }
        return new DefaultTenant();
    }

    private HussarTenantDefinition search(String tcode) {
        HussarTenantDefinition tenantByTenantCode = TenantCacheUtil.loadFromCacheByTenantCode((String)tcode);
        if (HussarUtils.isEmpty((Object)tenantByTenantCode)) {
            tenantByTenantCode = this.hussarBaseTenantService.getTenantByTenantCode(tcode);
        }
        return tenantByTenantCode;
    }
}

