/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.groupingmodel.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.Encrypt;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantStru;
import com.jxdinfo.hussar.tenant.common.model.SysTenantStruCancel;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantStruCancelService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantStruService;
import com.jxdinfo.hussar.tenant.groupingmodel.dto.SysStruSyncDto;
import com.jxdinfo.hussar.tenant.groupingmodel.model.StruUserChangeLog;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SyncTenantSuccessFlag;
import com.jxdinfo.hussar.tenant.groupingmodel.service.IStruUserChangeLogService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISyncStruUserDataService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISyncTenantSuccessFlagService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;

@Service
public class SyncStruUserDataServiceImpl
implements ISyncStruUserDataService {
    protected static final Logger logger = LoggerFactory.getLogger(SyncStruUserDataServiceImpl.class);
    @Lazy
    @Autowired(required=false)
    private ISysTenantStruService tenantStruService;
    @Lazy
    @Resource
    private ISysTenantService tenantService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysOfficeService sysOfficeService;
    @Resource
    private ISysOrganService sysOrganService;
    @Resource
    private ISysStruStaffService sysStruStaffService;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysStruUserService sysStruUserService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private IStruUserChangeLogService struUserChangeLogService;
    @Resource
    private ISyncTenantSuccessFlagService syncTenantSuccessFlagService;
    @Resource
    private ISysOrganTypeService sysOrganTypeService;
    @Resource
    private ISysStruRuleService sysStruRuleService;
    @Autowired(required=false)
    private Encrypt defEncrypt;
    @Resource
    private ISysTenantStruCancelService sysTenantStruCancelService;

    public void syncSysStru(StruUserChangeLog changeLog, Map<String, List<String>> errorMsg) throws ClassNotFoundException {
        List<SysTenant> tenantList = "DELETE".equals(changeLog.getMethod()) ? this.tenantService.list((Wrapper)Wrappers.lambdaQuery().eq(SysTenant::getTenantStatus, (Object)"1")) : this.getTenantList(changeLog.getRecordId());
        if (CollectionUtils.isEmpty(tenantList)) {
            this.struUserChangeLogService.removeById((Object)changeLog);
            return;
        }
        Class clazz = ClassUtils.forName((String)changeLog.getRecordClass(), (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
        SysStruSyncDto sysStruSyncDto = (SysStruSyncDto)JSONObject.parseObject((String)changeLog.getRecordValue(), (Class)clazz);
        SysStru sysStru = new SysStru();
        HussarUtils.copy((Object)sysStruSyncDto, (Object)sysStru);
        Long parentId = sysStru.getParentId();
        Boolean isSuccess = true;
        ArrayList flagList = Lists.newArrayList();
        if (2 == changeLog.getStatus()) {
            tenantList = this.filterTenant(tenantList, changeLog.getId());
        }
        for (SysTenant tenant : tenantList) {
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(changeLog.getId());
            flag.setTenantId(tenant.getId());
            String connName = tenant.getConnName();
            if ("master".equals(connName)) continue;
            try {
                switch (changeLog.getMethod()) {
                    case "UPDATE": {
                        SysUsers principalUser;
                        SysStru tenantParentStru;
                        sysStru = (SysStru)this.sysStruService.getById((Serializable)sysStru.getId());
                        if (sysStru.getParentId() != null && (tenantParentStru = (SysStru)this.sysStruService.getById(connName, (Serializable)sysStru.getParentId())) == null) {
                            sysStru.setParentId(Long.valueOf(11L));
                            sysStru.setStruFid("/1/" + sysStru.getId() + "/");
                        }
                        this.sysStruService.saveOrUpdate(connName, (Object)sysStru);
                        if (null == sysStru.getPrincipalId() || (principalUser = this.sysUsersService.getById(sysStru.getPrincipalId())) == null) break;
                        this.sysUsersService.saveOrUpdate(connName, (Object)principalUser);
                        break;
                    }
                    case "INSERT": {
                        SysStru tenantStru = (SysStru)this.sysStruService.getById(connName, (Serializable)sysStru);
                        if (tenantStru != null) break;
                        SysOrgan sysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)sysStru.getOrganId());
                        if (HussarUtils.isEmpty((Object)sysOrgan)) {
                            errorMsg.get("sysStrus").add("\u4e3b\u5e93\u91cc\u7684SysOrgan\u4e3a\u7a7a\uff0c\u4e3b\u952e\u4e3a\uff1a" + sysStru.getOrganId() + ";");
                            throw new BaseException("\u4e3b\u5e93\u91cc\u7684SysOrgan\u4e3a\u7a7a\uff0c\u4e3b\u952e\u4e3a\uff1a" + sysStru.getOrganId());
                        }
                        String organCode = sysOrgan.getOrganCode();
                        long organCodeCount = this.sysOrganService.count(tenant.getConnName(), (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysOrgan::getOrganCode, (Object)organCode)).ne(SysOrgan::getId, (Object)sysOrgan.getId()));
                        if (organCodeCount == 0L) {
                            SysUsers principalUser;
                            this.sysStruService.save(connName, (Object)sysStru);
                            if (null == sysStru.getPrincipalId() || (principalUser = this.sysUsersService.getById(sysStru.getPrincipalId())) == null) break;
                            this.sysUsersService.saveOrUpdate(connName, (Object)principalUser);
                            break;
                        }
                        errorMsg.get("sysStrus").add("\u8be5\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u91cd\u590d: " + organCode + ";");
                        logger.info("\u8be5\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u91cd\u590d: {}", (Object)organCode);
                        break;
                    }
                    case "DELETE": {
                        this.sysStruService.removeById(connName, (Object)sysStru);
                    }
                }
                flag.setSuccessFlag(Integer.valueOf(1));
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
                long count = this.syncTenantSuccessFlagService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)changeLog.getId())).eq(SyncTenantSuccessFlag::getTenantId, (Object)tenant.getId()));
                if (count >= 1L) continue;
                flagList.add(flag);
            }
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        if (null != parentId && "UPDATE".equals(changeLog.getMethod())) {
            isSuccess = this.parentAdd(parentId, changeLog.getId(), sysStru.getId(), isSuccess);
            isSuccess = this.parentDel(sysStruSyncDto.getOldParentId(), changeLog.getId(), sysStru.getId(), isSuccess);
        }
        if (isSuccess.booleanValue()) {
            this.struUserChangeLogService.removeById((Object)changeLog);
            this.syncTenantSuccessFlagService.remove((Wrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)changeLog.getId()));
        } else {
            changeLog.setStatus(Integer.valueOf(2));
            this.struUserChangeLogService.updateById((Object)changeLog);
        }
    }

    private Boolean parentAdd(Long parentId, Long logId, Long struId, Boolean isSuccess) {
        List<SysTenant> tenantList = this.getTenantList(parentId);
        if (CollectionUtils.isEmpty(tenantList)) {
            return true;
        }
        ArrayList flagList = Lists.newArrayList();
        tenantList = this.filterTenant(tenantList, logId);
        for (SysTenant tenant : tenantList) {
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(logId);
            flag.setTenantId(tenant.getId());
            try {
                SysStru sysStru;
                String connName = tenant.getConnName();
                if ("master".equals(connName) || (sysStru = (SysStru)this.sysStruService.getById((Serializable)struId)) == null) continue;
                this.sysStruService.saveOrUpdate(connName, (Object)sysStru);
                SysOffice sysOffice = (SysOffice)this.sysOfficeService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysOffice::getStruId, (Object)struId));
                this.sysOfficeService.saveOrUpdate(connName, sysOffice);
                SysOrgan sysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)sysStru.getOrganId());
                this.sysOrganService.saveOrUpdate(connName, (Object)sysOrgan);
                List usersList = this.sysUsersService.list((Wrapper)Wrappers.lambdaQuery().eq(SysUsers::getDepartmentId, (Object)sysStru.getId()));
                if (CollectionUtils.isEmpty((Collection)usersList)) continue;
                this.sysUsersService.saveOrUpdateBatch(connName, (Collection)usersList);
                List userIds = usersList.stream().map(SysUsers::getId).collect(Collectors.toList());
                List employeeIds = usersList.stream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
                this.sysUserRoleService.savePublicBatch(connName, userIds);
                List sysStruUserList = this.sysStruUserService.list((Wrapper)Wrappers.lambdaQuery().in(SysStruUser::getUserId, userIds));
                this.sysStruUserService.saveOrUpdateBatch(connName, sysStruUserList);
                List staffList = this.sysStaffService.list((Wrapper)Wrappers.lambdaQuery().in(SysStaff::getId, employeeIds));
                this.sysStaffService.saveOrUpdateBatch(connName, staffList);
                List struStaffList = this.sysStruStaffService.list((Wrapper)Wrappers.lambdaQuery().in(SysStruStaff::getStaffId, employeeIds));
                this.sysStruStaffService.saveOrUpdateBatch(connName, struStaffList);
                flag.setSuccessFlag(Integer.valueOf(1));
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
                long count = this.syncTenantSuccessFlagService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)logId)).eq(SyncTenantSuccessFlag::getTenantId, (Object)tenant.getId()));
                if (count >= 1L) continue;
                flagList.add(flag);
            }
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        return isSuccess;
    }

    private Boolean parentDel(Long parentId, Long logId, Long struId, Boolean isSuccess) {
        List<SysTenant> tenantList = this.getTenantList(parentId);
        if (CollectionUtils.isEmpty(tenantList)) {
            return true;
        }
        ArrayList flagList = Lists.newArrayList();
        tenantList = this.filterTenant(tenantList, logId);
        for (SysTenant tenant : tenantList) {
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(logId);
            flag.setTenantId(tenant.getId());
            try {
                SysStru sysStru;
                String connName = tenant.getConnName();
                if ("master".equals(connName) || (sysStru = (SysStru)this.sysStruService.getById(connName, (Serializable)struId)) == null) continue;
                this.sysStruService.removeById(connName, (Serializable)struId);
                this.sysOfficeService.remove(connName, (Wrapper)Wrappers.lambdaQuery().eq(SysOffice::getStruId, (Object)struId));
                this.sysOrganService.removeById(connName, (Serializable)sysStru.getOrganId());
                List usersList = this.sysUsersService.list(connName, (Wrapper)Wrappers.lambdaQuery().eq(SysUsers::getDepartmentId, (Object)sysStru.getId()));
                if (CollectionUtils.isEmpty((Collection)usersList)) continue;
                List userIds = usersList.stream().map(SysUsers::getId).collect(Collectors.toList());
                List employeeIds = usersList.stream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
                this.sysUsersService.removeByIds(connName, userIds);
                this.sysUserRoleService.removePublicBatch(connName, userIds);
                this.sysStruUserService.remove(connName, (Wrapper)Wrappers.lambdaQuery().in(SysStruUser::getUserId, userIds));
                this.sysStaffService.remove(connName, (Wrapper)Wrappers.lambdaQuery().in(SysStaff::getId, employeeIds));
                this.sysStruStaffService.remove(connName, (Wrapper)Wrappers.lambdaQuery().in(SysStruStaff::getStaffId, employeeIds));
                flag.setSuccessFlag(Integer.valueOf(1));
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
                long count = this.syncTenantSuccessFlagService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)logId)).eq(SyncTenantSuccessFlag::getTenantId, (Object)tenant.getId()));
                if (count >= 1L) continue;
                flagList.add(flag);
            }
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        return isSuccess;
    }

    public void syncSysOrgan(StruUserChangeLog changeLog, Map<String, List<String>> errorMsg) throws ClassNotFoundException {
        List<SysTenant> tenantList;
        if ("DELETE".equals(changeLog.getMethod())) {
            tenantList = this.tenantService.list((Wrapper)Wrappers.lambdaQuery().eq(SysTenant::getTenantStatus, (Object)"1"));
        } else {
            String organId = changeLog.getRecordId();
            SysStru sysStru = (SysStru)this.sysStruService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysStru::getOrganId, (Object)Long.parseLong(organId)));
            if (null == sysStru) {
                this.struUserChangeLogService.removeById((Object)changeLog);
                return;
            }
            tenantList = this.getTenantList(sysStru.getId());
        }
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            this.struUserChangeLogService.removeById((Object)changeLog);
            return;
        }
        Class clazz = ClassUtils.forName((String)changeLog.getRecordClass(), (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
        SysOrgan sysOrgan = (SysOrgan)JSONObject.parseObject((String)changeLog.getRecordValue(), (Class)clazz);
        boolean isSuccess = true;
        ArrayList flagList = Lists.newArrayList();
        if (2 == changeLog.getStatus()) {
            tenantList = this.filterTenant(tenantList, changeLog.getId());
        }
        for (SysTenant tenant : tenantList) {
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(changeLog.getId());
            flag.setTenantId(tenant.getId());
            if ("master".equals(tenant.getConnName())) continue;
            try {
                switch (changeLog.getMethod()) {
                    case "UPDATE": {
                        sysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)sysOrgan.getId());
                        this.sysOrganService.saveOrUpdate(tenant.getConnName(), (Object)sysOrgan);
                        break;
                    }
                    case "INSERT": {
                        long sysOrganCodeCount = this.sysOrganService.count(tenant.getConnName(), (Wrapper)new LambdaQueryWrapper().eq(SysOrgan::getOrganCode, (Object)sysOrgan.getOrganCode()));
                        if (sysOrganCodeCount == 0L) {
                            this.sysOrganService.saveOrUpdate(tenant.getConnName(), (Object)sysOrgan);
                            break;
                        }
                        errorMsg.get("sysOrgans").add("\u8be5\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u91cd\u590d: " + sysOrgan.getOrganCode() + ";");
                        logger.error("\u8be5\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u91cd\u590d: {}", (Object)sysOrgan.getOrganCode());
                        break;
                    }
                    case "DELETE": {
                        this.sysOrganService.removeById(tenant.getConnName(), (Object)sysOrgan);
                    }
                }
                flag.setSuccessFlag(Integer.valueOf(1));
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
                long count = this.syncTenantSuccessFlagService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)changeLog.getId())).eq(SyncTenantSuccessFlag::getTenantId, (Object)tenant.getId()));
                if (count >= 1L) continue;
                flagList.add(flag);
            }
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        if (isSuccess) {
            this.struUserChangeLogService.removeById((Object)changeLog);
            this.syncTenantSuccessFlagService.remove((Wrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)changeLog.getId()));
        } else {
            changeLog.setStatus(Integer.valueOf(2));
            this.struUserChangeLogService.updateById((Object)changeLog);
        }
    }

    public void syncSysStaff(StruUserChangeLog changeLog, Map<String, List<String>> errorMsg) throws ClassNotFoundException {
        List<SysTenant> tenantList;
        if ("DELETE".equals(changeLog.getMethod())) {
            tenantList = this.tenantService.list((Wrapper)Wrappers.lambdaQuery().eq(SysTenant::getTenantStatus, (Object)"1"));
        } else {
            List struStaffList = this.sysStruStaffService.list((Wrapper)Wrappers.lambdaQuery().eq(SysStruStaff::getStaffId, (Object)Long.parseLong(changeLog.getRecordId())));
            if (CollectionUtils.isEmpty((Collection)struStaffList)) {
                this.struUserChangeLogService.removeById((Object)changeLog);
                return;
            }
            List<Long> struIds = struStaffList.stream().map(SysStruStaff::getStruId).collect(Collectors.toList());
            tenantList = this.getTenantList(struIds);
        }
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            this.struUserChangeLogService.removeById((Object)changeLog);
            return;
        }
        Class clazz = ClassUtils.forName((String)changeLog.getRecordClass(), (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
        SysStaff sysStaff = (SysStaff)JSONObject.parseObject((String)changeLog.getRecordValue(), (Class)clazz);
        if (HussarUtils.isNotEmpty((Object)sysStaff.getIdcard())) {
            if (HussarUtils.isNotEmpty((Object)this.defEncrypt)) {
                sysStaff.setIdcard(this.defEncrypt.decrypt(sysStaff.getIdcard()));
            } else {
                sysStaff.setIdcard(sysStaff.getIdcard());
            }
        }
        boolean isSuccess = true;
        ArrayList flagList = Lists.newArrayList();
        if (2 == changeLog.getStatus()) {
            tenantList = this.filterTenant(tenantList, changeLog.getId());
        }
        int tenantListSize = tenantList.size();
        for (int i = 0; i < tenantList.size(); ++i) {
            SysTenant tenant = tenantList.get(i);
            logger.info("\u6267\u884csyncSysStaff\u65b9\u6cd5\uff0c\u540c\u6b65\u4eba\u5458\u4fe1\u606f\uff0c\u5f53\u524d\u79df\u6237\uff1a{}\uff0c\u7b2c{}\u6b21\uff0c\u603b\u5171{}\u4e2a\u79df\u6237", new Object[]{tenant.getTenantName(), i + 1, tenantListSize});
            SysStaff sysStaffSave = new SysStaff();
            HussarUtils.copy((Object)sysStaff, (Object)sysStaffSave);
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(changeLog.getId());
            flag.setTenantId(tenant.getId());
            if ("master".equals(tenant.getConnName())) continue;
            try {
                switch (changeLog.getMethod()) {
                    case "UPDATE": {
                        long idCardCount;
                        List<String> idCards;
                        String idcardEnrypt;
                        sysStaffSave = (SysStaff)this.sysStaffService.getById((Serializable)sysStaffSave.getId());
                        if (HussarUtils.isNotEmpty((Object)sysStaffSave.getIdcard())) {
                            idcardEnrypt = "";
                            idcardEnrypt = HussarUtils.isNotEmpty((Object)this.defEncrypt) ? this.defEncrypt.encrypt(sysStaffSave.getIdcard()) : sysStaffSave.getIdcard();
                            idCards = Arrays.asList(idcardEnrypt, sysStaffSave.getIdcard());
                            idCardCount = this.sysStaffService.count(tenant.getConnName(), (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysStaff::getId, (Object)sysStaffSave.getId())).in(SysStaff::getIdcard, idCards));
                            if (idCardCount == 0L) {
                                this.sysStaffService.saveOrUpdate(tenant.getConnName(), sysStaffSave);
                                break;
                            }
                            errorMsg.get("sysStaffs").add("\u540c\u6b65\u4eba\u5458\u8eab\u4efd\u8bc1\u53f7\u5df2\u5b58\u5728\uff0c\u4eba\u5458\u540d\u79f0:" + sysStaffSave.getName() + "\uff0c\u4eba\u5458\u8eab\u4efd\u8bc1\u53f7:" + sysStaffSave.getIdcard() + ";");
                            logger.info("\u540c\u6b65\u4eba\u5458\u8eab\u4efd\u8bc1\u53f7\u5df2\u5b58\u5728\uff0c\u4eba\u5458\u540d\u79f0:{}\uff0c\u4eba\u5458\u8eab\u4efd\u8bc1\u53f7:{}", (Object)sysStaffSave.getName(), (Object)sysStaffSave.getIdcard());
                            break;
                        }
                        this.sysStaffService.saveOrUpdate(tenant.getConnName(), sysStaffSave);
                        break;
                    }
                    case "INSERT": {
                        long idCardCount;
                        List<String> idCards;
                        String idcardEnrypt;
                        if (HussarUtils.isNotEmpty((Object)sysStaffSave.getIdcard())) {
                            idcardEnrypt = "";
                            idcardEnrypt = HussarUtils.isNotEmpty((Object)this.defEncrypt) ? this.defEncrypt.encrypt(sysStaffSave.getIdcard()) : sysStaffSave.getIdcard();
                            idCards = Arrays.asList(idcardEnrypt, sysStaffSave.getIdcard());
                            idCardCount = this.sysStaffService.count(tenant.getConnName(), (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStaff::getIdcard, idCards)).ne(SysStaff::getId, (Object)sysStaffSave.getId()));
                            if (idCardCount == 0L) {
                                this.sysStaffService.saveOrUpdate(tenant.getConnName(), sysStaffSave);
                                break;
                            }
                            errorMsg.get("sysStaffs").add("\u540c\u6b65\u4eba\u5458\u8eab\u4efd\u8bc1\u53f7\u5df2\u5b58\u5728\uff0c\u4eba\u5458\u540d\u79f0:" + sysStaffSave.getName() + "\uff0c\u4eba\u5458\u8eab\u4efd\u8bc1\u53f7:" + sysStaffSave.getIdcard() + ";");
                            logger.info("\u540c\u6b65\u4eba\u5458\u8eab\u4efd\u8bc1\u53f7\u5df2\u5b58\u5728\uff0c\u4eba\u5458\u540d\u79f0:{}\uff0c\u4eba\u5458\u8eab\u4efd\u8bc1\u53f7:{}", (Object)sysStaffSave.getName(), (Object)sysStaffSave.getIdcard());
                            break;
                        }
                        this.sysStaffService.saveOrUpdate(tenant.getConnName(), sysStaffSave);
                        break;
                    }
                    case "DELETE": {
                        this.sysStaffService.removeById(tenant.getConnName(), sysStaffSave);
                    }
                }
                flag.setSuccessFlag(Integer.valueOf(1));
                continue;
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
                long count = this.syncTenantSuccessFlagService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)changeLog.getId())).eq(SyncTenantSuccessFlag::getTenantId, (Object)tenant.getId()));
                if (count >= 1L) continue;
                flagList.add(flag);
            }
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        if (isSuccess) {
            this.struUserChangeLogService.removeById((Object)changeLog);
            this.syncTenantSuccessFlagService.remove((Wrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)changeLog.getId()));
        } else {
            changeLog.setStatus(Integer.valueOf(2));
            this.struUserChangeLogService.updateById((Object)changeLog);
        }
        logger.info("\u6267\u884csyncSysStaff\u65b9\u6cd5\uff0c\u540c\u6b65\u4eba\u5458\u4fe1\u606f\u7ed3\u675f");
    }

    public void syncSysStruStaff(StruUserChangeLog changeLog) throws ClassNotFoundException {
        List<SysTenant> tenantList;
        if ("DELETE".equals(changeLog.getMethod())) {
            tenantList = this.tenantService.list((Wrapper)Wrappers.lambdaQuery().eq(SysTenant::getTenantStatus, (Object)"1"));
        } else {
            SysStruStaff sysStruStaff = (SysStruStaff)this.sysStruStaffService.getById((Serializable)Long.valueOf(Long.parseLong(changeLog.getRecordId())));
            if (null == sysStruStaff) {
                this.struUserChangeLogService.removeById((Object)changeLog);
                return;
            }
            tenantList = this.getTenantList(sysStruStaff.getStruId());
        }
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            this.struUserChangeLogService.removeById((Object)changeLog);
            return;
        }
        Class clazz = ClassUtils.forName((String)changeLog.getRecordClass(), (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
        SysStruStaff sysStruStaff = (SysStruStaff)JSONObject.parseObject((String)changeLog.getRecordValue(), (Class)clazz);
        boolean isSuccess = true;
        ArrayList flagList = Lists.newArrayList();
        if (2 == changeLog.getStatus()) {
            tenantList = this.filterTenant(tenantList, changeLog.getId());
        }
        for (SysTenant tenant : tenantList) {
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(changeLog.getId());
            flag.setTenantId(tenant.getId());
            String connName = tenant.getConnName();
            if ("master".equals(connName)) continue;
            try {
                switch (changeLog.getMethod()) {
                    case "UPDATE": {
                        sysStruStaff = (SysStruStaff)this.sysStruStaffService.getById((Serializable)sysStruStaff.getId());
                        this.sysStruStaffService.saveOrUpdate(connName, sysStruStaff);
                        break;
                    }
                    case "INSERT": {
                        SysStaff masterStaff;
                        SysStaff tenantStaff = this.sysStaffService.getById(connName, (Serializable)sysStruStaff.getStaffId());
                        if (null == tenantStaff && null != (masterStaff = (SysStaff)this.sysStaffService.getById((Serializable)sysStruStaff.getStaffId()))) {
                            this.sysStaffService.saveOrUpdate(connName, masterStaff);
                        }
                        LambdaQueryWrapper sysStruStaffLambdaQueryWrapper = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)sysStruStaffLambdaQueryWrapper.eq(SysStruStaff::getStaffId, (Object)sysStruStaff.getStaffId())).eq(SysStruStaff::getStruId, (Object)sysStruStaff.getStruId());
                        List queryCheck = this.sysStruStaffService.list(connName, (Wrapper)sysStruStaffLambdaQueryWrapper);
                        if (HussarUtils.isEmpty((Object)queryCheck) || queryCheck.size() <= 0) {
                            this.sysStruStaffService.saveOrUpdate(tenant.getConnName(), sysStruStaff);
                            break;
                        }
                        logger.info("\u540c\u6b65\u7ec4\u7ec7\u4e0e\u4eba\u5458\u5173\u8054\u5173\u7cfb\uff08SYS_STRU_STAFF\uff09\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u4e0d\u518d\u6dfb\u52a0\u3002\u7528\u6237ID\uff1a{}\uff0c\u7ec4\u7ec7ID\uff1a{}", (Object)sysStruStaff.getStaffId(), (Object)sysStruStaff.getStruId());
                        break;
                    }
                    case "DELETE": {
                        this.sysStruStaffService.removeById(tenant.getConnName(), sysStruStaff);
                        SysStruStaff tenantSysStruStaff = this.sysStruStaffService.getById(connName, (Serializable)sysStruStaff.getId());
                        if (null == tenantSysStruStaff) break;
                        this.sysStruStaffService.removeById(connName, sysStruStaff);
                        List list = this.sysStruStaffService.list(connName, (Wrapper)Wrappers.lambdaQuery().eq(SysStruStaff::getStaffId, (Object)tenantSysStruStaff.getStaffId()));
                        if (!CollectionUtils.isEmpty((Collection)list)) break;
                        this.sysStaffService.removeById(connName, (Serializable)tenantSysStruStaff.getStaffId());
                    }
                }
                flag.setSuccessFlag(Integer.valueOf(1));
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
                long count = this.syncTenantSuccessFlagService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)changeLog.getId())).eq(SyncTenantSuccessFlag::getTenantId, (Object)tenant.getId()));
                if (count >= 1L) continue;
                flagList.add(flag);
            }
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        if (isSuccess) {
            this.struUserChangeLogService.removeById((Object)changeLog);
            this.syncTenantSuccessFlagService.remove((Wrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)changeLog.getId()));
        } else {
            changeLog.setStatus(Integer.valueOf(2));
            this.struUserChangeLogService.updateById((Object)changeLog);
        }
    }

    public void syncSysUsers(StruUserChangeLog changeLog, Map<String, List<String>> errorMsg) throws ClassNotFoundException {
        List<SysTenant> tenantList;
        if ("DELETE".equals(changeLog.getMethod())) {
            tenantList = this.tenantService.list((Wrapper)Wrappers.lambdaQuery().eq(SysTenant::getTenantStatus, (Object)"1"));
        } else {
            SysUsers sysUsers = this.sysUsersService.getById(Long.valueOf(Long.parseLong(changeLog.getRecordId())));
            if (null == sysUsers) {
                this.struUserChangeLogService.removeById((Object)changeLog);
                return;
            }
            List sysStruUserList = this.sysStruUserService.list((Wrapper)Wrappers.lambdaQuery().eq(SysStruUser::getUserId, (Object)sysUsers.getId()));
            if (CollectionUtils.isEmpty((Collection)sysStruUserList)) {
                this.struUserChangeLogService.removeById((Object)changeLog);
                return;
            }
            List<Long> struIds = sysStruUserList.stream().map(SysStruUser::getStruId).collect(Collectors.toList());
            tenantList = this.getTenantList(struIds);
        }
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            this.struUserChangeLogService.removeById((Object)changeLog);
            return;
        }
        Class clazz = ClassUtils.forName((String)changeLog.getRecordClass(), (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
        SysUsers sysUsers = (SysUsers)JSONObject.parseObject((String)changeLog.getRecordValue(), (Class)clazz);
        if (HussarUtils.isNotEmpty((Object)sysUsers.getTelephone())) {
            if (HussarUtils.isNotEmpty((Object)this.defEncrypt)) {
                sysUsers.setTelephone(this.defEncrypt.decrypt(sysUsers.getTelephone()));
            } else {
                sysUsers.setTelephone(sysUsers.getTelephone());
            }
        }
        if (HussarUtils.isNotEmpty((Object)sysUsers.getMobile())) {
            if (HussarUtils.isNotEmpty((Object)this.defEncrypt)) {
                sysUsers.setMobile(this.defEncrypt.decrypt(sysUsers.getMobile()));
            } else {
                sysUsers.setMobile(sysUsers.getMobile());
            }
        }
        boolean isSuccess = true;
        ArrayList flagList = Lists.newArrayList();
        if (2 == changeLog.getStatus()) {
            tenantList = this.filterTenant(tenantList, changeLog.getId());
        }
        int tenantListSize = tenantList.size();
        for (int i = 0; i < tenantList.size(); ++i) {
            SysTenant tenant = tenantList.get(i);
            logger.info("\u6267\u884csyncSysUsers\u65b9\u6cd5\uff0c\u540c\u6b65\u7528\u6237\u4fe1\u606f\uff0c\u5f53\u524d\u79df\u6237\uff1a{}\uff0c\u7b2c{}\u6b21\uff0c\u603b\u5171{}\u4e2a\u79df\u6237", new Object[]{tenant.getTenantName(), i + 1, tenantListSize});
            SysUsers sysUserSave = new SysUsers();
            HussarUtils.copy((Object)sysUsers, (Object)sysUserSave);
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(changeLog.getId());
            flag.setTenantId(tenant.getId());
            if ("master".equals(tenant.getConnName())) continue;
            try {
                switch (changeLog.getMethod()) {
                    case "UPDATE": {
                        sysUserSave = this.sysUsersService.getById(sysUserSave.getId());
                        this.sysUsersService.saveOrUpdate(tenant.getConnName(), (Object)sysUserSave);
                        break;
                    }
                    case "INSERT": {
                        long userAccountCount = this.sysUsersService.count(tenant.getConnName(), (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)sysUserSave.getUserAccount())).ne(SysUsers::getId, (Object)sysUserSave.getId()));
                        long usserIdcardCount = 0L;
                        if (HussarUtils.isNotEmpty((Object)sysUserSave.getIdcard())) {
                            usserIdcardCount = this.sysUsersService.count(tenant.getConnName(), (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getIdcard, (Object)sysUserSave.getIdcard())).ne(SysUsers::getId, (Object)sysUserSave.getId()));
                        }
                        if (userAccountCount == 0L && usserIdcardCount == 0L) {
                            this.sysUsersService.saveOrUpdate(tenant.getConnName(), (Object)sysUserSave);
                            SysUserRole record = (SysUserRole)this.sysUserRoleService.getOne(tenant.getConnName(), (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)sysUserSave.getId())).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.PUBLIC_ROLE.getValue()));
                            if (record != null) break;
                            SysUserRole userRole = new SysUserRole();
                            userRole.setUserId(sysUserSave.getId());
                            userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
                            userRole.setAdminOption("1");
                            this.sysUserRoleService.saveOrUpdate(tenant.getConnName(), (Object)userRole);
                            break;
                        }
                        if (userAccountCount > 0L) {
                            errorMsg.get("sysUsers").add("\u540c\u6b65\u7528\u6237\u8d26\u53f7\u5df2\u5b58\u5728\uff0c\u7528\u6237\u8d26\u53f7: " + sysUserSave.getUserAccount() + ";");
                            logger.info("\u540c\u6b65\u7528\u6237\u8d26\u53f7\u5df2\u5b58\u5728\uff0c\u7528\u6237\u8d26\u53f7: {}", (Object)sysUserSave.getUserAccount());
                        }
                        if (usserIdcardCount <= 0L) break;
                        errorMsg.get("sysUsers").add("\u540c\u6b65\u7528\u6237\u8eab\u4efd\u8bc1\u53f7\u5df2\u5b58\u5728\uff0c\u7528\u6237\u8d26\u53f7: " + sysUserSave.getUserAccount() + ",\u8eab\u4efd\u8bc1\u53f7: " + sysUserSave.getIdcard() + ";");
                        logger.info("\u540c\u6b65\u7528\u6237\u8eab\u4efd\u8bc1\u53f7\u5df2\u5b58\u5728\uff0c\u7528\u6237\u8d26\u53f7: {},\u8eab\u4efd\u8bc1\u53f7: {}", (Object)sysUserSave.getUserAccount(), (Object)sysUserSave.getIdcard());
                        break;
                    }
                    case "DELETE": {
                        this.sysUsersService.removeById(tenant.getConnName(), (Object)sysUserSave);
                        this.sysUserRoleService.remove(tenant.getConnName(), (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)sysUserSave.getId())).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.PUBLIC_ROLE.getValue()));
                    }
                }
                flag.setSuccessFlag(Integer.valueOf(1));
                continue;
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
                long count = this.syncTenantSuccessFlagService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)changeLog.getId())).eq(SyncTenantSuccessFlag::getTenantId, (Object)tenant.getId()));
                if (count >= 1L) continue;
                flagList.add(flag);
            }
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        if (isSuccess) {
            this.struUserChangeLogService.removeById((Object)changeLog);
            this.syncTenantSuccessFlagService.remove((Wrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)changeLog.getId()));
        } else {
            changeLog.setStatus(Integer.valueOf(2));
            this.struUserChangeLogService.updateById((Object)changeLog);
        }
        logger.info("\u6267\u884csyncSysUsers\u65b9\u6cd5\uff0c\u540c\u6b65\u7528\u6237\u4fe1\u606f\u7ed3\u675f");
    }

    public void syncSysStruUser(StruUserChangeLog changeLog) throws ClassNotFoundException {
        List<SysTenant> tenantList;
        if ("DELETE".equals(changeLog.getMethod())) {
            tenantList = this.tenantService.list((Wrapper)Wrappers.lambdaQuery().eq(SysTenant::getTenantStatus, (Object)"1"));
        } else {
            SysStruUser sysStruUser = (SysStruUser)this.sysStruUserService.getById((Serializable)Long.valueOf(Long.parseLong(changeLog.getRecordId())));
            if (null == sysStruUser) {
                this.struUserChangeLogService.removeById((Object)changeLog);
                return;
            }
            tenantList = this.getTenantList(sysStruUser.getStruId());
        }
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            this.struUserChangeLogService.removeById((Object)changeLog);
            return;
        }
        Class clazz = ClassUtils.forName((String)changeLog.getRecordClass(), (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
        SysStruUser sysStruUser = (SysStruUser)JSONObject.parseObject((String)changeLog.getRecordValue(), (Class)clazz);
        boolean isSuccess = true;
        ArrayList flagList = Lists.newArrayList();
        if (2 == changeLog.getStatus()) {
            tenantList = this.filterTenant(tenantList, changeLog.getId());
        }
        for (SysTenant tenant : tenantList) {
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(changeLog.getId());
            flag.setTenantId(tenant.getId());
            String connName = tenant.getConnName();
            if ("master".equals(connName)) continue;
            try {
                switch (changeLog.getMethod()) {
                    case "UPDATE": {
                        sysStruUser = (SysStruUser)this.sysStruUserService.getById((Serializable)sysStruUser.getId());
                        this.sysStruUserService.saveOrUpdate(connName, sysStruUser);
                        break;
                    }
                    case "INSERT": {
                        SysUsers masterUser;
                        SysUsers tenantUser = (SysUsers)this.sysUsersService.getById(connName, (Serializable)sysStruUser.getUserId());
                        if (null == tenantUser && null != (masterUser = this.sysUsersService.getById(sysStruUser.getUserId()))) {
                            this.sysUsersService.saveOrUpdate(connName, (Object)masterUser);
                            SysUserRole record = (SysUserRole)this.sysUserRoleService.getOne(connName, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)masterUser.getId())).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.PUBLIC_ROLE.getValue()));
                            if (record == null) {
                                SysUserRole userRole = new SysUserRole();
                                userRole.setUserId(masterUser.getId());
                                userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
                                userRole.setAdminOption("1");
                                this.sysUserRoleService.saveOrUpdate(tenant.getConnName(), (Object)userRole);
                            }
                        }
                        LambdaQueryWrapper sysStruUserLambdaQueryWrapper = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)sysStruUserLambdaQueryWrapper.eq(SysStruUser::getUserId, (Object)sysStruUser.getUserId())).eq(SysStruUser::getStruId, (Object)sysStruUser.getStruId());
                        List queryCheck = this.sysStruUserService.list(connName, (Wrapper)sysStruUserLambdaQueryWrapper);
                        if (HussarUtils.isEmpty((Object)queryCheck) || queryCheck.size() <= 0) {
                            this.sysStruUserService.saveOrUpdate(connName, sysStruUser);
                            break;
                        }
                        logger.info("\u540c\u6b65\u7ec4\u7ec7\u7528\u6237\u5173\u8054\u5173\u7cfb\uff08SYS_STRU_USER\uff09\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u4e0d\u518d\u6dfb\u52a0\u3002\u7528\u6237ID\uff1a{}\uff0c\u7ec4\u7ec7ID\uff1a{}", (Object)sysStruUser.getUserId(), (Object)sysStruUser.getStruId());
                        break;
                    }
                    case "DELETE": {
                        SysStruUser tenantSysStruUser = this.sysStruUserService.getById(connName, (Serializable)sysStruUser.getId());
                        if (null == tenantSysStruUser) break;
                        this.sysStruUserService.removeById(connName, sysStruUser);
                        List list = this.sysStruUserService.list(connName, (Wrapper)Wrappers.lambdaQuery().eq(SysStruUser::getUserId, (Object)tenantSysStruUser.getUserId()));
                        if (!CollectionUtils.isEmpty((Collection)list)) break;
                        this.sysUsersService.removeById(connName, (Serializable)tenantSysStruUser.getUserId());
                        this.sysUserRoleService.remove(connName, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)tenantSysStruUser.getUserId())).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.PUBLIC_ROLE.getValue()));
                    }
                }
                flag.setSuccessFlag(Integer.valueOf(1));
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
                long count = this.syncTenantSuccessFlagService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)changeLog.getId())).eq(SyncTenantSuccessFlag::getTenantId, (Object)tenant.getId()));
                if (count >= 1L) continue;
                flagList.add(flag);
            }
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        if (isSuccess) {
            this.struUserChangeLogService.removeById((Object)changeLog);
            this.syncTenantSuccessFlagService.remove((Wrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)changeLog.getId()));
        } else {
            changeLog.setStatus(Integer.valueOf(2));
            this.struUserChangeLogService.updateById((Object)changeLog);
        }
    }

    public void syncSysOffice(StruUserChangeLog changeLog, Map<String, List<String>> errorMsg) throws ClassNotFoundException {
        SysOffice sysOffice;
        List<SysTenant> tenantList;
        if ("DELETE".equals(changeLog.getMethod())) {
            tenantList = this.tenantService.list((Wrapper)Wrappers.lambdaQuery().eq(SysTenant::getTenantStatus, (Object)"1"));
        } else {
            String officeId = changeLog.getRecordId();
            sysOffice = (SysOffice)this.sysOfficeService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysOffice::getId, (Object)Long.parseLong(officeId)));
            if (null == sysOffice) {
                this.struUserChangeLogService.removeById((Object)changeLog);
                return;
            }
            tenantList = this.getTenantList(sysOffice.getStruId());
        }
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            this.struUserChangeLogService.removeById((Object)changeLog);
            return;
        }
        Class clazz = ClassUtils.forName((String)changeLog.getRecordClass(), (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
        sysOffice = (SysOffice)JSONObject.parseObject((String)changeLog.getRecordValue(), (Class)clazz);
        boolean isSuccess = true;
        ArrayList flagList = Lists.newArrayList();
        if (2 == changeLog.getStatus()) {
            tenantList = this.filterTenant(tenantList, changeLog.getId());
        }
        for (SysTenant tenant : tenantList) {
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(changeLog.getId());
            flag.setTenantId(tenant.getId());
            if ("master".equals(tenant.getConnName())) continue;
            try {
                switch (changeLog.getMethod()) {
                    case "UPDATE": {
                        sysOffice = (SysOffice)this.sysOfficeService.getById((Serializable)sysOffice.getId());
                        this.sysOfficeService.saveOrUpdate(tenant.getConnName(), sysOffice);
                        break;
                    }
                    case "INSERT": {
                        SysStru sysStru = (SysStru)this.sysStruService.getById((Serializable)sysOffice.getStruId());
                        if (HussarUtils.isEmpty((Object)sysStru)) {
                            errorMsg.get("sysOffices").add("\u4e3b\u5e93\u91cc\u7684SysStru\u4e3a\u7a7a\uff0c\u4e3b\u952e\u4e3a\uff1a" + sysOffice.getStruId() + ";");
                            throw new BaseException("\u4e3b\u5e93\u91cc\u7684SysStru\u4e3a\u7a7a\uff0c\u4e3b\u952e\u4e3a\uff1a" + sysOffice.getStruId());
                        }
                        SysOrgan sysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)sysStru.getOrganId());
                        if (HussarUtils.isEmpty((Object)sysOrgan)) {
                            errorMsg.get("sysStrus").add("\u4e3b\u5e93\u91cc\u7684SysOrgan\u4e3a\u7a7a\uff0c\u4e3b\u952e\u4e3a\uff1a" + sysStru.getOrganId() + ";");
                            throw new BaseException("\u4e3b\u5e93\u91cc\u7684SysOrgan\u4e3a\u7a7a\uff0c\u4e3b\u952e\u4e3a\uff1a" + sysStru.getOrganId());
                        }
                        String organCode = sysOrgan.getOrganCode();
                        long organCodeCount = this.sysOrganService.count(tenant.getConnName(), (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysOrgan::getOrganCode, (Object)organCode)).ne(SysOrgan::getId, (Object)sysOrgan.getId()));
                        if (organCodeCount == 0L) {
                            this.sysOfficeService.saveOrUpdate(tenant.getConnName(), sysOffice);
                            break;
                        }
                        errorMsg.get("sysOffices").add("\u8be5\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u91cd\u590d: " + organCode + ";");
                        logger.info("\u8be5\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u91cd\u590d: {}", (Object)organCode);
                        break;
                    }
                    case "DELETE": {
                        this.sysOfficeService.removeById(tenant.getConnName(), sysOffice);
                    }
                }
                flag.setSuccessFlag(Integer.valueOf(1));
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
                long count = this.syncTenantSuccessFlagService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)changeLog.getId())).eq(SyncTenantSuccessFlag::getTenantId, (Object)tenant.getId()));
                if (count >= 1L) continue;
                flagList.add(flag);
            }
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        if (isSuccess) {
            this.struUserChangeLogService.removeById((Object)changeLog);
            this.syncTenantSuccessFlagService.remove((Wrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)changeLog.getId()));
        } else {
            changeLog.setStatus(Integer.valueOf(2));
            this.struUserChangeLogService.updateById((Object)changeLog);
        }
    }

    private List<SysTenant> getTenantList(Object struId) {
        List tenantList;
        SysStru sysStru = (SysStru)this.sysStruService.getById((Serializable)Long.valueOf(Long.parseLong(struId + "")));
        if (sysStru == null) {
            return Lists.newArrayList();
        }
        List<String> struIds = Arrays.asList(sysStru.getStruFid().split("/"));
        List longSet = struIds.stream().filter(str -> !str.isEmpty()).map(Long::parseLong).collect(Collectors.toList());
        List sysTenantStruList = this.tenantStruService.list((Wrapper)Wrappers.lambdaQuery().in(SysTenantStru::getStruId, longSet));
        if (CollectionUtils.isEmpty((Collection)sysTenantStruList)) {
            return Lists.newArrayList();
        }
        List tenantIds = sysTenantStruList.stream().map(SysTenantStru::getTenantId).collect(Collectors.toList());
        LambdaQueryWrapper cancelQuery = new LambdaQueryWrapper();
        cancelQuery.in(SysTenantStruCancel::getStruId, longSet);
        List cancelList = this.sysTenantStruCancelService.list((Wrapper)cancelQuery);
        if (HussarUtils.isNotEmpty((Object)cancelList)) {
            List cancelTenantIds = cancelList.stream().map(SysTenantStruCancel::getTenantId).collect(Collectors.toList());
            tenantIds.removeAll(cancelTenantIds);
        }
        if (CollectionUtils.isEmpty((Collection)(tenantList = this.tenantService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysTenant::getId, tenantIds)).eq(SysTenant::getTenantStatus, (Object)"1"))))) {
            return Lists.newArrayList();
        }
        return tenantList;
    }

    private List<SysTenant> getTenantList(List<Long> struIds) {
        List struList = this.sysStruService.getStruByStruIds(struIds);
        HashSet fullStruIds = Sets.newHashSet();
        for (SysStru sysStru : struList) {
            fullStruIds.addAll(Arrays.asList(sysStru.getStruFid().split("/")));
        }
        Set longSet = fullStruIds.stream().filter(str -> !str.isEmpty()).map(Long::parseLong).collect(Collectors.toSet());
        List sysTenantStruList = this.tenantStruService.list((Wrapper)Wrappers.lambdaQuery().in(SysTenantStru::getStruId, longSet));
        if (CollectionUtils.isEmpty((Collection)sysTenantStruList)) {
            return Lists.newArrayList();
        }
        List tenantIds = sysTenantStruList.stream().map(SysTenantStru::getTenantId).collect(Collectors.toList());
        List tenantList = this.tenantService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysTenant::getId, tenantIds)).eq(SysTenant::getTenantStatus, (Object)"1"));
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper cancelQuery = new LambdaQueryWrapper();
        cancelQuery.in(SysTenantStruCancel::getStruId, struIds);
        List cancelList = this.sysTenantStruCancelService.list((Wrapper)cancelQuery);
        if (HussarUtils.isNotEmpty((Object)cancelList)) {
            List cancelTenantIds = cancelList.stream().map(SysTenantStruCancel::getTenantId).collect(Collectors.toList());
            tenantIds.removeAll(cancelTenantIds);
        }
        return tenantList;
    }

    private List<SysTenant> filterTenant(List<SysTenant> tenantList, Long logId) {
        List successFlagList = this.syncTenantSuccessFlagService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getSuccessFlag, (Object)0)).eq(SyncTenantSuccessFlag::getLogId, (Object)logId));
        if (CollectionUtils.isNotEmpty((Collection)successFlagList)) {
            List successTenantIds = successFlagList.stream().map(SyncTenantSuccessFlag::getTenantId).collect(Collectors.toList());
            tenantList = tenantList.stream().filter(t -> successTenantIds.contains(t.getId())).collect(Collectors.toList());
        }
        return tenantList;
    }

    public void syncSysOrganType(StruUserChangeLog changeLog) throws ClassNotFoundException {
        List<SysTenant> tenantList;
        logger.info("\u5f00\u59cb\u6267\u884c\u540c\u6b65\u7ec4\u7ec7\u7c7b\u578b\uff1asys_organ_type");
        if ("DELETE".equals(changeLog.getMethod())) {
            tenantList = this.tenantService.list((Wrapper)Wrappers.lambdaQuery().eq(SysTenant::getTenantStatus, (Object)"1"));
        } else {
            SysOrganType sysOrganType = (SysOrganType)this.sysOrganTypeService.getById((Serializable)Long.valueOf(Long.parseLong(changeLog.getRecordId())));
            if (null == sysOrganType) {
                this.struUserChangeLogService.removeById((Object)changeLog);
                return;
            }
            tenantList = this.getTenantAllList();
        }
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            this.struUserChangeLogService.removeById((Object)changeLog);
            return;
        }
        Class clazz = ClassUtils.forName((String)changeLog.getRecordClass(), (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
        SysOrganType sysOrganType = (SysOrganType)JSONObject.parseObject((String)changeLog.getRecordValue(), (Class)clazz);
        boolean isSuccess = true;
        ArrayList flagList = Lists.newArrayList();
        if (2 == changeLog.getStatus()) {
            tenantList = this.filterTenant(tenantList, changeLog.getId());
        }
        for (SysTenant tenant : tenantList) {
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(changeLog.getId());
            flag.setTenantId(tenant.getId());
            String connName = tenant.getConnName();
            if ("master".equals(connName)) continue;
            try {
                switch (changeLog.getMethod()) {
                    case "UPDATE": {
                        sysOrganType = (SysOrganType)this.sysOrganTypeService.getById((Serializable)sysOrganType.getId());
                        this.sysOrganTypeService.saveOrUpdate(connName, sysOrganType);
                        break;
                    }
                    case "INSERT": {
                        this.sysOrganTypeService.saveOrUpdate(connName, sysOrganType);
                        break;
                    }
                    case "DELETE": {
                        LambdaQueryWrapper qe = new LambdaQueryWrapper();
                        qe.eq(SysOrgan::getOrganType, (Object)sysOrganType.getOrganType());
                        List res = this.sysOrganService.list(connName, (Wrapper)qe);
                        if (HussarUtils.isEmpty((Object)res)) {
                            this.sysOrganTypeService.removeById(connName, sysOrganType);
                            break;
                        }
                        logger.info("\u79df\u6237{}\u5b58\u5728\u5173\u8054\u7ec4\u7ec7\u7c7b\u578b\u7684\u6570\u636e\uff0c\u6682\u4e0d\u5220\u9664\u3002", (Object)tenant.getTenantName());
                    }
                }
                flag.setSuccessFlag(Integer.valueOf(1));
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
                long count = this.syncTenantSuccessFlagService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)changeLog.getId())).eq(SyncTenantSuccessFlag::getTenantId, (Object)tenant.getId()));
                if (count >= 1L) continue;
                flagList.add(flag);
            }
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        if (isSuccess) {
            this.struUserChangeLogService.removeById((Object)changeLog);
            this.syncTenantSuccessFlagService.remove((Wrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)changeLog.getId()));
        } else {
            changeLog.setStatus(Integer.valueOf(2));
            this.struUserChangeLogService.updateById((Object)changeLog);
        }
        logger.info("\u6267\u884c\u540c\u6b65\u7ec4\u7ec7\u7c7b\u578b\u7ed3\u675f\uff1asys_organ_type");
    }

    public void syncSysStruRule(StruUserChangeLog changeLog) throws ClassNotFoundException {
        List<SysTenant> tenantList;
        logger.info("\u5f00\u59cb\u6267\u884c\u540c\u6b65\u7ec4\u7ec7\u7ed3\u6784\u89c4\u5219\uff1asys_stru_rule");
        if ("DELETE".equals(changeLog.getMethod())) {
            tenantList = this.tenantService.list((Wrapper)Wrappers.lambdaQuery().eq(SysTenant::getTenantStatus, (Object)"1"));
        } else {
            SysStruRule sysStruRule = (SysStruRule)this.sysStruRuleService.getById((Serializable)Long.valueOf(Long.parseLong(changeLog.getRecordId())));
            if (null == sysStruRule) {
                this.struUserChangeLogService.removeById((Object)changeLog);
                return;
            }
            tenantList = this.getTenantAllList();
        }
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            this.struUserChangeLogService.removeById((Object)changeLog);
            return;
        }
        Class clazz = ClassUtils.forName((String)changeLog.getRecordClass(), (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
        SysStruRule sysStruRule = (SysStruRule)JSONObject.parseObject((String)changeLog.getRecordValue(), (Class)clazz);
        boolean isSuccess = true;
        ArrayList flagList = Lists.newArrayList();
        tenantList = this.filterTenant(tenantList, changeLog.getId());
        for (SysTenant tenant : tenantList) {
            SyncTenantSuccessFlag flag = new SyncTenantSuccessFlag();
            flag.setLogId(changeLog.getId());
            flag.setTenantId(tenant.getId());
            String connName = tenant.getConnName();
            if ("master".equals(connName)) continue;
            try {
                switch (changeLog.getMethod()) {
                    case "UPDATE": {
                        sysStruRule = (SysStruRule)this.sysStruRuleService.getById((Serializable)sysStruRule.getId());
                        this.sysStruRuleService.saveOrUpdate(connName, sysStruRule);
                        break;
                    }
                    case "INSERT": {
                        this.sysStruRuleService.saveOrUpdate(connName, sysStruRule);
                        break;
                    }
                    case "DELETE": {
                        this.sysStruRuleService.removeById(connName, sysStruRule);
                    }
                }
                flag.setSuccessFlag(Integer.valueOf(1));
            }
            catch (Exception e) {
                isSuccess = false;
                flag.setSuccessFlag(Integer.valueOf(0));
                flag.setFailReason(e.getMessage());
                long count = this.syncTenantSuccessFlagService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)changeLog.getId())).eq(SyncTenantSuccessFlag::getTenantId, (Object)tenant.getId()));
                if (count >= 1L) continue;
                flagList.add(flag);
            }
        }
        this.syncTenantSuccessFlagService.saveBatch((Collection)flagList);
        if (isSuccess) {
            this.struUserChangeLogService.removeById((Object)changeLog);
            this.syncTenantSuccessFlagService.remove((Wrapper)Wrappers.lambdaQuery().eq(SyncTenantSuccessFlag::getLogId, (Object)changeLog.getId()));
        } else {
            changeLog.setStatus(Integer.valueOf(2));
            this.struUserChangeLogService.updateById((Object)changeLog);
        }
        logger.info("\u6267\u884c\u540c\u6b65\u7ec4\u7ec7\u7ed3\u6784\u89c4\u5219\u7ed3\u675f\uff1asys_stru_rule");
    }

    private List<SysTenant> getTenantAllList() {
        List tenantList = this.tenantService.list();
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            return Lists.newArrayList();
        }
        return tenantList;
    }
}

